/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.Archive;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.welcome.SdkLocationUtils;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponentKt;
import com.android.tools.idea.welcome.wizard.WelcomeUiUtils;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010&\u001a\u00020'H&J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020:0\tH\u0016J\b\u0010;\u001a\u00020\u0006H\u0014J\b\u0010<\u001a\u00020\u0006H\u0014J\u0010\u0010=\u001a\u0002062\u0006\u0010>\u001a\u00020\u0006H\u0016J\u0010\u0010?\u001a\u0002062\u0006\u0010@\u001a\u00020'H\u0016R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u0010\u0010\u0005\u001a\u00020\u00068\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000bR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000bR\u0014\u0010 \u001a\u00020!8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000bR\u0014\u0010&\u001a\u0004\u0018\u00010'8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030)0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u000bR\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030\t8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u000bR\u0012\u0010-\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010.R\u001a\u0010/\u001a\u000200X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u0006A"}, d2={"Lcom/android/tools/idea/welcome/install/InstallableComponent;", "Lcom/android/tools/idea/welcome/install/ComponentTreeNode;", "name", "", "description", "installUpdates", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "childrenToInstall", "", "getChildrenToInstall", "()Ljava/util/Collection;", "downloadSize", "", "getDownloadSize", "()J", "immediateChildren", "getImmediateChildren", "isChecked", "()Z", "isEnabled", "isInstalled", "isOptional", "isUnavailable", "label", "getLabel", "()Ljava/lang/String;", "optionalSdkPackages", "getOptionalSdkPackages", "packagesToInstall", "Lcom/android/repository/api/UpdatablePackage;", "getPackagesToInstall", "repositoryPackages", "Lcom/android/repository/impl/meta/RepositoryPackages;", "getRepositoryPackages", "()Lcom/android/repository/impl/meta/RepositoryPackages;", "requiredSdkPackages", "getRequiredSdkPackages", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "steps", "Lcom/android/tools/idea/wizard/model/ModelWizardStep;", "getSteps", "unavailablePackages", "getUnavailablePackages", "userSelection", "Ljava/lang/Boolean;", "willBeInstalled", "Lcom/android/tools/idea/observable/core/BoolProperty;", "getWillBeInstalled", "()Lcom/android/tools/idea/observable/core/BoolProperty;", "setWillBeInstalled", "(Lcom/android/tools/idea/observable/core/BoolProperty;)V", "configure", "", "installContext", "Lcom/android/tools/idea/welcome/install/InstallContext;", "createSteps", "Lcom/android/tools/idea/wizard/dynamic/DynamicWizardStep;", "isOptionalForSdkLocation", "isSelectedByDefault", "toggle", "isSelected", "updateState", "handler", "intellij.android.core"})
public abstract class InstallableComponent
extends ComponentTreeNode {
    @NotNull
    private final String name;
    @JvmField
    protected final boolean installUpdates;
    @NotNull
    private BoolProperty willBeInstalled;
    @Nullable
    private Boolean userSelection;
    private boolean isOptional;
    private boolean isInstalled;
    private boolean isUnavailable;
    @JvmField
    @Nullable
    protected AndroidSdkHandler sdkHandler;
    @NotNull
    private final Collection<String> optionalSdkPackages;
    private final boolean isEnabled;
    @NotNull
    private final Collection<ModelWizardStep<?>> steps;

    public InstallableComponent(@NotNull String name, @NotNull String description2, boolean installUpdates) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        super(description2);
        this.name = name;
        this.installUpdates = installUpdates;
        this.willBeInstalled = new BoolValueProperty(true);
        this.isOptional = true;
        this.optionalSdkPackages = CollectionsKt.emptyList();
        this.isEnabled = this.isOptional;
        this.steps = SetsKt.emptySet();
    }

    @NotNull
    protected final BoolProperty getWillBeInstalled() {
        return this.willBeInstalled;
    }

    protected final void setWillBeInstalled(@NotNull BoolProperty boolProperty) {
        Intrinsics.checkNotNullParameter((Object)boolProperty, (String)"<set-?>");
        this.willBeInstalled = boolProperty;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<UpdatablePackage> getPackagesToInstall() {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionsKt.plus(this.getRequiredSdkPackages(), (Iterable)this.getOptionalSdkPackages());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            UpdatablePackage it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if ((UpdatablePackage)this.getRepositoryPackages().getConsolidatedPkgs().get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UpdatablePackage p = (UpdatablePackage)element$iv$iv;
            boolean bl = false;
            if (!(p.hasRemote() && (!p.hasLocal() || this.installUpdates && p.isUpdate()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<String> getUnavailablePackages() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getRequiredSdkPackages();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        UpdatablePackage updatablePackage = $this$forEach$iv$iv$iv.iterator();
        while (updatablePackage.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = updatablePackage.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            UpdatablePackage updatablePackage2 = (UpdatablePackage)this.getRepositoryPackages().getConsolidatedPkgs().get(it);
            if ((updatablePackage2 != null && (updatablePackage2 = updatablePackage2.getLocal()) != null ? updatablePackage2.getPath() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List installedPackages = (List)destination$iv$iv;
        $this$mapNotNull$iv = this.getPackagesToInstall();
        Iterable iterable2 = this.getRequiredSdkPackages();
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            updatablePackage = (UpdatablePackage)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getPath());
        }
        return CollectionsKt.minus((Iterable)CollectionsKt.minus((Iterable)iterable2, (Iterable)((List)destination$iv$iv)), (Iterable)installedPackages);
    }

    @NotNull
    protected final RepositoryPackages getRepositoryPackages() {
        AndroidSdkHandler androidSdkHandler = this.sdkHandler;
        Intrinsics.checkNotNull((Object)androidSdkHandler);
        RepositoryPackages repositoryPackages = androidSdkHandler.getSdkManager((ProgressIndicator)InstallableComponentKt.access$getPROGRESS_LOGGER$p()).getPackages();
        Intrinsics.checkNotNullExpressionValue((Object)repositoryPackages, (String)"sdkHandler!!.getSdkManag\u2026PROGRESS_LOGGER).packages");
        return repositoryPackages;
    }

    @NotNull
    protected abstract Collection<String> getRequiredSdkPackages();

    @NotNull
    protected Collection<String> getOptionalSdkPackages() {
        return this.optionalSdkPackages;
    }

    /*
     * WARNING - void declaration
     */
    public final long getDownloadSize() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getPackagesToInstall();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Long it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            UpdatablePackage it = (UpdatablePackage)element$iv$iv;
            boolean bl2 = false;
            RemotePackage remotePackage = it.getRemote();
            Intrinsics.checkNotNull((Object)remotePackage);
            Archive archive = remotePackage.getArchive();
            if ((archive != null && (archive = archive.getComplete()) != null ? Long.valueOf(archive.getSize()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.sumOfLong((Iterable)((List)destination$iv$iv));
    }

    protected boolean isSelectedByDefault() {
        return true;
    }

    protected boolean isOptionalForSdkLocation() {
        return true;
    }

    @Override
    @NotNull
    public String getLabel() {
        String sizeLabel = this.isInstalled ? "installed" : (this.isUnavailable ? "unavailable" : WelcomeUiUtils.getSizeLabel(this.getDownloadSize()));
        return this.name + " \u2013 (" + sizeLabel + ")";
    }

    public abstract void configure(@NotNull InstallContext var1, @NotNull AndroidSdkHandler var2);

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @NotNull
    public Collection<InstallableComponent> getChildrenToInstall() {
        return (Boolean)this.willBeInstalled.get() == false ? (Collection)SetsKt.emptySet() : (Collection)SetsKt.setOf((Object)this);
    }

    @Override
    @NotNull
    public Collection<ModelWizardStep<?>> getSteps() {
        return this.steps;
    }

    @Override
    @NotNull
    public Collection<DynamicWizardStep> createSteps() {
        return SetsKt.emptySet();
    }

    @Override
    public void updateState(@NotNull AndroidSdkHandler handler2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        this.sdkHandler = handler2;
        boolean nothingToInstall = !SdkLocationUtils.isWritable(handler2.getLocation()) || this.getPackagesToInstall().isEmpty();
        this.isOptional = !nothingToInstall && this.isOptionalForSdkLocation();
        if (!this.isOptional) {
            bl = !nothingToInstall;
        } else if (this.userSelection != null) {
            Boolean bl2 = this.userSelection;
            Intrinsics.checkNotNull((Object)bl2);
            bl = bl2;
        } else {
            bl = this.isSelectedByDefault();
        }
        this.willBeInstalled.set(bl);
        boolean bl3 = this.isInstalled = this.sdkHandler != null && this.getPackagesToInstall().isEmpty() && this.getUnavailablePackages().isEmpty();
        this.isUnavailable = this.sdkHandler == null || !this.getUnavailablePackages().isEmpty();
    }

    @Override
    public void toggle(boolean isSelected) {
        if (this.isOptional) {
            this.userSelection = isSelected;
            this.willBeInstalled.set(isSelected);
        }
    }

    @Override
    @NotNull
    public Collection<ComponentTreeNode> getImmediateChildren() {
        return SetsKt.emptySet();
    }

    @Override
    public boolean isChecked() {
        Object t = this.willBeInstalled.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"willBeInstalled.get()");
        return (Boolean)t;
    }
}

