/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.WizardException;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 !*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0003!\"#B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\u0015J(\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u000e\u0010\u001a\u001a\n\u0018\u00010\u001bj\u0004\u0018\u0001`\u001cH\u0004J,\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00028\u00010\u0000\"\u0004\b\u0002\u0010\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00028\u00000\u0000J,\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00028\u00010\u0000\"\u0004\b\u0002\u0010\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u001e0 R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/welcome/install/InstallOperation;", "Return", "Argument", "", "context", "Lcom/android/tools/idea/welcome/install/InstallContext;", "progressRatio", "", "(Lcom/android/tools/idea/welcome/install/InstallContext;D)V", "getContext", "()Lcom/android/tools/idea/welcome/install/InstallContext;", "cleanup", "", "result", "(Ljava/lang/Object;)V", "execute", "argument", "(Ljava/lang/Object;)Ljava/lang/Object;", "perform", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/lang/Object;)Ljava/lang/Object;", "promptToRetry", "prompt", "", "failureDescription", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "then", "FinalResult", "next", "Lcom/google/common/base/Function;", "Companion", "FunctionWrapper", "OperationChain", "intellij.android.core"})
public abstract class InstallOperation<Return, Argument> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InstallContext context;
    private final double progressRatio;

    public InstallOperation(@NotNull InstallContext context2, double progressRatio) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.progressRatio = progressRatio;
    }

    @NotNull
    protected final InstallContext getContext() {
        return this.context;
    }

    protected abstract Return perform(@NotNull ProgressIndicator var1, Argument var2) throws WizardException, InstallationCancelledException;

    public final Return execute(Argument argument) throws WizardException, InstallationCancelledException {
        Object object;
        this.context.checkCanceled();
        if (this.progressRatio == 0.0) {
            object = this.perform((ProgressIndicator)new EmptyProgressIndicator(), argument);
        } else {
            Object r;
            try {
                r = this.context.run((ThrowableComputable)new ThrowableComputable(this, argument){
                    final /* synthetic */ InstallOperation<Return, Argument> this$0;
                    final /* synthetic */ Argument $argument;
                    {
                        this.this$0 = $receiver;
                        this.$argument = $argument;
                    }

                    public final Return compute() {
                        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                        if (progressIndicator == null) {
                            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
                        }
                        ProgressIndicator indicator = progressIndicator;
                        return this.this$0.perform(indicator, this.$argument);
                    }
                }, this.progressRatio);
            }
            catch (ProcessCanceledException e) {
                throw new InstallationCancelledException();
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, WizardException.class, InstallationCancelledException.class);
                throw new RuntimeException(e);
            }
            object = r;
        }
        return object;
    }

    protected final void promptToRetry(@NotNull String prompt, @NotNull String failureDescription, @Nullable Exception e) throws InstallationCancelledException {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)failureDescription, (String)"failureDescription");
        AtomicBoolean response2 = new AtomicBoolean(false);
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(new Runnable(prompt, failureDescription, response2){
            final /* synthetic */ String $prompt;
            final /* synthetic */ String $failureDescription;
            final /* synthetic */ AtomicBoolean $response;
            {
                this.$prompt = $prompt;
                this.$failureDescription = $failureDescription;
                this.$response = $response;
            }

            public final void run() {
                CharSequence charSequence = this.$prompt;
                Object object = new Regex("(\\p{Print}{30,50}([\\h\\n]|$))");
                String[] stringArray = "$1\n";
                String wrappedPrompt = object.replace(charSequence, (String)stringArray);
                object = this.$failureDescription;
                stringArray = new Regex("(\\p{Print}{30,50}([\\h\\n]|$))");
                String string = "$1\n";
                object = stringArray.replace((CharSequence)object, string);
                stringArray = new Regex("(\\p{Print}{30,50}/)");
                string = "$1\n";
                String wrappedFailure = stringArray.replace((CharSequence)object, string);
                stringArray = new String[]{"Retry", "Cancel"};
                int i = Messages.showDialog(null, (String)wrappedPrompt, (String)"Android Studio Setup", (String)wrappedFailure, (String[])stringArray, (int)0, (int)0, (Icon)Messages.getErrorIcon());
                this.$response.set(i == 0);
            }
        }, application.getAnyModalityState());
        if (!response2.get()) {
            if (e != null) {
                Throwables.throwIfInstanceOf((Throwable)e, WizardException.class);
            }
            throw new InstallationCancelledException();
        }
        this.context.print(failureDescription + "\n", ConsoleViewContentType.ERROR_OUTPUT);
    }

    public abstract void cleanup(Return var1);

    @NotNull
    public final <FinalResult> InstallOperation<FinalResult, Argument> then(@NotNull InstallOperation<FinalResult, Return> next) {
        Intrinsics.checkNotNullParameter(next, (String)"next");
        return new OperationChain(this, next);
    }

    @NotNull
    public final <FinalResult> InstallOperation<FinalResult, Argument> then(@NotNull Function<Return, FinalResult> next) {
        Intrinsics.checkNotNullParameter(next, (String)"next");
        return this.then(Companion.wrap(this.context, next, 0.0));
    }

    @JvmStatic
    @NotNull
    public static final <Return, Argument> InstallOperation<Return, Argument> wrap(@NotNull InstallContext context2, @NotNull Function<Argument, Return> function, double progressShare) {
        return Companion.wrap(context2, function, progressShare);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u0002*\u0004\b\u0004\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004B-\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00030\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00040\u0004\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\f\u001a\u00028\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010\u0010R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/welcome/install/InstallOperation$OperationChain;", "FinalResult", "Argument", "Return", "Lcom/android/tools/idea/welcome/install/InstallOperation;", "first", "second", "(Lcom/android/tools/idea/welcome/install/InstallOperation;Lcom/android/tools/idea/welcome/install/InstallOperation;)V", "cleanup", "", "result", "(Ljava/lang/Object;)V", "perform", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "argument", "(Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/lang/Object;)Ljava/lang/Object;", "intellij.android.core"})
    private static final class OperationChain<FinalResult, Argument, Return>
    extends InstallOperation<FinalResult, Argument> {
        @NotNull
        private final InstallOperation<Return, Argument> first;
        @NotNull
        private final InstallOperation<FinalResult, Return> second;

        public OperationChain(@NotNull InstallOperation<Return, Argument> first, @NotNull InstallOperation<FinalResult, Return> second) {
            Intrinsics.checkNotNullParameter(first, (String)"first");
            Intrinsics.checkNotNullParameter(second, (String)"second");
            super(first.getContext(), 0.0);
            this.first = first;
            this.second = second;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected FinalResult perform(@NotNull ProgressIndicator indicator, Argument argument) throws WizardException, InstallationCancelledException {
            FinalResult FinalResult;
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Return firstResult = this.first.execute(argument);
            try {
                FinalResult = this.second.execute(firstResult);
            }
            finally {
                this.first.cleanup(firstResult);
            }
            return FinalResult;
        }

        @Override
        public void cleanup(FinalResult result2) {
            this.second.cleanup(result2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000f\u001a\u00028\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/welcome/install/InstallOperation$FunctionWrapper;", "Return", "Argument", "Lcom/android/tools/idea/welcome/install/InstallOperation;", "context", "Lcom/android/tools/idea/welcome/install/InstallContext;", "runnable", "Lcom/google/common/base/Function;", "progressShare", "", "(Lcom/android/tools/idea/welcome/install/InstallContext;Lcom/google/common/base/Function;D)V", "cleanup", "", "result", "(Ljava/lang/Object;)V", "perform", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "argument", "(Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/lang/Object;)Ljava/lang/Object;", "intellij.android.core"})
    private static final class FunctionWrapper<Return, Argument>
    extends InstallOperation<Return, Argument> {
        @NotNull
        private final Function<Argument, Return> runnable;

        public FunctionWrapper(@NotNull InstallContext context2, @NotNull Function<Argument, Return> runnable2, double progressShare) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter(runnable2, (String)"runnable");
            super(context2, progressShare);
            this.runnable = runnable2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Return perform(@NotNull ProgressIndicator indicator, Argument argument) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            indicator.start();
            try {
                Object object2 = this.runnable.apply(argument);
                Intrinsics.checkNotNull((Object)object2);
                object = object2;
            }
            finally {
                indicator.setFraction(1.0);
            }
            return (Return)object;
        }

        @Override
        public void cleanup(Return result2) {
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00050\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/welcome/install/InstallOperation$Companion;", "", "()V", "wrap", "Lcom/android/tools/idea/welcome/install/InstallOperation;", "Return", "Argument", "context", "Lcom/android/tools/idea/welcome/install/InstallContext;", "function", "Lcom/google/common/base/Function;", "progressShare", "", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <Return, Argument> InstallOperation<Return, Argument> wrap(@NotNull InstallContext context2, @NotNull Function<Argument, Return> function, double progressShare) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter(function, (String)"function");
            return new FunctionWrapper<Return, Argument>(context2, function, progressShare);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

