/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.sdklib.devices.Storage;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.startup.AndroidSdkInitializer;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.HaxmKt;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"GVM_WINDOWS_INSTALL_URL", "", "HAXM_DOCUMENTATION_URL", "HAXM_WINDOWS_INSTALL_URL", "getInitialSdkLocation", "Ljava/io/File;", "mode", "Lcom/android/tools/idea/welcome/config/FirstRunWizardMode;", "getMaxHaxmMemory", "", "memorySize", "", "getRecommendedHaxmMemory", "intellij.android.core"})
@JvmName(name="FirstRunWizardDefaults")
public final class FirstRunWizardDefaults {
    @NotNull
    public static final String HAXM_DOCUMENTATION_URL = "https://github.com/intel/haxm";
    @NotNull
    public static final String HAXM_WINDOWS_INSTALL_URL = "https://github.com/intel/haxm/wiki/Installation-Instructions-on-Windows";
    @NotNull
    public static final String GVM_WINDOWS_INSTALL_URL = "https://github.com/google/android-emulator-hypervisor-driver";

    public static final int getRecommendedHaxmMemory(long memorySize) {
        long gb = Storage.Unit.GiB.getNumberOfBytes();
        long defaultMemory = memorySize > (long)16 * gb ? (long)4 * gb : (memorySize > (long)4 * gb ? (long)2 * gb : (memorySize > (long)2 * gb ? gb : Math.min(memorySize, gb / (long)2)));
        return RangesKt.coerceAtMost((int)((int)(defaultMemory / HaxmKt.UI_UNITS.getNumberOfBytes())), (int)FirstRunWizardDefaults.getMaxHaxmMemory(memorySize));
    }

    public static final int getMaxHaxmMemory(long memorySize) {
        long gb = Storage.Unit.GiB.getNumberOfBytes();
        long maxMemory = RangesKt.coerceAtLeast((long)(memorySize - (long)2 * gb), (long)(memorySize / (long)2));
        return (int)(maxMemory / HaxmKt.UI_UNITS.getNumberOfBytes());
    }

    @NotNull
    public static final File getInitialSdkLocation(@NotNull FirstRunWizardMode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        File file2 = mode.getSdkLocation();
        if (file2 == null) {
            List<Sdk> list2 = AndroidSdks.getInstance().getAllAndroidSdks();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getInstance().allAndroidSdks");
            Sdk sdk = (Sdk)CollectionsKt.firstOrNull(list2);
            if ((sdk != null && (sdk = sdk.getHomeDirectory()) != null ? FileExtensions.toIoFile((VirtualFile)sdk) : (file2 = null)) == null) {
                File file3 = AndroidSdkInitializer.getAndroidSdkPathOrDefault();
                file2 = file3;
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAndroidSdkPathOrDefault()");
            }
        }
        return file2;
    }
}

