/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.annotations.concurrency.Slow;
import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.InstallerFactory;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.Uninstaller;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.installer.BasicInstallerFactory;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.progress.ThrottledProgressWrapper;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.welcome.install.InstallableComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J&\u0010\u0012\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/welcome/install/ComponentInstaller;", "", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "(Lcom/android/sdklib/repository/AndroidSdkHandler;)V", "ensureSdkPackagesUninstalled", "", "packageNames", "", "", "progress", "Lcom/android/repository/api/ProgressIndicator;", "getPackagesToInstall", "", "Lcom/android/repository/api/RemotePackage;", "components", "", "Lcom/android/tools/idea/welcome/install/InstallableComponent;", "installPackages", "packages", "downloader", "Lcom/android/repository/api/Downloader;", "intellij.android.core"})
public final class ComponentInstaller {
    @NotNull
    private final AndroidSdkHandler sdkHandler;

    public ComponentInstaller(@NotNull AndroidSdkHandler sdkHandler) {
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        this.sdkHandler = sdkHandler;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RemotePackage> getPackagesToInstall(@NotNull Iterable<? extends InstallableComponent> components) throws SdkQuickfixUtils.PackageResolutionException {
        void $this$mapTo$iv$iv;
        Iterable list$iv$iv;
        InstallableComponent it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(components, (String)"components");
        StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager sdkManager = this.sdkHandler.getSdkManager((ProgressIndicator)progress2);
        Iterable<? extends InstallableComponent> $this$flatMap$iv = components;
        boolean $i$f$flatMap = false;
        Iterable<? extends InstallableComponent> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (InstallableComponent)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getPackagesToInstall();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List requests2 = (List)destination$iv$iv;
        List<UpdatablePackage> list2 = SdkQuickfixUtils.resolve(requests2, sdkManager.getPackages());
        Intrinsics.checkNotNullExpressionValue(list2, (String)"resolve(requests, sdkManager.packages)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (UpdatablePackage)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            RemotePackage remotePackage = it.getRemote();
            Intrinsics.checkNotNull((Object)remotePackage);
            collection2.add(remotePackage);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Slow
    public final void installPackages(@NotNull List<? extends RemotePackage> packages, @NotNull Downloader downloader, @NotNull ProgressIndicator progress2) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        Intrinsics.checkNotNullParameter((Object)downloader, (String)"downloader");
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        ThrottledProgressWrapper throttledProgress = new ThrottledProgressWrapper(progress2);
        RepoManager sdkManager = this.sdkHandler.getSdkManager((ProgressIndicator)throttledProgress);
        double progressMax = 0.0;
        double progressIncrement = 0.9 / ((double)packages.size() * 2.0);
        BasicInstallerFactory factory2 = new BasicInstallerFactory();
        Iterable $this$map$iv = packages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RemotePackage remotePackage = (RemotePackage)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(factory2.createInstaller((RemotePackage)it, sdkManager, downloader));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Installer installer = (Installer)element$iv;
            boolean bl = false;
            if (installer.prepare(throttledProgress.createSubProgress(progressMax += progressIncrement))) {
                installer.complete(throttledProgress.createSubProgress(progressMax + progressIncrement));
            }
            throttledProgress.setFraction(progressMax += progressIncrement);
        }
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, throttledProgress.createSubProgress(1.0), null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Slow
    public final void ensureSdkPackagesUninstalled(@NotNull Collection<String> packageNames, @NotNull ProgressIndicator progress2) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(packageNames, (String)"packageNames");
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        RepoManager sdkManager = this.sdkHandler.getSdkManager(progress2);
        Map localPackages = sdkManager.getPackages().getLocalPackages();
        List packagesToUninstall = new ArrayList();
        for (String packageName2 : packageNames) {
            LocalPackage p = (LocalPackage)localPackages.get(packageName2);
            if (p != null) {
                packagesToUninstall.add(p);
                continue;
            }
            progress2.logInfo("Package '" + packageName2 + "' does not appear to be installed - ignoring");
        }
        double progressMax = 0.0;
        double progressIncrement = 0.9 / ((double)packagesToUninstall.size() * 2.0);
        InstallerFactory factory2 = (InstallerFactory)new BasicInstallerFactory();
        Iterable $this$map$iv = packagesToUninstall;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocalPackage localPackage = (LocalPackage)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(factory2.createUninstaller((LocalPackage)it, sdkManager));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Uninstaller uninstaller = (Uninstaller)element$iv;
            boolean bl = false;
            if (uninstaller.prepare(progress2.createSubProgress(progressMax += progressIncrement))) {
                uninstaller.complete(progress2.createSubProgress(progressMax + progressIncrement));
            }
            progress2.setFraction(progressMax += progressIncrement);
        }
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, progress2.createSubProgress(1.0), null, null);
        progress2.setFraction(1.0);
    }
}

