/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.tools.idea.avdmanager.HardwareAccelerationCheck;
import com.android.tools.idea.welcome.install.CheckSdkOperationKt;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.WizardException;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/welcome/install/CheckSdkOperation;", "Lcom/android/tools/idea/welcome/install/InstallOperation;", "Ljava/io/File;", "context", "Lcom/android/tools/idea/welcome/install/InstallContext;", "(Lcom/android/tools/idea/welcome/install/InstallContext;)V", "cleanup", "", "result", "perform", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "file", "intellij.android.core"})
public final class CheckSdkOperation
extends InstallOperation<File, File> {
    public CheckSdkOperation(@NotNull InstallContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, 0.0);
    }

    @Override
    @NotNull
    protected File perform(@NotNull ProgressIndicator indicator, @NotNull File file2) throws WizardException, InstallationCancelledException {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (HardwareAccelerationCheck.isChromeOSAndIsNotHWAccelerated()) {
            return file2;
        }
        File tool = new File(file2, "emulator" + File.separator + CheckSdkOperationKt.access$getTOOL_NAME$p());
        if (!tool.isFile()) {
            throw new WizardException("SDK emulator directory is missing");
        }
        if (!CheckSdkOperationKt.access$checkExecutePermission(tool)) {
            throw new WizardException(tool.getAbsolutePath() + " file is not a valid executable");
        }
        if (!CheckSdkOperationKt.access$checkRuns(tool)) {
            throw new WizardException(CheckSdkOperationKt.access$getERROR_CANT_RUN_TOOL$p());
        }
        return file2;
    }

    @Override
    public void cleanup(@NotNull File result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
    }
}

