/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.support.AndroidxName;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.DependencyManagementException;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0001H\u0007\u001a&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0001\u001a2\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u000b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u0007H\u0007\u001a\u0012\u0010\u000e\u001a\u00020\u0007*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u0007*\u00020\u000b\u001a\n\u0010\u0012\u001a\u00020\u0007*\u00020\u000b\u001a\n\u0010\u0013\u001a\u00020\u0007*\u00020\u000b\u001a\u0014\u0010\u0014\u001a\u00020\u0001*\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u0016*F\u0010\u0017\" \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u00010\u00182 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u00010\u0018\u00a8\u0006\u0019"}, d2={"createAddDependencyMessage", "", "coordinates", "", "Lcom/android/ide/common/repository/GradleCoordinate;", "warning", "userWantsToAdd", "", "project", "Lcom/intellij/openapi/project/Project;", "addDependenciesWithUiConfirmation", "Lcom/intellij/openapi/module/Module;", "promptUserBeforeAdding", "requestSync", "dependsOn", "artifactId", "Lcom/android/tools/idea/projectsystem/GoogleMavenArtifactId;", "dependsOnAndroidx", "dependsOnAppCompat", "dependsOnOldSupportLib", "mapAndroidxName", "name", "Lcom/android/support/AndroidxName;", "DependencyAnalysis", "Lkotlin/Triple;", "intellij.android.core"})
@JvmName(name="DependencyManagementUtil")
public final class DependencyManagementUtil {
    public static final boolean dependsOn(@NotNull Module $this$dependsOn, @NotNull GoogleMavenArtifactId artifactId) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$dependsOn, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)((Object)artifactId), (String)"artifactId");
            try {
                GradleCoordinate coordinate = new GradleCoordinate(artifactId.getMavenGroupId(), artifactId.getMavenArtifactId(), "+");
                return ProjectSystemUtil.getModuleSystem($this$dependsOn).getResolvedDependency(coordinate) != null;
            }
            catch (DependencyManagementException e) {
                Logger.getInstance((String)$this$dependsOn.getClass().getName()).warn(e.getMessage());
            }
            catch (Throwable e) {
                if ($this$dependsOn.isDisposed()) break block3;
                throw e;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean dependsOnAndroidx(@NotNull Module $this$dependsOnAndroidx) {
        boolean bl;
        block4: {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$dependsOnAndroidx, (String)"<this>");
            GoogleMavenArtifactId[] $this$filter$iv = GoogleMavenArtifactId.values();
            boolean $i$f$filter = false;
            GoogleMavenArtifactId[] googleMavenArtifactIdArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)it.getMavenGroupId(), (String)"androidx", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GoogleMavenArtifactId it = (GoogleMavenArtifactId)((Object)element$iv);
                    boolean bl3 = false;
                    if (!DependencyManagementUtil.dependsOn($this$dependsOnAndroidx, it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean dependsOnOldSupportLib(@NotNull Module $this$dependsOnOldSupportLib) {
        boolean bl;
        block4: {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$dependsOnOldSupportLib, (String)"<this>");
            GoogleMavenArtifactId[] $this$filter$iv = GoogleMavenArtifactId.values();
            boolean $i$f$filter = false;
            GoogleMavenArtifactId[] googleMavenArtifactIdArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)it.getMavenGroupId(), (String)"com.android.support", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GoogleMavenArtifactId it = (GoogleMavenArtifactId)((Object)element$iv);
                    boolean bl3 = false;
                    if (!DependencyManagementUtil.dependsOn($this$dependsOnOldSupportLib, it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final String mapAndroidxName(@Nullable Module $this$mapAndroidxName, @NotNull AndroidxName name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Module module2 = $this$mapAndroidxName;
        if (module2 == null) {
            String string2 = name.defaultName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.defaultName()");
            return string2;
        }
        boolean dependsOnAndroidx = DependencyManagementUtil.dependsOnAndroidx(module2);
        if (dependsOnAndroidx) {
            String string3 = name.newName();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name.newName()");
        } else {
            String string4 = name.oldName();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"name.oldName()");
        }
        return string;
    }

    public static final boolean dependsOnAppCompat(@NotNull Module $this$dependsOnAppCompat) {
        Intrinsics.checkNotNullParameter((Object)$this$dependsOnAppCompat, (String)"<this>");
        return DependencyManagementUtil.dependsOn($this$dependsOnAppCompat, GoogleMavenArtifactId.APP_COMPAT_V7) || DependencyManagementUtil.dependsOn($this$dependsOnAppCompat, GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7);
    }

    /*
     * WARNING - void declaration
     */
    @UiThread
    @JvmOverloads
    @NotNull
    public static final List<GradleCoordinate> addDependenciesWithUiConfirmation(@NotNull Module $this$addDependenciesWithUiConfirmation, @NotNull List<GradleCoordinate> coordinates, boolean promptUserBeforeAdding, boolean requestSync2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair coordinateToException2;
        Object errorMessage;
        List coordinatesToExceptions2;
        Intrinsics.checkNotNullParameter((Object)$this$addDependenciesWithUiConfirmation, (String)"<this>");
        Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (coordinates.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem($this$addDependenciesWithUiConfirmation);
        Iterable $this$distinctBy$iv = coordinates;
        boolean $i$f$distinctBy = false;
        HashSet<Pair> set$iv = new HashSet<Pair>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            GradleCoordinate it = (GradleCoordinate)e$iv;
            boolean bl = false;
            Pair key$iv = new Pair((Object)it.getGroupId(), (Object)it.getArtifactId());
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinctCoordinates = list$iv;
        Triple triple = (Triple)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(moduleSystem, distinctCoordinates){
            final /* synthetic */ AndroidModuleSystem $moduleSystem;
            final /* synthetic */ List<GradleCoordinate> $distinctCoordinates;
            {
                this.$moduleSystem = $moduleSystem;
                this.$distinctCoordinates = $distinctCoordinates;
            }

            public final Triple<List<GradleCoordinate>, List<GradleCoordinate>, String> compute() {
                return this.$moduleSystem.analyzeDependencyCompatibility(this.$distinctCoordinates);
            }
        }, "Analyzing Dependency Compatibility", false, moduleSystem.getModule().getProject());
        List compatibleDependencies = (List)triple.component1();
        List incompatibleDependencies = (List)triple.component2();
        String warning = (String)triple.component3();
        if (promptUserBeforeAdding) {
            Project project = $this$addDependenciesWithUiConfirmation.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            if (!DependencyManagementUtil.userWantsToAdd(project, distinctCoordinates, warning)) {
                return distinctCoordinates;
            }
        } else if (!((Collection)incompatibleDependencies).isEmpty()) {
            Messages.showErrorDialog((String)warning, (String)"Compatibility Issues Detected");
            if (compatibleDependencies.isEmpty()) {
                return incompatibleDependencies;
            }
        }
        boolean shouldSync = (coordinatesToExceptions2 = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(compatibleDependencies, moduleSystem){
            final /* synthetic */ List<GradleCoordinate> $compatibleDependencies;
            final /* synthetic */ AndroidModuleSystem $moduleSystem;
            {
                this.$compatibleDependencies = $compatibleDependencies;
                this.$moduleSystem = $moduleSystem;
            }

            public final List<Pair<GradleCoordinate, DependencyManagementException>> compute() {
                ArrayList<Pair> coordinatesToExceptions2 = new ArrayList<Pair>();
                for (GradleCoordinate coordinate : this.$compatibleDependencies) {
                    try {
                        this.$moduleSystem.registerDependency(coordinate);
                    }
                    catch (DependencyManagementException e) {
                        coordinatesToExceptions2.add(new Pair((Object)coordinate, (Object)e));
                    }
                }
                return coordinatesToExceptions2;
            }
        }, "Adding Dependencies", false, moduleSystem.getModule().getProject())).size() < compatibleDependencies.size() && requestSync2;
        Intrinsics.checkNotNullExpressionValue((Object)coordinatesToExceptions2, (String)"coordinatesToExceptions");
        if (!((Collection)coordinatesToExceptions2).isEmpty()) {
            errorMessage = "The following dependencies could not be added:\n";
            for (Pair coordinateToException2 : coordinatesToExceptions2) {
                errorMessage = (String)errorMessage + coordinateToException2.getFirst() + " Reason: " + ((DependencyManagementException)coordinateToException2.getSecond()).getMessage() + "\n";
            }
            if (shouldSync) {
                errorMessage = (String)errorMessage + "\nA sync will be still be performed to resolve the dependencies that were added successfully.";
            }
            Messages.showErrorDialog((String)errorMessage, (String)"Could Not Add Dependency");
        }
        if (shouldSync) {
            Project project = $this$addDependenciesWithUiConfirmation.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            ProjectSystemUtil.getSyncManager(project).syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
        }
        errorMessage = coordinatesToExceptions2;
        Collection collection2 = incompatibleDependencies;
        boolean $i$f$map = false;
        coordinateToException2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add((GradleCoordinate)it.getFirst());
        }
        return CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
    }

    public static /* synthetic */ List addDependenciesWithUiConfirmation$default(Module module2, List list2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return DependencyManagementUtil.addDependenciesWithUiConfirmation(module2, list2, bl, bl2);
    }

    public static final boolean userWantsToAdd(@NotNull Project project, @NotNull List<GradleCoordinate> coordinates, @NotNull String warning) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
        return Messages.showOkCancelDialog((Project)project, (String)DependencyManagementUtil.createAddDependencyMessage(coordinates, warning), (String)"Add Project Dependency", (Icon)Messages.getErrorIcon()) == 0;
    }

    public static /* synthetic */ boolean userWantsToAdd$default(Project project, List list2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        return DependencyManagementUtil.userWantsToAdd(project, list2, string);
    }

    @VisibleForTesting
    @NotNull
    public static final String createAddDependencyMessage(@NotNull List<GradleCoordinate> coordinates, @NotNull String warning) {
        Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
        String libraryNames2 = CollectionsKt.joinToString$default((Iterable)coordinates, (CharSequence)", ", null, null, (int)0, null, (Function1)createAddDependencyMessage.libraryNames.1.INSTANCE, (int)30, null);
        String string = StringUtil.pluralize((String)"this", (int)coordinates.size());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluralize(\"this\", coordinates.size)");
        String these = string;
        String string2 = StringUtil.pluralize((String)"library", (int)coordinates.size());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pluralize(\"library\", coordinates.size)");
        String libraries2 = string2;
        String requires = "This operation requires the " + libraries2 + " " + libraryNames2 + ".";
        if (((CharSequence)warning).length() == 0) {
            return requires + "\n\nWould you like to add " + these + " now?";
        }
        String them = coordinates.size() > 1 ? "them" : "it";
        return requires + "\n\nProblem: " + warning + "\n\nThe project may not compile after adding " + these + " " + libraries2 + ".\nWould you like to add " + them + " anyway?";
    }

    public static /* synthetic */ String createAddDependencyMessage$default(List list2, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return DependencyManagementUtil.createAddDependencyMessage(list2, string);
    }

    @UiThread
    @JvmOverloads
    @NotNull
    public static final List<GradleCoordinate> addDependenciesWithUiConfirmation(@NotNull Module $this$addDependenciesWithUiConfirmation, @NotNull List<GradleCoordinate> coordinates, boolean promptUserBeforeAdding) {
        Intrinsics.checkNotNullParameter((Object)$this$addDependenciesWithUiConfirmation, (String)"<this>");
        Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
        return DependencyManagementUtil.addDependenciesWithUiConfirmation$default($this$addDependenciesWithUiConfirmation, coordinates, promptUserBeforeAdding, false, 4, null);
    }
}

