/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;

abstract class UpdaterTreeNode
extends DefaultMutableTreeNode
implements Comparable<UpdaterTreeNode>,
SdkUpdaterConfigPanel.MultiStateRow {
    UpdaterTreeNode() {
    }

    public abstract PackageNodeModel.SelectedState getInitialState();

    public abstract PackageNodeModel.SelectedState getCurrentState();

    protected abstract void setState(PackageNodeModel.SelectedState var1);

    public final void resetState() {
        this.setState(this.getInitialState());
    }

    public boolean includeInSummary() {
        return false;
    }

    public boolean isPrimary() {
        return false;
    }

    @Override
    public final void cycleState() {
        if (this.getCurrentState() == null) {
            return;
        }
        if (this.getCurrentState() == PackageNodeModel.SelectedState.NOT_INSTALLED) {
            if (this.canHaveMixedState()) {
                this.setState(PackageNodeModel.SelectedState.MIXED);
            } else {
                this.setState(PackageNodeModel.SelectedState.INSTALLED);
            }
        } else if (this.getCurrentState() == PackageNodeModel.SelectedState.INSTALLED) {
            this.setState(PackageNodeModel.SelectedState.NOT_INSTALLED);
        } else {
            this.setState(PackageNodeModel.SelectedState.INSTALLED);
        }
    }

    protected boolean canHaveMixedState() {
        return false;
    }

    @NotNull
    public String getStatusString() {
        return "";
    }

    @Override
    public int compareTo(@NotNull UpdaterTreeNode o) {
        return this.toString().compareTo(o.toString());
    }

    public void customizeRenderer(Renderer renderer2, JTree tree2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
    }

    public static class Renderer
    extends JPanel
    implements TreeCellRenderer {
        private final ColoredTreeCellRenderer myTextRenderer;
        public final ThreeStateCheckBox myCheckbox = new ThreeStateCheckBox();

        public Renderer() {
            super(new BorderLayout());
            this.myTextRenderer = new ColoredTreeCellRenderer(){

                public void customizeCellRenderer(@NotNull JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                }
            };
            this.myTextRenderer.setOpaque(true);
            this.add((Component)this.myCheckbox, "West");
            this.add((Component)this.myTextRenderer, "Center");
        }

        @Override
        public final Component getTreeCellRendererComponent(JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (!(value2 instanceof UpdaterTreeNode)) {
                return null;
            }
            UpdaterTreeNode node = (UpdaterTreeNode)value2;
            this.invalidate();
            this.myCheckbox.setVisible(true);
            if (node.getCurrentState() == PackageNodeModel.SelectedState.MIXED) {
                this.myCheckbox.setState(ThreeStateCheckBox.State.DONT_CARE);
            } else {
                this.myCheckbox.setSelected(node.getCurrentState() == PackageNodeModel.SelectedState.INSTALLED);
            }
            this.myCheckbox.setOpaque(false);
            this.myCheckbox.setBackground(null);
            this.setBackground(null);
            this.myTextRenderer.getTreeCellRendererComponent(tree2, value2, selected, expanded, leaf, row2, hasFocus);
            node.customizeRenderer(this, tree2, selected, expanded, leaf, row2, hasFocus);
            this.revalidate();
            return this;
        }

        public ColoredTreeCellRenderer getTextRenderer() {
            return this.myTextRenderer;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleRenderer();
            }
            return this.accessibleContext;
        }

        protected class AccessibleRenderer
        extends JPanel.AccessibleJPanel {
            protected AccessibleRenderer() {
                super(Renderer.this);
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return Renderer.this.myCheckbox.getAccessibleContext().getAccessibleRole();
            }

            @Override
            public String getAccessibleName() {
                return AccessibleContextUtil.combineAccessibleStrings((String)Renderer.this.myTextRenderer.getAccessibleContext().getAccessibleName(), (String)Renderer.this.myCheckbox.getAccessibleContext().getAccessibleName());
            }

            @Override
            public String getAccessibleDescription() {
                return AccessibleContextUtil.combineAccessibleStrings((String)Renderer.this.myTextRenderer.getAccessibleContext().getAccessibleDescription(), (String)Renderer.this.myCheckbox.getAccessibleContext().getAccessibleDescription());
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet set = new AccessibleStateSet();
                set.addAll(Renderer.this.myCheckbox.getAccessibleContext().getAccessibleStateSet().toArray());
                set.addAll(Renderer.this.myTextRenderer.getAccessibleContext().getAccessibleStateSet().toArray());
                return set;
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                return Renderer.this.myCheckbox.getAccessibleContext().getAccessibleAction();
            }
        }
    }
}

