/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.SettingsController;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigurable;
import com.android.tools.idea.updater.configure.SourcesTableModel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateSitesPanel {
    private JPanel myRootPanel;
    private TableView myUpdateSitesTable;
    private JPanel mySourcesPanel;
    private JPanel mySourcesLoadingPanel;
    private AsyncProcessIcon mySourcesLoadingIcon;
    private JCheckBox myForceHttp;
    private JCheckBox myDisableSdkPatches;
    private SourcesTableModel mySourcesTableModel;
    private static SettingsController ourSettingsController = StudioSettingsController.getInstance();

    public UpdateSitesPanel(@NotNull Runnable refreshCallback) {
        this.$$$setupUI$$$();
        this.init(refreshCallback);
    }

    private void init(@NotNull Runnable refreshCallback) {
        this.mySourcesTableModel.setRefreshCallback(refreshCallback);
    }

    private void createUIComponents() {
        this.mySourcesLoadingIcon = new AsyncProcessIcon("Loading...");
        Runnable finishLoadingCallback = () -> {
            this.mySourcesLoadingPanel.setVisible(false);
            DataManager dataManager = DataManager.getInstance();
            DataContext dataContext = dataManager.getDataContext((Component)this.myRootPanel);
            @Nullable Settings settings = (Settings)Settings.KEY.getData(dataContext);
            if (settings != null) {
                settings.revalidate();
            }
        };
        this.mySourcesTableModel = new SourcesTableModel(() -> this.mySourcesLoadingPanel.setVisible(true), finishLoadingCallback, ModalityState.current());
        this.myUpdateSitesTable = new TableView((ListTableModel)this.mySourcesTableModel);
        ToolbarDecorator userDefinedDecorator = ToolbarDecorator.createDecorator((JTable)this.myUpdateSitesTable);
        this.mySourcesPanel = this.addExtraActions(userDefinedDecorator).createPanel();
        SdkUpdaterConfigPanel.setTableProperties((JTable)this.myUpdateSitesTable, null);
    }

    private ToolbarDecorator addExtraActions(ToolbarDecorator decorator2) {
        return decorator2.setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                UpdateSitesPanel.this.mySourcesTableModel.editRow(UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRow());
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                return UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRowCount() == 1 && UpdateSitesPanel.this.mySourcesTableModel.isEditable(UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRow());
            }
        }).setAddActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                return UpdateSitesPanel.this.mySourcesTableModel.isEditable();
            }
        }).addExtraAction(new AnActionButton("Select All", AllIcons.Actions.Selectall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                UpdateSitesPanel.this.mySourcesTableModel.setAllEnabled(true);
            }

            public boolean isEnabled() {
                return UpdateSitesPanel.this.mySourcesTableModel.hasEditableRows();
            }
        }).addExtraAction(new AnActionButton("Deselect All", AllIcons.Actions.Unselectall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                UpdateSitesPanel.this.mySourcesTableModel.setAllEnabled(false);
            }

            public boolean isEnabled() {
                return UpdateSitesPanel.this.mySourcesTableModel.hasEditableRows();
            }
        }).setMoveDownAction(null).setMoveUpAction(null).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                if (UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRowCount() < 1) {
                    return false;
                }
                for (int i : UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRows()) {
                    if (UpdateSitesPanel.this.mySourcesTableModel.isEditable(i)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public boolean isModified() {
        return this.mySourcesTableModel.isSourcesModified() || ourSettingsController.getForceHttp() != this.myForceHttp.isSelected() || ourSettingsController.getDisableSdkPatches() != this.myDisableSdkPatches.isSelected();
    }

    public void reset() {
        this.mySourcesTableModel.reset();
        this.myForceHttp.setSelected(ourSettingsController.getForceHttp());
        this.myDisableSdkPatches.setSelected(ourSettingsController.getDisableSdkPatches());
    }

    public void setConfigurable(@NotNull SdkUpdaterConfigurable configurable) {
        this.mySourcesTableModel.setConfigurable(configurable);
    }

    public void save() {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                UpdateSitesPanel.this.mySourcesTableModel.save(ProgressManager.getInstance().getProgressIndicator());
                ourSettingsController.setForceHttp(UpdateSitesPanel.this.myForceHttp.isSelected());
                ourSettingsController.setDisableSdkPatches(UpdateSitesPanel.this.myDisableSdkPatches.isSelected());
            }
        }, "Saving Sources", false, null, (JComponent)this.myRootPanel);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("These sites are consulted for installing and updating SDK platforms and tools.");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, new Dimension(600, -1), new Dimension(600, -1)));
        JPanel jPanel3 = this.mySourcesPanel;
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.mySourcesLoadingPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Loading sources...");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.mySourcesLoadingIcon;
        jPanel.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myForceHttp = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Force https://... sources to be fetched using http://...");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDisableSdkPatches = jCheckBox = new JCheckBox();
        jCheckBox.setText("Disable SDK diff patching");
        jCheckBox.setToolTipText("Disabling SDK diff patching will likely increase SDK packages download volumes, but will speed up package installation once downloaded. This may be useful if you have a fast internet connection with no traffic limitations but local patch installation takes a significant amount of time on your machine. SDK diff patching is enabled by default and is the preferred installation method for higher-end hardware.");
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jPanel2.add((Component)jBLabel3, new GridConstraints(3, 1, 1, 2, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

