/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.SettingsController;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.adapters.AdapterProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.ui.ApplicationUtils;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.updater.configure.CheckboxClickListener;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.PlatformComponentsPanel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigurable;
import com.android.tools.idea.updater.configure.ToolComponentsPanel;
import com.android.tools.idea.updater.configure.UpdateSitesPanel;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.wizard.deprecated.ConsolidatedProgressStep;
import com.android.tools.idea.welcome.wizard.deprecated.InstallComponentsPath;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DialogWrapperHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.SingleStepPath;
import com.android.utils.FileUtils;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsConfigurable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.table.SelectionProvider;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkUpdaterConfigPanel
implements Disposable {
    private JPanel myRootPane;
    private JTextField mySdkLocationTextField;
    private JComboBox<File> mySdkLocationChooser;
    private JBLabel mySdkLocationLabel;
    private JPanel mySdkLocationPanel;
    private HyperlinkLabel myEditSdkLink;
    private HyperlinkLabel myCleanupDiskLink;
    private JBLabel mySdkErrorLabel;
    private PlatformComponentsPanel myPlatformComponentsPanel;
    private ToolComponentsPanel myToolComponentsPanel;
    private UpdateSitesPanel myUpdateSitesPanel;
    private HyperlinkLabel myChannelLink;
    private JBTabbedPane myTabPane;
    private final Downloader myDownloader;
    private final SettingsController mySettings;
    private final SdkUpdaterConfigurable myConfigurable;
    private final OptionalValueProperty<File> mySelectedSdkLocation;
    private final BindingsManager myBindingsManager;
    private final RepoManager.RepoLoadedListener myLocalUpdater;
    private final RepoManager.RepoLoadedListener myRemoteUpdater;

    public SdkUpdaterConfigPanel(final @NotNull Runnable channelChangedCallback, @Nullable Downloader downloader, @Nullable SettingsController settings, @NotNull SdkUpdaterConfigurable configurable) {
        this.$$$setupUI$$$();
        this.mySelectedSdkLocation = new OptionalValueProperty();
        this.myBindingsManager = new BindingsManager();
        this.myLocalUpdater = packages -> ApplicationManager.getApplication().invokeLater(() -> this.loadPackages(packages), ModalityState.any());
        this.myRemoteUpdater = new RepoManager.RepoLoadedListener(){

            public void loaded(@NotNull RepositoryPackages packages) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    SdkUpdaterConfigPanel.this.loadPackages(packages);
                    SdkUpdaterConfigPanel.this.myPlatformComponentsPanel.finishLoading();
                    SdkUpdaterConfigPanel.this.myToolComponentsPanel.finishLoading();
                }, ModalityState.any());
            }
        };
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.SDK_MANAGER).setKind(AndroidStudioEvent.EventKind.SDK_MANAGER_LOADED));
        this.myConfigurable = configurable;
        this.myUpdateSitesPanel.setConfigurable(configurable);
        this.myDownloader = downloader;
        this.mySettings = settings;
        Collection<File> sdkLocations = SdkUpdaterConfigPanel.getSdkLocations();
        if (!sdkLocations.isEmpty()) {
            this.mySelectedSdkLocation.set((File)((Object)sdkLocations.stream().findFirst()));
        }
        this.mySelectedSdkLocation.addListener(() -> ApplicationManager.getApplication().invokeLater(this::reset));
        ((CardLayout)this.mySdkLocationPanel.getLayout()).show(this.mySdkLocationPanel, "SingleSdk");
        this.setUpSingleSdkChooser();
        this.setUpDiskCleanupLink();
        this.myBindingsManager.bindTwoWay(this.mySelectedSdkLocation, new AdapterProperty<String, Optional<File>>((AbstractProperty)new TextProperty(this.mySdkLocationTextField), (Optional)this.mySelectedSdkLocation.get()){

            @Override
            @NotNull
            protected Optional<File> convertFromSourceType(@NotNull String value2) {
                if (value2.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(new File(value2));
            }

            @Override
            @NotNull
            protected String convertFromDestType(@NotNull Optional<File> value2) {
                return value2.map(File::getPath).orElse("");
            }
        });
        this.myChannelLink.setHyperlinkText("Preview packages available! ", "Switch", " to Preview Channel to see them");
        this.myChannelLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                UpdateSettingsConfigurable settings = new UpdateSettingsConfigurable(false);
                ShowSettingsUtil.getInstance().editConfigurable((Component)SdkUpdaterConfigPanel.this.getComponent(), (Configurable)settings);
                channelChangedCallback.run();
            }
        });
        this.myToolComponentsPanel.setConfigurable(this.myConfigurable);
        this.myPlatformComponentsPanel.setConfigurable(this.myConfigurable);
    }

    @Nullable
    File getSelectedSdkLocation() {
        return ((Optional)this.mySelectedSdkLocation.get()).orElse(null);
    }

    @NotNull
    private static Collection<File> getSdkLocations() {
        File androidHome = IdeSdks.getInstance().getAndroidSdkPath();
        if (androidHome != null) {
            return ImmutableList.of((Object)androidHome);
        }
        HashSet<File> locations = new HashSet<File>();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            try {
                LocalProperties localProperties = new LocalProperties(project);
                File androidSdkPath = localProperties.getAndroidSdkPath();
                if (androidSdkPath != null) {
                    locations.add(androidSdkPath);
                    continue;
                }
            }
            catch (IOException ignored) {
                Logger.getInstance(SdkUpdaterConfigPanel.class).info("Unable to read local.properties file from project: " + project.getName(), (Throwable)ignored);
            }
            List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
            for (AndroidFacet facet2 : facets) {
                AndroidPlatform androidPlatform = AndroidPlatform.getInstance(facet2.getModule());
                AndroidSdkData sdkData = androidPlatform == null ? null : androidPlatform.getSdkData();
                if (sdkData == null) continue;
                locations.add(sdkData.getLocationFile());
            }
        }
        return locations;
    }

    private void setUpSingleSdkChooser() {
        this.myEditSdkLink.setHyperlinkText("Edit");
        this.myEditSdkLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                DialogWrapperHost host = new DialogWrapperHost(null);
                DynamicWizard wizard = new DynamicWizard(null, null, "SDK Setup", host){

                    @Override
                    public void init() {
                        DownloadingComponentsStep progressStep = new DownloadingComponentsStep(this.myHost.getDisposable(), this.myHost);
                        String sdkPath = SdkUpdaterConfigPanel.this.mySdkLocationTextField.getText();
                        File location2 = StringUtil.isEmpty((String)sdkPath) ? FirstRunWizardDefaults.getInitialSdkLocation(FirstRunWizardMode.MISSING_SDK) : new File(sdkPath);
                        InstallComponentsPath path2 = new InstallComponentsPath(FirstRunWizardMode.MISSING_SDK, location2, progressStep, false);
                        progressStep.setInstallComponentsPath(path2);
                        this.addPath(path2);
                        this.addPath(new SingleStepPath(progressStep));
                        super.init();
                    }

                    @Override
                    public void performFinishingActions() {
                        File sdkLocation = IdeSdks.getInstance().getAndroidSdkPath();
                        if (sdkLocation == null) {
                            return;
                        }
                        String stateSdkLocationPath = this.myState.get(WizardConstants.KEY_SDK_INSTALL_LOCATION);
                        assert (stateSdkLocationPath != null);
                        File stateSdkLocation = new File(stateSdkLocationPath);
                        if (!FileUtil.filesEqual((File)sdkLocation, (File)stateSdkLocation)) {
                            SdkUpdaterConfigPanel.setAndroidSdkLocation(stateSdkLocation);
                            sdkLocation = stateSdkLocation;
                        }
                        SdkUpdaterConfigPanel.this.mySelectedSdkLocation.setValue(sdkLocation);
                        SdkUpdaterConfigPanel.this.refresh(false);
                    }

                    @Override
                    @NotNull
                    protected String getProgressTitle() {
                        return "Setting up SDK...";
                    }

                    @Override
                    protected String getWizardActionDescription() {
                        return "Setting up SDK...";
                    }
                };
                wizard.init();
                wizard.show();
            }
        });
        this.mySdkLocationTextField.setEditable(false);
    }

    private void setUpDiskCleanupLink() {
        this.myCleanupDiskLink.setHyperlinkText("Optimize disk space");
        this.myCleanupDiskLink.addHyperlinkListener(e -> {
            HtmlBuilder cleanupMessageBuilder;
            File sdkLocation = this.getSelectedSdkLocation();
            if (sdkLocation == null) {
                return;
            }
            ImmutableSet SDK_DIRECTORIES_TO_CLEANUP = ImmutableSet.of((Object)".temp", (Object)".downloadIntermediates");
            try {
                cleanupMessageBuilder = (HtmlBuilder)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> SdkUpdaterConfigPanel.lambda$setUpDiskCleanupLink$3((Set)SDK_DIRECTORIES_TO_CLEANUP, sdkLocation), "Analyzing SDK Disk Space Utilization", true, null);
            }
            catch (ProcessCanceledException ex) {
                return;
            }
            if (cleanupMessageBuilder == null) {
                Messages.showInfoMessage((Component)this.myRootPane, (String)"The disk space utilized by this SDK is already optimized.", (String)"SDK Disk Space Utilization");
            } else if (SdkUpdaterConfigurable.confirmChange(cleanupMessageBuilder)) {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> SdkUpdaterConfigPanel.lambda$setUpDiskCleanupLink$4((Set)SDK_DIRECTORIES_TO_CLEANUP, sdkLocation), "Deleting SDK Temporary Files", false, null);
            }
        });
    }

    public void dispose() {
        this.myBindingsManager.releaseAll();
    }

    private static void setAndroidSdkLocation(File sdkLocation) {
        ApplicationUtils.invokeWriteActionAndWait(ModalityState.any(), () -> IdeSdks.getInstance().setAndroidSdkPath(sdkLocation, null));
    }

    public JComponent getComponent() {
        return this.myRootPane;
    }

    public boolean isModified() {
        return this.myPlatformComponentsPanel.isModified() || this.myToolComponentsPanel.isModified() || this.myUpdateSitesPanel.isModified();
    }

    static void setTreeTableProperties(TreeTableView tt, UpdaterTreeNode.Renderer renderer2, ChangeListener listener2) {
        tt.setTreeCellRenderer((TreeCellRenderer)renderer2);
        new CheckboxClickListener(tt, renderer2).installOn((Component)tt);
        TreeUtil.installActions((JTree)tt.getTree());
        tt.getTree().setToggleClickCount(0);
        tt.getTree().setShowsRootHandles(true);
        SdkUpdaterConfigPanel.setTableProperties((JTable)tt, listener2);
    }

    static void setTableProperties(final @NotNull JTable table2, final @Nullable ChangeListener listener2) {
        assert (table2 instanceof SelectionProvider);
        ActionMap am = table2.getActionMap();
        final CycleAction forwardAction = new CycleAction(false);
        final CycleAction backwardAction = new CycleAction(true);
        if (!ScreenReader.isActive()) {
            am.put("selectPreviousColumnCell", backwardAction);
            am.put("selectNextColumnCell", forwardAction);
        }
        table2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n' || e.getKeyChar() == ' ') {
                    Collection selection = ((SelectionProvider)table2).getSelection();
                    for (MultiStateRow node : selection) {
                        node.cycleState();
                        table2.repaint();
                        if (listener2 == null) continue;
                        listener2.stateChanged(new ChangeEvent(node));
                    }
                }
            }
        });
        table2.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != null) {
                    table2.getSelectionModel().clearSelection();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                JTable table22 = (JTable)e.getSource();
                if (table22.getSelectionModel().getMinSelectionIndex() != -1) {
                    return;
                }
                boolean traversalBackward = "TRAVERSAL_BACKWARD".equals(SdkUpdaterConfigPanel.getCause(e));
                if (traversalBackward) {
                    backwardAction.doAction(table22);
                } else {
                    forwardAction.doAction(table22);
                }
            }
        });
    }

    @Nullable
    private static String getCause(@NotNull FocusEvent event) {
        try {
            Method getCause = event.getClass().getDeclaredMethod("getCause", new Class[0]);
            Object enumValue = getCause.invoke((Object)event, new Object[0]);
            if (enumValue == null) {
                return null;
            }
            return enumValue.toString();
        }
        catch (ReflectiveOperationException ex) {
            Logger.getInstance(SdkUpdaterConfigPanel.class).warn((Throwable)ex);
            return null;
        }
    }

    protected static void resizeColumnsToFit(JTable table2) {
        TableColumnModel columnModel = table2.getColumnModel();
        for (int column2 = 1; column2 < table2.getColumnCount(); ++column2) {
            int width = 50;
            for (int row2 = 0; row2 < table2.getRowCount(); ++row2) {
                TableCellRenderer renderer2 = table2.getCellRenderer(row2, column2);
                Component comp = table2.prepareRenderer(renderer2, row2, column2);
                width = Math.max(comp.getPreferredSize().width + 1, width);
            }
            columnModel.getColumn(column2).setPreferredWidth(width);
        }
    }

    public void refresh(boolean forceRemoteReload) {
        this.validate();
        Project[] projects2 = ProjectManager.getInstance().getOpenProjects();
        StudioProgressRunner progressRunner = new StudioProgressRunner(false, false, "Loading SDK", projects2.length == 0 ? null : projects2[0]);
        if (forceRemoteReload) {
            this.myPlatformComponentsPanel.startLoading();
            this.myToolComponentsPanel.startLoading();
            this.myConfigurable.getRepoManager().load(0L, (List)ImmutableList.of((Object)this.myLocalUpdater), (List)ImmutableList.of((Object)this.myRemoteUpdater), null, (ProgressRunner)progressRunner, this.myDownloader, this.mySettings);
        } else {
            this.myConfigurable.getRepoManager().load(0L, (List)ImmutableList.of((Object)this.myLocalUpdater), null, null, (ProgressRunner)progressRunner, null, this.mySettings);
        }
    }

    private void validate() {
        Path nullableSdkPath = this.myConfigurable.getRepoManager().getLocalPath();
        @NotNull Path sdkLocation = nullableSdkPath == null ? Paths.get("", new String[0]) : nullableSdkPath;
        Validator.Result result2 = PathValidator.forAndroidSdkLocation().validate(sdkLocation);
        Validator.Severity severity = result2.getSeverity();
        if (severity == Validator.Severity.OK) {
            this.mySdkLocationLabel.setForeground(JBColor.foreground());
            this.mySdkErrorLabel.setVisible(false);
        } else {
            this.mySdkErrorLabel.setIcon(severity.getIcon());
            this.mySdkErrorLabel.setText(result2.getMessage());
            this.mySdkErrorLabel.setVisible(true);
        }
        boolean enabled = severity != Validator.Severity.ERROR;
        this.myPlatformComponentsPanel.setEnabled(enabled);
        this.myTabPane.setEnabled(enabled);
    }

    private void loadPackages(RepositoryPackages packages) {
        TreeMultimap platformPackages = TreeMultimap.create();
        TreeSet toolsPackages = Sets.newTreeSet();
        for (UpdatablePackage info2 : packages.getConsolidatedPkgs().values()) {
            RepoPackage p = info2.getRepresentative();
            TypeDetails details = p.getTypeDetails();
            if (details instanceof DetailsTypes.ApiDetailsType) {
                platformPackages.put((Object)((DetailsTypes.ApiDetailsType)details).getAndroidVersion(), (Object)info2);
                continue;
            }
            toolsPackages.add(info2);
        }
        this.myPlatformComponentsPanel.setPackages((Multimap<AndroidVersion, UpdatablePackage>)platformPackages);
        this.myToolComponentsPanel.setPackages(toolsPackages);
    }

    public Collection<PackageNodeModel> getStates() {
        ArrayList<PackageNodeModel> result2 = new ArrayList<PackageNodeModel>();
        result2.addAll(this.myPlatformComponentsPanel.myStates);
        result2.addAll(this.myToolComponentsPanel.myStates);
        return result2;
    }

    public void reset() {
        this.refresh(true);
        Collection<File> sdkLocations = SdkUpdaterConfigPanel.getSdkLocations();
        if (sdkLocations.size() == 1) {
            this.mySdkLocationTextField.setText(sdkLocations.iterator().next().getPath());
        }
        if (sdkLocations.isEmpty()) {
            this.myCleanupDiskLink.setEnabled(false);
        } else {
            this.myCleanupDiskLink.setEnabled(true);
        }
        this.myPlatformComponentsPanel.reset();
        this.myToolComponentsPanel.reset();
        this.myUpdateSitesPanel.reset();
    }

    public void saveSources() {
        this.myUpdateSitesPanel.save();
    }

    public boolean areSourcesModified() {
        return this.myUpdateSitesPanel.isModified();
    }

    private void createUIComponents() {
        this.myUpdateSitesPanel = new UpdateSitesPanel(() -> this.refresh(true));
    }

    private static /* synthetic */ void lambda$setUpDiskCleanupLink$4(Set SDK_DIRECTORIES_TO_CLEANUP, File sdkLocation) {
        for (String cleanupDir : SDK_DIRECTORIES_TO_CLEANUP) {
            File cleanupDirFile = new File(sdkLocation, cleanupDir);
            FileUtil.delete((File)cleanupDirFile);
        }
    }

    private static /* synthetic */ HtmlBuilder lambda$setUpDiskCleanupLink$3(Set SDK_DIRECTORIES_TO_CLEANUP, File sdkLocation) throws RuntimeException {
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        long totalSizeToCleanup = 0L;
        htmlBuilder.openHtmlBody();
        htmlBuilder.addHtml("The files under the following SDK locations can be safely cleaned up:").newline().beginList();
        for (String cleanupDir : SDK_DIRECTORIES_TO_CLEANUP) {
            File cleanupDirFile = new File(sdkLocation, cleanupDir);
            long size = 0L;
            for (File f : FileUtils.getAllFiles((File)cleanupDirFile)) {
                size += f.length();
            }
            if (size <= 0L) continue;
            htmlBuilder.listItem().addHtml(cleanupDirFile.getAbsolutePath() + " (" + new Storage(size).toUiString() + ") ");
            totalSizeToCleanup += size;
        }
        htmlBuilder.endList();
        htmlBuilder.addHtml("Do you want to proceed with deleting the specified files?");
        htmlBuilder.closeHtmlBody();
        if (totalSizeToCleanup > 0L) {
            return htmlBuilder;
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel2;
        ToolComponentsPanel toolComponentsPanel;
        PlatformComponentsPanel platformComponentsPanel;
        JBTabbedPane jBTabbedPane;
        HyperlinkLabel hyperlinkLabel3;
        HyperlinkLabel hyperlinkLabel4;
        JTextField jTextField;
        JPanel jPanel;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRootPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Manager for the Android SDK and Tools used by the IDE");
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 8, 2, 3, 3, null, null, null));
        this.mySdkLocationLabel = jBLabel2 = new JBLabel();
        jBLabel2.setEnabled(true);
        jBLabel2.setText("Android SDK Location:");
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.mySdkErrorLabel = jBLabel = new JBLabel();
        jBLabel.setText("SDK Location must be set");
        jBLabel.setVisible(false);
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.mySdkLocationPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, "SingleSdk");
        this.mySdkLocationTextField = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, new Dimension(400, -1), null, null));
        this.myEditSdkLink = hyperlinkLabel4 = new HyperlinkLabel();
        jPanel4.add((Component)hyperlinkLabel4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 3, null, null, null));
        this.myCleanupDiskLink = hyperlinkLabel3 = new HyperlinkLabel();
        jPanel4.add((Component)hyperlinkLabel3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, "MultiSdk");
        JComboBox jComboBox = new JComboBox();
        this.mySdkLocationChooser = jComboBox;
        jPanel5.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myTabPane = jBTabbedPane = new JBTabbedPane();
        jPanel2.add((Component)jBTabbedPane, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 7, null, new Dimension(200, 200), null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("SDK Platforms", null, jPanel6, null);
        this.myPlatformComponentsPanel = platformComponentsPanel = new PlatformComponentsPanel();
        JComponent jComponent = platformComponentsPanel.$$$getRootComponent$$$();
        jPanel6.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("SDK Tools", null, jPanel7, null);
        this.myToolComponentsPanel = toolComponentsPanel = new ToolComponentsPanel();
        JComponent jComponent2 = toolComponentsPanel.$$$getRootComponent$$$();
        jPanel7.add((Component)jComponent2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("SDK Update Sites", null, jPanel8, null);
        UpdateSitesPanel updateSitesPanel = this.myUpdateSitesPanel;
        JComponent jComponent3 = updateSitesPanel.$$$getRootComponent$$$();
        jPanel8.add((Component)jComponent3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myChannelLink = hyperlinkLabel2 = new HyperlinkLabel();
        hyperlinkLabel2.setVisible(false);
        jPanel2.add((Component)hyperlinkLabel2, new GridConstraints(3, 1, 1, 1, 4, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPane;
    }

    public static interface MultiStateRow {
        public void cycleState();
    }

    private static class CycleAction
    extends AbstractAction {
        final boolean myBackward;

        CycleAction(boolean backward) {
            this.myBackward = backward;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.doAction((JTable)evt.getSource());
        }

        public void doAction(JTable table2) {
            int row2;
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            ListSelectionModel selectionModel = table2.getSelectionModel();
            int n = row2 = this.myBackward ? selectionModel.getMinSelectionIndex() : selectionModel.getMaxSelectionIndex();
            if (row2 == -1 && this.myBackward) {
                row2 = table2.getRowCount();
            }
            if ((row2 += this.myBackward ? -1 : 1) < 0) {
                manager.focusPreviousComponent(table2);
            } else if (row2 >= table2.getRowCount()) {
                manager.focusNextComponent(table2);
            } else {
                selectionModel.setSelectionInterval(row2, row2);
                table2.setColumnSelectionInterval(1, 1);
                table2.scrollRectToVisible(table2.getCellRect(row2, 1, true));
            }
            table2.repaint();
        }
    }

    private static final class DownloadingComponentsStep
    extends ConsolidatedProgressStep {
        private InstallComponentsPath myInstallComponentsPath;

        private DownloadingComponentsStep(@NotNull Disposable disposable2, @NotNull DynamicWizardHost host) {
            super(disposable2, host);
        }

        private void setInstallComponentsPath(InstallComponentsPath installComponentsPath) {
            this.setPaths(Collections.singletonList(installComponentsPath));
            this.myInstallComponentsPath = installComponentsPath;
        }

        @Override
        public boolean isStepVisible() {
            return this.myInstallComponentsPath.shouldDownloadingComponentsStepBeShown();
        }
    }
}

