/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.validation.validators;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.ui.validation.validators.PathValidatorKt;
import com.android.tools.idea.ui.validation.validators.Rule;
import com.intellij.openapi.util.SystemInfo;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.jcip.annotations.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Immutable
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0012\u0013B+\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/ui/validation/validators/PathValidator;", "Lcom/android/tools/adtui/validation/Validator;", "Ljava/nio/file/Path;", "pathName", "", "errors", "", "Lcom/android/tools/idea/ui/validation/validators/Rule;", "warnings", "(Ljava/lang/String;Ljava/lang/Iterable;Ljava/lang/Iterable;)V", "getErrors", "()Ljava/lang/Iterable;", "validate", "Lcom/android/tools/adtui/validation/Validator$Result;", "value", "projectFile", "severity", "Lcom/android/tools/adtui/validation/Validator$Severity;", "Builder", "Companion", "intellij.android.core"})
public final class PathValidator
implements Validator<Path> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pathName;
    @NotNull
    private final Iterable<Rule> errors;
    @NotNull
    private final Iterable<Rule> warnings;

    private PathValidator(String pathName, Iterable<? extends Rule> errors2, Iterable<? extends Rule> warnings) {
        this.pathName = pathName;
        this.errors = errors2;
        this.warnings = warnings;
    }

    @TestOnly
    @NotNull
    public final Iterable<Rule> getErrors() {
        return this.errors;
    }

    @NotNull
    public Validator.Result validate(@NotNull Path value2) {
        Validator.Result result2;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        try {
            Validator.Result result3;
            Validator.Result it = result3 = this.validate(value2, Validator.Severity.ERROR);
            boolean bl = false;
            Object object = !Intrinsics.areEqual((Object)it, (Object)Validator.Result.OK) ? result3 : null;
            if (object == null) {
                Validator.Result result4;
                Validator.Result it2 = result4 = this.validate(value2, Validator.Severity.WARNING);
                boolean bl2 = false;
                object = !Intrinsics.areEqual((Object)it2, (Object)Validator.Result.OK) ? result4 : null;
                if (object == null) {
                    object = Validator.Result.OK;
                }
            }
            result2 = object;
        }
        catch (Exception ex) {
            PathValidatorKt.access$getLogger().warn((Throwable)ex);
            result2 = new Validator.Result(Validator.Severity.ERROR, "Invalid file, see Help -> Show Log for more details: " + value2, null, 4, null);
        }
        return result2;
    }

    private final Validator.Result validate(Path projectFile, Validator.Severity severity) {
        boolean bl;
        boolean bl2 = bl = severity != Validator.Severity.OK;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Iterable<Rule> rules2 = severity == Validator.Severity.ERROR ? this.errors : this.warnings;
        for (Rule rule : rules2) {
            Path matchingFile = rule.getMatchingFile(projectFile);
            if (matchingFile == null) continue;
            return new Validator.Result(severity, rule.getMessage(matchingFile, this.pathName), null, 4, null);
        }
        return Validator.Result.OK;
    }

    @JvmStatic
    @NotNull
    public static final PathValidator createDefault(@NotNull String pathName) {
        return Companion.createDefault(pathName);
    }

    @JvmStatic
    @NotNull
    public static final PathValidator forAndroidSdkLocation() {
        return Companion.forAndroidSdkLocation();
    }

    @JvmStatic
    @NotNull
    public static final PathValidator forAndroidNdkLocation() {
        return Companion.forAndroidNdkLocation();
    }

    public /* synthetic */ PathValidator(String pathName, Iterable errors2, Iterable warnings, DefaultConstructorMarker $constructor_marker) {
        this(pathName, errors2, warnings);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\u0000J\u0006\u0010\f\u001a\u00020\u0000J\b\u0010\r\u001a\u00020\u0000H\u0007J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/ui/validation/validators/PathValidator$Builder;", "", "()V", "errors", "", "Lcom/android/tools/idea/ui/validation/validators/Rule;", "warnings", "build", "Lcom/android/tools/idea/ui/validation/validators/PathValidator;", "pathName", "", "withAllRules", "withCommonRules", "withCommonTestRules", "withError", "rule", "withWarning", "intellij.android.core"})
    public static final class Builder {
        @NotNull
        private final List<Rule> errors = new ArrayList();
        @NotNull
        private final List<Rule> warnings = new ArrayList();

        @NotNull
        public final Builder withAllRules() {
            this.withCommonRules();
            this.withError(PathValidatorKt.getIS_EMPTY());
            this.withError(PathValidatorKt.getPATH_NOT_WRITABLE());
            this.withWarning(PathValidatorKt.getNON_EMPTY_DIRECTORY());
            return this;
        }

        @NotNull
        public final Builder withCommonRules() {
            this.withCommonTestRules();
            if (SystemInfo.isWindows) {
                this.withError(PathValidatorKt.getWINDOWS_PATH_TOO_LONG());
            }
            return this;
        }

        @TestOnly
        @NotNull
        public final Builder withCommonTestRules() {
            this.withError(PathValidatorKt.getINVALID_SLASHES());
            this.withError(PathValidatorKt.getILLEGAL_CHARACTER());
            this.withWarning(PathValidatorKt.getWHITESPACE());
            if (SystemInfo.isWindows) {
                this.withError(PathValidatorKt.getILLEGAL_WINDOWS_FILENAME());
                this.withError(PathValidatorKt.getNON_ASCII_CHARS());
            } else {
                this.withWarning(PathValidatorKt.getILLEGAL_WINDOWS_FILENAME());
                this.withWarning(PathValidatorKt.getNON_ASCII_CHARS());
            }
            this.withError(PathValidatorKt.getPARENT_DIRECTORY_NOT_WRITABLE());
            this.withError(PathValidatorKt.getLOCATION_IS_A_FILE());
            this.withError(PathValidatorKt.getLOCATION_IS_ROOT());
            this.withError(PathValidatorKt.getPARENT_IS_NOT_A_DIRECTORY());
            this.withError(PathValidatorKt.getPATH_INSIDE_ANDROID_STUDIO());
            return this;
        }

        @NotNull
        public final Builder withError(@NotNull Rule rule) {
            Builder builder2;
            Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
            Builder $this$withError_u24lambda_u2d0 = builder2 = this;
            boolean bl = false;
            $this$withError_u24lambda_u2d0.errors.add(rule);
            return builder2;
        }

        @NotNull
        public final Builder withWarning(@NotNull Rule rule) {
            Builder builder2;
            Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
            Builder $this$withWarning_u24lambda_u2d1 = builder2 = this;
            boolean bl = false;
            $this$withWarning_u24lambda_u2d1.warnings.add(rule);
            return builder2;
        }

        @NotNull
        public final PathValidator build(@NotNull String pathName) {
            Intrinsics.checkNotNullParameter((Object)pathName, (String)"pathName");
            return new PathValidator(pathName, this.errors, this.warnings, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/ui/validation/validators/PathValidator$Companion;", "", "()V", "createDefault", "Lcom/android/tools/idea/ui/validation/validators/PathValidator;", "pathName", "", "forAndroidNdkLocation", "forAndroidSdkLocation", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PathValidator createDefault(@NotNull String pathName) {
            Intrinsics.checkNotNullParameter((Object)pathName, (String)"pathName");
            return new Builder().withAllRules().build(pathName);
        }

        @JvmStatic
        @NotNull
        public final PathValidator forAndroidSdkLocation() {
            return new Builder().withCommonRules().build("Android SDK location");
        }

        @JvmStatic
        @NotNull
        public final PathValidator forAndroidNdkLocation() {
            return new Builder().withCommonRules().build("Android NDK location");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

