/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenshot;

import com.android.tools.idea.ui.AndroidAdbUiBundle;
import com.android.tools.idea.ui.screenshot.ScreenshotImage;
import com.android.tools.idea.ui.screenshot.ScreenshotSupplier;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.ExceptionUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/ui/screenshot/ScreenshotTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "project", "Lcom/intellij/openapi/project/Project;", "screenshotSupplier", "Lcom/android/tools/idea/ui/screenshot/ScreenshotSupplier;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/ui/screenshot/ScreenshotSupplier;)V", "<set-?>", "", "error", "getError", "()Ljava/lang/String;", "Lcom/android/tools/idea/ui/screenshot/ScreenshotImage;", "screenshot", "getScreenshot", "()Lcom/android/tools/idea/ui/screenshot/ScreenshotImage;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.android.adb.ui"})
public class ScreenshotTask
extends Task.Modal {
    @NotNull
    private final ScreenshotSupplier screenshotSupplier;
    @Nullable
    private ScreenshotImage screenshot;
    @Nullable
    private String error;

    public ScreenshotTask(@NotNull Project project, @NotNull ScreenshotSupplier screenshotSupplier) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)screenshotSupplier, (String)"screenshotSupplier");
        super(project, AndroidAdbUiBundle.message("screenshot.action.title", new Object[0]), true);
        this.screenshotSupplier = screenshotSupplier;
    }

    @Nullable
    public final ScreenshotImage getScreenshot() {
        return this.screenshot;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.setIndeterminate(true);
        indicator.setText(AndroidAdbUiBundle.message("screenshot.task.step.obtain", new Object[0]));
        try {
            this.screenshot = this.screenshotSupplier.captureScreenshot();
        }
        catch (Exception e) {
            if (indicator.isCanceled()) {
                return;
            }
            String message2 = ExceptionUtil.getMessage((Throwable)e);
            if (message2 == null) {
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)e.getClass().getName(), (String)"e.javaClass.name");
                AndroidAdbUiBundle.message("screenshot.error.generic", objectArray);
            }
            this.error = message2;
        }
    }
}

