/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenshot;

import com.android.tools.adtui.ImageUtils;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001d\u001a\u00020\fH\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0010H\u0002J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0005R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0011\u0010\u001b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/ui/screenshot/ScreenshotImage;", "", "image", "Ljava/awt/image/BufferedImage;", "screenshotRotationQuadrants", "", "displayInfo", "", "isTv", "", "(Ljava/awt/image/BufferedImage;ILjava/lang/String;Z)V", "displayDensity", "", "getDisplayDensity", "()D", "displaySize", "Ljava/awt/Dimension;", "getDisplaySize", "()Ljava/awt/Dimension;", "height", "getHeight", "()I", "getImage", "()Ljava/awt/image/BufferedImage;", "isRoundDisplay", "()Z", "getScreenshotRotationQuadrants", "width", "getWidth", "computeDisplayDensity", "computeDisplaySize", "rotated", "rotationQuadrants", "intellij.android.adb.ui"})
public final class ScreenshotImage {
    @NotNull
    private final BufferedImage image;
    private final int screenshotRotationQuadrants;
    @NotNull
    private final String displayInfo;
    private final boolean isTv;
    private final boolean isRoundDisplay;
    @Nullable
    private final Dimension displaySize;
    private final double displayDensity;

    public ScreenshotImage(@NotNull BufferedImage image, int screenshotRotationQuadrants, @NotNull String displayInfo, boolean isTv) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)displayInfo, (String)"displayInfo");
        this.image = image;
        this.screenshotRotationQuadrants = screenshotRotationQuadrants;
        this.displayInfo = displayInfo;
        this.isTv = isTv;
        this.isRoundDisplay = StringsKt.contains$default((CharSequence)this.displayInfo, (CharSequence)"FLAG_ROUND", (boolean)false, (int)2, null);
        this.displaySize = this.computeDisplaySize();
        this.displayDensity = this.computeDisplayDensity();
    }

    @NotNull
    public final BufferedImage getImage() {
        return this.image;
    }

    public final int getScreenshotRotationQuadrants() {
        return this.screenshotRotationQuadrants;
    }

    public final boolean isTv() {
        return this.isTv;
    }

    public final int getWidth() {
        return this.image.getWidth();
    }

    public final int getHeight() {
        return this.image.getHeight();
    }

    public final boolean isRoundDisplay() {
        return this.isRoundDisplay;
    }

    @Nullable
    public final Dimension getDisplaySize() {
        return this.displaySize;
    }

    public final double getDisplayDensity() {
        return this.displayDensity;
    }

    @NotNull
    public final ScreenshotImage rotated(int rotationQuadrants) {
        if (rotationQuadrants == 0) {
            return this;
        }
        BufferedImage bufferedImage = ImageUtils.rotateByQuadrants((BufferedImage)this.image, (int)rotationQuadrants);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"rotateByQuadrants(image, rotationQuadrants)");
        return new ScreenshotImage(bufferedImage, this.screenshotRotationQuadrants + rotationQuadrants & 3, this.displayInfo, this.isTv);
    }

    private final Dimension computeDisplaySize() {
        Dimension dimension2;
        MatchResult matchResult = Regex.find$default((Regex)new Regex("(\\d+) x (\\d+)"), (CharSequence)this.displayInfo, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getDestructured()) == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        String width = (String)matchResult2.getMatch().getGroupValues().get(1);
        String height = (String)matchResult2.getMatch().getGroupValues().get(2);
        try {
            dimension2 = new Dimension(Integer.parseInt(width), Integer.parseInt(height));
        }
        catch (NumberFormatException e) {
            dimension2 = null;
        }
        return dimension2;
    }

    private final double computeDisplayDensity() {
        double d;
        MatchResult matchResult = Regex.find$default((Regex)new Regex("density (\\d+)"), (CharSequence)this.displayInfo, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getDestructured()) == null) {
            return Double.NaN;
        }
        String density = (String)matchResult.getMatch().getGroupValues().get(1);
        try {
            d = Double.parseDouble(density);
        }
        catch (NumberFormatException e) {
            d = Double.NaN;
        }
        return d;
    }
}

