/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenrecording;

import com.android.tools.idea.ui.AndroidAdbUiBundle;
import com.android.tools.idea.ui.screenrecording.ScreenRecorderPersistentOptions;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScreenRecorderOptionsDialog
extends DialogWrapper {
    @NonNls
    private static final String SCREENRECORDER_DIMENSIONS_KEY = "ScreenshotRecorder.Options.Dimensions";
    private final DefaultComboBoxModel<Integer> myComboBoxModel;
    private JPanel myPanel;
    @VisibleForTesting
    JTextField myBitRateTextField;
    @VisibleForTesting
    JCheckBox myShowTouchCheckBox;
    private JCheckBox myEmulatorRecordingCheckBox;
    private JComboBox<Integer> myResolutionPercentComboBox;
    private JBLabel myRecordingLengthLabel;

    public ScreenRecorderOptionsDialog(@NotNull Project project, boolean isEmulator, int apiLevel) {
        super(project, true);
        Integer[] integerArray = new Integer[3];
        this.$$$setupUI$$$();
        integerArray[0] = 100;
        integerArray[1] = 50;
        integerArray[2] = 30;
        this.myComboBoxModel = new DefaultComboBoxModel<Integer>(integerArray);
        ScreenRecorderPersistentOptions options2 = ScreenRecorderPersistentOptions.getInstance();
        this.myResolutionPercentComboBox.setModel(this.myComboBoxModel);
        this.myComboBoxModel.setSelectedItem(options2.getResolutionPercent());
        if (options2.getBitRateMbps() > 0) {
            this.myBitRateTextField.setText(Integer.toString(options2.getBitRateMbps()));
        }
        this.myShowTouchCheckBox.setSelected(options2.getShowTaps());
        this.myEmulatorRecordingCheckBox.setSelected(options2.getUseEmulatorRecording());
        this.myEmulatorRecordingCheckBox.setVisible(isEmulator);
        this.myEmulatorRecordingCheckBox.addItemListener(event -> this.updateMaxRecordingLengthLabel(isEmulator, apiLevel));
        this.updateMaxRecordingLengthLabel(isEmulator, apiLevel);
        this.setTitle("Screen Recorder Options");
        this.init();
    }

    private void updateMaxRecordingLengthLabel(boolean isEmulator, int apiLevel) {
        int maxRecordingDurationMin = isEmulator && this.myEmulatorRecordingCheckBox.isSelected() || apiLevel >= 34 ? 30 : 3;
        this.myRecordingLengthLabel.setText(AndroidAdbUiBundle.message("screenrecord.options.info", maxRecordingDurationMin));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return SCREENRECORDER_DIMENSIONS_KEY;
    }

    @Nullable
    protected String getHelpId() {
        return "org.jetbrains.android.r/studio-ui/am-video.html";
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.getOKAction().putValue("Name", AndroidAdbUiBundle.message("screenrecord.options.ok.button.text", new Object[0]));
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo info2 = ScreenRecorderOptionsDialog.validateInteger(this.myBitRateTextField, AndroidAdbUiBundle.message("screenrecord.options.bit.rate.invalid", new Object[0]));
        if (info2 != null) {
            return info2;
        }
        return super.doValidate();
    }

    @Nullable
    private static ValidationInfo validateInteger(JTextField textField2, String errorMessage) {
        String s = ScreenRecorderOptionsDialog.getText(textField2);
        if (s.isEmpty()) {
            return null;
        }
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return new ValidationInfo(errorMessage, (JComponent)textField2);
        }
        return null;
    }

    protected void doOKAction() {
        ScreenRecorderPersistentOptions options2 = ScreenRecorderPersistentOptions.getInstance();
        options2.setBitRateMbps(ScreenRecorderOptionsDialog.getIntegerValue(this.myBitRateTextField));
        options2.setResolutionPercent((Integer)this.myComboBoxModel.getSelectedItem());
        options2.setShowTaps(this.myShowTouchCheckBox.isSelected());
        options2.setUseEmulatorRecording(this.myEmulatorRecordingCheckBox.isSelected());
        super.doOKAction();
    }

    private static int getIntegerValue(JTextField textField2) {
        String s = ScreenRecorderOptionsDialog.getText(textField2);
        return s.isEmpty() ? 0 : Integer.parseInt(s);
    }

    private static String getText(JTextField textField2) {
        Document doc = textField2.getDocument();
        try {
            return doc.getText(0, doc.getLength()).trim();
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    public boolean getUseEmulatorRecording() {
        return ScreenRecorderPersistentOptions.getInstance().getUseEmulatorRecording();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JBLabel jBLabel;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setHorizontalTextPosition(10);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/AndroidAdbUiBundle").getString("screenrecord.options.bit.rate"));
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myBitRateTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, new Dimension(30, -1), new Dimension(150, -1), null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setHorizontalTextPosition(10);
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/AndroidAdbUiBundle").getString("screenrecord.options.resolution"));
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRecordingLengthLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/AndroidAdbUiBundle").getString("screenrecord.options.info"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myShowTouchCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/AndroidAdbUiBundle").getString("screenrecord.options.show.taps"));
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("messages/AndroidAdbUiBundle").getString("screenrecord.options.show.taps.tooltip"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 3, 8, 0, 2, 0, null, null, null));
        this.myEmulatorRecordingCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalTextPosition(11);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/AndroidAdbUiBundle").getString("screenrecord.options.use.emulator.recording"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("messages/AndroidAdbUiBundle").getString("screenrecord.options.use.emulator.recording.tooltip"));
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 3, 8, 0, 2, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myResolutionPercentComboBox = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 2, 1, 1, 0, 3, 7, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

