/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenrecording;

import com.android.tools.idea.ui.AndroidAdbUiBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderDialog;", "", "dialogTitle", "", "onStop", "Ljava/lang/Runnable;", "(Ljava/lang/String;Ljava/lang/Runnable;)V", "recordingLabel", "Ljavax/swing/JLabel;", "value", "recordingLabelText", "getRecordingLabelText", "()Ljava/lang/String;", "setRecordingLabelText", "(Ljava/lang/String;)V", "", "recordingTimeMillis", "getRecordingTimeMillis", "()J", "setRecordingTimeMillis", "(J)V", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "createWrapper", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "recordingTimeText", "timeMillis", "MyDialogWrapper", "intellij.android.adb.ui"})
public final class ScreenRecorderDialog {
    @NotNull
    private final String dialogTitle;
    @NotNull
    private final Runnable onStop;
    private long recordingTimeMillis;
    @NotNull
    private String recordingLabelText;
    private JLabel recordingLabel;

    public ScreenRecorderDialog(@NotNull String dialogTitle, @NotNull Runnable onStop) {
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)onStop, (String)"onStop");
        this.dialogTitle = dialogTitle;
        this.onStop = onStop;
        this.recordingLabelText = this.recordingTimeText(this.recordingTimeMillis);
    }

    public final long getRecordingTimeMillis() {
        return this.recordingTimeMillis;
    }

    public final void setRecordingTimeMillis(long value2) {
        this.recordingTimeMillis = value2;
        this.setRecordingLabelText(this.recordingTimeText(value2));
    }

    @NotNull
    public final String getRecordingLabelText() {
        return this.recordingLabelText;
    }

    public final void setRecordingLabelText(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.recordingLabelText = value2;
        JLabel jLabel = this.recordingLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recordingLabel");
            jLabel = null;
        }
        jLabel.setText(value2);
    }

    private final String recordingTimeText(long timeMillis) {
        int seconds = (int)(timeMillis / (long)1000);
        Object[] objectArray = new Object[1];
        String string = "%02d:%02d";
        Object[] objectArray2 = new Object[]{seconds / 60, seconds % 60};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(format, *args)");
        return AndroidAdbUiBundle.message("screenrecord.dialog.progress", objectArray);
    }

    private final DialogPanel createPanel() {
        DialogPanel dialogPanel = ComponentsKt.DialogPanel$default((String)this.dialogTitle, null, (int)2, null);
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setText(this.dialogTitle);
        titlePanel.setActive(true);
        WindowMoveListener moveListener2 = new WindowMoveListener(titlePanel){

            @NotNull
            protected Component getView(@NotNull Component component2) {
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                Container container = SwingUtilities.getAncestorOfClass(DialogWrapperDialog.class, component2);
                Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getAncestorOfClass(Dialo\u2026g::class.java, component)");
                return container;
            }
        };
        titlePanel.addMouseListener((MouseListener)moveListener2);
        titlePanel.addMouseMotionListener((MouseMotionListener)moveListener2);
        dialogPanel.add((Component)titlePanel, (Object)"North");
        BorderLayoutPanel centerPanel2 = new BorderLayoutPanel();
        centerPanel2.setBorder((Border)JBUI.Borders.empty((int)15, (int)10));
        this.recordingLabel = ComponentsKt.Label$default((String)this.recordingTimeText(this.recordingTimeMillis), null, null, (boolean)false, (int)14, null);
        JLabel jLabel = this.recordingLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recordingLabel");
            jLabel = null;
        }
        centerPanel2.addToLeft((Component)jLabel);
        centerPanel2.addToCenter(Box.createRigidArea(new Dimension(JBUIScale.scale((int)20), 0)));
        JButton stopButton = new JButton(AndroidAdbUiBundle.message("screenrecord.dialog.stop.recording", new Object[0]));
        stopButton.addActionListener(new ActionListener(this){
            final /* synthetic */ ScreenRecorderDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                ScreenRecorderDialog.access$getOnStop$p(this.this$0).run();
            }
        });
        centerPanel2.addToRight((Component)stopButton);
        dialogPanel.add((Component)centerPanel2, (Object)"Center");
        return dialogPanel;
    }

    @NotNull
    public final DialogWrapper createWrapper(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new MyDialogWrapper(project, (JPanel)this.createPanel());
    }

    public static final /* synthetic */ Runnable access$getOnStop$p(ScreenRecorderDialog $this) {
        return $this.onStop;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\n\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0014J\b\u0010\f\u001a\u00020\rH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderDialog$MyDialogWrapper;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "panel", "Ljavax/swing/JPanel;", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/JPanel;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "createContentPaneBorder", "Ljavax/swing/border/Border;", "createSouthPanel", "init", "", "intellij.android.adb.ui"})
    private static final class MyDialogWrapper
    extends DialogWrapper {
        @NotNull
        private final JPanel panel;

        public MyDialogWrapper(@Nullable Project project, @NotNull JPanel panel2) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            super(project, false, DialogWrapper.IdeModalityType.MODELESS);
            this.panel = panel2;
            this.init();
        }

        protected void init() {
            super.init();
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(0);
            this.panel.setBorder((Border)PopupBorder.Factory.create((boolean)true, (boolean)true));
            this.getCancelAction().setEnabled(false);
        }

        @NotNull
        protected JComponent createCenterPanel() {
            return this.panel;
        }

        @Nullable
        protected JComponent createSouthPanel() {
            return null;
        }

        @Nullable
        protected Border createContentPaneBorder() {
            return null;
        }
    }
}

