/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.ui;

import com.android.resources.ResourceType;
import com.android.tools.idea.ui.resourcemanager.explorer.DesignAssetCellRenderer;
import com.android.tools.idea.ui.resourcemanager.model.ResourceAssetSet;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.ColorAssetCellRenderer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.SketchImporterViewKt;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fH\u0002R\u0017\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/ui/ResourcesView;", "Ljavax/swing/JTabbedPane;", "drawableAssets", "", "Lcom/android/tools/idea/ui/resourcemanager/model/ResourceAssetSet;", "colorAssets", "Lkotlin/Pair;", "Ljava/awt/Color;", "", "designAssetCellRenderer", "Lcom/android/tools/idea/ui/resourcemanager/explorer/DesignAssetCellRenderer;", "colorResourceCellRenderer", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/ui/ColorAssetCellRenderer;", "(Ljava/util/List;Ljava/util/List;Lcom/android/tools/idea/ui/resourcemanager/explorer/DesignAssetCellRenderer;Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/ui/ColorAssetCellRenderer;)V", "colors", "Ljavax/swing/JList;", "getColors", "()Ljavax/swing/JList;", "drawables", "getDrawables", "createAssetList", "Ljava/awt/Component;", "list", "intellij.android.core"})
public final class ResourcesView
extends JTabbedPane {
    @Nullable
    private final JList<?> drawables;
    @Nullable
    private final JList<?> colors;

    public ResourcesView(@NotNull List<ResourceAssetSet> drawableAssets, @NotNull List<? extends Pair<? extends Color, String>> colorAssets, @NotNull DesignAssetCellRenderer designAssetCellRenderer, @NotNull ColorAssetCellRenderer colorResourceCellRenderer) {
        Intrinsics.checkNotNullParameter(drawableAssets, (String)"drawableAssets");
        Intrinsics.checkNotNullParameter(colorAssets, (String)"colorAssets");
        Intrinsics.checkNotNullParameter((Object)designAssetCellRenderer, (String)"designAssetCellRenderer");
        Intrinsics.checkNotNullParameter((Object)colorResourceCellRenderer, (String)"colorResourceCellRenderer");
        super(1);
        this.drawables = SketchImporterViewKt.access$createDrawablesPreviewsList(drawableAssets, designAssetCellRenderer);
        this.colors = SketchImporterViewKt.access$createColorsPreviewsList(colorAssets, colorResourceCellRenderer);
        this.setTabLayoutPolicy(1);
        this.addTab(ResourceType.DRAWABLE.getDisplayName(), this.createAssetList(this.drawables));
        this.addTab(ResourceType.COLOR.getDisplayName(), this.createAssetList(this.colors));
        this.addChangeListener(new ChangeListener(){

            @Override
            public final void stateChanged(ChangeEvent it) {
                SketchImporterViewKt.access$resizeTabbedPane(this);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent e) {
                SketchImporterViewKt.access$resizeTabbedPane(this);
            }
        });
    }

    @Nullable
    public final JList<?> getDrawables() {
        return this.drawables;
    }

    @Nullable
    public final JList<?> getColors() {
        return this.colors;
    }

    private final Component createAssetList(JList<?> list2) {
        JPanel jPanel;
        JPanel $this$createAssetList_u24lambda_u2d0 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        JComponent jComponent = list2;
        if (jComponent == null) {
            jComponent = new JLabel("No valid assets");
        }
        $this$createAssetList_u24lambda_u2d0.add(jComponent);
        return jPanel;
    }
}

