/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.ui;

import com.android.tools.idea.ui.resourcemanager.model.ResourceAssetSet;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetPreviewManager;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.builders.ResourceFileGenerator;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.AssetModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ColorAssetModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.DrawableAssetModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.StudioResourcesModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.ChildView;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.SketchImporterPresenterKt;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010'\u001a,\u0012\u001a\u0012\u0018\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b(\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b(0\u000b\u0012\f\u0012\n )*\u0004\u0018\u00010\u000e0\u000e0\nH\u0004J\u001c\u0010*\u001a\u0016\u0012\u0004\u0012\u00020\u0014\u0012\f\u0012\n )*\u0004\u0018\u00010\u00150\u00150\nH\u0004J\u0010\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\u0014J\u0018\u0010.\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0/J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00140/J\u0018\u00101\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0/J\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00140/J\b\u00103\u001a\u000204H&R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR*\u0010\t\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0012\u0004\u0012\u00020\u000e0\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0012\u0010\u001d\u001a\u00020\u001eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u00065"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/ui/ResourcesPresenter;", "", "project", "Lcom/intellij/openapi/project/Project;", "assetPreviewManager", "Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetPreviewManager;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetPreviewManager;)V", "getAssetPreviewManager", "()Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetPreviewManager;", "colorsToColorAssets", "", "Lkotlin/Pair;", "Ljava/awt/Color;", "", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/ColorAssetModel;", "getColorsToColorAssets", "()Ljava/util/Map;", "drawableFileGenerator", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/builders/ResourceFileGenerator;", "filesToDrawableAssets", "Lcom/android/tools/idea/ui/resourcemanager/model/ResourceAssetSet;", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/DrawableAssetModel;", "getFilesToDrawableAssets", "importAll", "", "getImportAll", "()Z", "setImportAll", "(Z)V", "resources", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/StudioResourcesModel;", "getResources", "()Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/StudioResourcesModel;", "view", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/ui/ChildView;", "getView", "()Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/ui/ChildView;", "setView", "(Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/ui/ChildView;)V", "generateColorPairs", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm.PlatformType", "generateDrawableFiles", "getAsset", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/AssetModel;", "file", "getDisplayableColors", "", "getDisplayableDrawables", "getSelectedColors", "getSelectedDrawables", "populateView", "", "intellij.android.core"})
public abstract class ResourcesPresenter {
    @NotNull
    private final AssetPreviewManager assetPreviewManager;
    public ChildView view;
    private boolean importAll;
    @NotNull
    private final ResourceFileGenerator drawableFileGenerator;

    public ResourcesPresenter(@NotNull Project project, @NotNull AssetPreviewManager assetPreviewManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)assetPreviewManager, (String)"assetPreviewManager");
        this.assetPreviewManager = assetPreviewManager;
        this.importAll = true;
        this.drawableFileGenerator = new ResourceFileGenerator(project);
    }

    @NotNull
    public final AssetPreviewManager getAssetPreviewManager() {
        return this.assetPreviewManager;
    }

    @NotNull
    public final ChildView getView() {
        ChildView childView = this.view;
        if (childView != null) {
            return childView;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"view");
        return null;
    }

    public final void setView(@NotNull ChildView childView) {
        Intrinsics.checkNotNullParameter((Object)childView, (String)"<set-?>");
        this.view = childView;
    }

    public final boolean getImportAll() {
        return this.importAll;
    }

    public final void setImportAll(boolean bl) {
        this.importAll = bl;
    }

    @NotNull
    public abstract StudioResourcesModel getResources();

    @NotNull
    protected abstract Map<ResourceAssetSet, DrawableAssetModel> getFilesToDrawableAssets();

    @NotNull
    protected abstract Map<Pair<Color, String>, ColorAssetModel> getColorsToColorAssets();

    public abstract void populateView();

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Map<ResourceAssetSet, DrawableAssetModel> generateDrawableFiles() {
        Map map2;
        ImmutableList<DrawableAssetModel> immutableList = this.getResources().getDrawableAssets();
        if (immutableList != null) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = (Iterable)immutableList;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv;
                DrawableAssetModel it = (DrawableAssetModel)element$iv$iv;
                boolean bl = false;
                LightVirtualFile lightVirtualFile = this.drawableFileGenerator.generateDrawableFile(it);
                Intrinsics.checkNotNullExpressionValue((Object)lightVirtualFile, (String)"drawableFileGenerator.generateDrawableFile(it)");
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                Pair pair = TuplesKt.to((Object)SketchImporterPresenterKt.access$toAsset(lightVirtualFile, string), (Object)it);
                map3.put(pair.getFirst(), pair.getSecond());
            }
            map2 = destination$iv$iv;
        } else {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ResourceAssetSet> getDisplayableDrawables() {
        List list2;
        Set<ResourceAssetSet> files2 = this.getFilesToDrawableAssets().keySet();
        if (this.importAll) {
            list2 = CollectionsKt.toList((Iterable)files2);
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = files2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ResourceAssetSet it = (ResourceAssetSet)element$iv$iv;
                boolean bl = false;
                DrawableAssetModel drawableAssetModel = this.getFilesToDrawableAssets().get(it);
                if (!(drawableAssetModel != null ? drawableAssetModel.isExportable() : false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    @NotNull
    public final List<ResourceAssetSet> getSelectedDrawables() {
        return this.getView().getSelectedDrawables();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Map<Pair<Color, String>, ColorAssetModel> generateColorPairs() {
        Map map2;
        ImmutableList<ColorAssetModel> immutableList = this.getResources().getColorAssets();
        if (immutableList != null) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = (Iterable)immutableList;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv;
                ColorAssetModel it = (ColorAssetModel)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)TuplesKt.to((Object)it.getColor(), (Object)it.getName()), (Object)it);
                map3.put(pair.getFirst(), pair.getSecond());
            }
            map2 = destination$iv$iv;
        } else {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<Color, String>> getDisplayableColors() {
        List list2;
        Set<Pair<Color, String>> colors = this.getColorsToColorAssets().keySet();
        if (this.importAll) {
            list2 = CollectionsKt.toList((Iterable)colors);
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = colors;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Pair it = (Pair)element$iv$iv;
                boolean bl = false;
                ColorAssetModel colorAssetModel = this.getColorsToColorAssets().get(it);
                if (!(colorAssetModel != null ? colorAssetModel.isExportable() : false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    @NotNull
    public final List<Pair<Color, String>> getSelectedColors() {
        return this.getView().getSelectedColors();
    }

    @Nullable
    public final AssetModel getAsset(@NotNull ResourceAssetSet file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.getFilesToDrawableAssets().get(file2);
    }
}

