/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.ui;

import com.android.tools.idea.ui.resourcemanager.model.ResourceAssetSet;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetPreviewManager;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.SketchLibrary;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.builders.SketchToStudioConverter;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ColorAssetModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.DrawableAssetModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.StudioResourcesModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchDocument;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.ChildView;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.DocumentView;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.ResourcesPresenter;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\"\u001a\u00020#H\u0016R>\u0010\u000b\u001a,\u0012\u001a\u0012\u0018\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u000f\u0012\t\u0012\u00070\u0010\u00a2\u0006\u0002\b\u000f0\r\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014RL\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00170\u00170\f2\u001a\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00170\u00170\f@VX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0014\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/ui/DocumentPresenter;", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/ui/ResourcesPresenter;", "sketchDocument", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/parser/document/SketchDocument;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/SketchLibrary;", "assetPreviewManager", "Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetPreviewManager;", "(Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/parser/document/SketchDocument;Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/SketchLibrary;Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetPreviewManager;)V", "colorsToColorAssets", "", "Lkotlin/Pair;", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/ColorAssetModel;", "kotlin.jvm.PlatformType", "getColorsToColorAssets", "()Ljava/util/Map;", "<set-?>", "Lcom/android/tools/idea/ui/resourcemanager/model/ResourceAssetSet;", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/DrawableAssetModel;", "filesToDrawableAssets", "getFilesToDrawableAssets", "setFilesToDrawableAssets", "(Ljava/util/Map;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "resources", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/StudioResourcesModel;", "getResources", "()Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/StudioResourcesModel;", "populateView", "", "intellij.android.core"})
public final class DocumentPresenter
extends ResourcesPresenter {
    @NotNull
    private final Project project;
    @NotNull
    private final StudioResourcesModel resources;
    @NotNull
    private Map<ResourceAssetSet, ? extends DrawableAssetModel> filesToDrawableAssets;
    @NotNull
    private final Map<Pair<Color, String>, ColorAssetModel> colorsToColorAssets;

    public DocumentPresenter(@NotNull SketchDocument sketchDocument, @NotNull Project project, @NotNull SketchLibrary library, @NotNull AssetPreviewManager assetPreviewManager) {
        Intrinsics.checkNotNullParameter((Object)sketchDocument, (String)"sketchDocument");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)assetPreviewManager, (String)"assetPreviewManager");
        super(project, assetPreviewManager);
        this.project = project;
        StudioResourcesModel studioResourcesModel = SketchToStudioConverter.getResources(sketchDocument, library);
        Intrinsics.checkNotNullExpressionValue((Object)studioResourcesModel, (String)"getResources(sketchDocument, library)");
        this.resources = studioResourcesModel;
        this.filesToDrawableAssets = this.generateDrawableFiles();
        this.colorsToColorAssets = this.generateColorPairs();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public StudioResourcesModel getResources() {
        return this.resources;
    }

    @Override
    @NotNull
    protected Map<ResourceAssetSet, DrawableAssetModel> getFilesToDrawableAssets() {
        return this.filesToDrawableAssets;
    }

    public void setFilesToDrawableAssets(@NotNull Map<ResourceAssetSet, ? extends DrawableAssetModel> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.filesToDrawableAssets = map2;
    }

    @Override
    @NotNull
    protected Map<Pair<Color, String>, ColorAssetModel> getColorsToColorAssets() {
        return this.colorsToColorAssets;
    }

    @Override
    public void populateView() {
        ChildView childView = this.getView();
        Intrinsics.checkNotNull((Object)childView, (String)"null cannot be cast to non-null type com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.DocumentView");
        ((DocumentView)childView).refresh(this.getDisplayableDrawables(), this.getDisplayableColors());
    }
}

