/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.deserializers;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchAssetCollection;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchDocument;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchForeignStyle;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchForeignSymbol;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchForeignTextStyle;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchSharedStyle;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchSharedSymbol;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SketchDocumentDeserializer
implements JsonDeserializer<SketchDocument> {
    private static final String ASSETS = "assets";
    private static final String COLOR_SPACE = "colorSpace";
    private static final String CURRENT_PAGE_INDEX = "currentPageIndex";
    private static final String EXT_LAYER_STYLES = "foreignLayerStyles";
    private static final String EXT_SYMBOLS = "foreignSymbols";
    private static final String EXT_TEXT_STYLES = "foreignTextStyles";
    private static final String LAYER_STYLES = "layerStyles";
    private static final String LAYER_SYMBOLS = "layerSymbols";
    private static final String LAYER_TEXT_STYLES = "layerTextStyles";
    private static final String OBJECTS = "objects";
    private static final short DEFAULT_COLOR_SPACE = 0;
    private static final int DEFAULT_CURRENT_PAGE_INDEX = 0;

    @Nullable
    public SketchDocument deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context2) {
        JsonObject jsonObject = json.getAsJsonObject();
        SketchAssetCollection assets = (SketchAssetCollection)context2.deserialize(jsonObject.get(ASSETS), SketchAssetCollection.class);
        JsonElement colorSpaceElement = jsonObject.get(COLOR_SPACE);
        short colorSpace = colorSpaceElement != null ? colorSpaceElement.getAsShort() : (short)0;
        JsonElement currentPageIndexElement = jsonObject.get(CURRENT_PAGE_INDEX);
        int currentPageIndex = currentPageIndexElement != null ? currentPageIndexElement.getAsInt() : 0;
        SketchForeignStyle[] foreignLayerStyles = (SketchForeignStyle[])context2.deserialize(jsonObject.get(EXT_LAYER_STYLES), SketchForeignStyle[].class);
        SketchForeignSymbol[] foreignSymbols = (SketchForeignSymbol[])context2.deserialize(jsonObject.get(EXT_SYMBOLS), SketchForeignSymbol[].class);
        SketchForeignTextStyle[] foreignTextStyles = (SketchForeignTextStyle[])context2.deserialize(jsonObject.get(EXT_TEXT_STYLES), SketchForeignTextStyle[].class);
        SketchSharedStyle[] layerStyles = (SketchSharedStyle[])SketchDocumentDeserializer.getObjectsFrom(jsonObject, SketchSharedStyle[].class, context2, LAYER_STYLES);
        SketchSharedSymbol[] layerSymbols = (SketchSharedSymbol[])SketchDocumentDeserializer.getObjectsFrom(jsonObject, SketchSharedSymbol[].class, context2, LAYER_SYMBOLS);
        SketchSharedStyle[] layerTextStyles = (SketchSharedStyle[])SketchDocumentDeserializer.getObjectsFrom(jsonObject, SketchSharedStyle[].class, context2, LAYER_TEXT_STYLES);
        return new SketchDocument(assets, colorSpace, currentPageIndex, foreignLayerStyles, foreignSymbols, foreignTextStyles, layerStyles, layerSymbols, layerTextStyles);
    }

    @NotNull
    private static <T> T getObjectsFrom(@NotNull JsonObject jsonObject, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context2, @NotNull String memberName) {
        return (T)context2.deserialize(jsonObject.get(memberName).getAsJsonObject().get(OBJECTS), typeOfT);
    }
}

