/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.InheritedProperties;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ResizingConstraint;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ShapeModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.StyleModel;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AreaModel
extends ShapeModel {
    @NotNull
    private final Area myArea;

    public AreaModel(@NotNull Area shape, @Nullable StyleModel style, boolean flippedHorizontal, boolean flippedVertical, boolean closed, int rotation, int operation, @NotNull Point2D.Double framePosition, boolean hasClippingMask, boolean shouldBreakMaskChain, boolean isLastShapeGroup, @NotNull ResizingConstraint constraint) {
        super(shape, style, flippedHorizontal, flippedVertical, closed, rotation, operation, framePosition, hasClippingMask, shouldBreakMaskChain, isLastShapeGroup, constraint);
        this.myArea = shape;
    }

    @NotNull
    public Area getModelArea() {
        return this.myArea;
    }

    private void addShape(@NotNull AreaModel model2) {
        this.myArea.add(model2.getModelArea());
    }

    private void subtractShape(@NotNull AreaModel model2) {
        this.myArea.subtract(model2.getModelArea());
    }

    private void differenceShape(@NotNull AreaModel model2) {
        this.myArea.exclusiveOr(model2.getModelArea());
    }

    private void intersectShape(@NotNull AreaModel model2) {
        this.myArea.intersect(model2.getModelArea());
    }

    public void applyOperation(@NotNull AreaModel model2) {
        int booleanOperation = model2.getBooleanOperation();
        switch (booleanOperation) {
            case 0: {
                this.addShape(model2);
                break;
            }
            case 1: {
                this.subtractShape(model2);
                break;
            }
            case -1: 
            case 3: {
                this.differenceShape(model2);
                break;
            }
            case 2: {
                this.intersectShape(model2);
            }
        }
    }

    @Override
    public void applyTransformations(@Nullable InheritedProperties properties2) {
        AffineTransform transform2 = this.computeAffineTransform(properties2);
        this.myArea.transform(transform2);
        this.transformGradient(transform2);
        if (properties2 != null) {
            this.applyOpacity(properties2.getInheritedOpacity());
        }
    }

    @Override
    public void scale(double scaleX, double scaleY) {
        AffineTransform scaleTransform = new AffineTransform();
        scaleTransform.scale(scaleX, scaleY);
        this.myArea.transform(scaleTransform);
        this.transformGradient(scaleTransform);
    }

    @Override
    public void translateTo(double translateX, double translateY) {
        AffineTransform translateTransform = new AffineTransform();
        translateTransform.translate(-this.myShapeFrameLocation.getX(), -this.myShapeFrameLocation.getY());
        translateTransform.translate(translateX, translateY);
        this.myArea.transform(translateTransform);
        this.transformGradient(translateTransform);
    }
}

