/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.builders;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.SketchLibrary;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.builders.Path2DBuilder;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.AreaModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.AssetModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.BorderModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ColorAssetModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.DrawableAssetModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.FillModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.GradientModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.GradientStopModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.InheritedProperties;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.PathModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ResizingConstraint;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ShapeModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.StudioResourcesModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.StyleModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.SymbolModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchDocument;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchForeignSymbol;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchSharedStyle;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.interfaces.SketchLayer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.interfaces.SketchLayerable;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchArtboard;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchBorder;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchCurvePoint;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchExportFormat;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchFill;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchGradient;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchGradientStop;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchGraphicsContextSettings;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchPage;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchPoint2D;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchShapeGroup;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchShapePath;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchStyle;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchSymbolInstance;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchSymbolMaster;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.SketchFile;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SketchToStudioConverter {
    private static final String DEFAULT_DOCUMENT_COLOR_NAME = "document_color";

    @NotNull
    public static StudioResourcesModel getResources(@NotNull SketchPage sketchPage, @NotNull SketchLibrary library) {
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        for (SketchArtboard artboard : SketchFile.getArtboards(sketchPage)) {
            listBuilder.add((Object)SketchToStudioConverter.createDrawableAsset(artboard, library));
        }
        for (SketchSymbolMaster symbolMaster : SketchFile.getAllSymbolMasters(sketchPage)) {
            listBuilder.add((Object)SketchToStudioConverter.createDrawableAsset(symbolMaster, library, AssetModel.Origin.SYMBOL));
        }
        return new StudioResourcesModel((ImmutableList<DrawableAssetModel>)listBuilder.build(), (ImmutableList<ColorAssetModel>)ImmutableList.of());
    }

    @NotNull
    public static StudioResourcesModel getResources(@NotNull SketchDocument sketchDocument, @NotNull SketchLibrary library) {
        ImmutableList.Builder drawableListBuilder = new ImmutableList.Builder();
        ImmutableList.Builder colorListBuilder = new ImmutableList.Builder();
        colorListBuilder.addAll(SketchToStudioConverter.getDocumentColors(sketchDocument));
        colorListBuilder.addAll(SketchToStudioConverter.getExternalColors(sketchDocument));
        colorListBuilder.addAll(SketchToStudioConverter.getSharedColors(sketchDocument));
        drawableListBuilder.addAll(SketchToStudioConverter.getExternalDrawables(sketchDocument, library));
        drawableListBuilder.addAll(SketchToStudioConverter.getSharedDrawables(sketchDocument, library));
        return new StudioResourcesModel((ImmutableList<DrawableAssetModel>)drawableListBuilder.build(), (ImmutableList<ColorAssetModel>)colorListBuilder.build());
    }

    @NotNull
    public static DrawableAssetModel createDrawableAsset(@NotNull SketchArtboard artboard, @NotNull SketchLibrary library) {
        SketchLayer[] layers;
        ImmutableList.Builder shapes = new ImmutableList.Builder();
        for (SketchLayer layer : layers = artboard.getLayers()) {
            if (layer instanceof SketchSymbolInstance && library.hasSymbols()) {
                shapes.addAll(SketchToStudioConverter.createShapeModelsFromSymbol((SketchSymbolInstance)layer, new InheritedProperties(), library));
                continue;
            }
            if (layer instanceof SketchShapeGroup) {
                shapes.addAll(SketchToStudioConverter.createShapeModelFromShapeGroup((SketchShapeGroup)layer, new InheritedProperties(), false));
                continue;
            }
            if (!(layer instanceof SketchLayerable)) continue;
            shapes.addAll(SketchToStudioConverter.createShapeModelsFromLayerable((SketchLayerable)((Object)layer), new InheritedProperties(), library));
        }
        ImmutableList shapeModels = shapes.build();
        String name = SketchToStudioConverter.getDefaultName(artboard);
        boolean exportable = artboard.getExportOptions().getExportFormats().length != 0;
        Rectangle2D.Double dimension2 = artboard.getFrame();
        return new DrawableAssetModel((ImmutableList<ShapeModel>)shapeModels, exportable, name, dimension2, dimension2, AssetModel.Origin.ARTBOARD);
    }

    @NotNull
    private static DrawableAssetModel createDrawableAsset(@NotNull SketchSymbolMaster symbolMaster, @NotNull SketchLibrary library, @NotNull AssetModel.Origin origin) {
        boolean exportable = symbolMaster.getExportOptions().getExportFormats().length != 0;
        String name = SketchToStudioConverter.getDefaultName(symbolMaster);
        Rectangle2D.Double dimension2 = symbolMaster.getFrame();
        return new DrawableAssetModel(SketchToStudioConverter.createShapeModelsFromLayerable(symbolMaster, new InheritedProperties(), library), exportable, name, dimension2, dimension2, origin);
    }

    @NotNull
    private static String getDefaultName(@NotNull SketchLayer layer) {
        String name = layer.getName();
        if (layer.getExportOptions().getExportFormats().length != 0) {
            SketchExportFormat format = layer.getExportOptions().getExportFormats()[0];
            if (format.getNamingScheme() == 1) {
                return format.getName() + name;
            }
            if (format.getNamingScheme() == 0) {
                return name + format.getName();
            }
        }
        return name;
    }

    @NotNull
    private static ImmutableList<ShapeModel> createShapeModelsFromSymbol(@NotNull SketchSymbolInstance symbolInstance, @NotNull InheritedProperties inheritedProperties, @NotNull SketchLibrary library) {
        SymbolModel symbolModel = SketchToStudioConverter.getSymbolModel(symbolInstance.getSymbolId(), library);
        if (symbolModel == null) {
            return ImmutableList.of();
        }
        symbolModel.setSymbolInstance(symbolInstance);
        inheritedProperties = SketchToStudioConverter.inheritFromSymbol(symbolInstance, inheritedProperties);
        symbolModel.scaleShapes();
        symbolModel.applyProperties(inheritedProperties);
        return symbolModel.getShapeModels();
    }

    @Nullable
    private static SymbolModel getSymbolModel(@NotNull String symbolId, @NotNull SketchLibrary library) {
        SketchSymbolMaster symbolMaster = library.getSymbol(symbolId);
        if (symbolMaster == null) {
            return null;
        }
        ImmutableList<ShapeModel> shapeModels = SketchToStudioConverter.createShapeModelsFromLayerable(symbolMaster, new InheritedProperties(), library);
        return new SymbolModel(shapeModels, symbolMaster);
    }

    @NotNull
    private static ImmutableList<ShapeModel> createShapeModelFromShapeGroup(@NotNull SketchShapeGroup shapeGroup, @NotNull InheritedProperties inheritedProperties, boolean isLastShapeGroup) {
        SketchBorder shapeGroupBorder;
        SketchFill[] fills = shapeGroup.getStyle().getFills();
        SketchBorder[] borders = shapeGroup.getStyle().getBorders();
        SketchFill shapeGroupFill = fills != null ? fills[0] : null;
        SketchBorder sketchBorder = shapeGroupBorder = borders != null ? borders[0] : null;
        if (shapeGroupBorder == null && shapeGroupFill == null && !shapeGroup.hasClippingMask()) {
            return ImmutableList.of();
        }
        SketchLayer[] layers = shapeGroup.getLayers();
        SketchShapePath baseSketchShapePath = (SketchShapePath)layers[0];
        Path2D.Double baseShapePath = SketchToStudioConverter.getPath2D(baseSketchShapePath);
        StyleModel styleModel = SketchToStudioConverter.createStyleModel(shapeGroup.getStyle());
        if (styleModel != null) {
            styleModel.makeGradientRelative(baseShapePath);
        }
        InheritedProperties newInheritedProperties = SketchToStudioConverter.inheritFromShapeGroup(shapeGroup, inheritedProperties);
        PathModel finalShape = new PathModel(baseShapePath, styleModel, baseSketchShapePath.isFlippedHorizontal(), baseSketchShapePath.isFlippedVertical(), baseSketchShapePath.isClosed(), baseSketchShapePath.getRotation(), shapeGroup.getBooleanOperation(), baseSketchShapePath.getFramePosition(), shapeGroup.hasClippingMask(), shapeGroup.shouldBreakMaskChain(), isLastShapeGroup, inheritedProperties.getInheritedResizingConstraint());
        if (layers.length == 1) {
            finalShape.applyTransformations(newInheritedProperties);
            return ImmutableList.of((Object)finalShape);
        }
        AreaModel finalArea = finalShape.convertToArea();
        finalArea.applyTransformations(null);
        for (int i = 1; i < layers.length; ++i) {
            SketchShapePath path2 = (SketchShapePath)layers[i];
            if (!path2.isVisible()) continue;
            PathModel pathModel = SketchToStudioConverter.createPathModel(path2);
            AreaModel areaModel = pathModel.convertToArea();
            areaModel.applyTransformations(null);
            finalArea.applyOperation(areaModel);
        }
        finalArea.applyTransformations(newInheritedProperties);
        return ImmutableList.of((Object)finalArea);
    }

    @NotNull
    private static PathModel createPathModel(@NotNull SketchShapePath shapePath) {
        return new PathModel(SketchToStudioConverter.getPath2D(shapePath), null, shapePath.isFlippedHorizontal(), shapePath.isFlippedVertical(), shapePath.isClosed(), shapePath.getRotation(), shapePath.getBooleanOperation(), shapePath.getFramePosition(), false, false, false, new ResizingConstraint());
    }

    @NotNull
    public static ImmutableList<ShapeModel> createShapeModelsFromLayerable(@NotNull SketchLayerable layerable, @NotNull InheritedProperties inheritedProperties, @NotNull SketchLibrary library) {
        ImmutableList.Builder builder2 = new ImmutableList.Builder();
        inheritedProperties = SketchToStudioConverter.inheritFromLayerable(layerable, inheritedProperties);
        boolean isLastGroupElement = false;
        SketchLayer[] groupLayers = layerable.getLayers();
        for (int i = 0; i < groupLayers.length; ++i) {
            if (i == groupLayers.length - 1) {
                isLastGroupElement = true;
            }
            SketchLayer layer = groupLayers[i];
            if (library.hasSymbols() && layer instanceof SketchSymbolInstance) {
                builder2.addAll(SketchToStudioConverter.createShapeModelsFromSymbol((SketchSymbolInstance)layer, inheritedProperties, library));
                continue;
            }
            if (layer instanceof SketchShapeGroup) {
                SketchShapeGroup shapeGroup = (SketchShapeGroup)layer;
                builder2.addAll(SketchToStudioConverter.createShapeModelFromShapeGroup(shapeGroup, inheritedProperties, isLastGroupElement));
                continue;
            }
            if (!(layer instanceof SketchLayerable)) continue;
            builder2.addAll(SketchToStudioConverter.createShapeModelsFromLayerable((SketchLayerable)((Object)layer), inheritedProperties, library));
        }
        return builder2.build();
    }

    @NotNull
    private static InheritedProperties inheritFromSymbol(@NotNull SketchSymbolInstance symbolInstance, @NotNull InheritedProperties inheritedProperties) {
        Rectangle2D.Double frame = symbolInstance.getFrame();
        Point2D.Double translation = new Point2D.Double(frame.getX(), frame.getY());
        SketchGraphicsContextSettings contextSettings = symbolInstance.getStyle().getContextSettings();
        double opacity = contextSettings != null ? contextSettings.getOpacity() : 1.0;
        ResizingConstraint constraint = symbolInstance.getResizingConstraint();
        return new InheritedProperties(inheritedProperties, translation, symbolInstance.isFlippedHorizontal(), symbolInstance.isFlippedVertical(), symbolInstance.getRotation(), opacity, constraint);
    }

    @NotNull
    private static InheritedProperties inheritFromShapeGroup(@NotNull SketchShapeGroup shapeGroup, @NotNull InheritedProperties inheritedProperties) {
        Rectangle2D.Double frame = shapeGroup.getFrame();
        Point2D.Double translation = new Point2D.Double(frame.getX(), frame.getY());
        ResizingConstraint constraint = shapeGroup.getResizingConstraint();
        return new InheritedProperties(inheritedProperties, translation, shapeGroup.isFlippedHorizontal(), shapeGroup.isFlippedVertical(), shapeGroup.getRotation(), 1.0, constraint);
    }

    @NotNull
    private static InheritedProperties inheritFromLayerable(@NotNull SketchLayerable layerable, @NotNull InheritedProperties inheritedProperties) {
        Rectangle2D.Double frame = layerable.getFrame();
        Point2D.Double translation = !(layerable instanceof SketchSymbolMaster) ? new Point2D.Double(frame.getX(), frame.getY()) : new Point2D.Double();
        SketchGraphicsContextSettings graphicContextSettings = layerable.getStyle().getContextSettings();
        double opacity = graphicContextSettings != null ? graphicContextSettings.getOpacity() : 1.0;
        return new InheritedProperties(inheritedProperties, translation, layerable.isFlippedHorizontal(), layerable.isFlippedVertical(), layerable.getRotation(), opacity, layerable.getResizingConstraint());
    }

    @Nullable
    private static StyleModel createStyleModel(@Nullable SketchStyle sketchStyle) {
        if (sketchStyle == null) {
            return null;
        }
        SketchGraphicsContextSettings styleGraphicsContextSettings = sketchStyle.getContextSettings();
        double styleOpacity = styleGraphicsContextSettings != null ? styleGraphicsContextSettings.getOpacity() : 1.0;
        SketchBorder[] sketchBorders = sketchStyle.getBorders();
        SketchBorder sketchBorder = sketchBorders != null && sketchBorders.length != 0 ? sketchBorders[0] : null;
        BorderModel borderModel = sketchBorder != null && sketchBorder.isEnabled() ? new BorderModel(sketchBorder.getThickness(), sketchBorder.getColor()) : null;
        SketchFill[] sketchFills = sketchStyle.getFills();
        SketchFill sketchFill = sketchFills != null && sketchFills.length != 0 ? sketchFills[0] : null;
        FillModel fillModel = null;
        if (sketchFill != null && sketchFill.isEnabled()) {
            SketchGradient sketchGradient = sketchFill.getGradient();
            GradientModel gradientModel = SketchToStudioConverter.createGradientModel(sketchGradient);
            SketchGraphicsContextSettings fillGraphicsContextSettings = sketchFill.getContextSettings();
            double fillOpacity = fillGraphicsContextSettings != null ? fillGraphicsContextSettings.getOpacity() : 1.0;
            fillModel = new FillModel(sketchFill.getColor(), gradientModel, fillOpacity);
        }
        return new StyleModel(fillModel, borderModel, styleOpacity);
    }

    @Nullable
    private static GradientModel createGradientModel(@Nullable SketchGradient sketchGradient) {
        if (sketchGradient == null) {
            return null;
        }
        SketchGradientStop[] gradientStops = sketchGradient.getStops();
        GradientStopModel[] gradientStopModels = new GradientStopModel[gradientStops.length];
        for (int i = 0; i < gradientStops.length; ++i) {
            SketchGradientStop gradientStop = gradientStops[i];
            gradientStopModels[i] = new GradientStopModel(gradientStop.getPosition(), gradientStop.getColor());
        }
        return new GradientModel(sketchGradient.getGradientType(), sketchGradient.getFrom(), sketchGradient.getTo(), gradientStopModels);
    }

    @NotNull
    private static Path2D.Double getPath2D(@NotNull SketchShapePath shapePath) {
        if ("rectangle".equals(shapePath.getClassType())) {
            if (SketchToStudioConverter.hasRoundCorners(shapePath)) {
                return SketchToStudioConverter.getRoundRectanglePath(shapePath);
            }
            return SketchToStudioConverter.getGenericPath(shapePath);
        }
        return SketchToStudioConverter.getGenericPath(shapePath);
    }

    @NotNull
    private static Path2D.Double getGenericPath(@NotNull SketchShapePath shapePath) {
        Path2DBuilder path2DBuilder = new Path2DBuilder();
        SketchCurvePoint[] points = shapePath.getPoints();
        if (points.length == 0) {
            return new Path2D.Double();
        }
        SketchPoint2D startCoords = points[0].getPoint().makeAbsolutePosition(shapePath.getFrame());
        path2DBuilder.startPath(startCoords);
        SketchCurvePoint currentCurvePoint = points[0];
        for (int i = 1; i < points.length; ++i) {
            SketchCurvePoint previousCurvePoint = points[i - 1];
            currentCurvePoint = points[i];
            SketchPoint2D previousPoint = previousCurvePoint.getPoint().makeAbsolutePosition(shapePath.getFrame());
            SketchPoint2D currentPoint = currentCurvePoint.getPoint().makeAbsolutePosition(shapePath.getFrame());
            SketchPoint2D previousPointCurveFrom = previousPoint;
            SketchPoint2D currentPointCurveTo = currentPoint;
            if (previousCurvePoint.hasCurveFrom()) {
                previousPointCurveFrom = previousCurvePoint.getCurveFrom().makeAbsolutePosition(shapePath.getFrame());
            }
            if (currentCurvePoint.hasCurveTo()) {
                currentPointCurveTo = currentCurvePoint.getCurveTo().makeAbsolutePosition(shapePath.getFrame());
            }
            if (!previousCurvePoint.hasCurveFrom() && !currentCurvePoint.hasCurveTo()) {
                path2DBuilder.createLine(currentPoint);
                continue;
            }
            path2DBuilder.createBezierCurve(previousPointCurveFrom, currentPointCurveTo, currentPoint);
        }
        if (shapePath.isClosed()) {
            path2DBuilder.createClosedShape(shapePath, currentCurvePoint);
        }
        return path2DBuilder.build();
    }

    @NotNull
    private static Path2D.Double getRoundRectanglePath(@NotNull SketchShapePath shapePath) {
        Path2DBuilder path2DBuilder = new Path2DBuilder();
        SketchCurvePoint[] points = shapePath.getPoints();
        SketchPoint2D startPoint = new SketchPoint2D(0.0, 0.0);
        SketchPoint2D endPoint = new SketchPoint2D(0.0, 0.0);
        SketchPoint2D previousPoint = new SketchPoint2D(0.0, 0.0);
        for (int i = 0; i < points.length; ++i) {
            switch (i) {
                case 0: {
                    startPoint.setLocation(0.0, points[i].getCornerRadius());
                    endPoint.setLocation(points[i].getCornerRadius(), 0.0);
                    path2DBuilder.startPath(startPoint);
                    break;
                }
                case 1: {
                    startPoint.setLocation(shapePath.getFrame().getWidth() - (double)points[i].getCornerRadius(), 0.0);
                    endPoint.setLocation(shapePath.getFrame().getWidth(), points[i].getCornerRadius());
                    break;
                }
                case 2: {
                    startPoint.setLocation(shapePath.getFrame().getWidth(), shapePath.getFrame().getHeight() - (double)points[i].getCornerRadius());
                    endPoint.setLocation(shapePath.getFrame().getWidth() - (double)points[i].getCornerRadius(), shapePath.getFrame().getHeight());
                    break;
                }
                case 3: {
                    startPoint.setLocation(points[i].getCornerRadius(), shapePath.getFrame().getHeight());
                    endPoint.setLocation(0.0, shapePath.getFrame().getHeight() - (double)points[i].getCornerRadius());
                }
            }
            if (points[i].getCornerRadius() != 0) {
                if (!previousPoint.equals(startPoint) && i != 0) {
                    path2DBuilder.createLine(startPoint);
                }
                path2DBuilder.createQuadCurve(points[i].getPoint().makeAbsolutePosition(shapePath.getFrame()), endPoint);
            } else {
                path2DBuilder.createLine(startPoint.makeAbsolutePosition(shapePath.getFrame()));
            }
            previousPoint.setLocation(endPoint);
        }
        path2DBuilder.closePath();
        return path2DBuilder.build();
    }

    private static boolean hasRoundCorners(@NotNull SketchShapePath shapePath) {
        SketchCurvePoint[] points;
        for (SketchCurvePoint point : points = shapePath.getPoints()) {
            if (point.getCornerRadius() == 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static ImmutableList<ColorAssetModel> getDocumentColors(@NotNull SketchDocument sketchDocument) {
        Color[] documentColors = sketchDocument.getAssets().getColors();
        int len = documentColors.length;
        if (len == 1) {
            return ImmutableList.of((Object)new ColorAssetModel(true, DEFAULT_DOCUMENT_COLOR_NAME, documentColors[0], AssetModel.Origin.DOCUMENT));
        }
        ImmutableList.Builder colorListBuilder = new ImmutableList.Builder();
        for (int i = 0; i < len; ++i) {
            colorListBuilder.add((Object)new ColorAssetModel(true, "document_color_" + (i + 1), documentColors[i], AssetModel.Origin.DOCUMENT));
        }
        return colorListBuilder.build();
    }

    @NotNull
    private static ImmutableList<ColorAssetModel> getExternalColors(@NotNull SketchDocument sketchDocument) {
        ImmutableList.Builder colorListBuilder = new ImmutableList.Builder();
        return colorListBuilder.build();
    }

    @NotNull
    private static ImmutableList<ColorAssetModel> getSharedColors(@NotNull SketchDocument sketchDocument) {
        SketchSharedStyle[] sharedStyles;
        ImmutableList.Builder colorListBuilder = new ImmutableList.Builder();
        for (SketchSharedStyle style : sharedStyles = sketchDocument.getLayerStyles()) {
            Color color;
            SketchFill[] fills = style.getValue().getFills();
            Color color2 = color = fills != null && fills.length != 0 ? fills[0].getColor() : null;
            if (color == null) continue;
            colorListBuilder.add((Object)new ColorAssetModel(true, style.getName(), color, AssetModel.Origin.SHARED));
        }
        return colorListBuilder.build();
    }

    @NotNull
    private static ImmutableList<DrawableAssetModel> getExternalDrawables(@NotNull SketchDocument sketchDocument, @NotNull SketchLibrary library) {
        if (sketchDocument.getForeignSymbols() == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder drawableListBuilder = new ImmutableList.Builder();
        for (SketchForeignSymbol foreignSymbol : sketchDocument.getForeignSymbols()) {
            DrawableAssetModel drawableAsset = SketchToStudioConverter.createDrawableAsset(foreignSymbol.getSymbolMaster(), library, AssetModel.Origin.EXTERNAL);
            drawableListBuilder.add((Object)drawableAsset);
        }
        return drawableListBuilder.build();
    }

    @NotNull
    private static ImmutableList<DrawableAssetModel> getSharedDrawables(@NotNull SketchDocument sketchDocument, @NotNull SketchLibrary library) {
        ImmutableList.Builder drawableListBuilder = new ImmutableList.Builder();
        return drawableListBuilder.build();
    }
}

