/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.rendering;

import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.ui.resourcemanager.model.Asset;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetIconProvider;
import com.android.tools.idea.ui.resourcemanager.rendering.FetchImageExecutor;
import com.android.tools.idea.ui.resourcemanager.rendering.ImageCache;
import com.android.tools.idea.ui.resourcemanager.rendering.ResourceRenderingUtilsKt;
import com.android.tools.idea.ui.resourcemanager.rendering.SlowResourcePreviewManagerKt;
import com.android.tools.idea.ui.resourcemanager.rendering.SlowResourcePreviewProvider;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JF\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\u0010H\u0002JD\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020 2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100\u001aH\u0016J\u0018\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u001eH\u0002J \u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u00061"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/rendering/SlowResourcePreviewManager;", "Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetIconProvider;", "imageCache", "Lcom/android/tools/idea/ui/resourcemanager/rendering/ImageCache;", "resourcePreviewProvider", "Lcom/android/tools/idea/ui/resourcemanager/rendering/SlowResourcePreviewProvider;", "(Lcom/android/tools/idea/ui/resourcemanager/rendering/ImageCache;Lcom/android/tools/idea/ui/resourcemanager/rendering/SlowResourcePreviewProvider;)V", "PLACEHOLDER_IMAGE", "Ljava/awt/image/BufferedImage;", "contentRatio", "", "fetchImageExecutor", "Lcom/android/tools/idea/ui/resourcemanager/rendering/FetchImageExecutor;", "imageIcon", "Lcom/intellij/util/ui/JBImageIcon;", "supportsTransparency", "", "getSupportsTransparency", "()Z", "setSupportsTransparency", "(Z)V", "fetchImage", "Ljava/awt/Image;", "asset", "Lcom/android/tools/idea/ui/resourcemanager/model/Asset;", "refreshCallBack", "Lkotlin/Function0;", "", "isStillVisible", "targetSize", "Ljava/awt/Dimension;", "component", "Ljava/awt/Component;", "forceImageRender", "getIcon", "Ljavax/swing/ImageIcon;", "assetToRender", "width", "", "height", "refreshCallback", "shouldBeRendered", "getScale", "target", "source", "scaleToFitIfNeeded", "bufferedImage", "shouldScale", "scale", "intellij.android.core"})
public final class SlowResourcePreviewManager
implements AssetIconProvider {
    @NotNull
    private final ImageCache imageCache;
    @NotNull
    private final SlowResourcePreviewProvider resourcePreviewProvider;
    @NotNull
    private final FetchImageExecutor fetchImageExecutor;
    @NotNull
    private final BufferedImage PLACEHOLDER_IMAGE;
    @NotNull
    private final JBImageIcon imageIcon;
    private final double contentRatio;
    private boolean supportsTransparency;

    public SlowResourcePreviewManager(@NotNull ImageCache imageCache, @NotNull SlowResourcePreviewProvider resourcePreviewProvider) {
        Intrinsics.checkNotNullParameter((Object)imageCache, (String)"imageCache");
        Intrinsics.checkNotNullParameter((Object)resourcePreviewProvider, (String)"resourcePreviewProvider");
        this.imageCache = imageCache;
        this.resourcePreviewProvider = resourcePreviewProvider;
        boolean $i$f$service = false;
        Class<FetchImageExecutor> serviceClass$iv = FetchImageExecutor.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        this.fetchImageExecutor = (FetchImageExecutor)object;
        this.PLACEHOLDER_IMAGE = this.resourcePreviewProvider.getPreviewPlaceholder();
        this.imageIcon = new JBImageIcon((Image)this.PLACEHOLDER_IMAGE);
        this.contentRatio = 0.1;
        this.supportsTransparency = true;
    }

    @Override
    public boolean getSupportsTransparency() {
        return this.supportsTransparency;
    }

    public void setSupportsTransparency(boolean bl) {
        this.supportsTransparency = bl;
    }

    @Override
    @NotNull
    public ImageIcon getIcon(@NotNull Asset assetToRender, int width, int height, @NotNull Component component2, @NotNull Function0<Unit> refreshCallback, @NotNull Function0<Boolean> shouldBeRendered) {
        Intrinsics.checkNotNullParameter((Object)assetToRender, (String)"assetToRender");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter(refreshCallback, (String)"refreshCallback");
        Intrinsics.checkNotNullParameter(shouldBeRendered, (String)"shouldBeRendered");
        if (height > 0 && width > 0) {
            Image image;
            Dimension targetSize = new Dimension(width, height);
            Image image2 = SlowResourcePreviewManager.fetchImage$default(this, assetToRender, refreshCallback, shouldBeRendered, targetSize, component2, false, 32, null);
            int imageWidth = image2.getWidth(null);
            int imageHeight = image2.getHeight(null);
            double scale = this.getScale(targetSize, new Dimension(imageWidth, imageHeight));
            if (!Intrinsics.areEqual((Object)image2, (Object)this.PLACEHOLDER_IMAGE) && !Intrinsics.areEqual((Object)image2, (Object)ResourceRenderingUtilsKt.getERROR_IMAGE()) && this.shouldScale(scale)) {
                if (scale < 1.0) {
                    Image image3 = ImageUtil.scaleImage((Image)image2, (double)scale);
                    Intrinsics.checkNotNullExpressionValue((Object)image3, (String)"scaleImage(image, scale)");
                    image2 = image3;
                } else {
                    BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)image2);
                    Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"toBufferedImage(image)");
                    BufferedImage bufferedImage2 = bufferedImage;
                    BufferedImage bufferedImage3 = ImageUtils.lowQualityFastScale((BufferedImage)bufferedImage2, (double)scale, (double)scale);
                    Intrinsics.checkNotNullExpressionValue((Object)bufferedImage3, (String)"lowQualityFastScale(bufferedImage, scale, scale)");
                    image2 = bufferedImage3;
                    this.fetchImage(assetToRender, refreshCallback, shouldBeRendered, targetSize, component2, true);
                }
            }
            this.imageIcon.setImage(Intrinsics.areEqual((Object)(image = image2), (Object)ResourceRenderingUtilsKt.getERROR_IMAGE()) ? (Image)ResourceRenderingUtilsKt.createFailedIcon(targetSize) : (Intrinsics.areEqual((Object)image, (Object)this.PLACEHOLDER_IMAGE) ? (Image)(this.shouldScale(scale) ? ImageUtils.lowQualityFastScale((BufferedImage)this.PLACEHOLDER_IMAGE, (double)scale, (double)scale) : this.PLACEHOLDER_IMAGE) : image2));
            this.setSupportsTransparency(!Intrinsics.areEqual((Object)image2, (Object)ResourceRenderingUtilsKt.getERROR_IMAGE()));
        } else {
            this.imageIcon.setImage((Image)this.PLACEHOLDER_IMAGE);
        }
        return (ImageIcon)this.imageIcon;
    }

    private final boolean shouldScale(double scale) {
        double d = 1.0 - this.contentRatio;
        return !(scale <= 1.0 + this.contentRatio ? d <= scale : false);
    }

    private final double getScale(Dimension target2, Dimension source) {
        double xScale = (double)target2.width / source.getWidth();
        double yScale = (double)target2.height / source.getHeight();
        return Math.min(xScale, yScale);
    }

    private final Image fetchImage(Asset asset, Function0<Unit> refreshCallBack, Function0<Boolean> isStillVisible, Dimension targetSize, Component component2, boolean forceImageRender) {
        return ImageCache.computeAndGet$default(this.imageCache, asset, this.PLACEHOLDER_IMAGE, forceImageRender, refreshCallBack, null, (Function0)new Function0<CompletableFuture<? extends BufferedImage>>(isStillVisible, this, component2, targetSize, asset){
            final /* synthetic */ Function0<Boolean> $isStillVisible;
            final /* synthetic */ SlowResourcePreviewManager this$0;
            final /* synthetic */ Component $component;
            final /* synthetic */ Dimension $targetSize;
            final /* synthetic */ Asset $asset;
            {
                this.$isStillVisible = $isStillVisible;
                this.this$0 = $receiver;
                this.$component = $component;
                this.$targetSize = $targetSize;
                this.$asset = $asset;
                super(0);
            }

            @NotNull
            public final CompletableFuture<? extends BufferedImage> invoke() {
                CompletableFuture<Object> completableFuture;
                if (((Boolean)this.$isStillVisible.invoke()).booleanValue()) {
                    CompletableFuture<U> completableFuture2 = CompletableFuture.supplyAsync(new Supplier(this.$isStillVisible, this.this$0, this.$component, this.$targetSize, this.$asset){
                        final /* synthetic */ Function0<Boolean> $isStillVisible;
                        final /* synthetic */ SlowResourcePreviewManager this$0;
                        final /* synthetic */ Component $component;
                        final /* synthetic */ Dimension $targetSize;
                        final /* synthetic */ Asset $asset;
                        {
                            this.$isStillVisible = $isStillVisible;
                            this.this$0 = $receiver;
                            this.$component = $component;
                            this.$targetSize = $targetSize;
                            this.$asset = $asset;
                        }

                        @Nullable
                        public final BufferedImage get() {
                            if (((Boolean)this.$isStillVisible.invoke()).booleanValue()) {
                                try {
                                    BufferedImage bufferedImage = SlowResourcePreviewManager.access$getResourcePreviewProvider$p(this.this$0).getSlowPreview((int)(JBUI.pixScale((Component)this.$component) * (float)this.$targetSize.width), (int)(JBUI.pixScale((Component)this.$component) * (float)this.$targetSize.height), this.$asset);
                                    if (bufferedImage == null) {
                                        throw new Exception("Failed to resolve resource");
                                    }
                                    BufferedImage previewImage = bufferedImage;
                                    return SlowResourcePreviewManager.access$scaleToFitIfNeeded(this.this$0, previewImage, this.$targetSize, this.$component);
                                }
                                catch (Exception throwable) {
                                    SlowResourcePreviewManagerKt.access$getLOG$p().warn("Error while rendering " + this.$asset, (Throwable)throwable);
                                    return ResourceRenderingUtilsKt.getERROR_IMAGE();
                                }
                            }
                            return (BufferedImage)((Object)((Void)null));
                        }
                    }, SlowResourcePreviewManager.access$getFetchImageExecutor$p(this.this$0));
                    completableFuture = completableFuture2;
                    Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"private fun fetchImage(a\u2026e(null)\n      }\n    }\n  }");
                } else {
                    CompletableFuture<Object> completableFuture3 = CompletableFuture.completedFuture(null);
                    completableFuture = completableFuture3;
                    Intrinsics.checkNotNullExpressionValue(completableFuture3, (String)"{\n        CompletableFut\u2026letedFuture(null)\n      }");
                }
                return completableFuture;
            }
        }, 16, null);
    }

    static /* synthetic */ Image fetchImage$default(SlowResourcePreviewManager slowResourcePreviewManager, Asset asset, Function0 function0, Function0 function02, Dimension dimension2, Component component2, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return slowResourcePreviewManager.fetchImage(asset, (Function0<Unit>)function0, (Function0<Boolean>)function02, dimension2, component2, bl);
    }

    private final BufferedImage scaleToFitIfNeeded(BufferedImage bufferedImage, Dimension targetSize, Component component2) {
        Image image = ImageUtil.ensureHiDPI((Image)bufferedImage, (ScaleContext)ScaleContext.create((Component)component2));
        Dimension imageSize = new Dimension(image.getWidth(null), image.getHeight(null));
        double scale = this.getScale(targetSize, imageSize);
        if (this.shouldScale(scale)) {
            int newWidth = (int)((double)imageSize.width * scale);
            int newHeight = (int)((double)imageSize.height * scale);
            if (newWidth > 0 && newHeight > 0) {
                image = ImageUtil.scaleImage((Image)image, (double)scale);
            }
        }
        if (!(image instanceof BufferedImage)) {
            Logger.getInstance(SlowResourcePreviewManager.class).error("Not BufferedImage");
            BufferedImage bufferedImage2 = ImageUtil.toBufferedImage((Image)image);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"toBufferedImage(image)");
            return bufferedImage2;
        }
        return (BufferedImage)image;
    }

    public static final /* synthetic */ SlowResourcePreviewProvider access$getResourcePreviewProvider$p(SlowResourcePreviewManager $this) {
        return $this.resourcePreviewProvider;
    }

    public static final /* synthetic */ BufferedImage access$scaleToFitIfNeeded(SlowResourcePreviewManager $this, BufferedImage bufferedImage, Dimension targetSize, Component component2) {
        return $this.scaleToFitIfNeeded(bufferedImage, targetSize, component2);
    }

    public static final /* synthetic */ FetchImageExecutor access$getFetchImageExecutor$p(SlowResourcePreviewManager $this) {
        return $this.fetchImageExecutor;
    }
}

