/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.rendering;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.tools.idea.fonts.DownloadableFontCacheService;
import com.android.tools.idea.ui.resourcemanager.rendering.FontIconData;
import com.android.tools.idea.ui.resourcemanager.rendering.FontIconProviderKt;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J,\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0016J\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/rendering/FontFamilyIcon;", "Ljavax/swing/Icon;", "()V", "fontService", "Lcom/android/tools/idea/fonts/DownloadableFontCacheService;", "Lorg/jetbrains/annotations/NotNull;", "fonts", "", "Lcom/android/tools/idea/ui/resourcemanager/rendering/FontIconData;", "height", "", "getHeight", "()I", "setHeight", "(I)V", "width", "getWidth", "setWidth", "getIconHeight", "getIconWidth", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "setFontFamily", "fontFamily", "Lcom/android/ide/common/fonts/FontFamily;", "intellij.android.core"})
final class FontFamilyIcon
implements Icon {
    private int width;
    private int height;
    @NotNull
    private List<FontIconData> fonts = CollectionsKt.emptyList();
    @NotNull
    private final DownloadableFontCacheService fontService;

    public FontFamilyIcon() {
        DownloadableFontCacheService downloadableFontCacheService = DownloadableFontCacheService.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)downloadableFontCacheService, (String)"getInstance()");
        this.fontService = downloadableFontCacheService;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFontFamily(@NotNull FontFamily fontFamily) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)fontFamily, (String)"fontFamily");
        Iterable iterable = fontFamily.getFonts();
        FontFamilyIcon fontFamilyIcon = this;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FontIconData fontIconData;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FontDetail fontDetail = (FontDetail)element$iv$iv;
            boolean bl2 = false;
            if (this.fontService.loadDetailFont(fontDetail) != null) {
                Font font;
                boolean bl3 = false;
                String string = fontDetail.getStyleName();
                Intrinsics.checkNotNullExpressionValue((Object)font, (String)"font");
                fontIconData = new FontIconData(string, font);
            } else {
                fontIconData = null;
            }
            if (fontIconData == null) continue;
            FontIconData it$iv$iv = fontIconData;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        fontFamilyIcon.fonts = (List)destination$iv$iv;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(@Nullable Component c, @Nullable Graphics g, int x, int y) {
        Rectangle2D fontBounds;
        FontIconData fontToRender;
        Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        int maxWidth = 0;
        int maxHeight = 0;
        float fontSize = 0.0f;
        fontSize = 10.0f;
        Font originalFont = ((Graphics2D)g).getFont();
        Object antiAliasValue = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object renderValue = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_RENDERING);
        Iterable $this$forEach$iv = this.fonts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            fontToRender = (FontIconData)element$iv;
            boolean bl = false;
            fontBounds = FontIconProviderKt.access$getFontBounds(fontToRender, g, fontSize);
            maxWidth = Math.max(maxWidth, (int)fontBounds.getWidth());
        }
        fontSize *= (float)this.width / (float)(maxWidth + JBUI.scale((int)4));
        $this$forEach$iv = this.fonts;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            fontToRender = (FontIconData)element$iv;
            boolean bl = false;
            fontBounds = FontIconProviderKt.access$getFontBounds(fontToRender, g, fontSize);
            maxHeight += (int)fontBounds.getHeight();
        }
        fontSize *= Math.min((float)this.height / (float)(maxHeight + JBUI.scale((int)4)), 1.0f);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int yOffset = 0;
        Iterable $this$forEach$iv2 = this.fonts;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            FontIconData fontToRender2 = (FontIconData)element$iv;
            boolean bl = false;
            Rectangle2D textBounds = FontIconProviderKt.access$getFontBounds(fontToRender2, g, fontSize);
            ((Graphics2D)g).setFont(fontToRender2.getFont().deriveFont(fontSize));
            ((Graphics2D)g).drawString(fontToRender2.getName(), x + (int)(((double)this.width - textBounds.getWidth()) / (double)2), yOffset += (int)textBounds.getHeight());
        }
        ((Graphics2D)g).setFont(originalFont);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, antiAliasValue);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, renderValue);
    }
}

