/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.plugin;

import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.resources.ResourceType;
import com.android.tools.idea.ui.resourcemanager.importer.QualifierMatcher;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRendererManager;
import com.android.tools.idea.ui.resourcemanager.plugin.ResourceImporter;
import com.android.tools.idea.ui.resourcemanager.plugin.SVGAssetRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.SVGImporterKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/SVGImporter;", "Lcom/android/tools/idea/ui/resourcemanager/plugin/ResourceImporter;", "()V", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "userCanEditQualifiers", "", "getUserCanEditQualifiers", "()Z", "convertSVGToVectorDrawable", "Lcom/intellij/testFramework/LightVirtualFile;", "it", "Ljava/io/File;", "getSourcePreview", "Lcom/android/tools/idea/ui/resourcemanager/plugin/DesignAssetRenderer;", "asset", "Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "getSupportedFileTypes", "", "processFile", "file", "intellij.android.core"})
public final class SVGImporter
implements ResourceImporter {
    @NotNull
    private final String presentableName;

    public SVGImporter() {
        this.presentableName = "SVG Importer";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.presentableName;
    }

    @Override
    public boolean getUserCanEditQualifiers() {
        return true;
    }

    @Override
    @NotNull
    public Set<String> getSupportedFileTypes() {
        return SVGImporterKt.access$getSupportedFileTypes$p();
    }

    @Override
    @Nullable
    public DesignAssetRenderer getSourcePreview(@NotNull DesignAsset asset) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        return DesignAssetRendererManager.Companion.getInstance().getViewer(SVGAssetRenderer.class);
    }

    @Override
    @Nullable
    public DesignAsset processFile(@NotNull File file2) {
        DesignAsset designAsset;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        QualifierMatcher qualifierMatcher = new QualifierMatcher(null, 1, null);
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        QualifierMatcher.Result qualifierMatcherResult = qualifierMatcher.parsePath(string);
        LightVirtualFile lightVirtualFile = this.convertSVGToVectorDrawable(file2);
        if (lightVirtualFile != null) {
            LightVirtualFile it = lightVirtualFile;
            boolean bl = false;
            designAsset = new DesignAsset((VirtualFile)it, CollectionsKt.toList((Iterable)qualifierMatcherResult.getQualifiers()), ResourceType.DRAWABLE, qualifierMatcherResult.getResourceName(), null, 16, null);
        } else {
            designAsset = null;
        }
        return designAsset;
    }

    private final LightVirtualFile convertSVGToVectorDrawable(File it) {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = Svg2Vector.parseSvgToXml((Path)it.toPath(), (OutputStream)byteArrayOutputStream);
        }
        catch (Exception e) {
            Logger.getInstance(SVGImporter.class).warn("Error converting " + it.getAbsolutePath() + " to vector drawable - " + e.getLocalizedMessage());
            return null;
        }
        String errors2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)errors2, (String)"errors");
        if (!StringsKt.isBlank((CharSequence)errors2)) {
            Logger.getInstance(SVGImporter.class).warn("Error converting " + it.getAbsolutePath() + " to vector drawable:\n" + errors2);
        }
        if (byteArrayOutputStream.size() == 0) {
            return null;
        }
        String string = FilesKt.getNameWithoutExtension((File)it) + ".xml";
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteArrayOutputStream.toByteArray()");
        object = byArray;
        return new LightVirtualFile(string, (CharSequence)new String((byte[])object, Charsets.UTF_8));
    }
}

