/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.model;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.ui.resourcemanager.ResourceManagerTracking;
import com.android.tools.idea.ui.resourcemanager.model.ResourceDataManagerKt;
import com.android.tools.idea.ui.resourcemanager.model.ResourcePasteProviderKt;
import com.android.tools.idea.ui.resourcemanager.model.SupportedKotlinElement;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.idea.util.ReformatUtil;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Producer;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0002J \u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J.\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00072\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00052\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010#\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\"\u0010$\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J,\u0010%\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J,\u0010&\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010(\u001a\u00020\f2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\"\u0010+\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\"\u0010,\u001a\u00020\f2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J6\u0010/\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00072\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00052\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J \u00100\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u00061"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/model/ResourcePasteProvider;", "Lcom/intellij/ide/PasteProvider;", "()V", "IMAGE_LIKE_TYPES", "", "Lcom/android/resources/ResourceType;", "resourceCodeReference", "", "Lcom/android/resources/ResourceUrl;", "getResourceCodeReference", "(Lcom/android/resources/ResourceUrl;)Ljava/lang/String;", "dependsOnAppCompat", "", "xmlTag", "Lcom/intellij/psi/xml/XmlTag;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getResourceUrl", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "insertImageView", "", "resourceReference", "psiElement", "Lcom/intellij/psi/PsiElement;", "caret", "Lcom/intellij/openapi/editor/Caret;", "isFixedDimension", "insertIncludeTag", "isPasteEnabled", "isPastePossible", "pasteAtCaret", "type", "project", "Lcom/intellij/openapi/project/Project;", "performForImageView", "performForJavaCode", "performForKotlinCode", "performForXml", "performPaste", "processForAttribute", "xmlAttribute", "Lcom/intellij/psi/xml/XmlAttribute;", "processForTag", "processForValue", "xmlAttributeValue", "Lcom/intellij/psi/xml/XmlAttributeValue;", "replaceAtCaret", "setSrcAttribute", "intellij.android.core"})
public final class ResourcePasteProvider
implements PasteProvider {
    @NotNull
    private final Set<ResourceType> IMAGE_LIKE_TYPES;

    public ResourcePasteProvider() {
        Object[] objectArray = new ResourceType[]{ResourceType.DRAWABLE, ResourceType.MIPMAP, ResourceType.COLOR};
        this.IMAGE_LIKE_TYPES = SetsKt.setOf((Object[])objectArray);
    }

    public void performPaste(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Object object = CommonDataKeys.CARET.getData(dataContext);
        Intrinsics.checkNotNull((Object)object);
        Caret caret = (Caret)object;
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        boolean $i$f$runReadAction = false;
        PsiElement psiElement = (PsiElement)ApplicationManager.getApplication().runReadAction(new Computable(psiFile2, caret){
            final /* synthetic */ PsiFile $psiFile$inlined;
            final /* synthetic */ Caret $caret$inlined;
            {
                this.$psiFile$inlined = psiFile;
                this.$caret$inlined = caret;
            }

            public final T compute() {
                boolean bl = false;
                return (T)this.$psiFile$inlined.findElementAt(this.$caret$inlined.getOffset());
            }
        });
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        FileType fileType = psiFile2.getFileType();
        if (Intrinsics.areEqual((Object)fileType, (Object)XmlFileType.INSTANCE)) {
            this.performForXml(psiElement, dataContext, caret, project);
        } else if (Intrinsics.areEqual((Object)fileType, (Object)JavaFileType.INSTANCE)) {
            this.performForJavaCode(dataContext, caret, project);
        } else if (Intrinsics.areEqual((Object)fileType, (Object)KotlinFileType.INSTANCE)) {
            this.performForKotlinCode(psiElement, dataContext, caret, project);
        }
    }

    private final void performForKotlinCode(PsiElement psiElement, DataContext dataContext, Caret caret, Project project) {
        SupportedKotlinElement supportedKotlinElement;
        SupportedKotlinElement supportedKotlinElement2;
        PsiElement kotlinParentElement;
        ResourceUrl resourceUrl = this.getResourceUrl(dataContext);
        if (resourceUrl == null) {
            return;
        }
        ResourceUrl resourceUrl2 = resourceUrl;
        if (psiElement == null) {
            return;
        }
        String resourceCodeReference = this.getResourceCodeReference(resourceUrl2);
        Class<? extends PsiElement>[] classArray = SupportedKotlinElement.Companion.getAllSupportedKotlinElementClasses();
        PsiElement psiElement2 = kotlinParentElement = PsiUtilsKt.getParentOfTypes((PsiElement)psiElement, (boolean)false, (Class[])Arrays.copyOf(classArray, classArray.length));
        if (psiElement2 != null) {
            PsiElement psiElement3 = psiElement2;
            SupportedKotlinElement.Companion companion = SupportedKotlinElement.Companion;
            PsiElement p0 = psiElement3;
            boolean bl = false;
            supportedKotlinElement2 = companion.toSupportedKotlinElement(p0);
        } else {
            supportedKotlinElement2 = supportedKotlinElement = null;
        }
        if (supportedKotlinElement != null) {
            supportedKotlinElement.getProcessElement().invoke((Object)kotlinParentElement, (Object)caret, (Object)resourceCodeReference);
            ResourceManagerTracking.INSTANCE.logPasteUrlText(project, resourceUrl2.type);
        } else {
            this.pasteAtCaret(caret, resourceCodeReference, resourceUrl2.type, project);
        }
    }

    private final void performForJavaCode(DataContext dataContext, Caret caret, Project project) {
        ResourceUrl resourceUrl = this.getResourceUrl(dataContext);
        if (resourceUrl == null) {
            return;
        }
        ResourceUrl resourceUrl2 = resourceUrl;
        String resourceCodeReference = this.getResourceCodeReference(resourceUrl2);
        this.pasteAtCaret(caret, resourceCodeReference, resourceUrl2.type, project);
    }

    private final void performForXml(PsiElement psiElement, DataContext dataContext, Caret caret, Project project) {
        ResourceUrl resourceUrl = this.getResourceUrl(dataContext);
        Object object = resourceUrl;
        if (object == null || (object = object.toString()) == null) {
            return;
        }
        Object resourceReference = object;
        if (psiElement instanceof PsiWhiteSpace && IdeResourcesUtil.getFolderType(((PsiWhiteSpace)psiElement).getContainingFile()) == ResourceFolderType.LAYOUT) {
            ResourceType resourceType = resourceUrl.type;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"resourceUrl.type");
            ResourceManagerTracking.INSTANCE.logPasteOnBlank(project, resourceType);
            if (this.IMAGE_LIKE_TYPES.contains(resourceUrl.type)) {
                this.insertImageView((String)resourceReference, psiElement, caret, resourceUrl.type == ResourceType.COLOR);
                return;
            }
            if (resourceUrl.type == ResourceType.LAYOUT) {
                this.insertIncludeTag((String)resourceReference, psiElement, caret);
                return;
            }
        }
        if (!(psiElement instanceof XmlElement)) {
            this.pasteAtCaret(caret, (String)resourceReference, resourceUrl.type, project);
            return;
        }
        PsiElement $this$parentOfType$iv = psiElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        XmlAttributeValue xmlAttributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, XmlAttributeValue.class, (boolean)true);
        if (this.processForValue(xmlAttributeValue, caret, (String)resourceReference)) {
            ResourceType resourceType = resourceUrl.type;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"resourceUrl.type");
            ResourceManagerTracking.INSTANCE.logPasteOnXmlAttribute(project, resourceType);
            return;
        }
        PsiElement $this$parentOfType$iv2 = psiElement;
        boolean withSelf$iv2 = false;
        boolean $i$f$parentOfType2 = false;
        XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv2, XmlAttribute.class, (boolean)true);
        if (this.processForAttribute(xmlAttribute, caret, (String)resourceReference)) {
            ResourceType resourceType = resourceUrl.type;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"resourceUrl.type");
            ResourceManagerTracking.INSTANCE.logPasteOnXmlAttribute(project, resourceType);
            return;
        }
        PsiElement $this$parentOfType$iv3 = psiElement;
        boolean withSelf$iv3 = false;
        boolean $i$f$parentOfType3 = false;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv3, XmlTag.class, (boolean)true);
        if (this.processForTag(xmlTag, caret, (String)resourceReference)) {
            ResourceType resourceType = resourceUrl.type;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"resourceUrl.type");
            ResourceManagerTracking.INSTANCE.logPasteOnXmlTag(project, resourceType);
            return;
        }
        this.pasteAtCaret(caret, (String)resourceReference, resourceUrl.type, project);
    }

    private final void insertIncludeTag(String resourceReference, PsiElement psiElement, Caret caret) {
        Object element$iv;
        XmlTag parent2;
        block3: {
            PsiElement $this$parentOfType$iv = psiElement;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, XmlTag.class, (boolean)true);
            if (xmlTag == null) {
                return;
            }
            parent2 = xmlTag;
            PsiElement[] psiElementArray = parent2.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"parent.children");
            Object[] $this$last$iv = psiElementArray;
            boolean $i$f$last = false;
            int n = $this$last$iv.length + -1;
            if (0 <= n) {
                do {
                    int index$iv = n--;
                    element$iv = $this$last$iv[index$iv];
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (it.getTextRange().getStartOffset() < caret.getOffset()) break block3;
                } while (0 <= n);
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        PsiElement before = (PsiElement)element$iv;
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(parent2, before, resourceReference){
            final /* synthetic */ XmlTag $parent$inlined;
            final /* synthetic */ PsiElement $before$inlined;
            final /* synthetic */ String $resourceReference$inlined;
            {
                this.$parent$inlined = xmlTag;
                this.$before$inlined = psiElement;
                this.$resourceReference$inlined = string;
            }

            public final T compute() {
                XmlTag childTag;
                boolean bl = false;
                PsiElement psiElement = this.$parent$inlined.addAfter((PsiElement)this.$parent$inlined.createChildTag("include", this.$parent$inlined.getNamespace(), null, false), this.$before$inlined);
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlTag");
                XmlTag $this$insertIncludeTag_u24lambda_u2d3_u24lambda_u2d2 = childTag = (XmlTag)psiElement;
                boolean bl2 = false;
                $this$insertIncludeTag_u24lambda_u2d3_u24lambda_u2d2.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", "wrap_content");
                $this$insertIncludeTag_u24lambda_u2d3_u24lambda_u2d2.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", "wrap_content");
                $this$insertIncludeTag_u24lambda_u2d3_u24lambda_u2d2.setAttribute("layout", this.$resourceReference$inlined);
                $this$insertIncludeTag_u24lambda_u2d3_u24lambda_u2d2.collapseIfEmpty();
                Project project = this.$parent$inlined.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"parent.project");
                ReformatUtil.reformatAndRearrange(project, (PsiElement)$this$insertIncludeTag_u24lambda_u2d3_u24lambda_u2d2);
                return (T)Unit.INSTANCE;
            }
        });
    }

    private final void insertImageView(String resourceReference, PsiElement psiElement, Caret caret, boolean isFixedDimension) {
        Object element$iv;
        boolean dependsOnAppCompat;
        XmlTag parent2;
        block3: {
            PsiElement $this$parentOfType$iv = psiElement;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, XmlTag.class, (boolean)true);
            if (xmlTag == null) {
                return;
            }
            parent2 = xmlTag;
            dependsOnAppCompat = this.dependsOnAppCompat(parent2);
            PsiElement[] psiElementArray = parent2.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"parent.children");
            Object[] $this$last$iv = psiElementArray;
            boolean $i$f$last = false;
            int n = $this$last$iv.length + -1;
            if (0 <= n) {
                do {
                    int index$iv = n--;
                    element$iv = $this$last$iv[index$iv];
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (it.getTextRange().getStartOffset() < caret.getOffset()) break block3;
                } while (0 <= n);
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        PsiElement before = (PsiElement)element$iv;
        String dimensionValue = isFixedDimension ? "50dp" : "wrap_content";
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(parent2, before, dimensionValue, this, dependsOnAppCompat, resourceReference){
            final /* synthetic */ XmlTag $parent$inlined;
            final /* synthetic */ PsiElement $before$inlined;
            final /* synthetic */ String $dimensionValue$inlined;
            final /* synthetic */ ResourcePasteProvider this$0;
            final /* synthetic */ boolean $dependsOnAppCompat$inlined;
            final /* synthetic */ String $resourceReference$inlined;
            {
                this.$parent$inlined = xmlTag;
                this.$before$inlined = psiElement;
                this.$dimensionValue$inlined = string;
                this.this$0 = resourcePasteProvider;
                this.$dependsOnAppCompat$inlined = bl;
                this.$resourceReference$inlined = string2;
            }

            public final T compute() {
                XmlTag childTag;
                boolean bl = false;
                PsiElement psiElement = this.$parent$inlined.addAfter((PsiElement)this.$parent$inlined.createChildTag("ImageView", this.$parent$inlined.getNamespace(), null, false), this.$before$inlined);
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlTag");
                XmlTag $this$insertImageView_u24lambda_u2d6_u24lambda_u2d5 = childTag = (XmlTag)psiElement;
                boolean bl2 = false;
                $this$insertImageView_u24lambda_u2d6_u24lambda_u2d5.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", this.$dimensionValue$inlined);
                $this$insertImageView_u24lambda_u2d6_u24lambda_u2d5.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", this.$dimensionValue$inlined);
                ResourcePasteProvider.access$setSrcAttribute(this.this$0, this.$dependsOnAppCompat$inlined, $this$insertImageView_u24lambda_u2d6_u24lambda_u2d5, this.$resourceReference$inlined);
                $this$insertImageView_u24lambda_u2d6_u24lambda_u2d5.collapseIfEmpty();
                Project project = this.$parent$inlined.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"parent.project");
                ReformatUtil.reformatAndRearrange(project, (PsiElement)$this$insertImageView_u24lambda_u2d6_u24lambda_u2d5);
                return (T)Unit.INSTANCE;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean processForTag(XmlTag xmlTag, Caret caret, String resourceReference) {
        XmlTag xmlTag2 = xmlTag;
        if (xmlTag2 == null) return false;
        String string = xmlTag2.getName();
        String string2 = string;
        if (string2 == null) return false;
        switch (string2.hashCode()) {
            case 1125864064: {
                if (!string2.equals("ImageView")) return false;
                boolean bl = this.performForImageView(xmlTag, resourceReference);
                return bl;
            }
            default: {
                return false;
            }
        }
    }

    private final boolean processForAttribute(XmlAttribute xmlAttribute, Caret caret, String resourceReference) {
        block1: {
            if (xmlAttribute == null) {
                return false;
            }
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable(xmlAttribute, resourceReference){
                final /* synthetic */ XmlAttribute $xmlAttribute$inlined;
                final /* synthetic */ String $resourceReference$inlined;
                {
                    this.$xmlAttribute$inlined = xmlAttribute;
                    this.$resourceReference$inlined = string;
                }

                public final T compute() {
                    boolean bl = false;
                    this.$xmlAttribute$inlined.setValue(this.$resourceReference$inlined);
                    return (T)Unit.INSTANCE;
                }
            });
            XmlAttributeValue xmlAttributeValue = xmlAttribute.getValueElement();
            if (xmlAttributeValue == null || (xmlAttributeValue = xmlAttributeValue.getValueTextRange()) == null) break block1;
            int it = xmlAttributeValue.getStartOffset();
            boolean bl = false;
            ResourcePasteProviderKt.access$selectStringFromOffset(caret, resourceReference, it);
        }
        return true;
    }

    private final boolean processForValue(XmlAttributeValue xmlAttributeValue, Caret caret, String resourceReference) {
        if (xmlAttributeValue == null) {
            return false;
        }
        PsiElement psiElement = xmlAttributeValue.getParent();
        this.processForAttribute(psiElement instanceof XmlAttribute ? (XmlAttribute)psiElement : null, caret, resourceReference);
        return true;
    }

    private final void pasteAtCaret(Caret caret, String resourceReference, ResourceType type, Project project) {
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(caret, resourceReference){
            final /* synthetic */ Caret $caret$inlined;
            final /* synthetic */ String $resourceReference$inlined;
            {
                this.$caret$inlined = caret;
                this.$resourceReference$inlined = string;
            }

            public final T compute() {
                boolean bl = false;
                this.$caret$inlined.getEditor().getDocument().insertString(this.$caret$inlined.getOffset(), (CharSequence)this.$resourceReference$inlined);
                return (T)Unit.INSTANCE;
            }
        });
        ResourcePasteProviderKt.access$selectStringFromOffset(caret, resourceReference, caret.getOffset());
        ResourceManagerTracking.INSTANCE.logPasteUrlText(project, type);
    }

    static /* synthetic */ void pasteAtCaret$default(ResourcePasteProvider resourcePasteProvider, Caret caret, String string, ResourceType resourceType, Project project, int n, Object object) {
        if ((n & 4) != 0) {
            resourceType = null;
        }
        resourcePasteProvider.pasteAtCaret(caret, string, resourceType, project);
    }

    private final void replaceAtCaret(Caret caret, PsiElement psiElement, String resourceReference, ResourceType type, Project project) {
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(caret, psiElement, resourceReference){
            final /* synthetic */ Caret $caret$inlined;
            final /* synthetic */ PsiElement $psiElement$inlined;
            final /* synthetic */ String $resourceReference$inlined;
            {
                this.$caret$inlined = caret;
                this.$psiElement$inlined = psiElement;
                this.$resourceReference$inlined = string;
            }

            public final T compute() {
                boolean bl = false;
                this.$caret$inlined.getEditor().getDocument().replaceString(this.$psiElement$inlined.getTextRange().getStartOffset(), this.$psiElement$inlined.getTextRange().getEndOffset(), (CharSequence)this.$resourceReference$inlined);
                return (T)Unit.INSTANCE;
            }
        });
        ResourcePasteProviderKt.access$selectStringFromOffset(caret, resourceReference, psiElement.getTextRange().getStartOffset());
        ResourceManagerTracking.INSTANCE.logPasteUrlText(project, type);
    }

    static /* synthetic */ void replaceAtCaret$default(ResourcePasteProvider resourcePasteProvider, Caret caret, PsiElement psiElement, String string, ResourceType resourceType, Project project, int n, Object object) {
        if ((n & 8) != 0) {
            resourceType = null;
        }
        resourcePasteProvider.replaceAtCaret(caret, psiElement, string, resourceType, project);
    }

    private final boolean performForImageView(XmlTag xmlTag, String resourceReference) {
        boolean dependsOnAppCompat = this.dependsOnAppCompat(xmlTag);
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(this, dependsOnAppCompat, xmlTag, resourceReference){
            final /* synthetic */ ResourcePasteProvider this$0;
            final /* synthetic */ boolean $dependsOnAppCompat$inlined;
            final /* synthetic */ XmlTag $xmlTag$inlined;
            final /* synthetic */ String $resourceReference$inlined;
            {
                this.this$0 = resourcePasteProvider;
                this.$dependsOnAppCompat$inlined = bl;
                this.$xmlTag$inlined = xmlTag;
                this.$resourceReference$inlined = string;
            }

            public final T compute() {
                boolean bl = false;
                ResourcePasteProvider.access$setSrcAttribute(this.this$0, this.$dependsOnAppCompat$inlined, this.$xmlTag$inlined, this.$resourceReference$inlined);
                Project project = this.$xmlTag$inlined.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"xmlTag.project");
                ReformatUtil.reformatAndRearrange(project, (PsiElement)this.$xmlTag$inlined);
                return (T)Unit.INSTANCE;
            }
        });
        return true;
    }

    private final void setSrcAttribute(boolean dependsOnAppCompat, XmlTag xmlTag, String resourceReference) {
        if (dependsOnAppCompat) {
            PsiFile psiFile = xmlTag.getContainingFile();
            XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
            if (xmlFile != null) {
                XmlFile it = xmlFile;
                boolean bl = false;
                IdeResourcesUtil.ensureNamespaceImported$default(it, "http://schemas.android.com/apk/res-auto", null, 4, null);
            }
            xmlTag.setAttribute("srcCompat", "http://schemas.android.com/apk/res-auto", resourceReference);
            xmlTag.setAttribute("src", "http://schemas.android.com/apk/res/android", null);
        } else {
            xmlTag.setAttribute("srcCompat", "http://schemas.android.com/apk/res-auto", null);
            xmlTag.setAttribute("src", "http://schemas.android.com/apk/res/android", resourceReference);
        }
    }

    private final boolean dependsOnAppCompat(XmlTag xmlTag) {
        boolean $i$f$runReadAction = false;
        return Intrinsics.areEqual((Object)ApplicationManager.getApplication().runReadAction(new Computable(xmlTag){
            final /* synthetic */ XmlTag $xmlTag$inlined;
            {
                this.$xmlTag$inlined = xmlTag;
            }

            public final T compute() {
                Boolean bl;
                Module module2;
                boolean bl2 = false;
                Module module3 = module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)this.$xmlTag$inlined));
                if (module3 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"findModuleForPsiElement(xmlTag)");
                    bl = DependencyManagementUtil.dependsOnAppCompat(module2);
                } else {
                    bl = null;
                }
                return (T)bl;
            }
        }), (Object)true);
    }

    private final ResourceUrl getResourceUrl(DataContext dataContext) {
        Transferable transferable2;
        Producer producer = (Producer)PasteAction.TRANSFERABLE_PROVIDER.getData(dataContext);
        return (ResourceUrl)(producer != null && (transferable2 = (Transferable)producer.produce()) != null ? transferable2.getTransferData(ResourceDataManagerKt.RESOURCE_URL_FLAVOR) : null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        Transferable transferable2;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Producer producer = (Producer)PasteAction.TRANSFERABLE_PROVIDER.getData(dataContext);
        return producer != null && (transferable2 = (Transferable)producer.produce()) != null ? transferable2.isDataFlavorSupported(ResourceDataManagerKt.RESOURCE_URL_FLAVOR) : false;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.isPastePossible(dataContext);
    }

    private final String getResourceCodeReference(ResourceUrl $this$resourceCodeReference) {
        Object object;
        block3: {
            block2: {
                object = $this$resourceCodeReference.namespace;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = it + ".";
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return (String)object + "R." + $this$resourceCodeReference.type + "." + $this$resourceCodeReference.name;
    }

    public static final /* synthetic */ void access$setSrcAttribute(ResourcePasteProvider $this, boolean dependsOnAppCompat, XmlTag xmlTag, String resourceReference) {
        $this.setSrcAttribute(dependsOnAppCompat, xmlTag, resourceReference);
    }
}

