/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.importer;

import com.android.ide.common.resources.FileResourceNameValidator;
import com.android.tools.idea.ui.resourcemanager.importer.ImportersProvider;
import com.android.tools.idea.ui.resourcemanager.importer.ResourceImportManagerKt;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.android.tools.idea.ui.resourcemanager.model.ResourceAssetSet;
import com.android.tools.idea.ui.resourcemanager.plugin.ResourceImporter;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a4\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\u0018\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u00050\u000b\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f*\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\f*\u00020\u0011\u001a\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\b\u0012\u0004\u0012\u00020\r0\f\u001a\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f*\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\u0006\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"MAX_FILE_DEPTH", "", "PREFERENCE_LAST_SELECTED_DIRECTORY", "", "chooseDesignAssets", "", "importersProvider", "Lcom/android/tools/idea/ui/resourcemanager/importer/ImportersProvider;", "parent", "Ljavax/swing/JComponent;", "fileChosenCallback", "Lkotlin/Function1;", "Lkotlin/sequences/Sequence;", "Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "createFileDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "findAllDesignAssets", "Ljava/io/File;", "getAllLeafFiles", "groupIntoDesignAssetSet", "", "Lcom/android/tools/idea/ui/resourcemanager/model/ResourceAssetSet;", "toDesignAsset", "intellij.android.core"})
public final class ResourceImportManagerKt {
    @NotNull
    private static final String PREFERENCE_LAST_SELECTED_DIRECTORY = "resourceExplorer.lastChosenDirectory";
    private static final int MAX_FILE_DEPTH = 10;

    @NotNull
    public static final Sequence<File> getAllLeafFiles(@NotNull File $this$getAllLeafFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllLeafFiles, (String)"<this>");
        FileVisitOption[] fileVisitOptionArray = new FileVisitOption[]{FileVisitOption.FOLLOW_LINKS};
        Stream<Path> stream = Files.walk($this$getAllLeafFiles.toPath(), 10, fileVisitOptionArray);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"walk(toPath(), MAX_FILE_\u2026VisitOption.FOLLOW_LINKS)");
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence(stream), (Function1)getAllLeafFiles.1.INSTANCE), (Function1)getAllLeafFiles.2.INSTANCE);
    }

    @NotNull
    public static final Sequence<DesignAsset> toDesignAsset(@NotNull Sequence<? extends File> $this$toDesignAsset, @NotNull ImportersProvider importersProvider) {
        Intrinsics.checkNotNullParameter($this$toDesignAsset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)importersProvider, (String)"importersProvider");
        return SequencesKt.mapNotNull($this$toDesignAsset, (Function1)((Function1)new Function1<File, DesignAsset>(importersProvider){
            final /* synthetic */ ImportersProvider $importersProvider;
            {
                this.$importersProvider = $importersProvider;
                super(1);
            }

            @Nullable
            public final DesignAsset invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ResourceImporter resourceImporter = (ResourceImporter)CollectionsKt.firstOrNull(this.$importersProvider.getImportersForExtension(FilesKt.getExtension((File)it)));
                return resourceImporter != null ? resourceImporter.processFile(it) : null;
            }
        }));
    }

    @NotNull
    public static final Sequence<DesignAsset> findAllDesignAssets(@NotNull Sequence<? extends File> $this$findAllDesignAssets, @NotNull ImportersProvider importersProvider) {
        Intrinsics.checkNotNullParameter($this$findAllDesignAssets, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)importersProvider, (String)"importersProvider");
        return ResourceImportManagerKt.toDesignAsset((Sequence<? extends File>)SequencesKt.flatMap($this$findAllDesignAssets, (Function1)findAllDesignAssets.1.INSTANCE), importersProvider);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ResourceAssetSet> groupIntoDesignAssetSet(@NotNull Sequence<DesignAsset> $this$groupIntoDesignAssetSet) {
        void $this$mapTo$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$groupIntoDesignAssetSet, (String)"<this>");
        Sequence<DesignAsset> $this$groupBy$iv = $this$groupIntoDesignAssetSet;
        boolean $i$f$groupBy = false;
        Sequence<DesignAsset> sequence = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            DesignAsset it = (DesignAsset)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            String name = (String)entry.getKey();
            List assets = (List)entry.getValue();
            String string = FileResourceNameValidator.getValidResourceFileName((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValidResourceFileName(name)");
            object.add(new ResourceAssetSet(string, assets));
        }
        return (List)destination$iv$iv;
    }

    public static final void chooseDesignAssets(@NotNull ImportersProvider importersProvider, @Nullable JComponent parent2, @NotNull Function1<? super Sequence<DesignAsset>, Unit> fileChosenCallback) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)importersProvider, (String)"importersProvider");
        Intrinsics.checkNotNullParameter(fileChosenCallback, (String)"fileChosenCallback");
        String string = PropertiesComponent.getInstance().getValue(PREFERENCE_LAST_SELECTED_DIRECTORY);
        if (string != null) {
            VirtualFile virtualFile2;
            String it = string;
            boolean bl = false;
            try {
                virtualFile2 = VfsUtil.findFile((Path)new File(it).toPath(), (boolean)true);
            }
            catch (InvalidPathException ex) {
                virtualFile2 = null;
            }
            virtualFile = virtualFile2;
        } else {
            virtualFile = null;
        }
        VirtualFile lastChosenDirFile = virtualFile;
        FileChooserDescriptor fileChooserDescriptor2 = ResourceImportManagerKt.createFileDescriptor(importersProvider);
        FileChooserFactory.getInstance().createPathChooser(fileChooserDescriptor2, null, (Component)parent2).choose(lastChosenDirFile, new Consumer(importersProvider, fileChosenCallback){
            final /* synthetic */ ImportersProvider $importersProvider;
            final /* synthetic */ Function1<Sequence<DesignAsset>, Unit> $fileChosenCallback;
            {
                this.$importersProvider = $importersProvider;
                this.$fileChosenCallback = $fileChosenCallback;
            }

            public final void consume(List<VirtualFile> selectedFiles) {
                Intrinsics.checkNotNullExpressionValue(selectedFiles, (String)"selectedFiles");
                Sequence<DesignAsset> allDesignAssets2 = ResourceImportManagerKt.findAllDesignAssets((Sequence<? extends File>)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)selectedFiles), (Function1)chooseDesignAssets.allDesignAssets.1.INSTANCE), this.$importersProvider);
                this.$fileChosenCallback.invoke(allDesignAssets2);
                VirtualFile virtualFile = (VirtualFile)CollectionsKt.firstOrNull(selectedFiles);
                PropertiesComponent.getInstance().setValue("resourceExplorer.lastChosenDirectory", virtualFile != null ? virtualFile.getPath() : null);
            }
        });
    }

    public static /* synthetic */ void chooseDesignAssets$default(ImportersProvider importersProvider, JComponent jComponent, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            jComponent = null;
        }
        ResourceImportManagerKt.chooseDesignAssets(importersProvider, jComponent, (Function1<? super Sequence<DesignAsset>, Unit>)function1);
    }

    private static final FileChooserDescriptor createFileDescriptor(ImportersProvider importersProvider) {
        Set<String> supportedFileTypes = importersProvider.getSupportedFileTypes();
        FileChooserDescriptor fileChooserDescriptor2 = new FileChooserDescriptor(true, true, false, false, false, true).withFileFilter(new Condition(supportedFileTypes){
            final /* synthetic */ Set<String> $supportedFileTypes;
            {
                this.$supportedFileTypes = $supportedFileTypes;
            }

            public final boolean value(VirtualFile it) {
                return CollectionsKt.contains((Iterable)this.$supportedFileTypes, (Object)it.getExtension());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor2, (String)"val supportedFileTypes =\u2026n in supportedFileTypes }");
        return fileChooserDescriptor2;
    }
}

