/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.importer;

import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.ui.resourcemanager.importer.DesignAssetImporter;
import com.android.tools.idea.ui.resourcemanager.importer.DesignAssetImporterKt;
import com.android.tools.idea.ui.resourcemanager.importer.FileImportRowViewModel;
import com.android.tools.idea.ui.resourcemanager.importer.ImportersProvider;
import com.android.tools.idea.ui.resourcemanager.importer.ResourceImportDialogViewModel;
import com.android.tools.idea.ui.resourcemanager.importer.ResourceImportManagerKt;
import com.android.tools.idea.ui.resourcemanager.importer.SummaryScreenViewModel;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.android.tools.idea.ui.resourcemanager.model.DesignAssetKt;
import com.android.tools.idea.ui.resourcemanager.model.ResourceAssetSet;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRendererManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJD\u0010+\u001a\u00020&2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u000e0-2\u0006\u0010/\u001a\u00020\u000e2\u001e\u00100\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000602\u0012\u0004\u0012\u00020&01H\u0002J\u0012\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010.H\u0002J\u0006\u00106\u001a\u00020&J\u001a\u00107\u001a\n 9*\u0004\u0018\u000108082\b\u0010:\u001a\u0004\u0018\u00010;H\u0002J\"\u0010<\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020\u00062\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020&0?J\u0018\u0010@\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010B0A2\u0006\u0010=\u001a\u00020\u0006J\u000e\u0010C\u001a\u00020.2\u0006\u0010/\u001a\u00020\u000eJ\u001a\u0010D\u001a\n 9*\u0004\u0018\u000108082\b\u0010:\u001a\u0004\u0018\u00010;H\u0002J\b\u0010E\u001a\u0004\u0018\u000108J\u0010\u0010F\u001a\u0002042\u0006\u00105\u001a\u00020.H\u0002J&\u0010G\u001a\u00020&2\u001e\u00100\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000602\u0012\u0004\u0012\u00020&01J&\u0010H\u001a\u00020&2\u001e\u00100\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000602\u0012\u0004\u0012\u00020&01J\u000e\u0010I\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\u0006J9\u0010J\u001a\u00020&2\u0006\u0010/\u001a\u00020\u000e2\u0006\u00105\u001a\u00020.2!\u0010K\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\bL\u0012\b\bM\u0012\u0004\b\b(N\u0012\u0004\u0012\u00020&0?J\u001c\u0010O\u001a\u0004\u0018\u0001082\u0006\u00105\u001a\u00020.2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010;R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R \u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006P"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/importer/ResourceImportDialogViewModel;", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "assets", "Lkotlin/sequences/Sequence;", "Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "designAssetImporter", "Lcom/android/tools/idea/ui/resourcemanager/importer/DesignAssetImporter;", "importersProvider", "Lcom/android/tools/idea/ui/resourcemanager/importer/ImportersProvider;", "(Lorg/jetbrains/android/facet/AndroidFacet;Lkotlin/sequences/Sequence;Lcom/android/tools/idea/ui/resourcemanager/importer/DesignAssetImporter;Lcom/android/tools/idea/ui/resourcemanager/importer/ImportersProvider;)V", "assetSets", "", "Lcom/android/tools/idea/ui/resourcemanager/model/ResourceAssetSet;", "getAssetSets", "()Ljava/util/Set;", "assetSetsToImport", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "fileCount", "", "getFileCount", "()I", "fileViewModels", "", "Lcom/android/tools/idea/ui/resourcemanager/importer/FileImportRowViewModel;", "rendererManager", "Lcom/android/tools/idea/ui/resourcemanager/plugin/DesignAssetRendererManager;", "resourceDuplicateValidator", "Lcom/android/tools/idea/res/IdeResourceNameValidator;", "resourceNameValidator", "summaryScreenViewModel", "Lcom/android/tools/idea/ui/resourcemanager/importer/SummaryScreenViewModel;", "getSummaryScreenViewModel", "()Lcom/android/tools/idea/ui/resourcemanager/importer/SummaryScreenViewModel;", "updateCallback", "Lkotlin/Function0;", "", "getUpdateCallback", "()Lkotlin/jvm/functions/Function0;", "setUpdateCallback", "(Lkotlin/jvm/functions/Function0;)V", "addAssetSet", "existingAssets", "", "", "assetSet", "assetAddedCallback", "Lkotlin/Function2;", "", "checkIfNameUnique", "", "newName", "commit", "createDuplicateValidationInfo", "Lcom/intellij/openapi/ui/ValidationInfo;", "kotlin.jvm.PlatformType", "field", "Ljavax/swing/JTextField;", "createFileViewModel", "asset", "removeCallback", "Lkotlin/Function1;", "getAssetPreview", "Ljava/util/concurrent/CompletableFuture;", "Ljava/awt/Image;", "getItemNumberString", "getSameNameIsImportedValidationInfo", "getValidationInfo", "hasDuplicate", "importMoreAssetIfEmpty", "importMoreAssets", "removeAsset", "rename", "assetRenamedCallback", "Lkotlin/ParameterName;", "name", "newAssetSet", "validateName", "intellij.android.core"})
public final class ResourceImportDialogViewModel {
    @NotNull
    private final AndroidFacet facet;
    @NotNull
    private final ImportersProvider importersProvider;
    @NotNull
    private final Set<ResourceAssetSet> assetSetsToImport;
    @NotNull
    private final DesignAssetRendererManager rendererManager;
    @NotNull
    private final SummaryScreenViewModel summaryScreenViewModel;
    @NotNull
    private Function0<Unit> updateCallback;
    @NotNull
    private final Map<DesignAsset, FileImportRowViewModel> fileViewModels;
    @NotNull
    private final IdeResourceNameValidator resourceDuplicateValidator;
    @NotNull
    private final IdeResourceNameValidator resourceNameValidator;

    public ResourceImportDialogViewModel(@NotNull AndroidFacet facet2, @NotNull Sequence<DesignAsset> assets, @NotNull DesignAssetImporter designAssetImporter, @NotNull ImportersProvider importersProvider) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter(assets, (String)"assets");
        Intrinsics.checkNotNullParameter((Object)designAssetImporter, (String)"designAssetImporter");
        Intrinsics.checkNotNullParameter((Object)importersProvider, (String)"importersProvider");
        this.facet = facet2;
        this.importersProvider = importersProvider;
        this.assetSetsToImport = CollectionUtilsKt.toIdentitySet((Collection)ResourceImportManagerKt.groupIntoDesignAssetSet((Sequence<DesignAsset>)SequencesKt.take(assets, (int)400)));
        this.rendererManager = DesignAssetRendererManager.Companion.getInstance();
        this.summaryScreenViewModel = new SummaryScreenViewModel(designAssetImporter, this.rendererManager, this.facet, DesignAssetImporterKt.getSourceSetsResDirs(this.facet));
        this.updateCallback = updateCallback.1.INSTANCE;
        this.fileViewModels = new LinkedHashMap();
        this.resourceDuplicateValidator = IdeResourceNameValidator.Companion.forFilename(ResourceFolderType.DRAWABLE, null, (ResourceRepository)ResourceRepositoryManager.getAppResources(this.facet));
        this.resourceNameValidator = IdeResourceNameValidator.Companion.forFilename$default(IdeResourceNameValidator.Companion, ResourceFolderType.DRAWABLE, null, null, 4, null);
    }

    public /* synthetic */ ResourceImportDialogViewModel(AndroidFacet androidFacet, Sequence sequence, DesignAssetImporter designAssetImporter, ImportersProvider importersProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            designAssetImporter = new DesignAssetImporter();
        }
        if ((n & 8) != 0) {
            importersProvider = new ImportersProvider(null, 1, null);
        }
        this(androidFacet, (Sequence<DesignAsset>)sequence, designAssetImporter, importersProvider);
    }

    @NotNull
    public final AndroidFacet getFacet() {
        return this.facet;
    }

    @NotNull
    public final Set<ResourceAssetSet> getAssetSets() {
        return this.assetSetsToImport;
    }

    @NotNull
    public final SummaryScreenViewModel getSummaryScreenViewModel() {
        return this.summaryScreenViewModel;
    }

    /*
     * WARNING - void declaration
     */
    public final int getFileCount() {
        void var3_3;
        Iterable $this$sumBy$iv = this.getAssetSets();
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            ResourceAssetSet resourceAssetSet = (ResourceAssetSet)element$iv;
            int n = sum$iv;
            boolean bl = false;
            int n2 = it.getAssets().size();
            sum$iv = n + n2;
        }
        return (int)var3_3;
    }

    @NotNull
    public final Function0<Unit> getUpdateCallback() {
        return this.updateCallback;
    }

    public final void setUpdateCallback(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.updateCallback = function0;
    }

    @NotNull
    public final CompletableFuture<? extends Image> getAssetPreview(@NotNull DesignAsset asset) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        DesignAssetRenderer designAssetRenderer = this.rendererManager.getViewer(asset.getFile());
        VirtualFile virtualFile = asset.getFile();
        Module module2 = this.facet.getModule();
        JBDimension jBDimension = JBUI.size((int)50);
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(50)");
        return DesignAssetRenderer.getImage$default(designAssetRenderer, virtualFile, module2, (Dimension)jBDimension, null, 8, null);
    }

    @NotNull
    public final String getItemNumberString(@NotNull ResourceAssetSet assetSet) {
        Intrinsics.checkNotNullParameter((Object)assetSet, (String)"assetSet");
        return "(" + assetSet.getAssets().size() + " " + StringUtil.pluralize((String)"item", (int)assetSet.getAssets().size()) + ")";
    }

    @NotNull
    public final ResourceAssetSet removeAsset(@NotNull DesignAsset asset) {
        Object element$iv2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
            Iterable $this$first$iv = this.assetSetsToImport;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                ResourceAssetSet it = (ResourceAssetSet)element$iv2;
                boolean bl = false;
                if (!it.getAssets().contains(asset)) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        ResourceAssetSet designAssetSet = (ResourceAssetSet)element$iv2;
        designAssetSet.setAssets(CollectionsKt.minus((Iterable)designAssetSet.getAssets(), (Object)asset));
        if (designAssetSet.getAssets().isEmpty()) {
            this.assetSetsToImport.remove(designAssetSet);
        }
        this.updateCallback.invoke();
        return designAssetSet;
    }

    /*
     * WARNING - void declaration
     */
    public final void importMoreAssets(@NotNull Function2<? super ResourceAssetSet, ? super List<DesignAsset>, Unit> assetAddedCallback) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(assetAddedCallback, (String)"assetAddedCallback");
        Iterable $this$associateBy$iv = this.assetSetsToImport;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ResourceAssetSet resourceAssetSet = (ResourceAssetSet)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getName(), element$iv$iv);
        }
        Map assetByName = destination$iv$iv;
        ResourceImportManagerKt.chooseDesignAssets$default(this.importersProvider, null, (Function1)new Function1<Sequence<? extends DesignAsset>, Unit>(this, (Map<String, ResourceAssetSet>)assetByName, assetAddedCallback){
            final /* synthetic */ ResourceImportDialogViewModel this$0;
            final /* synthetic */ Map<String, ResourceAssetSet> $assetByName;
            final /* synthetic */ Function2<ResourceAssetSet, List<DesignAsset>, Unit> $assetAddedCallback;
            {
                this.this$0 = $receiver;
                this.$assetByName = $assetByName;
                this.$assetAddedCallback = $assetAddedCallback;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Sequence<DesignAsset> newAssetSets) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(newAssetSets, (String)"newAssetSets");
                Iterable iterable = ResourceImportManagerKt.groupIntoDesignAssetSet((Sequence<DesignAsset>)SequencesKt.take(newAssetSets, (int)400));
                ResourceImportDialogViewModel resourceImportDialogViewModel = this.this$0;
                Map<String, ResourceAssetSet> map2 = this.$assetByName;
                Function2<ResourceAssetSet, List<DesignAsset>, Unit> function2 = this.$assetAddedCallback;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ResourceAssetSet it = (ResourceAssetSet)element$iv;
                    boolean bl = false;
                    ResourceImportDialogViewModel.access$addAssetSet(resourceImportDialogViewModel, map2, it, function2);
                }
            }
        }, 2, null);
    }

    public final void importMoreAssetIfEmpty(@NotNull Function2<? super ResourceAssetSet, ? super List<DesignAsset>, Unit> assetAddedCallback) {
        Intrinsics.checkNotNullParameter(assetAddedCallback, (String)"assetAddedCallback");
        if (this.getAssetSets().isEmpty()) {
            this.importMoreAssets(assetAddedCallback);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addAssetSet(Map<String, ResourceAssetSet> existingAssets, ResourceAssetSet assetSet, Function2<? super ResourceAssetSet, ? super List<DesignAsset>, Unit> assetAddedCallback) {
        ResourceAssetSet existingAssetSet = existingAssets.get(assetSet.getName());
        if (existingAssetSet != null) {
            void $this$filterTo$iv$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = DesignAssetKt.getDesignAssets(existingAssetSet);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void designAsset;
                DesignAsset designAsset2 = (DesignAsset)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(designAsset.getFile().getPath());
            }
            Set existingPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterable $this$filter$iv = DesignAssetKt.getDesignAssets(assetSet);
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DesignAsset designAsset = (DesignAsset)element$iv$iv;
                boolean bl = false;
                if (!(!existingPaths.contains(designAsset.getFile().getPath()))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List onlyNewFiles = (List)destination$iv$iv2;
            if (!((Collection)onlyNewFiles).isEmpty()) {
                existingAssetSet.setAssets(CollectionsKt.plus((Collection)existingAssetSet.getAssets(), (Iterable)onlyNewFiles));
                assetAddedCallback.invoke((Object)existingAssetSet, (Object)onlyNewFiles);
                this.updateCallback.invoke();
            }
        } else {
            this.assetSetsToImport.add(assetSet);
            assetAddedCallback.invoke((Object)assetSet, DesignAssetKt.getDesignAssets(assetSet));
            this.updateCallback.invoke();
        }
    }

    public final void rename(@NotNull ResourceAssetSet assetSet, @NotNull String newName2, @NotNull Function1<? super ResourceAssetSet, Unit> assetRenamedCallback) {
        Intrinsics.checkNotNullParameter((Object)assetSet, (String)"assetSet");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Intrinsics.checkNotNullParameter(assetRenamedCallback, (String)"assetRenamedCallback");
        if (!this.assetSetsToImport.contains(assetSet)) {
            boolean bl = false;
            String string = "The assetSet \"" + assetSet.getName() + "\" should already exist";
            throw new IllegalArgumentException(string.toString());
        }
        ResourceAssetSet renamedAssetSet = new ResourceAssetSet(newName2, assetSet.getAssets());
        this.assetSetsToImport.remove(assetSet);
        this.assetSetsToImport.add(renamedAssetSet);
        assetRenamedCallback.invoke((Object)renamedAssetSet);
    }

    @NotNull
    public final FileImportRowViewModel createFileViewModel(@NotNull DesignAsset asset, @NotNull Function1<? super DesignAsset, Unit> removeCallback) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        Intrinsics.checkNotNullParameter(removeCallback, (String)"removeCallback");
        Function1 viewModelRemoveCallback2 = (Function1)new Function1<DesignAsset, Unit>(removeCallback, asset, this){
            final /* synthetic */ Function1<DesignAsset, Unit> $removeCallback;
            final /* synthetic */ DesignAsset $asset;
            final /* synthetic */ ResourceImportDialogViewModel this$0;
            {
                this.$removeCallback = $removeCallback;
                this.$asset = $asset;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DesignAsset it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$removeCallback.invoke((Object)this.$asset);
                ResourceImportDialogViewModel.access$getFileViewModels$p(this.this$0).remove(this.$asset);
            }
        };
        FileImportRowViewModel fileImportRowViewModel = new FileImportRowViewModel(asset, ResourceFolderType.DRAWABLE, null, viewModelRemoveCallback2, 4, null);
        this.fileViewModels.put(asset, fileImportRowViewModel);
        return fileImportRowViewModel;
    }

    @Nullable
    public final ValidationInfo validateName(@NotNull String newName2, @Nullable JTextField field2) {
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        String errorText = this.resourceNameValidator.getErrorText(newName2);
        if (errorText != null) {
            return new ValidationInfo(errorText, (JComponent)field2);
        }
        if (this.hasDuplicate(newName2)) {
            return this.createDuplicateValidationInfo(field2);
        }
        if (this.checkIfNameUnique(newName2)) {
            return this.getSameNameIsImportedValidationInfo(field2);
        }
        return null;
    }

    public static /* synthetic */ ValidationInfo validateName$default(ResourceImportDialogViewModel resourceImportDialogViewModel, String string, JTextField jTextField, int n, Object object) {
        if ((n & 2) != 0) {
            jTextField = null;
        }
        return resourceImportDialogViewModel.validateName(string, jTextField);
    }

    private final boolean hasDuplicate(String newName2) {
        return this.resourceDuplicateValidator.doesResourceExist(newName2);
    }

    private final ValidationInfo createDuplicateValidationInfo(JTextField field2) {
        return new ValidationInfo("A resource with this name already exists and might be overridden if the qualifiers are the same.", (JComponent)field2).asWarning();
    }

    private final ValidationInfo getSameNameIsImportedValidationInfo(JTextField field2) {
        return new ValidationInfo("A resource with the same name is also being imported.", (JComponent)field2).asWarning();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkIfNameUnique(String newName2) {
        boolean bl;
        boolean nameSeen = false;
        Iterable $this$any$iv = this.assetSetsToImport;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            ResourceAssetSet it = (ResourceAssetSet)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it.getName(), (Object)newName2)) {
                if (nameSeen) {
                    return true;
                }
                nameSeen = true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @Nullable
    public final ValidationInfo getValidationInfo() {
        return (ValidationInfo)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.assetSetsToImport), (Function1)((Function1)new Function1<ResourceAssetSet, Pair<? extends ResourceAssetSet, ? extends ValidationInfo>>(this){
            final /* synthetic */ ResourceImportDialogViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Pair<ResourceAssetSet, ValidationInfo> invoke(@NotNull ResourceAssetSet asset) {
                Pair pair;
                Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
                ValidationInfo validationInfo = ResourceImportDialogViewModel.validateName$default(this.this$0, asset.getName(), null, 2, null);
                if (validationInfo != null) {
                    ValidationInfo validationInfo2 = validationInfo;
                    boolean bl = false;
                    pair = TuplesKt.to((Object)asset, (Object)validationInfo2);
                } else {
                    pair = null;
                }
                return pair;
            }
        })), (Function1)getValidationInfo.2.INSTANCE), (Function1)getValidationInfo.3.INSTANCE));
    }

    public final void commit() {
        this.summaryScreenViewModel.setAssetSetsToImport(this.assetSetsToImport);
    }

    public static final /* synthetic */ void access$addAssetSet(ResourceImportDialogViewModel $this, Map existingAssets, ResourceAssetSet assetSet, Function2 assetAddedCallback) {
        $this.addAssetSet(existingAssets, assetSet, (Function2<? super ResourceAssetSet, ? super List<DesignAsset>, Unit>)assetAddedCallback);
    }

    public static final /* synthetic */ Map access$getFileViewModels$p(ResourceImportDialogViewModel $this) {
        return $this.fileViewModels;
    }
}

