/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.importer;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.tools.idea.ui.resourcemanager.ResourceManagerTracking;
import com.android.tools.idea.ui.resourcemanager.model.Mapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB'\b\u0016\u0012\u001e\u0010\u0002\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\"\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006B\u001b\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/importer/QualifierMatcher;", "", "mapper", "", "Lcom/android/tools/idea/ui/resourcemanager/model/Mapper;", "Lcom/android/ide/common/resources/configuration/ResourceQualifier;", "([Lcom/android/tools/idea/ui/resourcemanager/model/Mapper;)V", "mappers", "", "(Ljava/util/Set;)V", "baseFolderConfigMatch", "Lcom/android/tools/idea/ui/resourcemanager/importer/QualifierMatcher$Result;", "path", "", "parsePath", "Result", "intellij.android.core"})
public final class QualifierMatcher {
    @NotNull
    private final Set<Mapper<ResourceQualifier>> mappers;

    public QualifierMatcher(@NotNull Set<? extends Mapper<? extends ResourceQualifier>> mappers) {
        Intrinsics.checkNotNullParameter(mappers, (String)"mappers");
        this.mappers = mappers;
    }

    public /* synthetic */ QualifierMatcher(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        this(set);
    }

    public QualifierMatcher(Mapper<? extends ResourceQualifier> ... mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        this(SetsKt.setOf((Object[])Arrays.copyOf(mapper, mapper.length)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Result parsePath(@NotNull String path2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        if (this.mappers.isEmpty()) {
            return this.baseFolderConfigMatch(path2);
        }
        Set qualifiers = new LinkedHashSet();
        Set unusedMappers = CollectionsKt.toMutableSet((Iterable)this.mappers);
        StringBuffer finalFileName = new StringBuffer();
        Matcher matcher = ((Mapper)CollectionsKt.first((Iterable)this.mappers)).getPattern().matcher(path2);
        Iterable iterable = this.mappers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Mapper it = (Mapper)element$iv;
            boolean bl = false;
            matcher.usePattern(it.getPattern());
            if (!matcher.find()) continue;
            MatchResult matchResult = matcher.toMatchResult();
            Intrinsics.checkNotNullExpressionValue((Object)matchResult, (String)"matcher.toMatchResult()");
            Object qualifier = it.getQualifier(it.getValue(matchResult));
            if (qualifier != null) {
                qualifiers.add(qualifier);
                unusedMappers.remove(it);
            }
            matcher.appendReplacement(finalFileName, "");
        }
        $this$forEach$iv = unusedMappers;
        boolean $i$f$mapNotNull = false;
        Iterator iterator2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            Mapper it = (Mapper)element$iv$iv;
            boolean bl2 = false;
            if (it.getDefaultQualifier() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)qualifiers);
        matcher.appendTail(finalFileName);
        if (!((Collection)qualifiers).isEmpty()) {
            ResourceManagerTracking.INSTANCE.logDensityInferred();
        }
        String string = finalFileName.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"finalFileName.toString()");
        Result result2 = this.baseFolderConfigMatch(string);
        qualifiers.addAll((Collection)result2.getQualifiers());
        return new Result(result2.getResourceName(), qualifiers);
    }

    /*
     * WARNING - void declaration
     */
    private final Result baseFolderConfigMatch(String path2) {
        FolderConfiguration folderConfiguration;
        Object object;
        void $this$filterTo$iv$iv;
        String resourceName;
        void $this$filterTo$iv$iv2;
        String string = FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)path2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(\u2026thUtil.getFileName(path))");
        String fileName = string;
        String[] stringArray = new String[]{"-"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)fileName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        String[] destination$iv$iv = (String[])new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nameSplit = (List)destination$iv$iv;
        if (nameSplit.size() > 1) {
            Set qualifiers;
            String string2 = FileUtil.sanitizeFileName((String)((String)nameSplit.get(0)));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sanitizeFileName(nameSplit[0])");
            resourceName = string2;
            Object[] objectArray = FolderConfiguration.getConfigFromQualifiers((Iterable)CollectionsKt.drop((Iterable)nameSplit, (int)1));
            Set set = objectArray != null && (objectArray = objectArray.getQualifiers()) != null ? ArraysKt.toSet((Object[])objectArray) : (qualifiers = null);
            if (qualifiers != null) {
                return new Result(resourceName, qualifiers);
            }
        }
        String string3 = FileUtil.sanitizeFileName((String)fileName);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sanitizeFileName(fileName)");
        resourceName = string3;
        String string4 = PathUtil.getFileName((String)PathUtil.getParentPath((String)path2));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getFileName(PathUtil.getParentPath(path))");
        String parent2 = string4;
        destination$iv$iv = new String[]{"-"};
        Iterable $this$filter$iv2 = StringsKt.split$default((CharSequence)parent2, (String[])destination$iv$iv, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter2 = false;
        Iterable iterable2 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl3 = !StringsKt.isBlank((CharSequence)it);
            if (!bl3) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List parentSplit = (List)destination$iv$iv2;
        FolderConfiguration folderConfiguration2 = FolderConfiguration.getConfigFromQualifiers((Iterable)parentSplit);
        if (folderConfiguration2 == null) {
            folderConfiguration2 = FolderConfiguration.getConfigFromQualifiers((Iterable)CollectionsKt.drop((Iterable)parentSplit, (int)1));
        }
        if ((object = (folderConfiguration = folderConfiguration2)) == null || (object = object.getQualifiers()) == null || (object = ArraysKt.toSet((Object[])object)) == null) {
            object = SetsKt.emptySet();
        }
        Object qualifiers = object;
        return new Result(resourceName, (Set<? extends ResourceQualifier>)qualifiers);
    }

    public QualifierMatcher() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/importer/QualifierMatcher$Result;", "", "resourceName", "", "qualifiers", "", "Lcom/android/ide/common/resources/configuration/ResourceQualifier;", "(Ljava/lang/String;Ljava/util/Set;)V", "getQualifiers", "()Ljava/util/Set;", "getResourceName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.core"})
    public static final class Result {
        @NotNull
        private final String resourceName;
        @NotNull
        private final Set<ResourceQualifier> qualifiers;

        public Result(@NotNull String resourceName, @NotNull Set<? extends ResourceQualifier> qualifiers) {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            Intrinsics.checkNotNullParameter(qualifiers, (String)"qualifiers");
            this.resourceName = resourceName;
            this.qualifiers = qualifiers;
        }

        @NotNull
        public final String getResourceName() {
            return this.resourceName;
        }

        @NotNull
        public final Set<ResourceQualifier> getQualifiers() {
            return this.qualifiers;
        }

        @NotNull
        public final String component1() {
            return this.resourceName;
        }

        @NotNull
        public final Set<ResourceQualifier> component2() {
            return this.qualifiers;
        }

        @NotNull
        public final Result copy(@NotNull String resourceName, @NotNull Set<? extends ResourceQualifier> qualifiers) {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            Intrinsics.checkNotNullParameter(qualifiers, (String)"qualifiers");
            return new Result(resourceName, qualifiers);
        }

        public static /* synthetic */ Result copy$default(Result result2, String string, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                string = result2.resourceName;
            }
            if ((n & 2) != 0) {
                set = result2.qualifiers;
            }
            return result2.copy(string, set);
        }

        @NotNull
        public String toString() {
            return "Result(resourceName=" + this.resourceName + ", qualifiers=" + this.qualifiers + ")";
        }

        public int hashCode() {
            int result2 = this.resourceName.hashCode();
            result2 = result2 * 31 + ((Object)this.qualifiers).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual((Object)this.resourceName, (Object)result2.resourceName)) {
                return false;
            }
            return Intrinsics.areEqual(this.qualifiers, result2.qualifiers);
        }
    }
}

