/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.explorer;

import com.android.resources.ResourceType;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.idea.ui.resourcemanager.explorer.ResourceExplorerListView;
import com.android.tools.idea.ui.resourcemanager.explorer.ResourceExplorerListViewModel;
import com.android.tools.idea.ui.resourcemanager.explorer.ResourceExplorerViewModel;
import com.android.tools.idea.ui.resourcemanager.importer.ResourceImportDragTarget;
import com.android.tools.idea.ui.resourcemanager.widget.DetailedPreview;
import com.android.tools.idea.ui.resourcemanager.widget.OverflowingTabbedPaneWrapper;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBSplitter;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002BI\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0017H\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0001H\u0002J\b\u0010\"\u001a\u00020 H\u0002J\u000e\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u0011J\u0016\u0010#\u001a\u00020 2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\nJ\b\u0010'\u001a\u00020 H\u0002R\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/ui/resourcemanager/explorer/ResourceExplorerView;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "viewModel", "Lcom/android/tools/idea/ui/resourcemanager/explorer/ResourceExplorerViewModel;", "preselectedResourceName", "", "resourceImportDragTarget", "Lcom/android/tools/idea/ui/resourcemanager/importer/ResourceImportDragTarget;", "withMultiModuleSearch", "", "withSummaryView", "withDetailView", "multiSelection", "(Lcom/android/tools/idea/ui/resourcemanager/explorer/ResourceExplorerViewModel;Ljava/lang/String;Lcom/android/tools/idea/ui/resourcemanager/importer/ResourceImportDragTarget;ZZZZ)V", "centerPanel", "fileToSelect", "Lcom/intellij/openapi/vfs/VirtualFile;", "headerPanel", "listView", "Lcom/android/tools/idea/ui/resourcemanager/explorer/ResourceExplorerListView;", "listViewJob", "Ljava/util/concurrent/CompletableFuture;", "Lcom/android/tools/idea/ui/resourcemanager/explorer/ResourceExplorerListViewModel;", "resourceToSelect", "resourcesTabsPanel", "Lcom/android/tools/idea/ui/resourcemanager/widget/OverflowingTabbedPaneWrapper;", "summaryView", "Lcom/android/tools/idea/ui/resourcemanager/widget/DetailedPreview;", "topActionsPanel", "createResourcesListView", "dispose", "", "getContentPanel", "populateResources", "selectAsset", "virtualFile", "resourceName", "recentlyAdded", "selectIfNeeded", "intellij.android.core"})
public final class ResourceExplorerView
extends JPanel
implements Disposable {
    @NotNull
    private final ResourceExplorerViewModel viewModel;
    @NotNull
    private final ResourceImportDragTarget resourceImportDragTarget;
    private final boolean withMultiModuleSearch;
    private final boolean withSummaryView;
    private final boolean withDetailView;
    private final boolean multiSelection;
    @Nullable
    private VirtualFile fileToSelect;
    @Nullable
    private String resourceToSelect;
    @NotNull
    private final OverflowingTabbedPaneWrapper resourcesTabsPanel;
    @NotNull
    private final JPanel topActionsPanel;
    @NotNull
    private final JPanel headerPanel;
    @NotNull
    private final JPanel centerPanel;
    @Nullable
    private final DetailedPreview summaryView;
    @Nullable
    private ResourceExplorerListView listView;
    @Nullable
    private CompletableFuture<ResourceExplorerListViewModel> listViewJob;

    /*
     * WARNING - void declaration
     */
    public ResourceExplorerView(@NotNull ResourceExplorerViewModel viewModel2, @Nullable String preselectedResourceName, @NotNull ResourceImportDragTarget resourceImportDragTarget, boolean withMultiModuleSearch, boolean withSummaryView, boolean withDetailView, boolean multiSelection) {
        void $this$centerPanel_u24lambda_u2d4;
        JComponent $this$headerPanel_u24lambda_u2d3;
        JComponent $this$topActionsPanel_u24lambda_u2d2;
        JComponent $this$resourcesTabsPanel_u24lambda_u2d1;
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)viewModel2, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)resourceImportDragTarget, (String)"resourceImportDragTarget");
        super(new BorderLayout());
        this.viewModel = viewModel2;
        this.resourceImportDragTarget = resourceImportDragTarget;
        this.withMultiModuleSearch = withMultiModuleSearch;
        this.withSummaryView = withSummaryView;
        this.withDetailView = withDetailView;
        this.multiSelection = multiSelection;
        this.resourceToSelect = preselectedResourceName;
        OverflowingTabbedPaneWrapper overflowingTabbedPaneWrapper = jComponent = new OverflowingTabbedPaneWrapper();
        ResourceExplorerView resourceExplorerView = this;
        boolean bl = false;
        ResourceType[] $this$forEach$iv = this.viewModel.getSupportedResourceTypes();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ResourceType element$iv;
            ResourceType it = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            $this$resourcesTabsPanel_u24lambda_u2d1.getTabbedPane().add(it.getDisplayName(), null);
        }
        $this$resourcesTabsPanel_u24lambda_u2d1.getTabbedPane().setSelectedIndex(this.viewModel.getResourceTypeIndex());
        $this$resourcesTabsPanel_u24lambda_u2d1.getTabbedPane().addChangeListener(new ChangeListener(this){
            final /* synthetic */ ResourceExplorerView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void stateChanged(ChangeEvent event) {
                Object object = event.getSource();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JTabbedPane");
                int index2 = ((JTabbedPane)object).getModel().getSelectedIndex();
                ResourceExplorerView.access$getViewModel$p(this.this$0).setResourceTypeIndex(index2);
            }
        });
        resourceExplorerView.resourcesTabsPanel = jComponent;
        $this$resourcesTabsPanel_u24lambda_u2d1 = jComponent = new JPanel();
        resourceExplorerView = this;
        boolean bl3 = false;
        $this$topActionsPanel_u24lambda_u2d2.setLayout(new BoxLayout($this$topActionsPanel_u24lambda_u2d2, 1));
        $this$topActionsPanel_u24lambda_u2d2.setOpaque(false);
        resourceExplorerView.topActionsPanel = jComponent;
        $this$topActionsPanel_u24lambda_u2d2 = jComponent = new JPanel();
        resourceExplorerView = this;
        boolean bl4 = false;
        $this$headerPanel_u24lambda_u2d3.setLayout(new BoxLayout($this$headerPanel_u24lambda_u2d3, 1));
        $this$headerPanel_u24lambda_u2d3.add(this.resourcesTabsPanel);
        $this$headerPanel_u24lambda_u2d3.add(this.topActionsPanel);
        resourceExplorerView.headerPanel = jComponent;
        $this$headerPanel_u24lambda_u2d3 = jComponent = new JPanel();
        resourceExplorerView = this;
        boolean bl5 = false;
        $this$centerPanel_u24lambda_u2d4.setLayout(new BoxLayout((Container)$this$centerPanel_u24lambda_u2d4, 1));
        $this$centerPanel_u24lambda_u2d4.setOpaque(false);
        $this$centerPanel_u24lambda_u2d4.setBorder((Border)JBUI.Borders.empty());
        resourceExplorerView.centerPanel = jComponent;
        this.summaryView = this.withSummaryView ? new DetailedPreview() : null;
        DnDManager.getInstance().registerTarget((DnDTarget)this.resourceImportDragTarget, (JComponent)this);
        this.add(this.getContentPanel());
        this.viewModel.setUpdateResourceTabCallback((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                resourcesTabsPanel.getTabbedPane().setSelectedIndex(viewModel.getResourceTypeIndex());
            }
        }));
        this.viewModel.setPopulateResourcesCallback((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.populateResources();
            }
        }));
        this.populateResources();
    }

    public /* synthetic */ ResourceExplorerView(ResourceExplorerViewModel resourceExplorerViewModel2, String string, ResourceImportDragTarget resourceImportDragTarget, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = true;
        }
        if ((n & 0x40) != 0) {
            bl4 = true;
        }
        this(resourceExplorerViewModel2, string, resourceImportDragTarget, bl, bl2, bl3, bl4);
    }

    private final void populateResources() {
        ResourceExplorerListView resourceExplorerListView = this.listView;
        if (resourceExplorerListView != null) {
            ResourceExplorerListView it = resourceExplorerListView;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.listView = null;
        CompletableFuture<ResourceExplorerListViewModel> completableFuture = this.listViewJob;
        if (completableFuture != null) {
            completableFuture.cancel(true);
        }
        this.listViewJob = this.viewModel.createResourceListViewModel().whenCompleteAsync(new BiConsumer(this){
            final /* synthetic */ ResourceExplorerView this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final void accept(ResourceExplorerListViewModel listViewModel, Throwable throwable) {
                void it;
                Intrinsics.checkNotNullExpressionValue((Object)listViewModel, (String)"listViewModel");
                ResourceExplorerListView resourceExplorerListView = ResourceExplorerView.access$createResourcesListView(this.this$0, listViewModel);
                ResourceExplorerView resourceExplorerView = this.this$0;
                ResourceExplorerListView resourceExplorerListView2 = resourceExplorerListView;
                ResourceExplorerView resourceExplorerView2 = this.this$0;
                boolean bl = false;
                if (!Disposer.isDisposed((Disposable)resourceExplorerView)) {
                    ResourceExplorerView.access$getCenterPanel$p(resourceExplorerView).removeAll();
                    ResourceExplorerView.access$getCenterPanel$p(resourceExplorerView).add((Component)it);
                    Disposer.register((Disposable)resourceExplorerView, (Disposable)((Disposable)it));
                } else {
                    Disposer.dispose((Disposable)((Disposable)it));
                }
                ResourceExplorerView.access$setListView$p(resourceExplorerView2, resourceExplorerListView);
                ResourceExplorerView.access$selectIfNeeded(this.this$0);
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    public void dispose() {
        DnDManager.getInstance().unregisterTarget((DnDTarget)this.resourceImportDragTarget, (JComponent)this);
    }

    private final JPanel getContentPanel() {
        JPanel jPanel;
        JPanel $this$getContentPanel_u24lambda_u2d6 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$getContentPanel_u24lambda_u2d6.add((Component)this.headerPanel, "North");
        $this$getContentPanel_u24lambda_u2d6.add((Component)this.centerPanel, "Center");
        JPanel explorerListPanel = jPanel;
        if (this.summaryView == null) {
            return explorerListPanel;
        }
        JPanel $this$getContentPanel_u24lambda_u2d7 = jPanel = new JBSplitter(0.6f);
        boolean bl2 = false;
        explorerListPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, JBUI.scale((int)1), AdtUiUtils.DEFAULT_BORDER_COLOR));
        $this$getContentPanel_u24lambda_u2d7.setShowDividerControls(true);
        $this$getContentPanel_u24lambda_u2d7.setShowDividerIcon(true);
        $this$getContentPanel_u24lambda_u2d7.setDividerWidth(JBUI.scale((int)10));
        $this$getContentPanel_u24lambda_u2d7.setFirstComponent(explorerListPanel);
        $this$getContentPanel_u24lambda_u2d7.setSecondComponent(this.summaryView);
        return jPanel;
    }

    private final void selectIfNeeded() {
        VirtualFile file2 = this.fileToSelect;
        String resourceName = this.resourceToSelect;
        if (file2 != null) {
            this.fileToSelect = null;
            this.selectAsset(file2);
        } else if (resourceName != null) {
            this.resourceToSelect = null;
            this.selectAsset(resourceName, false);
        }
    }

    public final void selectAsset(@NotNull VirtualFile virtualFile) {
        block2: {
            block1: {
                Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
                if (virtualFile.isDirectory()) {
                    return;
                }
                this.viewModel.setResourceTypeIndex(this.viewModel.getTabIndexForFile(virtualFile));
                if (this.listView != null) break block1;
                this.fileToSelect = virtualFile;
                break block2;
            }
            ResourceExplorerListView resourceExplorerListView = this.listView;
            if (resourceExplorerListView == null) break block2;
            resourceExplorerListView.selectAsset(virtualFile);
        }
    }

    public final void selectAsset(@NotNull String resourceName, boolean recentlyAdded) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
                if (this.listView != null) break block0;
                this.resourceToSelect = resourceName;
                break block1;
            }
            ResourceExplorerListView resourceExplorerListView = this.listView;
            if (resourceExplorerListView == null) break block1;
            resourceExplorerListView.selectAsset(resourceName, recentlyAdded);
        }
    }

    private final ResourceExplorerListView createResourcesListView(ResourceExplorerListViewModel viewModel2) {
        return new ResourceExplorerListView(viewModel2, this.resourceImportDragTarget, this.withMultiModuleSearch, this.summaryView, this.withDetailView, this.multiSelection);
    }

    public static final /* synthetic */ void access$setListView$p(ResourceExplorerView $this, ResourceExplorerListView resourceExplorerListView) {
        $this.listView = resourceExplorerListView;
    }

    public static final /* synthetic */ ResourceExplorerListView access$createResourcesListView(ResourceExplorerView $this, ResourceExplorerListViewModel viewModel2) {
        return $this.createResourcesListView(viewModel2);
    }

    public static final /* synthetic */ void access$selectIfNeeded(ResourceExplorerView $this) {
        $this.selectIfNeeded();
    }

    public static final /* synthetic */ JPanel access$getCenterPanel$p(ResourceExplorerView $this) {
        return $this.centerPanel;
    }
}

