/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.tools.idea.ui.resourcechooser.AssetSetWidget;
import com.android.tools.idea.ui.resourcemanager.model.Asset;
import com.android.tools.idea.ui.resourcemanager.model.ResourceAssetSet;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetIconProvider;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetPreviewManager;
import com.android.tools.idea.ui.resourcemanager.rendering.DefaultIconProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J8\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/ui/resourcechooser/CompactResourceListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/android/tools/idea/ui/resourcemanager/model/ResourceAssetSet;", "assetPreviewManager", "Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetPreviewManager;", "cellHeight", "", "(Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetPreviewManager;I)V", "widget", "Lcom/android/tools/idea/ui/resourcechooser/AssetSetWidget;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "isSelected", "", "cellHasFocus", "intellij.android.core"})
public final class CompactResourceListCellRenderer
implements ListCellRenderer<ResourceAssetSet> {
    @NotNull
    private final AssetPreviewManager assetPreviewManager;
    @NotNull
    private final AssetSetWidget widget;

    public CompactResourceListCellRenderer(@NotNull AssetPreviewManager assetPreviewManager, int cellHeight) {
        Intrinsics.checkNotNullParameter((Object)assetPreviewManager, (String)"assetPreviewManager");
        this.assetPreviewManager = assetPreviewManager;
        this.widget = new AssetSetWidget(cellHeight);
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends ResourceAssetSet> list2, @NotNull ResourceAssetSet value2, int index2, boolean isSelected, boolean cellHasFocus) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Asset assetToRender = value2.getHighestDensityAsset();
        Dimension thumbnailSize = this.widget.getThumbnailSize();
        AssetIconProvider iconProvider = this.assetPreviewManager.getPreviewProvider(assetToRender.getType());
        Icon icon2 = iconProvider instanceof DefaultIconProvider ? (Icon)null : iconProvider.getIcon(assetToRender, thumbnailSize.width, thumbnailSize.height, list2, (Function0<Unit>)((Function0)new Function0<Unit>(list2, index2){
            final /* synthetic */ JList<? extends ResourceAssetSet> $list;
            final /* synthetic */ int $index;
            {
                this.$list = $list;
                this.$index = $index;
                super(0);
            }

            public final void invoke() {
                block0: {
                    Rectangle rectangle = this.$list.getCellBounds(this.$index, this.$index);
                    if (rectangle == null) break block0;
                    Rectangle rectangle2 = rectangle;
                    JList<? extends ResourceAssetSet> jList = this.$list;
                    Rectangle p0 = rectangle2;
                    boolean bl = false;
                    jList.repaint(p0);
                }
            }
        }), (Function0<Boolean>)((Function0)new Function0<Boolean>(list2, index2){
            final /* synthetic */ JList<? extends ResourceAssetSet> $list;
            final /* synthetic */ int $index;
            {
                this.$list = $list;
                this.$index = $index;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                int n = this.$list.getFirstVisibleIndex();
                return this.$index <= this.$list.getLastVisibleIndex() ? n <= this.$index : false;
            }
        }));
        this.widget.updateWidget(icon2, value2.getName(), isSelected, cellHasFocus);
        return this.widget;
    }
}

