/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.designer.overlays;

import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.ui.designer.overlays.ChooseOverlayDialog;
import com.android.tools.idea.ui.designer.overlays.OverlayConfiguration;
import com.android.tools.idea.ui.designer.overlays.OverlayData;
import com.android.tools.idea.ui.designer.overlays.OverlayEntry;
import com.android.tools.idea.ui.designer.overlays.OverlayNotFoundException;
import com.android.tools.idea.ui.designer.overlays.OverlayProvider;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Toggleable;
import icons.StudioIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public class OverlayMenuAction
extends DropDownAction {
    private final EditorDesignSurface mySurface;

    public OverlayMenuAction(@NotNull EditorDesignSurface surface) {
        super("Overlays Menu", "Overlays Menu", StudioIcons.LayoutInspector.MODE_3D);
        this.mySurface = surface;
    }

    protected boolean updateActions(@NotNull DataContext context2) {
        List providers = OverlayConfiguration.EP_NAME.getExtensionsIfPointIsRegistered();
        this.removeAll();
        if (!providers.isEmpty()) {
            DefaultActionGroup overlayGroup = DefaultActionGroup.createPopupGroup(() -> "Overlays");
            OverlayEntry currentOverlay = this.mySurface.getOverlayConfiguration().getCurrentOverlayEntry();
            for (OverlayData overlay : this.mySurface.getOverlayConfiguration().getAllOverlays()) {
                boolean isCurrentlySelected = false;
                if (overlay.getOverlayEntry().equals(currentOverlay)) {
                    isCurrentlySelected = true;
                }
                overlayGroup.add((AnAction)new ToggleOverlayAction(this.mySurface, overlay.getOverlayName(), overlay.getOverlayEntry(), isCurrentlySelected));
            }
            this.add((AnAction)overlayGroup);
            for (OverlayProvider provider2 : providers) {
                this.add(new AddOverlayAction(this.mySurface, provider2));
            }
            this.add(new DeleteOverlayAction(this.mySurface));
            this.addSeparator();
            this.add(new UpdateOverlayAction(this.mySurface));
            this.add(new ToggleCachedOverlayAction(this.mySurface));
            this.add(new CancelOverlayAction(this.mySurface));
        }
        return true;
    }

    public static class CancelOverlayAction
    extends AnAction {
        private final EditorDesignSurface mySurface;

        public CancelOverlayAction(@NotNull EditorDesignSurface surface) {
            super("Cancel Overlay", "Disable current overlay", StudioIcons.LayoutInspector.CLEAR_OVERLAY);
            this.mySurface = surface;
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setVisible(this.mySurface.getOverlayConfiguration().isOverlayPresent());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (this.mySurface.getOverlayConfiguration().isOverlayPresent()) {
                this.mySurface.getOverlayConfiguration().clearCurrentOverlay();
                this.mySurface.repaint();
            } else {
                Notifications.Bus.notify((Notification)new Notification("Manage Overlays", "Error cancelling overlay action", "There is no overlay action to be cancelled.", NotificationType.WARNING));
            }
        }
    }

    @VisibleForTesting
    static class DeleteOverlayAction
    extends AnAction {
        @NotNull
        private final EditorDesignSurface mySurface;

        DeleteOverlayAction(@NotNull EditorDesignSurface surface) {
            super("Delete Overlay...", null, StudioIcons.Common.DELETE);
            this.mySurface = surface;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(!this.mySurface.getOverlayConfiguration().getAllOverlays().isEmpty());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<OverlayData> overlays = this.mySurface.getOverlayConfiguration().getAllOverlays();
            ChooseOverlayDialog chooser = new ChooseOverlayDialog(overlays, "Choose overlay", "Choose the overlay you want to delete");
            chooser.show();
            List chosen = chooser.getChosenElements();
            this.mySurface.getOverlayConfiguration().removeOverlays(chosen);
        }
    }

    public static class UpdateOverlayAction
    extends AnAction {
        @NotNull
        private final EditorDesignSurface mySurface;

        public UpdateOverlayAction(@NotNull EditorDesignSurface surface) {
            super("Reload Overlay", "Reload the current overlay", StudioIcons.LayoutEditor.Motion.LOOP);
            this.mySurface = surface;
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setVisible(this.mySurface.getOverlayConfiguration().isOverlayPresent());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            OverlayConfiguration overlayConfiguration = this.mySurface.getOverlayConfiguration();
            OverlayEntry currentOverlay = overlayConfiguration.getCurrentOverlayEntry();
            if (overlayConfiguration.getOverlayImage() != null && !overlayConfiguration.isPlaceholderVisible()) {
                overlayConfiguration.showPlaceholder();
                Promise<OverlayData> promise = currentOverlay.getOverlayProvider().getOverlay(currentOverlay.getId());
                promise.onSuccess(result2 -> {
                    if (this.mySurface.getOverlayConfiguration().isPlaceholderVisible()) {
                        result2.setOverlayProvider(currentOverlay.getOverlayProvider());
                        overlayConfiguration.updateOverlay((OverlayData)result2);
                    }
                });
                promise.onError(t -> {
                    if (this.mySurface.getOverlayConfiguration().isPlaceholderVisible()) {
                        overlayConfiguration.hidePlaceholder();
                        if (t instanceof OverlayNotFoundException) {
                            overlayConfiguration.removeOverlayFromList(currentOverlay);
                            Notifications.Bus.notify((Notification)new Notification("Manage Overlays", "Error fetching overlay", "The overlay you requested does not exist anymore.", NotificationType.ERROR));
                        } else {
                            Notifications.Bus.notify((Notification)new Notification("Manage Overlays", "Error fetching overlay", "There was an error fetching the overlay. Please try again.", NotificationType.ERROR));
                        }
                    }
                });
            } else {
                Notifications.Bus.notify((Notification)new Notification("Manage Overlays", "Update error", "There is no overlay to be updated. Please select an overlay before trying to update it.", NotificationType.WARNING));
            }
        }
    }

    public static class AddOverlayAction
    extends AnAction {
        @NotNull
        private final OverlayProvider myOverlayProvider;
        @NotNull
        private final EditorDesignSurface mySurface;

        AddOverlayAction(@NotNull EditorDesignSurface surface, @NotNull OverlayProvider provider2) {
            super("Add " + provider2.getPluginName() + " Overlay...", null, StudioIcons.LayoutInspector.LOAD_OVERLAY);
            this.myOverlayProvider = provider2;
            this.mySurface = surface;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            OverlayConfiguration overlayConfiguration = this.mySurface.getOverlayConfiguration();
            overlayConfiguration.showPlaceholder();
            Promise<OverlayData> promise = this.myOverlayProvider.addOverlay();
            promise.onSuccess(result2 -> {
                if (overlayConfiguration.isPlaceholderVisible()) {
                    result2.setOverlayProvider(this.myOverlayProvider);
                    overlayConfiguration.addOverlay((OverlayData)result2);
                }
            });
            promise.onError(t -> {
                if (overlayConfiguration.isPlaceholderVisible()) {
                    overlayConfiguration.hidePlaceholder();
                    Notifications.Bus.notify((Notification)new Notification("Manage Overlays", "Error fetching overlay", "There was an error fetching the overlay. Please try again.", NotificationType.ERROR));
                }
            });
        }
    }

    public static class ToggleCachedOverlayAction
    extends AnAction {
        EditorDesignSurface mySurface;

        public ToggleCachedOverlayAction(@NotNull EditorDesignSurface surface) {
            super("Toggle Overlay", "Toggle current overlay on/off", StudioIcons.LayoutEditor.Toolbar.LAYER);
            this.mySurface = surface;
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setVisible(this.mySurface.getOverlayConfiguration().isOverlayPresent());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            OverlayConfiguration configuration = this.mySurface.getOverlayConfiguration();
            if (configuration.getOverlayImage() != null && !configuration.isPlaceholderVisible()) {
                if (!configuration.getOverlayVisibility()) {
                    configuration.showCachedOverlay();
                } else {
                    configuration.hideCachedOverlay();
                }
                this.mySurface.repaint();
            } else {
                Notifications.Bus.notify((Notification)new Notification("Manage Overlays", "Error toggling overlay", "There was no overlay to be toggled. Please select an overlay first.", NotificationType.WARNING));
            }
        }
    }

    @VisibleForTesting
    static class ToggleOverlayAction
    extends AnAction
    implements Toggleable {
        @NotNull
        private final OverlayEntry myOverlayEntry;
        @NotNull
        private final EditorDesignSurface mySurface;

        ToggleOverlayAction(@NotNull EditorDesignSurface surface, @NotNull String title, @NotNull OverlayEntry overlayEntry, boolean checked) {
            super(title, null, overlayEntry.getOverlayProvider().getPluginIcon());
            this.myOverlayEntry = overlayEntry;
            this.mySurface = surface;
            this.getTemplatePresentation().putClientProperty("selected", (Object)checked);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            OverlayConfiguration overlayConfiguration = this.mySurface.getOverlayConfiguration();
            OverlayEntry currentOverlay = overlayConfiguration.getCurrentOverlayEntry();
            if (this.myOverlayEntry.equals(currentOverlay)) {
                overlayConfiguration.clearCurrentOverlay();
            } else {
                overlayConfiguration.showPlaceholder();
                Promise<OverlayData> promise = this.myOverlayEntry.getOverlayProvider().getOverlay(this.myOverlayEntry.getId());
                promise.onSuccess(result2 -> {
                    if (this.mySurface.getOverlayConfiguration().isPlaceholderVisible()) {
                        result2.setOverlayProvider(this.myOverlayEntry.getOverlayProvider());
                        overlayConfiguration.updateOverlay((OverlayData)result2);
                    }
                });
                promise.onError(t -> {
                    if (this.mySurface.getOverlayConfiguration().isPlaceholderVisible()) {
                        overlayConfiguration.hidePlaceholder();
                        if (t instanceof OverlayNotFoundException) {
                            overlayConfiguration.removeOverlayFromList(this.myOverlayEntry);
                            Notifications.Bus.notify((Notification)new Notification("Manage Overlays", "Error fetching overlay", "The overlay you requested does not exist anymore.", NotificationType.ERROR));
                        } else {
                            Notifications.Bus.notify((Notification)new Notification("Manage Overlays", "Error fetching overlay", "There was an error fetching the overlay. Please try again.", NotificationType.ERROR));
                        }
                    }
                });
            }
        }
    }
}

