/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.intellij.ui.components.JBTextArea;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/ui/PlaceholderTextArea;", "Lcom/intellij/ui/components/JBTextArea;", "placeHolderText", "", "(Ljava/lang/String;)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.android.core"})
final class PlaceholderTextArea
extends JBTextArea {
    @Nullable
    private final String placeHolderText;

    public PlaceholderTextArea(@Nullable String placeHolderText) {
        this.placeHolderText = placeHolderText;
    }

    public void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        if (this.placeHolderText == null) {
            return;
        }
        String string = super.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"super.getText()");
        if (((CharSequence)string).length() > 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(super.getDisabledTextColor());
        FontMetrics metrics = g2.getFontMetrics();
        int x = this.getInsets().left + this.getMargin().left;
        int y = this.getInsets().top + this.getMargin().top + metrics.getAscent();
        g2.drawString(this.placeHolderText, x, y);
    }
}

