/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ProfileableClient;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.io.grpc.Channel;
import com.android.tools.idea.io.grpc.ManagedChannel;
import com.android.tools.idea.io.grpc.MethodDescriptor;
import com.android.tools.idea.io.grpc.ServerCallHandler;
import com.android.tools.idea.io.grpc.ServerServiceDefinition;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.io.grpc.stub.AbstractStub;
import com.android.tools.idea.io.grpc.stub.ServerCalls;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.ClientSummary;
import com.android.tools.idea.transport.ServiceProxy;
import com.android.tools.idea.transport.TransportBytesPreprocessor;
import com.android.tools.idea.transport.TransportEventPreprocessor;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.idea.transport.TransportServiceProxy;
import com.android.tools.idea.transport.TransportServiceProxyKt;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00fe\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u0000 h2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001hB?\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\u0010\u0011J \u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u0002012\u0006\u0010+\u001a\u0002022\u0006\u00103\u001a\u00020\u0013H\u0016J\u0018\u00104\u001a\u0002012\u0006\u00105\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u0013H\u0016J\u0010\u00106\u001a\u0002012\u0006\u00105\u001a\u00020\u0005H\u0016J\u0010\u00107\u001a\u0002012\u0006\u00105\u001a\u00020\u0005H\u0016J\b\u00108\u001a\u000201H\u0016J\u001e\u00109\u001a\u0002012\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0007J\u0018\u0010?\u001a\n )*\u0004\u0018\u00010\f0\f2\u0006\u0010@\u001a\u00020\fH\u0002J\u001e\u0010A\u001a\u0002012\u0006\u0010:\u001a\u00020B2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020C0=H\u0007J\u001e\u0010D\u001a\u0002012\u0006\u0010:\u001a\u00020E2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020F0=H\u0002J\u001e\u0010G\u001a\u0002012\u0006\u0010:\u001a\u00020H2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\f0=H\u0007J\u001e\u0010I\u001a\u0002012\u0006\u0010:\u001a\u00020J2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020K0=H\u0002J\b\u0010L\u001a\u00020MH\u0016J\u001e\u0010N\u001a\u0002012\u0006\u0010:\u001a\u00020O2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020P0=H\u0002J\b\u0010Q\u001a\u00020$H\u0002J\u0018\u0010R\u001a\u0004\u0018\u00010\u00192\u0006\u0010S\u001a\u00020\u00182\u0006\u0010T\u001a\u00020\u0019J\u000e\u0010U\u001a\u00020$2\u0006\u0010V\u001a\u00020\u001cJ\u000e\u0010W\u001a\u00020$2\u0006\u0010X\u001a\u00020\u001eJ\u001f\u0010Y\u001a\u0004\u0018\u00010$2\u0006\u0010Z\u001a\u00020\u00132\u0006\u0010-\u001a\u00020&H\u0002\u00a2\u0006\u0002\u0010[J\b\u0010\\\u001a\u000201H\u0002J\b\u0010]\u001a\u000201H\u0002JK\u0010]\u001a\u000201\"\u0004\b\u0000\u0010^2\u001d\u0010_\u001a\u0019\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H^0a0`\u00a2\u0006\u0002\bb2\u0014\u0010c\u001a\u0010\u0012\u0004\u0012\u0002H^\u0012\u0006\u0012\u0004\u0018\u00010,0`2\u0006\u0010.\u001a\u00020/H\u0002J,\u0010]\u001a\u0002012\f\u0010d\u001a\b\u0012\u0004\u0012\u00020,0e2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00130e2\u0006\u0010.\u001a\u00020/H\u0002J\b\u0010g\u001a\u000201H\u0002R\"\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\n )*\u0004\u0018\u00010(0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Lcom/android/tools/idea/transport/TransportServiceProxy;", "Lcom/android/tools/idea/transport/ServiceProxy;", "Lcom/android/ddmlib/AndroidDebugBridge$IClientChangeListener;", "Lcom/android/ddmlib/AndroidDebugBridge$IDeviceChangeListener;", "ddmlibDevice", "Lcom/android/ddmlib/IDevice;", "transportDevice", "Lcom/android/tools/profiler/proto/Common$Device;", "channel", "Lcom/android/tools/idea/io/grpc/ManagedChannel;", "proxyEventQueue", "Ljava/util/concurrent/BlockingDeque;", "Lcom/android/tools/profiler/proto/Common$Event;", "proxyBytesCache", "", "", "Lcom/android/tools/idea/protobuf/ByteString;", "(Lcom/android/ddmlib/IDevice;Lcom/android/tools/profiler/proto/Common$Device;Lcom/android/tools/idea/io/grpc/ManagedChannel;Ljava/util/concurrent/BlockingDeque;Ljava/util/Map;)V", "cachedProcesses", "", "Lcom/android/tools/profiler/proto/Common$Process;", "getCachedProcesses", "()Ljava/util/Map;", "commandHandlers", "Lcom/android/tools/profiler/proto/Commands$Command$CommandType;", "Lcom/android/tools/idea/transport/TransportProxy$ProxyCommandHandler;", "dataPreprocessors", "", "Lcom/android/tools/idea/transport/TransportBytesPreprocessor;", "eventPreprocessors", "Lcom/android/tools/idea/transport/TransportEventPreprocessor;", "eventStreamingLatch", "Ljava/util/concurrent/CountDownLatch;", "eventsListenerThread", "Ljava/lang/Thread;", "isDeviceApiSupported", "", "latestEventTimestampNs", "", "serviceStub", "Lcom/android/tools/profiler/proto/TransportServiceGrpc$TransportServiceBlockingStub;", "kotlin.jvm.PlatformType", "addProcess", "client", "Lcom/android/tools/idea/transport/ClientSummary;", "timestampNs", "level", "Lcom/android/tools/profiler/proto/Common$Process$ExposureLevel;", "clientChanged", "", "Lcom/android/ddmlib/Client;", "changeMask", "deviceChanged", "device", "deviceConnected", "deviceDisconnected", "disconnect", "execute", "request", "Lcom/android/tools/profiler/proto/Transport$ExecuteRequest;", "responseObserver", "Lcom/android/tools/idea/io/grpc/stub/StreamObserver;", "Lcom/android/tools/profiler/proto/Transport$ExecuteResponse;", "generateEndEvent", "previousEvent", "getBytes", "Lcom/android/tools/profiler/proto/Transport$BytesRequest;", "Lcom/android/tools/profiler/proto/Transport$BytesResponse;", "getCurrentTime", "Lcom/android/tools/profiler/proto/Transport$TimeRequest;", "Lcom/android/tools/profiler/proto/Transport$TimeResponse;", "getEvents", "Lcom/android/tools/profiler/proto/Transport$GetEventsRequest;", "getProcesses", "Lcom/android/tools/profiler/proto/Transport$GetProcessesRequest;", "Lcom/android/tools/profiler/proto/Transport$GetProcessesResponse;", "getServiceDefinition", "Lcom/android/tools/idea/io/grpc/ServerServiceDefinition;", "getVersion", "Lcom/android/tools/profiler/proto/Transport$VersionRequest;", "Lcom/android/tools/profiler/proto/Transport$VersionResponse;", "isProfileableSupported", "registerCommandHandler", "commandType", "handler", "registerDataPreprocessor", "dataPreprocessor", "registerEventPreprocessor", "eventPreprocessor", "removeProcess", "clientPid", "(IJ)Ljava/lang/Boolean;", "updateDebuggables", "updateProcesses", "C", "getList", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "summarizeClient", "addedClients", "", "removedClients", "updateProfileables", "Companion", "intellij.android.transport"})
public final class TransportServiceProxy
extends ServiceProxy
implements AndroidDebugBridge.IClientChangeListener,
AndroidDebugBridge.IDeviceChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IDevice ddmlibDevice;
    @NotNull
    private final Common.Device transportDevice;
    @NotNull
    private final BlockingDeque<Common.Event> proxyEventQueue;
    @NotNull
    private final Map<String, ByteString> proxyBytesCache;
    private final TransportServiceGrpc.TransportServiceBlockingStub serviceStub;
    @TestOnly
    @NotNull
    private final Map<Integer, Common.Process> cachedProcesses;
    private final boolean isDeviceApiSupported;
    @Nullable
    private Thread eventsListenerThread;
    @NotNull
    private final Map<Commands.Command.CommandType, TransportProxy.ProxyCommandHandler> commandHandlers;
    @NotNull
    private final List<TransportEventPreprocessor> eventPreprocessors;
    @NotNull
    private final List<TransportBytesPreprocessor> dataPreprocessors;
    private long latestEventTimestampNs;
    @Nullable
    private CountDownLatch eventStreamingLatch;
    @NotNull
    private static final String EMULATOR = "Emulator";
    @NotNull
    public static final String PRE_LOLLIPOP_FAILURE_REASON = "Pre-Lollipop devices are not supported.";

    public TransportServiceProxy(@NotNull IDevice ddmlibDevice, @NotNull Common.Device transportDevice, @NotNull ManagedChannel channel, @NotNull BlockingDeque<Common.Event> proxyEventQueue, @NotNull Map<String, ByteString> proxyBytesCache) {
        Intrinsics.checkNotNullParameter((Object)ddmlibDevice, (String)"ddmlibDevice");
        Intrinsics.checkNotNullParameter((Object)transportDevice, (String)"transportDevice");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter(proxyEventQueue, (String)"proxyEventQueue");
        Intrinsics.checkNotNullParameter(proxyBytesCache, (String)"proxyBytesCache");
        super(TransportServiceGrpc.getServiceDescriptor());
        this.ddmlibDevice = ddmlibDevice;
        this.transportDevice = transportDevice;
        this.proxyEventQueue = proxyEventQueue;
        this.proxyBytesCache = proxyBytesCache;
        this.serviceStub = TransportServiceGrpc.newBlockingStub((Channel)((Channel)channel));
        Map map2 = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"synchronizedMap(HashMap())");
        this.cachedProcesses = map2;
        String string = this.transportDevice.getUnsupportedReason();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"transportDevice.unsupportedReason");
        this.isDeviceApiSupported = ((CharSequence)string).length() == 0;
        this.commandHandlers = new LinkedHashMap();
        this.eventPreprocessors = new ArrayList();
        this.dataPreprocessors = new ArrayList();
        this.latestEventTimestampNs = Long.MIN_VALUE;
        TransportServiceProxy.Companion.getLog().info("ProfilerDevice created: " + this.transportDevice);
        this.updateProcesses();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
    }

    @NotNull
    public final Map<Integer, Common.Process> getCachedProcesses() {
        return this.cachedProcesses;
    }

    @Nullable
    public final TransportProxy.ProxyCommandHandler registerCommandHandler(@NotNull Commands.Command.CommandType commandType, @NotNull TransportProxy.ProxyCommandHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)commandType, (String)"commandType");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        return this.commandHandlers.put(commandType, handler2);
    }

    public final boolean registerEventPreprocessor(@NotNull TransportEventPreprocessor eventPreprocessor) {
        Intrinsics.checkNotNullParameter((Object)eventPreprocessor, (String)"eventPreprocessor");
        return this.eventPreprocessors.add(eventPreprocessor);
    }

    public final boolean registerDataPreprocessor(@NotNull TransportBytesPreprocessor dataPreprocessor) {
        Intrinsics.checkNotNullParameter((Object)dataPreprocessor, (String)"dataPreprocessor");
        return this.dataPreprocessors.add(dataPreprocessor);
    }

    @Override
    public void disconnect() {
        block2: {
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
            AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
            CountDownLatch countDownLatch = this.eventStreamingLatch;
            if (countDownLatch == null) break block2;
            CountDownLatch it = countDownLatch;
            boolean bl = false;
            try {
                it.await();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private final void getVersion(Transport.VersionRequest request2, StreamObserver<Transport.VersionResponse> responseObserver2) {
        Transport.VersionResponse versionResponse = Transport.VersionResponse.newBuilder().setVersion(this.transportDevice.getVersion()).build();
        Intrinsics.checkNotNullExpressionValue((Object)versionResponse, (String)"newBuilder().setVersion(\u2026rtDevice.version).build()");
        TransportServiceProxyKt.access$onLast(responseObserver2, versionResponse);
    }

    @VisibleForTesting
    public final void getEvents(@NotNull Transport.GetEventsRequest request2, @NotNull StreamObserver<Common.Event> responseObserver2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver2, (String)"responseObserver");
        TransportServiceProxyKt.access$startThread(new Runnable(this, request2){
            final /* synthetic */ TransportServiceProxy this$0;
            final /* synthetic */ Transport.GetEventsRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
            }

            /*
             * WARNING - void declaration
             */
            public final void run() {
                block3: {
                    Object object;
                    try {
                        void $this$forEach$iv;
                        Iterator iterator2 = TransportServiceProxy.access$getServiceStub$p(this.this$0).getEvents(this.$request);
                        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"serviceStub.getEvents(request)");
                        Iterator iterator3 = iterator2;
                        object = this.this$0;
                        boolean $i$f$forEach = false;
                        void var4_6 = $this$forEach$iv;
                        while (var4_6.hasNext()) {
                            E element$iv = var4_6.next();
                            Common.Event it = (Common.Event)element$iv;
                            boolean bl = false;
                            Common.Event event = it;
                            if (event == null) continue;
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"it");
                            Common.Event event2 = it;
                            BlockingDeque blockingDeque = TransportServiceProxy.access$getProxyEventQueue$p((TransportServiceProxy)object);
                            Common.Event p0 = event2;
                            boolean bl2 = false;
                            blockingDeque.offer(p0);
                        }
                    }
                    catch (StatusRuntimeException statusRuntimeException) {
                        // empty catch block
                    }
                    Thread thread = TransportServiceProxy.access$getEventsListenerThread$p(this.this$0);
                    if (thread == null) break block3;
                    object = thread;
                    TransportServiceProxy transportServiceProxy = this.this$0;
                    Thread it = object;
                    boolean bl = false;
                    it.interrupt();
                    TransportServiceProxy.access$setEventsListenerThread$p(transportServiceProxy, null);
                }
            }
        });
        this.eventStreamingLatch = new CountDownLatch(1);
        this.eventsListenerThread = TransportServiceProxyKt.access$startThread(new Runnable(this, responseObserver2){
            final /* synthetic */ TransportServiceProxy this$0;
            final /* synthetic */ StreamObserver<Common.Event> $responseObserver;
            {
                this.this$0 = $receiver;
                this.$responseObserver = $responseObserver;
            }

            /*
             * WARNING - void declaration
             */
            public final void run() {
                void $this$forEach$iv;
                Map ongoingEventGroups = new LinkedHashMap<K, V>();
                while (!Thread.currentThread().isInterrupted() || !TransportServiceProxy.access$getProxyEventQueue$p(this.this$0).isEmpty()) {
                    try {
                        Common.Event event = (Common.Event)TransportServiceProxy.access$getProxyEventQueue$p(this.this$0).take();
                        TransportServiceProxy.access$setLatestEventTimestampNs$p(this.this$0, Math.max(TransportServiceProxy.access$getLatestEventTimestampNs$p(this.this$0), event.getTimestamp()));
                        for (TransportEventPreprocessor preprocessor : TransportServiceProxy.access$getEventPreprocessors$p(this.this$0)) {
                            void $this$forEach$iv2;
                            if (!preprocessor.shouldPreprocess(event)) continue;
                            Intrinsics.checkNotNullExpressionValue(preprocessor.preprocessEvent(event), (String)"preprocessor.preprocessEvent(event)");
                            Iterator<T> iterator2 = this.$responseObserver;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv2) {
                                Common.Event p0 = (Common.Event)element$iv;
                                boolean bl = false;
                                iterator2.onNext(p0);
                            }
                        }
                        if (event.getIsEnded()) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            TransportServiceProxyKt.access$remove(ongoingEventGroups, event);
                        } else if (event.getGroupId() != 0L) {
                            Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                            TransportServiceProxyKt.access$add(ongoingEventGroups, event);
                        }
                        this.$responseObserver.onNext((Object)event);
                    }
                    catch (InterruptedException exception) {
                        Thread.currentThread().interrupt();
                    }
                }
                Iterable exception = ongoingEventGroups.values();
                StreamObserver<Common.Event> streamObserver = this.$responseObserver;
                TransportServiceProxy transportServiceProxy = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Long2ObjectMap it = (Long2ObjectMap)element$iv;
                    boolean bl = false;
                    Collection collection2 = it.values();
                    Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"it.values");
                    Iterable $this$forEach$iv3 = collection2;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv3) {
                        Common.Event lastEvent = (Common.Event)element$iv2;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)lastEvent, (String)"lastEvent");
                        streamObserver.onNext((Object)TransportServiceProxy.access$generateEndEvent(transportServiceProxy, lastEvent));
                    }
                }
                this.$responseObserver.onCompleted();
                CountDownLatch countDownLatch = TransportServiceProxy.access$getEventStreamingLatch$p(this.this$0);
                Intrinsics.checkNotNull((Object)countDownLatch);
                countDownLatch.countDown();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void getBytes(@NotNull Transport.BytesRequest request2, @NotNull StreamObserver<Transport.BytesResponse> responseObserver2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver2, (String)"responseObserver");
        Map<String, ByteString> map2 = this.proxyBytesCache;
        synchronized (map2) {
            void $this$fold$iv;
            void initial$iv;
            boolean bl = false;
            Object cached2 = this.proxyBytesCache.remove(request2.getId());
            Transport.BytesResponse.Builder response2 = cached2 == null ? this.serviceStub.getBytes(request2).toBuilder() : Transport.BytesResponse.newBuilder().setContents(cached2);
            cached2 = this.dataPreprocessors;
            ByteString byteString = response2.getContents();
            Transport.BytesResponse.Builder builder2 = response2;
            boolean $i$f$fold = false;
            void accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void preprocessor;
                TransportBytesPreprocessor transportBytesPreprocessor = (TransportBytesPreprocessor)element$iv;
                void contents = accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = preprocessor.shouldPreprocess(request2) ? preprocessor.preprocessBytes(request2.getId(), (ByteString)contents) : contents;
            }
            builder2.setContents((ByteString)accumulator$iv);
            Transport.BytesResponse bytesResponse = response2.build();
            Intrinsics.checkNotNullExpressionValue((Object)bytesResponse, (String)"response.build()");
            TransportServiceProxyKt.access$onLast(responseObserver2, bytesResponse);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final Common.Event generateEndEvent(Common.Event previousEvent) {
        return Common.Event.newBuilder().setKind(previousEvent.getKind()).setGroupId(previousEvent.getGroupId()).setPid(previousEvent.getPid()).setTimestamp(this.latestEventTimestampNs + 1L).setIsEnded(true).build();
    }

    private final void getCurrentTime(Transport.TimeRequest request2, StreamObserver<Transport.TimeResponse> responseObserver2) {
        Transport.TimeResponse timeResponse;
        if (this.isDeviceApiSupported) {
            Transport.TimeResponse timeResponse2;
            try {
                timeResponse2 = this.serviceStub.getCurrentTime(request2);
            }
            catch (StatusRuntimeException e) {
                responseObserver2.onError((Throwable)e);
                return;
            }
            timeResponse = timeResponse2;
        } else {
            timeResponse = Transport.TimeResponse.getDefaultInstance();
        }
        Transport.TimeResponse response2 = timeResponse;
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response");
        TransportServiceProxyKt.access$onLast(responseObserver2, response2);
    }

    private final void getProcesses(Transport.GetProcessesRequest request2, StreamObserver<Transport.GetProcessesResponse> responseObserver2) {
        Transport.GetProcessesResponse getProcessesResponse = Transport.GetProcessesResponse.newBuilder().addAllProcess((Iterable)this.cachedProcesses.values()).build();
        Intrinsics.checkNotNullExpressionValue((Object)getProcessesResponse, (String)"newBuilder().addAllProce\u2026Processes.values).build()");
        TransportServiceProxyKt.access$onLast(responseObserver2, getProcessesResponse);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void execute(@NotNull Transport.ExecuteRequest request2, @NotNull StreamObserver<Transport.ExecuteResponse> responseObserver2) {
        TransportProxy.ProxyCommandHandler proxyCommandHandler;
        StreamObserver<Transport.ExecuteResponse> streamObserver;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                Intrinsics.checkNotNullParameter(responseObserver2, (String)"responseObserver");
                Commands.Command command2 = request2.getCommand();
                boolean bl = false;
                streamObserver = responseObserver2;
                proxyCommandHandler = this.commandHandlers.get(command2.getType());
                if (proxyCommandHandler == null) break block2;
                TransportProxy.ProxyCommandHandler proxyCommandHandler2 = proxyCommandHandler;
                StreamObserver<Transport.ExecuteResponse> streamObserver2 = streamObserver;
                boolean bl2 = false;
                Transport.ExecuteResponse executeResponse = it.shouldHandle(command2) ? it.execute(command2) : null;
                streamObserver = streamObserver2;
                proxyCommandHandler = executeResponse;
                if (executeResponse != null) break block3;
            }
            proxyCommandHandler = this.serviceStub.execute(request2);
        }
        Intrinsics.checkNotNullExpressionValue((Object)proxyCommandHandler, (String)"commandHandlers[command.\u2026viceStub.execute(request)");
        TransportServiceProxyKt.access$onLast(streamObserver, proxyCommandHandler);
    }

    public void deviceConnected(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
    }

    public void deviceDisconnected(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
    }

    public void deviceChanged(@NotNull IDevice device2, int changeMask) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        if (device2 == this.ddmlibDevice) {
            if (TransportServiceProxyKt.access$contains(changeMask, 2)) {
                this.updateDebuggables();
            }
            if (TransportServiceProxyKt.access$contains(changeMask, 8) && this.isProfileableSupported()) {
                this.updateProfileables();
            }
        }
    }

    private final boolean isProfileableSupported() {
        return this.ddmlibDevice.getVersion().getFeatureLevel() >= 31;
    }

    public void clientChanged(@NotNull Client client2, int changeMask) {
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        if (TransportServiceProxyKt.access$contains(changeMask, 1) && client2.getDevice() == this.ddmlibDevice && client2.getClientData().getClientDescription() != null) {
            ClientSummary clientSummary = ClientSummary.Companion.of(client2);
            Intrinsics.checkNotNull((Object)clientSummary);
            this.updateProcesses(CollectionsKt.listOf((Object)clientSummary), CollectionsKt.emptyList(), Common.Process.ExposureLevel.DEBUGGABLE);
        }
    }

    @Override
    @NotNull
    public ServerServiceDefinition getServiceDefinition() {
        Pair[] pairArray = new Pair[6];
        MethodDescriptor methodDescriptor = TransportServiceGrpc.getGetVersionMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getGetVersionMethod()");
        pairArray[0] = TransportServiceProxy.getServiceDefinition$to(methodDescriptor, (Function2)new Function2<Transport.VersionRequest, StreamObserver<Transport.VersionResponse>, Unit>((Object)this){

            public final void invoke(@NotNull Transport.VersionRequest p0, @NotNull StreamObserver<Transport.VersionResponse> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                TransportServiceProxy.access$getVersion((TransportServiceProxy)this.receiver, p0, p1);
            }
        });
        MethodDescriptor methodDescriptor2 = TransportServiceGrpc.getGetProcessesMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor2, (String)"getGetProcessesMethod()");
        pairArray[1] = TransportServiceProxy.getServiceDefinition$to(methodDescriptor2, (Function2)new Function2<Transport.GetProcessesRequest, StreamObserver<Transport.GetProcessesResponse>, Unit>((Object)this){

            public final void invoke(@NotNull Transport.GetProcessesRequest p0, @NotNull StreamObserver<Transport.GetProcessesResponse> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                TransportServiceProxy.access$getProcesses((TransportServiceProxy)this.receiver, p0, p1);
            }
        });
        MethodDescriptor methodDescriptor3 = TransportServiceGrpc.getGetCurrentTimeMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor3, (String)"getGetCurrentTimeMethod()");
        pairArray[2] = TransportServiceProxy.getServiceDefinition$to(methodDescriptor3, (Function2)new Function2<Transport.TimeRequest, StreamObserver<Transport.TimeResponse>, Unit>((Object)this){

            public final void invoke(@NotNull Transport.TimeRequest p0, @NotNull StreamObserver<Transport.TimeResponse> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                TransportServiceProxy.access$getCurrentTime((TransportServiceProxy)this.receiver, p0, p1);
            }
        });
        MethodDescriptor methodDescriptor4 = TransportServiceGrpc.getGetEventsMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor4, (String)"getGetEventsMethod()");
        pairArray[3] = TransportServiceProxy.getServiceDefinition$to(methodDescriptor4, (Function2)new Function2<Transport.GetEventsRequest, StreamObserver<Common.Event>, Unit>((Object)this){

            public final void invoke(@NotNull Transport.GetEventsRequest p0, @NotNull StreamObserver<Common.Event> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                ((TransportServiceProxy)this.receiver).getEvents(p0, p1);
            }
        });
        MethodDescriptor methodDescriptor5 = TransportServiceGrpc.getGetBytesMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor5, (String)"getGetBytesMethod()");
        pairArray[4] = TransportServiceProxy.getServiceDefinition$to(methodDescriptor5, (Function2)new Function2<Transport.BytesRequest, StreamObserver<Transport.BytesResponse>, Unit>((Object)this){

            public final void invoke(@NotNull Transport.BytesRequest p0, @NotNull StreamObserver<Transport.BytesResponse> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                ((TransportServiceProxy)this.receiver).getBytes(p0, p1);
            }
        });
        MethodDescriptor methodDescriptor6 = TransportServiceGrpc.getExecuteMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor6, (String)"getExecuteMethod()");
        pairArray[5] = TransportServiceProxy.getServiceDefinition$to(methodDescriptor6, (Function2)new Function2<Transport.ExecuteRequest, StreamObserver<Transport.ExecuteResponse>, Unit>((Object)this){

            public final void invoke(@NotNull Transport.ExecuteRequest p0, @NotNull StreamObserver<Transport.ExecuteResponse> p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                ((TransportServiceProxy)this.receiver).execute(p0, p1);
            }
        });
        Map overrides2 = MapsKt.mapOf((Pair[])pairArray);
        ServerServiceDefinition serverServiceDefinition = this.generatePassThroughDefinitions(overrides2, (AbstractStub)this.serviceStub);
        Intrinsics.checkNotNullExpressionValue((Object)serverServiceDefinition, (String)"generatePassThroughDefin\u2026s(overrides, serviceStub)");
        return serverServiceDefinition;
    }

    private final void updateProfileables() {
        this.updateProcesses((Function1<? super IDevice, C[]>)((Function1)updateProfileables.1.INSTANCE), (Function1)new Function1<ProfileableClient, ClientSummary>((Object)ClientSummary.Companion){

            @Nullable
            public final ClientSummary invoke(@NotNull ProfileableClient p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ClientSummary.Companion)this.receiver).of(p0);
            }
        }, Common.Process.ExposureLevel.PROFILEABLE);
    }

    private final void updateDebuggables() {
        this.updateProcesses((Function1<? super IDevice, C[]>)((Function1)updateDebuggables.1.INSTANCE), (Function1)new Function1<Client, ClientSummary>((Object)ClientSummary.Companion){

            @Nullable
            public final ClientSummary invoke(@NotNull Client p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ClientSummary.Companion)this.receiver).of(p0);
            }
        }, Common.Process.ExposureLevel.DEBUGGABLE);
    }

    private final void updateProcesses() {
        this.updateDebuggables();
        if (this.isProfileableSupported()) {
            this.updateProfileables();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <C> void updateProcesses(Function1<? super IDevice, C[]> getList, Function1<? super C, ClientSummary> summarizeClient, Common.Process.ExposureLevel level) {
        if (this.isDeviceApiSupported) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterNotTo$iv$iv;
            void destination$iv;
            void $this$mapNotNullTo$iv;
            Map.Entry element$iv$iv;
            Collection $this$mapNotNullTo$iv$iv;
            Object[] $this$mapNotNull$iv = (Object[])getList.invoke((Object)this.ddmlibDevice);
            boolean $i$f$mapNotNull22 = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach22 = false;
            for (void element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                Object it$iv$iv;
                element$iv$iv = element$iv$iv$iv;
                boolean bl = false;
                if (summarizeClient.invoke((Object)element$iv$iv) == null) continue;
                boolean bl2 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List currentProcesses = (List)destination$iv$iv;
            Map<Integer, Common.Process> $i$f$mapNotNull22 = this.cachedProcesses;
            $this$mapNotNullTo$iv$iv = new LinkedHashSet();
            boolean $i$f$mapNotNullTo2 = false;
            Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator $i$f$forEach22 = $this$forEach$iv$iv.entrySet().iterator();
            while ($i$f$forEach22.hasNext()) {
                Integer it$iv;
                Map.Entry element$iv$iv2;
                Map.Entry element$iv = element$iv$iv2 = $i$f$forEach22.next();
                boolean bl = false;
                element$iv$iv = element$iv;
                boolean bl3 = false;
                int id2 = ((Number)element$iv$iv.getKey()).intValue();
                Common.Process p = (Common.Process)element$iv$iv.getValue();
                Integer n = id2;
                int it = ((Number)n).intValue();
                boolean bl4 = false;
                if ((p.getExposureLevel().compareTo((Enum)level) >= 0 ? n : null) == null) continue;
                it$iv = it$iv;
                boolean bl5 = false;
                destination$iv.add(it$iv);
            }
            Set previousProcessIds = (Set)destination$iv;
            Iterable $this$filterNot$iv = currentProcesses;
            boolean $i$f$filterNot22 = false;
            $this$forEach$iv$iv = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv3 : $this$filterNotTo$iv$iv) {
                ClientSummary it = (ClientSummary)element$iv$iv3;
                boolean bl = false;
                if (previousProcessIds.contains(it.getPid())) continue;
                destination$iv$iv2.add(element$iv$iv3);
            }
            List addedProcesses = (List)destination$iv$iv2;
            Iterable $i$f$filterNot22 = currentProcesses;
            Set set = previousProcessIds;
            boolean $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                ClientSummary bl = (ClientSummary)item$iv$iv;
                Collection collection2 = destination$iv$iv3;
                boolean bl6 = false;
                collection2.add(p0.getPid());
            }
            Set removedProcessIds = SetsKt.minus((Set)set, (Iterable)((List)destination$iv$iv3));
            this.updateProcesses(addedProcesses, removedProcessIds, level);
        }
    }

    private final void updateProcesses(Collection<ClientSummary> addedClients, Collection<Integer> removedClients, Common.Process.ExposureLevel level) {
        if (this.isDeviceApiSupported && this.ddmlibDevice.isOnline()) {
            try {
                long timestampNs = this.serviceStub.getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(this.transportDevice.getDeviceId()).build()).getTimestampNs();
                Iterable $this$forEach$iv = addedClients;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ClientSummary it = (ClientSummary)element$iv;
                    boolean bl = false;
                    this.addProcess(it, timestampNs, level);
                }
                $this$forEach$iv = removedClients;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    this.removeProcess(it, timestampNs);
                }
            }
            catch (Exception e) {
                TransportServiceProxy.Companion.getLog().info((Throwable)e);
            }
        }
    }

    private final boolean addProcess(ClientSummary client2, long timestampNs, Common.Process.ExposureLevel level) {
        String string;
        String description2 = client2.getName();
        boolean bl = false;
        String abi = client2.getAbi();
        boolean bl2 = false;
        if (abi != null && StringsKt.contains$default((CharSequence)abi, (CharSequence)")", (boolean)false, (int)2, null)) {
            String string2 = abi.substring(StringsKt.indexOf$default((CharSequence)abi, (char)'(', (int)0, (boolean)false, (int)6, null) + 1, StringsKt.indexOf$default((CharSequence)abi, (char)')', (int)0, (boolean)false, (int)6, null));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            Abi abi2 = Abi.getEnum((String)((String)this.ddmlibDevice.getAbis().get(0)));
            Intrinsics.checkNotNull((Object)abi2);
            string = abi2.getCpuArch();
        }
        String processAbiCpuArch = string;
        Common.Process newProcess = Common.Process.newBuilder().setName(description2).setPid(client2.getPid()).setDeviceId(this.transportDevice.getDeviceId()).setState(Common.Process.State.ALIVE).setStartTimestampNs(timestampNs).setAbiCpuArch(processAbiCpuArch).setExposureLevel(level).setPackageName(client2.getPackageName()).build();
        Integer n = client2.getPid();
        Intrinsics.checkNotNullExpressionValue((Object)newProcess, (String)"newProcess");
        this.cachedProcesses.put(n, newProcess);
        return this.proxyEventQueue.offer(Common.Event.newBuilder().setGroupId((long)newProcess.getPid()).setPid(newProcess.getPid()).setKind(Common.Event.Kind.PROCESS).setProcess(Common.ProcessData.newBuilder().setProcessStarted(Common.ProcessData.ProcessStarted.newBuilder().setProcess(newProcess))).setTimestamp(timestampNs).build());
    }

    private final Boolean removeProcess(int clientPid, long timestampNs) {
        Boolean bl;
        Common.Process process2 = this.cachedProcesses.remove(clientPid);
        if (process2 != null) {
            Common.Process process3 = process2;
            boolean bl2 = false;
            bl = this.proxyEventQueue.offer(Common.Event.newBuilder().setGroupId((long)process3.getPid()).setPid(process3.getPid()).setKind(Common.Event.Kind.PROCESS).setIsEnded(true).setTimestamp(timestampNs).build());
        } else {
            bl = null;
        }
        return bl;
    }

    private static final <Req, Res> Pair<MethodDescriptor<Req, Res>, ServerCallHandler<Req, Res>> getServiceDefinition$to(MethodDescriptor<Req, Res> $this$getServiceDefinition_u24to, Function2<? super Req, ? super StreamObserver<Res>, Unit> f) {
        return TuplesKt.to($this$getServiceDefinition_u24to, (Object)ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new ServerCalls.UnaryMethod(f){
            private final /* synthetic */ Function2 function;
            {
                this.function = function;
            }

            public final /* synthetic */ void invoke(Object p0, StreamObserver p1) {
                this.function.invoke(p0, (Object)p1);
            }
        }));
    }

    @JvmStatic
    @NotNull
    public static final Common.Device transportDeviceFromIDevice(@NotNull IDevice device2) {
        return Companion.transportDeviceFromIDevice(device2);
    }

    @JvmStatic
    @NotNull
    public static final String getDeviceModel(@NotNull IDevice device2) {
        return Companion.getDeviceModel(device2);
    }

    @JvmStatic
    @NotNull
    public static final String getDeviceManufacturer(@NotNull IDevice device2) {
        return Companion.getDeviceManufacturer(device2);
    }

    public static final /* synthetic */ TransportServiceGrpc.TransportServiceBlockingStub access$getServiceStub$p(TransportServiceProxy $this) {
        return $this.serviceStub;
    }

    public static final /* synthetic */ Thread access$getEventsListenerThread$p(TransportServiceProxy $this) {
        return $this.eventsListenerThread;
    }

    public static final /* synthetic */ BlockingDeque access$getProxyEventQueue$p(TransportServiceProxy $this) {
        return $this.proxyEventQueue;
    }

    public static final /* synthetic */ void access$setEventsListenerThread$p(TransportServiceProxy $this, Thread thread) {
        $this.eventsListenerThread = thread;
    }

    public static final /* synthetic */ void access$setLatestEventTimestampNs$p(TransportServiceProxy $this, long l) {
        $this.latestEventTimestampNs = l;
    }

    public static final /* synthetic */ long access$getLatestEventTimestampNs$p(TransportServiceProxy $this) {
        return $this.latestEventTimestampNs;
    }

    public static final /* synthetic */ List access$getEventPreprocessors$p(TransportServiceProxy $this) {
        return $this.eventPreprocessors;
    }

    public static final /* synthetic */ CountDownLatch access$getEventStreamingLatch$p(TransportServiceProxy $this) {
        return $this.eventStreamingLatch;
    }

    public static final /* synthetic */ Common.Event access$generateEndEvent(TransportServiceProxy $this, Common.Event previousEvent) {
        return $this.generateEndEvent(previousEvent);
    }

    public static final /* synthetic */ void access$getVersion(TransportServiceProxy $this, Transport.VersionRequest request2, StreamObserver responseObserver2) {
        $this.getVersion(request2, (StreamObserver<Transport.VersionResponse>)responseObserver2);
    }

    public static final /* synthetic */ void access$getProcesses(TransportServiceProxy $this, Transport.GetProcessesRequest request2, StreamObserver responseObserver2) {
        $this.getProcesses(request2, (StreamObserver<Transport.GetProcessesResponse>)responseObserver2);
    }

    public static final /* synthetic */ void access$getCurrentTime(TransportServiceProxy $this, Transport.TimeRequest request2, StreamObserver responseObserver2) {
        $this.getCurrentTime(request2, (StreamObserver<Transport.TimeResponse>)responseObserver2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0015\u0010\u000f\u001a\u00070\u0004\u00a2\u0006\u0002\b\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0015\u0010\u0012\u001a\u00070\u0004\u00a2\u0006\u0002\b\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\f\u0010\u0016\u001a\u00020\u0004*\u00020\u0011H\u0002J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/transport/TransportServiceProxy$Companion;", "", "()V", "EMULATOR", "", "PRE_LOLLIPOP_FAILURE_REASON", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "convertState", "Lcom/android/tools/profiler/proto/Common$Device$State;", "state", "Lcom/android/ddmlib/IDevice$DeviceState;", "getDeviceManufacturer", "device", "Lcom/android/ddmlib/IDevice;", "getDeviceModel", "getDeviceUnsupportedReason", "transportDeviceFromIDevice", "Lcom/android/tools/profiler/proto/Common$Device;", "getBootId", "getId", "", "bootId", "intellij.android.transport"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Logger logger2 = Logger.getInstance(TransportServiceProxy.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(TransportServiceProxy::class.java)");
            return logger2;
        }

        @JvmStatic
        @NotNull
        public final Common.Device transportDeviceFromIDevice(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            String bootId = this.getBootId(device2);
            Common.Device.Builder builder2 = Common.Device.newBuilder().setDeviceId(this.getId(device2, bootId)).setBootId(bootId).setSerial(device2.getSerialNumber()).setModel(this.getDeviceModel(device2)).setVersion(StringUtil.notNullize((String)device2.getProperty("ro.build.version.release"))).setCodename(StringUtil.notNullize((String)device2.getVersion().getCodename())).setApiLevel(device2.getVersion().getApiLevel()).setFeatureLevel(device2.getVersion().getFeatureLevel()).setManufacturer(this.getDeviceManufacturer(device2)).setIsEmulator(device2.isEmulator()).setBuildTags(device2.getProperty("ro.build.tags")).setBuildType(device2.getProperty("ro.build.type")).setCpuAbi(device2.getProperty("ro.product.cpu.abi"));
            IDevice.DeviceState deviceState = device2.getState();
            Intrinsics.checkNotNullExpressionValue((Object)deviceState, (String)"device.state");
            Common.Device device3 = builder2.setState(this.convertState(deviceState)).setUnsupportedReason(this.getDeviceUnsupportedReason(device2)).build();
            Intrinsics.checkNotNullExpressionValue((Object)device3, (String)"newBuilder()\n        .se\u2026device))\n        .build()");
            return device3;
        }

        private final long getId(IDevice $this$getId, String bootId) {
            long l;
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                String string = bootId;
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                digest.update(byArray);
                String string2 = $this$getId.getSerialNumber();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"serialNumber");
                string = string2;
                byte[] byArray2 = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
                digest.update(byArray2);
                l = ByteBuffer.wrap(digest.digest()).getLong();
            }
            catch (NoSuchAlgorithmException e) {
                this.getLog().info("SHA-256 is not available", (Throwable)e);
                l = new Random(System.currentTimeMillis()).nextLong();
            }
            return l;
        }

        private final String getBootId(IDevice $this$getBootId) {
            String string;
            Ref.ObjectRef bootId = new Ref.ObjectRef();
            try {
                $this$getBootId.executeShellCommand("cat /proc/sys/kernel/random/boot_id", (IShellOutputReceiver)new MultiLineReceiver((Ref.ObjectRef<String>)bootId){
                    final /* synthetic */ Ref.ObjectRef<String> $bootId;
                    {
                        this.$bootId = $bootId;
                    }

                    public void processNewLines(@NotNull String[] lines2) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)lines2, (String)"lines");
                        boolean bl2 = bl = lines2.length == 1;
                        if (_Assertions.ENABLED && !bl) {
                            String string = "Assertion failed";
                            throw new AssertionError((Object)string);
                        }
                        if (((CharSequence)lines2[0]).length() > 0) {
                            this.$bootId.element = lines2[0];
                        }
                    }

                    public boolean isCancelled() {
                        return false;
                    }
                });
            }
            catch (Exception e) {
                Exception exception = e;
                if (((exception instanceof TimeoutException ? true : exception instanceof AdbCommandRejectedException) ? true : exception instanceof IOException) ? true : exception instanceof ShellCommandUnresponsiveException) {
                    this.getLog().warn("Unable to retrieve boot_id from device " + $this$getBootId, (Throwable)e);
                }
                throw e;
            }
            if ((string = (String)bootId.element) == null) {
                string = String.valueOf($this$getBootId.getSerialNumber().hashCode());
            }
            return string;
        }

        private final Common.Device.State convertState(IDevice.DeviceState state2) {
            Common.Device.State state3;
            switch (WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                case 1: {
                    state3 = Common.Device.State.OFFLINE;
                    break;
                }
                case 2: {
                    state3 = Common.Device.State.ONLINE;
                    break;
                }
                case 3: {
                    state3 = Common.Device.State.DISCONNECTED;
                    break;
                }
                default: {
                    state3 = Common.Device.State.UNSPECIFIED;
                }
            }
            return state3;
        }

        private final String getDeviceUnsupportedReason(IDevice device2) {
            return device2.getVersion().getFeatureLevel() < 21 ? TransportServiceProxy.PRE_LOLLIPOP_FAILURE_REASON : "";
        }

        @JvmStatic
        @NotNull
        public final String getDeviceModel(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            String string = device2.isEmulator() ? StringUtil.notNullize((String)device2.getAvdName(), (String)device2.getSerialNumber()) : DevicePropertyUtil.getModel(device2, "Unknown");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when {\n      device.isEm\u2026(device, \"Unknown\")\n    }");
            return string;
        }

        @JvmStatic
        @NotNull
        public final String getDeviceManufacturer(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            String string = DevicePropertyUtil.getManufacturer(device2, device2.isEmulator() ? TransportServiceProxy.EMULATOR : "");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getManufacturer(device, \u2026ulator) EMULATOR else \"\")");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[IDevice.DeviceState.values().length];
                nArray[IDevice.DeviceState.OFFLINE.ordinal()] = 1;
                nArray[IDevice.DeviceState.ONLINE.ordinal()] = 2;
                nArray[IDevice.DeviceState.DISCONNECTED.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

