/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.adapter;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.protobuf.Message;
import com.android.tools.idea.protobuf.TextFormat;
import com.android.tools.idea.protobuf.Timestamp;
import com.android.tools.idea.testartifacts.instrumented.testsuite.adapter.AndroidDeviceResolver;
import com.android.tools.idea.testartifacts.instrumented.testsuite.adapter.ArtifactFileResolver;
import com.android.tools.idea.testartifacts.instrumented.testsuite.adapter.BenchmarkUtilsKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.adapter.UtpTestResultAdapter;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultListener;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCase;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCaseResult;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestSuite;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestSuiteResult;
import com.google.testing.platform.proto.api.core.TestArtifactProto;
import com.google.testing.platform.proto.api.core.TestCaseProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.google.testing.platform.proto.api.core.TestStatusProto;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0002R\u001d\u0010\u0005\u001a\u0004\u0018\u00010\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/UtpTestResultAdapter;", "", "protoFile", "Ljava/io/File;", "(Ljava/io/File;)V", "packageName", "", "getPackageName", "()Ljava/lang/String;", "packageName$delegate", "Lkotlin/Lazy;", "resultProto", "Lcom/google/testing/platform/proto/api/core/TestSuiteResultProto$TestSuiteResult;", "getResultProto", "()Lcom/google/testing/platform/proto/api/core/TestSuiteResultProto$TestSuiteResult;", "resultProto$delegate", "createTestCase", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCase;", "testResult", "Lcom/google/testing/platform/proto/api/core/TestResultProto$TestResult;", "artifactFileResolver", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/ArtifactFileResolver;", "forwardResults", "", "listener", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultListener;", "getIceboxArtifact", "millis", "", "Lcom/android/tools/idea/protobuf/Timestamp;", "intellij.android.core"})
public final class UtpTestResultAdapter {
    @NotNull
    private final File protoFile;
    @NotNull
    private final Lazy resultProto$delegate;
    @NotNull
    private final Lazy packageName$delegate;

    public UtpTestResultAdapter(@NotNull File protoFile) {
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        this.protoFile = protoFile;
        this.resultProto$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TestSuiteResultProto.TestSuiteResult>(this){
            final /* synthetic */ UtpTestResultAdapter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final TestSuiteResultProto.TestSuiteResult invoke() {
                TestSuiteResultProto.TestSuiteResult testSuiteResult;
                if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)UtpTestResultAdapter.access$getProtoFile$p(this.this$0)), (Object)"textproto")) {
                    TestSuiteResultProto.TestSuiteResult.Builder builder2 = TestSuiteResultProto.TestSuiteResult.newBuilder();
                    File file2 = UtpTestResultAdapter.access$getProtoFile$p(this.this$0);
                    Charset charset = Charset.defaultCharset();
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset()");
                    TextFormat.merge((CharSequence)FilesKt.readText((File)file2, (Charset)charset), (Message.Builder)((Message.Builder)builder2));
                    testSuiteResult = builder2.build();
                } else {
                    Closeable closeable = new FileInputStream(UtpTestResultAdapter.access$getProtoFile$p(this.this$0));
                    Throwable throwable = null;
                    try {
                        FileInputStream it = (FileInputStream)closeable;
                        boolean bl = false;
                        TestSuiteResultProto.TestSuiteResult testSuiteResult2 = TestSuiteResultProto.TestSuiteResult.parseFrom((InputStream)it);
                        testSuiteResult = testSuiteResult2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                return testSuiteResult;
            }
        }));
        this.packageName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ UtpTestResultAdapter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final String invoke() {
                void $this$mapNotNullTo$iv$iv;
                List list2 = UtpTestResultAdapter.access$getResultProto(this.this$0).getTestResultList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"resultProto.testResultList");
                Iterable $this$mapNotNull$iv = list2;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    String it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    TestResultProto.TestResult it = (TestResultProto.TestResult)element$iv$iv;
                    boolean bl2 = false;
                    TestResultProto.TestResult testResult = it;
                    if ((testResult != null && (testResult = testResult.getTestCase()) != null ? testResult.getTestPackage() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            }
        }));
    }

    private final TestSuiteResultProto.TestSuiteResult getResultProto() {
        Lazy lazy = this.resultProto$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-resultProto>(...)");
        return (TestSuiteResultProto.TestSuiteResult)object;
    }

    @Nullable
    public final String getPackageName() {
        Lazy lazy = this.packageName$delegate;
        return (String)lazy.getValue();
    }

    @WorkerThread
    public final void forwardResults(@NotNull AndroidTestResultListener listener2) {
        AndroidDevice device2;
        TestResultProto.TestResult testResult;
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        File file2 = this.protoFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"protoFile.parentFile");
        ArtifactFileResolver artifactFileResolver = new ArtifactFileResolver(file2);
        AndroidDeviceResolver androidDeviceResolver = new AndroidDeviceResolver(artifactFileResolver);
        Map deviceToTestCountMap = MapsKt.sortedMapOf((Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AndroidDevice it = (AndroidDevice)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getId());
                it = (AndroidDevice)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
            }
        }, (Pair[])new Pair[0]);
        Map deviceToTestSuiteMap = MapsKt.sortedMapOf((Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AndroidDevice it = (AndroidDevice)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getId());
                it = (AndroidDevice)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
            }
        }, (Pair[])new Pair[0]);
        List list2 = this.getResultProto().getTestResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"resultProto.testResultList");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            testResult = (TestResultProto.TestResult)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)testResult, (String)"testResult");
            device2 = androidDeviceResolver.getAndroidDevice(testResult);
            deviceToTestCountMap.compute(device2, forwardResults.1.1.INSTANCE);
        }
        List list3 = this.getResultProto().getTestResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"resultProto.testResultList");
        $this$forEach$iv = list3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            testResult = (TestResultProto.TestResult)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)testResult, (String)"testResult");
            device2 = androidDeviceResolver.getAndroidDevice(testResult);
            Object v = deviceToTestSuiteMap.computeIfAbsent(device2, new Function(this, deviceToTestCountMap, device2, listener2){
                final /* synthetic */ UtpTestResultAdapter this$0;
                final /* synthetic */ Map<AndroidDevice, Integer> $deviceToTestCountMap;
                final /* synthetic */ AndroidDevice $device;
                final /* synthetic */ AndroidTestResultListener $listener;
                {
                    this.this$0 = $receiver;
                    this.$deviceToTestCountMap = $deviceToTestCountMap;
                    this.$device = $device;
                    this.$listener = $listener;
                }

                @NotNull
                public final AndroidTestSuite apply(@NotNull AndroidDevice newDevice) {
                    Intrinsics.checkNotNullParameter((Object)newDevice, (String)"newDevice");
                    String string = UtpTestResultAdapter.access$getResultProto(this.this$0).getTestSuiteMetaData().getTestSuiteName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultProto.testSuiteMetaData.testSuiteName");
                    String string2 = UtpTestResultAdapter.access$getResultProto(this.this$0).getTestSuiteMetaData().getTestSuiteName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resultProto.testSuiteMetaData.testSuiteName");
                    AndroidTestSuite androidTestSuite = new AndroidTestSuite(string, string2, ((Number)this.$deviceToTestCountMap.getOrDefault(this.$device, 0)).intValue(), AndroidTestSuiteResult.PASSED);
                    AndroidTestResultListener androidTestResultListener = this.$listener;
                    AndroidTestSuite it = androidTestSuite;
                    boolean bl = false;
                    androidTestResultListener.onTestSuiteScheduled(newDevice);
                    androidTestResultListener.onTestSuiteStarted(newDevice, it);
                    return androidTestSuite;
                }
            });
            Intrinsics.checkNotNullExpressionValue(v, (String)"@WorkerThread\n  fun forw\u2026:onTestSuiteFinished)\n  }");
            AndroidTestSuite testSuite2 = (AndroidTestSuite)v;
            AndroidTestCase testCase = this.createTestCase(testResult, artifactFileResolver);
            if (testResult.getTestStatus() == TestStatusProto.TestStatus.FAILED) {
                testSuite2.setResult(AndroidTestSuiteResult.FAILED);
            }
            listener2.onTestCaseStarted(device2, testSuite2, testCase);
            listener2.onTestCaseFinished(device2, testSuite2, testCase);
        }
        deviceToTestSuiteMap.forEach(new BiConsumer(listener2){
            final /* synthetic */ AndroidTestResultListener $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void accept(@NotNull AndroidDevice p0, @NotNull AndroidTestSuite p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                this.$tmp0.onTestSuiteFinished(p0, p1);
            }
        });
    }

    private final AndroidTestCase createTestCase(TestResultProto.TestResult testResult, ArtifactFileResolver artifactFileResolver) {
        Object object;
        AndroidTestCaseResult androidTestCaseResult;
        TestCaseProto.TestCase testCase = testResult.getTestCase();
        Object object2 = testCase.getTestPackage() + "." + testCase.getTestClass() + "#" + testCase.getTestMethod();
        String string = testCase.getTestMethod();
        String string2 = testCase.getTestClass();
        String string3 = testCase.getTestPackage();
        File file2 = ArtifactFileResolver.getArtifactFile$default(artifactFileResolver, testResult, "icebox.info", null, 4, null);
        File file3 = this.getIceboxArtifact(testResult, artifactFileResolver);
        TestStatusProto.TestStatus testStatus = testResult.getTestStatus();
        switch (testStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[testStatus.ordinal()]) {
            case 1: {
                AndroidTestCaseResult androidTestCaseResult2 = AndroidTestCaseResult.PASSED;
                break;
            }
            case 2: {
                AndroidTestCaseResult androidTestCaseResult2 = AndroidTestCaseResult.FAILED;
                break;
            }
            default: {
                AndroidTestCaseResult androidTestCaseResult2 = androidTestCaseResult = AndroidTestCaseResult.SKIPPED;
            }
        }
        if ((object = ArtifactFileResolver.getArtifactFile$default(artifactFileResolver, testResult, "logcat", null, 4, null)) == null || (object = FilesKt.readText$default((File)object, null, (int)1, null)) == null) {
            object = "";
        }
        Object object3 = object;
        Timestamp timestamp = testCase.getStartTime();
        Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"testCase.startTime");
        long l = this.millis(timestamp);
        Timestamp timestamp2 = testCase.getEndTime();
        Intrinsics.checkNotNullExpressionValue((Object)timestamp2, (String)"testCase.endTime");
        long l2 = this.millis(timestamp2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"testMethod");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"testClass");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"testPackage");
        Object $this$createTestCase_u24lambda_u2d4 = object2 = new AndroidTestCase((String)object2, string, string2, string3, androidTestCaseResult, (String)object3, null, l, l2, null, file2, file3, 576, null);
        boolean bl = false;
        BenchmarkUtilsKt.setBenchmarkContextAndPrepareFiles(testResult, (AndroidTestCase)$this$createTestCase_u24lambda_u2d4, (Function1<? super String, ? extends File>)((Function1)new Function1<String, File>(artifactFileResolver){
            final /* synthetic */ ArtifactFileResolver $artifactFileResolver;
            {
                this.$artifactFileResolver = $artifactFileResolver;
                super(1);
            }

            @NotNull
            public final File invoke(@NotNull String outputArtifactPath) {
                Intrinsics.checkNotNullParameter((Object)outputArtifactPath, (String)"outputArtifactPath");
                File file2 = this.$artifactFileResolver.resolveFile(outputArtifactPath);
                if (file2 == null) {
                    file2 = new File(outputArtifactPath);
                }
                return file2;
            }
        }));
        return object2;
    }

    private final File getIceboxArtifact(TestResultProto.TestResult testResult, ArtifactFileResolver artifactFileResolver) {
        Regex iceboxArtifactRegrex = new Regex("snapshot-" + testResult.getTestCase().getTestClass() + "-" + testResult.getTestCase().getTestMethod() + "-failure[0-9]+(\\.tar(\\.gz)?)?");
        return artifactFileResolver.getArtifactFile(testResult, (Function1<? super TestArtifactProto.Artifact, Boolean>)((Function1)new Function1<TestArtifactProto.Artifact, Boolean>(iceboxArtifactRegrex){
            final /* synthetic */ Regex $iceboxArtifactRegrex;
            {
                this.$iceboxArtifactRegrex = $iceboxArtifactRegrex;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TestArtifactProto.Artifact artifact2) {
                Intrinsics.checkNotNullParameter((Object)artifact2, (String)"artifact");
                String string = new File(artifact2.getSourcePath().getPath()).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(artifact.sourcePath.path).name");
                return this.$iceboxArtifactRegrex.matches((CharSequence)string);
            }
        }));
    }

    private final long millis(Timestamp $this$millis) {
        return $this$millis.getSeconds() * 1000L + (long)$this$millis.getNanos() / 1000000L;
    }

    public static final /* synthetic */ TestSuiteResultProto.TestSuiteResult access$getResultProto(UtpTestResultAdapter $this) {
        return $this.getResultProto();
    }

    public static final /* synthetic */ File access$getProtoFile$p(UtpTestResultAdapter $this) {
        return $this.protoFile;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TestStatusProto.TestStatus.values().length];
            nArray[TestStatusProto.TestStatus.PASSED.ordinal()] = 1;
            nArray[TestStatusProto.TestStatus.FAILED.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

