/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.adapter;

import com.android.tools.idea.testartifacts.instrumented.testsuite.adapter.ArtifactFileResolver;
import com.google.testing.platform.proto.api.core.TestArtifactProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fJ\"\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\u0007J&\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/ArtifactFileResolver;", "", "parentDir", "Ljava/io/File;", "(Ljava/io/File;)V", "relativePathToFile", "", "", "getArtifactFile", "testResult", "Lcom/google/testing/platform/proto/api/core/TestResultProto$TestResult;", "filterFunc", "Lkotlin/Function1;", "Lcom/google/testing/platform/proto/api/core/TestArtifactProto$Artifact;", "", "label", "namespace", "getRelativePath", "resolveFile", "relativePath", "intellij.android.core"})
final class ArtifactFileResolver {
    @NotNull
    private final File parentDir;
    @NotNull
    private final Map<String, File> relativePathToFile;

    public ArtifactFileResolver(@NotNull File parentDir) {
        Intrinsics.checkNotNullParameter((Object)parentDir, (String)"parentDir");
        this.parentDir = parentDir;
        this.relativePathToFile = new LinkedHashMap();
    }

    @Nullable
    public final File getArtifactFile(@NotNull TestResultProto.TestResult testResult, @NotNull String label, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return this.getArtifactFile(testResult, (Function1<? super TestArtifactProto.Artifact, Boolean>)((Function1)new Function1<TestArtifactProto.Artifact, Boolean>(label, namespace){
            final /* synthetic */ String $label;
            final /* synthetic */ String $namespace;
            {
                this.$label = $label;
                this.$namespace = $namespace;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull TestArtifactProto.Artifact artifact2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)artifact2, (String)"artifact");
                if (Intrinsics.areEqual((Object)artifact2.getLabel().getLabel(), (Object)this.$label) && Intrinsics.areEqual((Object)artifact2.getLabel().getNamespace(), (Object)this.$namespace)) {
                    String string = artifact2.getSourcePath().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifact.sourcePath.path");
                    if (!StringsKt.isBlank((CharSequence)string)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    public static /* synthetic */ File getArtifactFile$default(ArtifactFileResolver artifactFileResolver, TestResultProto.TestResult testResult, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "android";
        }
        return artifactFileResolver.getArtifactFile(testResult, string, string2);
    }

    @Nullable
    public final File getArtifactFile(@NotNull TestResultProto.TestResult testResult, @NotNull Function1<? super TestArtifactProto.Artifact, Boolean> filterFunc) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        Intrinsics.checkNotNullParameter(filterFunc, (String)"filterFunc");
        String string = this.getRelativePath(testResult, filterFunc);
        if (string == null) {
            return null;
        }
        String relativePath = string;
        return this.relativePathToFile.computeIfAbsent(relativePath, new Function(this){
            final /* synthetic */ ArtifactFileResolver this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public final File apply(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.resolveFile(it);
            }
        });
    }

    private final String getRelativePath(TestResultProto.TestResult testResult, Function1<? super TestArtifactProto.Artifact, Boolean> filterFunc) {
        List list2 = testResult.getOutputArtifactList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"testResult.outputArtifactList");
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list2), filterFunc), (Function1)getRelativePath.1.INSTANCE));
    }

    @Nullable
    public final File resolveFile(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        if (FileUtil.exists((String)relativePath)) {
            return new File(relativePath);
        }
        File file2 = FilesKt.resolve((File)this.parentDir, (String)relativePath);
        if (file2.exists()) {
            return file2;
        }
        String string = new File(relativePath).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(relativePath).name");
        File file3 = FilesKt.resolve((File)this.parentDir, (String)string);
        if (file3.exists()) {
            return file3;
        }
        return null;
    }
}

