/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.TestExecutionOption;
import com.android.tools.idea.model.TestOptions;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ModuleSystemUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.AndroidRunConfigurationModule;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.AndroidRunConfigurationEditor;
import com.android.tools.idea.run.editor.AndroidTestExtraParam;
import com.android.tools.idea.run.editor.AndroidTestExtraParamKt;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.TestRunParameters;
import com.android.tools.idea.run.tasks.AppLaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestApplicationLaunchTask;
import com.android.tools.idea.testartifacts.instrumented.EnableRetention;
import com.android.tools.idea.testartifacts.instrumented.configuration.AndroidTestConfiguration;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.AndroidTestSuiteView;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.TestLibraries;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.Icon;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.dom.manifest.Instrumentation;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTestRunConfiguration
extends AndroidRunConfigurationBase
implements RefactoringListenerProvider {
    public static final int TEST_ALL_IN_MODULE = 0;
    public static final int TEST_ALL_IN_PACKAGE = 1;
    public static final int TEST_CLASS = 2;
    public static final int TEST_METHOD = 3;
    public static final String DEFAULT_ANDROID_INSTRUMENTATION_RUNNER_CLASS = "android.test.InstrumentationTestRunner";
    public int TESTING_TYPE = 0;
    @NotNull
    public String METHOD_NAME = "";
    @NotNull
    public String CLASS_NAME = "";
    @NotNull
    public String PACKAGE_NAME = "";
    @NotNull
    public String TEST_NAME_REGEX = "";
    @NotNull
    public String INSTRUMENTATION_RUNNER_CLASS = "";
    @NotNull
    public String EXTRA_OPTIONS = "";
    public EnableRetention RETENTION_ENABLED = EnableRetention.NO;
    public int RETENTION_MAX_SNAPSHOTS = 2;
    public boolean RETENTION_COMPRESS_SNAPSHOTS = false;

    public AndroidTestRunConfiguration(Project project, ConfigurationFactory factory2) {
        super(project, factory2, true);
    }

    @Override
    @NotNull
    public List<DeployTargetProvider> getApplicableDeployTargetProviders() {
        return this.getDeployTargetContext().getApplicableDeployTargetProviders(true);
    }

    @Override
    protected Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet facet2) {
        if (!AndroidModel.isRequired(facet2)) {
            return Pair.create((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
        }
        AndroidModel androidModel = AndroidModel.get(facet2);
        if (androidModel == null) {
            return Pair.create((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
        }
        return new Pair((Object)Boolean.TRUE, null);
    }

    public boolean isGeneratedName() {
        return Objects.equals(this.getName(), this.suggestedName());
    }

    public String suggestedName() {
        if (this.TESTING_TYPE == 1) {
            return ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{this.PACKAGE_NAME});
        }
        if (this.TESTING_TYPE == 2) {
            return JavaExecutionUtil.getShortClassName((String)this.CLASS_NAME);
        }
        if (this.TESTING_TYPE == 3) {
            return this.METHOD_NAME + "()";
        }
        if (this.TESTING_TYPE == 0 && StringUtil.isNotEmpty((String)this.TEST_NAME_REGEX)) {
            if (StringUtil.isNotEmpty((String)this.METHOD_NAME)) {
                return this.METHOD_NAME + "()";
            }
            return this.TEST_NAME_REGEX;
        }
        return TestRunnerBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public List<ValidationError> checkConfiguration(@NotNull AndroidFacet facet2) {
        int count2;
        ArrayList<ValidationError> errors2 = new ArrayList<ValidationError>();
        Module module2 = facet2.getModule();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module2.getProject());
        switch (this.TESTING_TYPE) {
            case 1: {
                PsiPackage testPackage = facade.findPackage(this.PACKAGE_NAME);
                if (testPackage != null) break;
                errors2.add(ValidationError.warning(JUnitBundle.message((String)"package.does.not.exist.error.message", (Object[])new Object[]{this.PACKAGE_NAME})));
                break;
            }
            case 2: {
                PsiClass testClass = null;
                try {
                    testClass = ((AndroidRunConfigurationModule)this.getConfigurationModule()).checkModuleAndClassName(this.CLASS_NAME, JUnitBundle.message((String)"no.test.class.specified.error.text", (Object[])new Object[0]));
                }
                catch (RuntimeConfigurationException e) {
                    errors2.add(ValidationError.fromException(e));
                }
                if (testClass == null || JUnitUtil.isTestClass((PsiClass)testClass)) break;
                errors2.add(ValidationError.warning(ExecutionBundle.message((String)"class.isnt.test.class.error.message", (Object[])new Object[]{this.CLASS_NAME})));
                break;
            }
            case 3: {
                errors2.addAll(this.checkTestMethod());
            }
        }
        AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet2.getConfiguration();
        if (!AndroidModel.isRequired(facet2) && !configuration.getState().PACK_TEST_CODE && (count2 = AndroidTestRunConfiguration.getTestSourceRootCount(module2)) > 0) {
            String shortMessage = "Test code not included into APK";
            String fixMessage = "Code and resources under test source " + (count2 > 1 ? "roots" : "root") + " aren't included into debug APK.\nWould you like to include them and recompile " + module2.getName() + " module?\n(You may change this option in Android facet settings later)";
            Runnable quickFix = () -> {
                int result2 = Messages.showYesNoCancelDialog((Project)this.getProject(), (String)fixMessage, (String)"Test code not included into APK", (Icon)Messages.getQuestionIcon());
                if (result2 == 0) {
                    configuration.getState().PACK_TEST_CODE = true;
                }
            };
            errors2.add(ValidationError.fatal("Test code not included into APK", quickFix));
        }
        return errors2;
    }

    @Override
    public boolean isTestConfiguration() {
        return true;
    }

    @Override
    @NotNull
    public TestCompileType getTestCompileMode() {
        return TestCompileType.ANDROID_TESTS;
    }

    private static int getTestSourceRootCount(@NotNull Module module2) {
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module2);
        return manager.getSourceRoots(true).length - manager.getSourceRoots(false).length;
    }

    private List<ValidationError> checkTestMethod() {
        PsiClass testClass;
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        try {
            testClass = configurationModule.checkModuleAndClassName(this.CLASS_NAME, JUnitBundle.message((String)"no.test.class.specified.error.text", (Object[])new Object[0]));
        }
        catch (RuntimeConfigurationException e) {
            return ImmutableList.of((Object)ValidationError.fromException(e));
        }
        ArrayList<ValidationError> errors2 = new ArrayList<ValidationError>();
        if (!JUnitUtil.isTestClass((PsiClass)testClass)) {
            errors2.add(ValidationError.warning(ExecutionBundle.message((String)"class.isnt.test.class.error.message", (Object[])new Object[]{this.CLASS_NAME})));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.METHOD_NAME)) {
            errors2.add(ValidationError.fatal(JUnitBundle.message((String)"method.name.not.specified.error.message", (Object[])new Object[0])));
        }
        JUnitUtil.TestMethodFilter filter2 = new JUnitUtil.TestMethodFilter(testClass);
        boolean found = false;
        boolean testAnnotated = false;
        for (PsiMethod method2 : testClass.findMethodsByName(this.METHOD_NAME, true)) {
            if (filter2.value(method2)) {
                found = true;
            }
            if (!JUnitUtil.isTestAnnotated((PsiMethod)method2)) continue;
            testAnnotated = true;
        }
        if (!found) {
            errors2.add(ValidationError.warning(JUnitBundle.message((String)"test.method.doesnt.exist.error.message", (Object[])new Object[]{this.METHOD_NAME})));
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)testClass, (String)"org.junit.runner.RunWith", (int)1) && !testAnnotated) {
            try {
                PsiClass testCaseClass = JUnitUtil.getTestCaseClass((Module)((AndroidRunConfigurationModule)this.getConfigurationModule()).getAndroidTestModule());
                if (!testClass.isInheritor(testCaseClass, true)) {
                    errors2.add(ValidationError.fatal(JUnitBundle.message((String)"class.isnt.inheritor.of.testcase.error.message", (Object[])new Object[]{this.CLASS_NAME})));
                }
            }
            catch (JUnitUtil.NoJUnitException e) {
                errors2.add(ValidationError.warning(ExecutionBundle.message((String)AndroidBundle.message("cannot.find.testcase.error", new Object[0]), (Object[])new Object[0])));
            }
        }
        return errors2;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new AndroidRunConfigurationEditor<AndroidTestRunConfiguration>(this.getProject(), (Predicate<Module>)((Predicate)module2 -> {
            if (module2 == null) {
                return false;
            }
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
            if (facet2 == null) {
                return false;
            }
            AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(facet2);
            AndroidModuleSystem.Type moduleType = moduleSystem.getType();
            switch (moduleType) {
                case TYPE_APP: 
                case TYPE_DYNAMIC_FEATURE: 
                case TYPE_LIBRARY: {
                    return ModuleSystemUtil.isAndroidTestModule(module2);
                }
                case TYPE_TEST: {
                    return ModuleSystemUtil.isMainModule(module2);
                }
                case TYPE_ATOM: 
                case TYPE_FEATURE: 
                case TYPE_INSTANTAPP: {
                    return false;
                }
                case TYPE_NON_ANDROID: {
                    return false;
                }
            }
            return false;
        }), this, false, true, moduleSelector2 -> new TestRunParameters(this.getProject(), (ConfigurationModuleSelector)moduleSelector2));
    }

    @Override
    @NotNull
    protected ConsoleProvider getConsoleProvider(boolean runOnMultipleDevices) {
        return (parent2, handler2, executor2) -> {
            AndroidTestSuiteView consoleView = new AndroidTestSuiteView(parent2, this.getProject(), ((AndroidRunConfigurationModule)this.getConfigurationModule()).getAndroidTestModule(), executor2.getToolWindowId(), (RunConfiguration)this);
            consoleView.attachToProcess(handler2);
            return consoleView;
        };
    }

    @Override
    @Nullable
    protected AppLaunchTask getApplicationLaunchTask(@NotNull ApplicationIdProvider applicationIdProvider, @NotNull AndroidFacet facet2, @NotNull String contributorsAmStartOptions, boolean waitForDebugger, @NotNull LaunchStatus launchStatus, @NotNull ApkProvider apkProvider, @NotNull ConsolePrinter consolePrinter, @NotNull IDevice device2) {
        String testAppId;
        String runner = this.INSTRUMENTATION_RUNNER_CLASS;
        if (StringUtil.isEmptyOrSpaces((String)runner)) {
            runner = AndroidTestRunConfiguration.getDefaultInstrumentationRunner(facet2);
        }
        if (StringUtil.isEmptyOrSpaces((String)runner)) {
            launchStatus.terminateLaunch("Unable to determine instrumentation runner", true);
            return null;
        }
        @Nullable AndroidModel androidModel = AndroidModel.get(facet2);
        TestOptions testOptions = androidModel != null ? androidModel.getTestOptions() : null;
        String instrumentationOptions = Joiner.on((String)" ").join((Object)this.getExtraInstrumentationOptions(facet2), (Object)this.getInstrumentationOptions(testOptions), new Object[0]);
        try {
            testAppId = applicationIdProvider.getTestPackageName();
            if (testAppId == null) {
                launchStatus.terminateLaunch("Unable to determine test package name", true);
                return null;
            }
        }
        catch (ApkProvisionException e) {
            launchStatus.terminateLaunch("Unable to determine test package name", true);
            return null;
        }
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(facet2);
        TestLibraries testLibrariesInUse = moduleSystem.getTestLibrariesInUse();
        TestExecutionOption testExecutionOption = testOptions != null ? testOptions.getExecutionOption() : null;
        switch (this.TESTING_TYPE) {
            case 0: {
                return AndroidTestApplicationLaunchTask.allInModuleTest(runner, testAppId, waitForDebugger, instrumentationOptions, testLibrariesInUse, testExecutionOption, launchStatus.getProcessHandler(), consolePrinter, device2);
            }
            case 1: {
                return AndroidTestApplicationLaunchTask.allInPackageTest(runner, testAppId, waitForDebugger, instrumentationOptions, testLibrariesInUse, testExecutionOption, launchStatus.getProcessHandler(), consolePrinter, device2, this.PACKAGE_NAME);
            }
            case 2: {
                return AndroidTestApplicationLaunchTask.classTest(runner, testAppId, waitForDebugger, instrumentationOptions, testLibrariesInUse, testExecutionOption, launchStatus.getProcessHandler(), consolePrinter, device2, this.CLASS_NAME);
            }
            case 3: {
                return AndroidTestApplicationLaunchTask.methodTest(runner, testAppId, waitForDebugger, instrumentationOptions, testLibrariesInUse, testExecutionOption, launchStatus.getProcessHandler(), consolePrinter, device2, this.CLASS_NAME, this.METHOD_NAME);
            }
        }
        launchStatus.terminateLaunch("Unknown testing type is selected", true);
        return null;
    }

    @NotNull
    public static String getDefaultInstrumentationRunner(@Nullable AndroidFacet facet2) {
        if (facet2 == null) {
            return DEFAULT_ANDROID_INSTRUMENTATION_RUNNER_CLASS;
        }
        AndroidModel androidModel = AndroidModel.get(facet2);
        if (androidModel != null) {
            String runner = androidModel.getTestOptions().getInstrumentationRunner();
            if (StringUtil.isEmptyOrSpaces((String)runner)) {
                return DEFAULT_ANDROID_INSTRUMENTATION_RUNNER_CLASS;
            }
            return runner;
        }
        return (String)DumbService.getInstance((Project)facet2.getModule().getProject()).runReadActionInSmartMode(() -> {
            Manifest manifest = Manifest.getMainManifest(facet2);
            if (manifest == null) {
                return DEFAULT_ANDROID_INSTRUMENTATION_RUNNER_CLASS;
            }
            for (Instrumentation instrumentation : manifest.getInstrumentations()) {
                PsiClass instrumentationClass;
                if (instrumentation == null || (instrumentationClass = (PsiClass)instrumentation.getInstrumentationClass().getValue()) == null) continue;
                return instrumentationClass.getQualifiedName();
            }
            return DEFAULT_ANDROID_INSTRUMENTATION_RUNNER_CLASS;
        });
    }

    @NotNull
    public String getExtraInstrumentationOptions(@Nullable AndroidFacet facet2) {
        Collection<Object> extraParams = AndroidTestConfiguration.getInstance().RUN_ANDROID_TEST_USING_GRADLE ? SequencesKt.toList(AndroidTestExtraParam.parseFromString(this.EXTRA_OPTIONS)) : AndroidTestExtraParamKt.merge(AndroidTestExtraParam.parseFromString(this.EXTRA_OPTIONS), AndroidTestExtraParamKt.getAndroidTestExtraParams(facet2));
        return extraParams.stream().map(param -> "-e " + param.getNAME() + " " + param.getVALUE()).collect(Collectors.joining(" "));
    }

    @NotNull
    public String getInstrumentationOptions(@Nullable TestOptions testOptions) {
        boolean isAnimationDisabled;
        ImmutableList.Builder builder2 = new ImmutableList.Builder();
        boolean bl = isAnimationDisabled = testOptions != null ? testOptions.getAnimationsDisabled() : false;
        if (isAnimationDisabled) {
            builder2.add((Object)"--no-window-animation");
        }
        return Joiner.on((String)" ").join((Iterable)builder2.build());
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element2) {
        if (element2 instanceof PsiPackage) {
            String pkgName = ((PsiPackage)element2).getQualifiedName();
            if (this.TESTING_TYPE == 1 && !Objects.equals(pkgName, this.PACKAGE_NAME)) {
                return null;
            }
            if (this.TESTING_TYPE != 1 && !Objects.equals(pkgName, StringUtil.getPackageName((String)this.CLASS_NAME))) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement instanceof PsiPackage) {
                        String newPkgName = ((PsiPackage)newElement).getQualifiedName();
                        if (AndroidTestRunConfiguration.this.TESTING_TYPE == 1) {
                            AndroidTestRunConfiguration.this.PACKAGE_NAME = newPkgName;
                        } else {
                            AndroidTestRunConfiguration.this.CLASS_NAME = AndroidTestRunConfiguration.this.CLASS_NAME.replace(StringUtil.getPackageName((String)AndroidTestRunConfiguration.this.CLASS_NAME), newPkgName);
                        }
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement instanceof PsiPackage) {
                        if (AndroidTestRunConfiguration.this.TESTING_TYPE == 1) {
                            AndroidTestRunConfiguration.this.PACKAGE_NAME = oldQualifiedName;
                        } else {
                            AndroidTestRunConfiguration.this.CLASS_NAME = AndroidTestRunConfiguration.this.CLASS_NAME.replace(StringUtil.getPackageName((String)AndroidTestRunConfiguration.this.CLASS_NAME), oldQualifiedName);
                        }
                    }
                }
            };
        }
        if ((this.TESTING_TYPE == 2 || this.TESTING_TYPE == 3) && element2 instanceof PsiClass) {
            if (!StringUtil.equals((CharSequence)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)element2)), (CharSequence)this.CLASS_NAME)) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement instanceof PsiClass) {
                        AndroidTestRunConfiguration.this.CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)newElement));
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement instanceof PsiClass) {
                        AndroidTestRunConfiguration.this.CLASS_NAME = oldQualifiedName;
                    }
                }
            };
        }
        if (this.TESTING_TYPE == 3 && element2 instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element2;
            if (!StringUtil.equals((CharSequence)psiMethod.getName(), (CharSequence)this.METHOD_NAME)) {
                return null;
            }
            PsiClass psiClass = psiMethod.getContainingClass();
            if (psiClass == null) {
                return null;
            }
            String fqName = psiClass.getQualifiedName();
            if (fqName != null && !StringUtil.equals((CharSequence)fqName, (CharSequence)this.CLASS_NAME)) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement instanceof PsiMethod) {
                        AndroidTestRunConfiguration.this.METHOD_NAME = ((PsiMethod)newElement).getName();
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement instanceof PsiMethod) {
                        AndroidTestRunConfiguration.this.METHOD_NAME = oldQualifiedName;
                    }
                }
            };
        }
        return null;
    }

    @Override
    @NotNull
    protected LaunchOptions.Builder getLaunchOptions() {
        LaunchOptions.Builder builder2 = super.getLaunchOptions();
        builder2.setPmInstallOptions(device2 -> {
            if (device2.isPresent() && ((IDevice)device2.get()).getVersion().getApiLevel() >= 23) {
                return "-t -g";
            }
            return "-t";
        });
        return builder2;
    }

    public TestExecutionOption getTestExecutionOption(@Nullable AndroidFacet facet2) {
        return Optional.ofNullable(facet2).map(AndroidModel::get).map(AndroidModel::getTestOptions).map(TestOptions::getExecutionOption).orElse(TestExecutionOption.HOST);
    }
}

