/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented;

import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidClassVisibilityCheckerBase
implements JavaCodeFragment.VisibilityChecker {
    private final ConfigurationModuleSelector myModuleSelector;

    public AndroidClassVisibilityCheckerBase(@NotNull ConfigurationModuleSelector moduleSelector2) {
        this.myModuleSelector = moduleSelector2;
    }

    public JavaCodeFragment.VisibilityChecker.Visibility isDeclarationVisible(PsiElement declaration, PsiElement place) {
        VirtualFile vFile;
        if (!(declaration instanceof PsiClass)) {
            return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
        }
        Module module2 = this.myModuleSelector.getModule();
        if (module2 == null) {
            return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
        }
        PsiFile file2 = declaration.getContainingFile();
        VirtualFile virtualFile = vFile = file2 != null ? file2.getVirtualFile() : null;
        if (vFile == null) {
            return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
        }
        return this.isVisible(module2, (PsiClass)declaration) ? JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE : JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
    }

    protected abstract boolean isVisible(@NotNull Module var1, @NotNull PsiClass var2);
}

