/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.annotations.concurrency.UiThread;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.uipreview.EditorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007Jg\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\t2M\b\u0002\u0010\u000f\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u0010H\u0007J \u0010\u000f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\tH\u0003J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J&\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u001f2\u0006\u0010 \u001a\u00020\u0015H\u0007J\u001c\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0013\u001a\u00020\t2\b\b\u0002\u0010\"\u001a\u00020\u0015H\u0007J\u001a\u0010#\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u000bH\u0007J\u001a\u0010#\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\tH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/templates/TemplateUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "checkDirectoryIsWriteable", "", "directory", "Ljava/io/File;", "checkedCreateDirectoryIfMissing", "Lcom/intellij/openapi/vfs/VirtualFile;", "copyDirectory", "src", "dest", "copyFile", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "file", "destination", "", "fileToCopy", "parent", "hasExtension", "extension", "", "openEditors", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "select", "readTextFromDisk", "warnIfNotExists", "readTextFromDocument", "intellij.android.templates"})
public final class TemplateUtils {
    @NotNull
    public static final TemplateUtils INSTANCE = new TemplateUtils();
    @NotNull
    private static final Logger LOG;

    private TemplateUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void openEditors(@NotNull Project project, @NotNull Collection<? extends File> files2, boolean select2) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        VirtualFile last = null;
        Iterable $this$filter$iv = files2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File p0 = (File)element$iv$iv;
            boolean bl = false;
            if (!p0.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            if (VfsUtil.findFileByIoFile((File)it, (boolean)true) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            last = it;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            EditorUtil.openEditor(project, it);
        }
        if (select2 && last != null) {
            EditorUtil.selectEditor(project, last);
        }
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String readTextFromDisk(@NotNull File file2, boolean warnIfNotExists) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        boolean bl = file2.isAbsolute();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        try {
            string = Files.asCharSource((File)file2, (Charset)Charsets.UTF_8).read();
        }
        catch (IOException e) {
            if (warnIfNotExists) {
                LOG.warn((Throwable)e);
            }
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String readTextFromDisk$default(File file2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return TemplateUtils.readTextFromDisk(file2, bl);
    }

    @JvmStatic
    @Nullable
    public static final String readTextFromDocument(@NotNull Project project, @NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        boolean bl = project.isInitialized();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file2);
        if (vFile == null) {
            LOG.debug("Cannot find file " + file2.getPath() + " in the VFS");
            return null;
        }
        return TemplateUtils.readTextFromDocument(project, vFile);
    }

    @JvmStatic
    @Nullable
    public static final String readTextFromDocument(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        boolean bl = project.isInitialized();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return (String)ApplicationManager.getApplication().runReadAction(new Computable(file2){
            final /* synthetic */ VirtualFile $file;
            {
                this.$file = $file;
            }

            public final String compute() {
                Document document2;
                Document document3 = document2 = FileDocumentManager.getInstance().getDocument(this.$file);
                return document3 != null ? document3.getText() : null;
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final VirtualFile checkedCreateDirectoryIfMissing(@NotNull File directory) throws IOException {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Object object = WriteCommandAction.runWriteCommandAction(null, (ThrowableComputable)new ThrowableComputable(directory){
            final /* synthetic */ File $directory;
            {
                this.$directory = $directory;
            }

            public final VirtualFile compute() {
                VirtualFile virtualFile = VfsUtil.createDirectoryIfMissing((String)this.$directory.getAbsolutePath());
                if (virtualFile == null) {
                    throw new IOException("Unable to create " + this.$directory.getAbsolutePath());
                }
                return virtualFile;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"directory: File): Virtua\u2026tory.absolutePath)\n    })");
        return (VirtualFile)object;
    }

    @JvmStatic
    public static final void checkDirectoryIsWriteable(@NotNull File directory) throws IOException {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        File d = directory;
        while (!d.exists() || !d.isDirectory()) {
            Intrinsics.checkNotNullExpressionValue((Object)d.getParentFile(), (String)"d.parentFile");
        }
        if (!d.canWrite()) {
            throw new IOException("Cannot write to folder: " + d.getAbsolutePath());
        }
    }

    @JvmStatic
    @UiThread
    @JvmOverloads
    public static final void copyDirectory(@NotNull VirtualFile src, @NotNull File dest, @NotNull Function3<? super VirtualFile, ? super VirtualFile, ? super File, Boolean> copyFile) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter(copyFile, (String)"copyFile");
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
        Intrinsics.checkNotNull((Object)VfsUtilCore.visitChildrenRecursively((VirtualFile)src, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(copyFile, src, dest, optionArray){
            final /* synthetic */ Function3<VirtualFile, VirtualFile, File, Boolean> $copyFile;
            final /* synthetic */ VirtualFile $src;
            final /* synthetic */ File $dest;
            {
                this.$copyFile = $copyFile;
                this.$src = $src;
                this.$dest = $dest;
                super($super_call_param$1);
            }

            public boolean visitFile(@NotNull VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                try {
                    return (Boolean)this.$copyFile.invoke((Object)file2, (Object)this.$src, (Object)this.$dest);
                }
                catch (IOException e) {
                    throw new VirtualFileVisitor.VisitorException((Throwable)e);
                }
            }
        }), IOException.class));
    }

    public static /* synthetic */ void copyDirectory$default(VirtualFile virtualFile, File file2, Function3 function3, int n, Object object) {
        if ((n & 4) != 0) {
            function3 = (Function3)new Function3<VirtualFile, VirtualFile, File, Boolean>((Object)INSTANCE){

                @NotNull
                public final Boolean invoke(@NotNull VirtualFile p0, @NotNull VirtualFile p1, @NotNull File p2) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    return TemplateUtils.access$copyFile(p0, p1, p2);
                }
            };
        }
        TemplateUtils.copyDirectory(virtualFile, file2, (Function3<? super VirtualFile, ? super VirtualFile, ? super File, Boolean>)function3);
    }

    @JvmStatic
    @UiThread
    private static final boolean copyFile(VirtualFile fileToCopy, VirtualFile parent2, File destination) {
        VirtualFile targetVf;
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)fileToCopy, (VirtualFile)parent2, (char)File.separatorChar);
        if (!(relativePath != null)) {
            boolean $i$a$-check-TemplateUtils$copyFile$22 = false;
            String $i$a$-check-TemplateUtils$copyFile$22 = fileToCopy.getPath() + " is not a child of " + parent2;
            throw new IllegalStateException($i$a$-check-TemplateUtils$copyFile$22.toString());
        }
        if (fileToCopy.isDirectory()) {
            TemplateUtils.checkedCreateDirectoryIfMissing(new File(destination, relativePath));
            return true;
        }
        File target2 = new File(destination, relativePath);
        File file2 = target2.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"target.parentFile");
        VirtualFile toDir = TemplateUtils.checkedCreateDirectoryIfMissing(file2);
        VirtualFile virtualFile = targetVf = LocalFileSystem.getInstance().findFileByIoFile(target2);
        boolean bl = virtualFile != null ? virtualFile.exists() : false;
        if (bl) {
            return false;
        }
        VfsUtilCore.copyFile((Object)INSTANCE, (VirtualFile)fileToCopy, (VirtualFile)toDir);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean hasExtension(@NotNull File file2, @NotNull String extension) {
        CharSequence charSequence;
        String string;
        block1: {
            void $this$trimStart$iv;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            String string2 = extension;
            string = Files.getFileExtension((String)file2.getName());
            boolean $i$f$trimStart = false;
            CharSequence $this$trimStart$iv$iv = (CharSequence)$this$trimStart$iv;
            boolean $i$f$trimStart2 = false;
            int n = $this$trimStart$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char it = $this$trimStart$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (it == '.') continue;
                charSequence = $this$trimStart$iv$iv.subSequence(index$iv$iv, $this$trimStart$iv$iv.length());
                break block1;
            }
            charSequence = "";
        }
        return StringsKt.equals((String)string, (String)((Object)charSequence).toString(), (boolean)true);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String readTextFromDisk(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return TemplateUtils.readTextFromDisk$default(file2, false, 2, null);
    }

    @JvmStatic
    @UiThread
    @JvmOverloads
    public static final void copyDirectory(@NotNull VirtualFile src, @NotNull File dest) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        TemplateUtils.copyDirectory$default(src, dest, null, 4, null);
    }

    public static final /* synthetic */ boolean access$copyFile(VirtualFile fileToCopy, VirtualFile parent2, File destination) {
        return TemplateUtils.copyFile(fileToCopy, parent2, destination);
    }

    static {
        Logger logger2 = Logger.getInstance((String)"#org.jetbrains.android.templates.DomUtilities");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(\"#org.jetbra\u2026.templates.DomUtilities\")");
        LOG = logger2;
    }
}

