/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.dialog;

import com.android.tools.idea.structure.dialog.SidePanel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.roots.ui.configuration.SidePanelSeparator;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002)*B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#J\u000e\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u0017J\u0006\u0010'\u001a\u00020\u001dJ\u000e\u0010(\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006+"}, d2={"Lcom/android/tools/idea/structure/dialog/SidePanel;", "Ljavax/swing/JPanel;", "myNavigator", "Lcom/intellij/ui/navigation/Place$Navigator;", "myHistory", "Lcom/intellij/ui/navigation/History;", "(Lcom/intellij/ui/navigation/Place$Navigator;Lcom/intellij/ui/navigation/History;)V", "cellRenderer", "Ljavax/swing/ListCellRenderer;", "Lcom/android/tools/idea/structure/dialog/SidePanel$PlaceData;", "descriptor", "Lcom/intellij/openapi/ui/popup/ListItemDescriptor;", "getDescriptor$annotations", "()V", "getDescriptor", "()Lcom/intellij/openapi/ui/popup/ListItemDescriptor;", "list", "Lcom/intellij/ui/components/JBList;", "getList", "()Lcom/intellij/ui/components/JBList;", "listModel", "Ljavax/swing/DefaultListModel;", "pendingSeparator", "", "validationParent", "Ljavax/swing/CellRendererPane;", "getValidationParent", "()Ljavax/swing/CellRendererPane;", "addPlace", "", "place", "Lcom/intellij/ui/navigation/Place;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "counterProvider", "Lkotlin/Function0;", "Lcom/android/tools/idea/structure/dialog/SidePanel$ProblemStats;", "addSeparator", "text", "clear", "select", "PlaceData", "ProblemStats", "intellij.android.core"})
public final class SidePanel
extends JPanel {
    @NotNull
    private final Place.Navigator myNavigator;
    @NotNull
    private final History myHistory;
    @NotNull
    private final DefaultListModel<PlaceData> listModel;
    @NotNull
    private final ListItemDescriptor<PlaceData> descriptor;
    @NotNull
    private final ListCellRenderer<PlaceData> cellRenderer;
    @NotNull
    private final CellRendererPane validationParent;
    @NotNull
    private final JBList<PlaceData> list;
    @Nullable
    private String pendingSeparator;

    /*
     * WARNING - void declaration
     */
    public SidePanel(@NotNull Place.Navigator myNavigator, @NotNull History myHistory) {
        void it;
        Intrinsics.checkNotNullParameter((Object)myNavigator, (String)"myNavigator");
        Intrinsics.checkNotNullParameter((Object)myHistory, (String)"myHistory");
        super(new BorderLayout());
        this.myNavigator = myNavigator;
        this.myHistory = myHistory;
        this.listModel = new DefaultListModel();
        this.descriptor = (ListItemDescriptor)new ListItemDescriptor<PlaceData>(){

            @Nullable
            public String getTextFor(@NotNull PlaceData place) {
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                return place.getPresentation().getText();
            }

            @Nullable
            public String getTooltipFor(@NotNull PlaceData place) {
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                return null;
            }

            @Nullable
            public Icon getIconFor(@NotNull PlaceData place) {
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                return (Icon)JBUIScale.scaleIcon((JBScalableIcon)((JBScalableIcon)EmptyIcon.create((int)16, (int)20)));
            }

            public boolean hasSeparatorAboveOf(@NotNull PlaceData value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                return value2.getSeparator() != null;
            }

            @Nullable
            public String getCaptionAboveOf(@NotNull PlaceData value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                return value2.getSeparator();
            }
        };
        JBList jBList = this.descriptor;
        this.cellRenderer = (ListCellRenderer)new GroupedItemsListRenderer<PlaceData>(this, jBList){
            @Nullable
            private JPanel extraPanel;
            @Nullable
            private JLabel countLabel;
            private boolean containsErrors;
            private boolean isSelected;
            @NotNull
            private final JBEmptyBorder textBorders;
            @NotNull
            private final JBEmptyBorder emptyBorders;
            final /* synthetic */ SidePanel this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
                JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)2, (int)5, (int)2, (int)12);
                Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(2, 5, 2, 6 + 6)");
                this.textBorders = jBEmptyBorder;
                JBEmptyBorder jBEmptyBorder2 = JBUI.Borders.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder2, (String)"empty()");
                this.emptyBorders = jBEmptyBorder2;
                this.mySeparatorComponent.setCaptionCentered(false);
            }

            @Nullable
            public final JPanel getExtraPanel() {
                return this.extraPanel;
            }

            public final void setExtraPanel(@Nullable JPanel jPanel) {
                this.extraPanel = jPanel;
            }

            @Nullable
            public final JLabel getCountLabel() {
                return this.countLabel;
            }

            public final void setCountLabel(@Nullable JLabel jLabel) {
                this.countLabel = jLabel;
            }

            @NotNull
            protected Color getForeground() {
                return (Color)new JBColor((Color)Gray._60, (Color)Gray._140);
            }

            @NotNull
            protected SeparatorWithText createSeparator() {
                return (SeparatorWithText)new SidePanelSeparator();
            }

            protected void layout() {
                JLabel jLabel = this.countLabel;
                if (jLabel != null) {
                    JLabel jLabel2 = this.countLabel;
                    CharSequence charSequence = jLabel2 != null ? jLabel2.getText() : null;
                    jLabel.setBorder(charSequence == null || charSequence.length() == 0 ? (Border)this.emptyBorders : (Border)this.textBorders);
                }
                JPanel jPanel = this.extraPanel;
                if (jPanel == null) {
                    return;
                }
                JPanel extraPanel = jPanel;
                this.myRendererComponent.add((Component)this.mySeparatorComponent, (Object)"North");
                extraPanel.add((Component)this.myComponent, "Center");
                extraPanel.add((Component)this.countLabel, "East");
                this.myRendererComponent.add((Component)this.extraPanel, (Object)"Center");
            }

            @NotNull
            public Component getListCellRendererComponent(@NotNull JList<? extends PlaceData> list2, @NotNull PlaceData value2, int index2, boolean isSelected, boolean cellHasFocus) {
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Component component2 = super.getListCellRendererComponent(list2, (Object)value2, index2, isSelected, cellHasFocus);
                this.updateCountLabel(isSelected, value2);
                this.layout();
                if (UIUtil.isClientPropertyTrue(list2, (Object)ExpandableItemsHandler.EXPANDED_RENDERER)) {
                    Rectangle bounds = list2.getCellBounds(index2, index2);
                    bounds.setSize((int)component2.getPreferredSize().getWidth(), (int)bounds.getHeight());
                    JPanel jPanel = this.extraPanel;
                    if (jPanel != null) {
                        JPanel jPanel2 = jPanel;
                        SidePanel sidePanel = this.this$0;
                        JPanel it = jPanel2;
                        boolean bl = false;
                        AbstractExpandableItemsHandler.setRelativeBounds((Component)component2, (Rectangle)bounds, (Component)it, (Container)sidePanel.getValidationParent());
                        it.setSize((int)it.getPreferredSize().getWidth(), it.getHeight());
                        UIUtil.putClientProperty((JComponent)it, (Key)ExpandableItemsHandler.USE_RENDERER_BOUNDS, (Object)true);
                        return it;
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"component");
                return component2;
            }

            @NotNull
            protected JComponent createItemComponent() {
                this.extraPanel = (JPanel)new NonOpaquePanel((LayoutManager)new BorderLayout());
                this.countLabel = new JLabel(this){
                    final /* synthetic */ cellRenderer.1 this$0;
                    {
                        this.this$0 = $receiver;
                        this.setFont(UIUtil.getListFont().deriveFont(1));
                    }

                    protected void paintComponent(@NotNull Graphics g) {
                        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                        g.setColor(cellRenderer.1.access$isSelected$p(this.this$0) ? UIUtil.getListSelectionBackground((boolean)true) : UIUtil.SIDE_PANEL_BACKGROUND);
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                        if (StringUtil.isEmpty((String)this.getText())) {
                            return;
                        }
                        JBColor deepBlue = new JBColor(new Color(9938098), new Color(92, 98, 113));
                        g.setColor(cellRenderer.1.access$isSelected$p(this.this$0) ? Gray._255.withAlpha(UIUtil.isUnderDarcula() ? 100 : 220) : (cellRenderer.1.access$getContainsErrors$p(this.this$0) ? JBColor.RED.darker() : (Color)deepBlue));
                        GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
                        g.fillRoundRect(0, 3, this.getWidth() - 6 - 1, this.getHeight() - 6, this.getHeight() - 6, this.getHeight() - 6);
                        config2.restore();
                        this.setForeground(cellRenderer.1.access$isSelected$p(this.this$0) && cellRenderer.1.access$getContainsErrors$p(this.this$0) ? JBColor.RED.darker() : (cellRenderer.1.access$isSelected$p(this.this$0) ? deepBlue.darker() : UIUtil.getListForeground((boolean)true, (boolean)true)));
                        super.paintComponent(g);
                    }
                };
                JComponent component2 = super.createItemComponent();
                this.myTextLabel.setForeground((Color)Gray._240);
                this.myTextLabel.setOpaque(true);
                Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"component");
                return component2;
            }

            @NotNull
            protected Color getBackground() {
                Color color = UIUtil.SIDE_PANEL_BACKGROUND;
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"SIDE_PANEL_BACKGROUND");
                return color;
            }

            private final void updateCountLabel(boolean isSelected, PlaceData value2) {
                ProblemStats problemStats;
                JLabel jLabel = this.countLabel;
                if (jLabel == null) {
                    return;
                }
                JLabel countLabel = jLabel;
                Function0<ProblemStats> function0 = value2.getCountProvider();
                ProblemStats problemStats2 = problemStats = function0 != null ? (ProblemStats)function0.invoke() : null;
                int count2 = problemStats2 != null ? problemStats2.getCount() : 0;
                this.isSelected = isSelected;
                ProblemStats problemStats3 = problemStats;
                boolean bl = this.containsErrors = problemStats3 != null ? problemStats3.getContainsErrors() : false;
                countLabel.setText(count2 == 0 ? "" : (count2 > 100 ? "100+" : String.valueOf(count2)));
            }

            public static final /* synthetic */ boolean access$isSelected$p(cellRenderer.1 $this) {
                return $this.isSelected;
            }

            public static final /* synthetic */ boolean access$getContainsErrors$p(cellRenderer.1 $this) {
                return $this.containsErrors;
            }
        };
        this.validationParent = new CellRendererPane();
        JBList jBList2 = jBList = new JBList((ListModel)this.listModel);
        SidePanel sidePanel = this;
        boolean bl = false;
        it.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        it.setBorder((Border)new EmptyBorder(5, 0, 0, 0));
        it.setSelectionMode(0);
        it.setCellRenderer(this.cellRenderer);
        it.add((Component)this.validationParent);
        it.addListSelectionListener(new ListSelectionListener((JBList<PlaceData>)it, this){
            final /* synthetic */ JBList<PlaceData> $it;
            final /* synthetic */ SidePanel this$0;
            {
                this.$it = $it;
                this.this$0 = $receiver;
            }

            public final void valueChanged(ListSelectionEvent e) {
                block1: {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    PlaceData placeData = (PlaceData)this.$it.getSelectedValue();
                    if (placeData == null) break block1;
                    PlaceData placeData2 = placeData;
                    SidePanel sidePanel = this.this$0;
                    PlaceData value2 = placeData2;
                    boolean bl = false;
                    SidePanel.access$getMyNavigator$p(sidePanel).navigateTo(value2.getPlace(), false);
                }
            }
        });
        sidePanel.list = jBList;
        this.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)this.list), (boolean)true), "Center");
    }

    @NotNull
    public final ListItemDescriptor<PlaceData> getDescriptor() {
        return this.descriptor;
    }

    @VisibleForTesting
    public static /* synthetic */ void getDescriptor$annotations() {
    }

    @NotNull
    public final CellRendererPane getValidationParent() {
        return this.validationParent;
    }

    @NotNull
    public final JBList<PlaceData> getList() {
        return this.list;
    }

    public final void addPlace(@NotNull Place place, @NotNull Presentation presentation, @Nullable Function0<ProblemStats> counterProvider) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        this.listModel.addElement(new PlaceData(place, this.pendingSeparator, presentation, counterProvider));
        this.pendingSeparator = null;
    }

    public final void clear() {
        this.listModel.clear();
        this.pendingSeparator = null;
    }

    public final void addSeparator(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.pendingSeparator = text2;
    }

    public final void select(@NotNull Place place) {
        Object v1;
        JBList<PlaceData> jBList;
        block1: {
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            Enumeration<PlaceData> enumeration = this.listModel.elements();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"listModel.elements()");
            Sequence sequence = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
            jBList = this.list;
            Sequence sequence2 = sequence;
            for (Object e : sequence2) {
                PlaceData it = (PlaceData)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPlace(), (Object)place)) continue;
                v1 = e;
                break block1;
            }
            v1 = null;
        }
        jBList.setSelectedValue(v1, true);
    }

    public static final /* synthetic */ Place.Navigator access$getMyNavigator$p(SidePanel $this) {
        return $this.myNavigator;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/structure/dialog/SidePanel$ProblemStats;", "", "count", "", "containsErrors", "", "(IZ)V", "getContainsErrors", "()Z", "getCount", "()I", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "intellij.android.core"})
    public static final class ProblemStats {
        private final int count;
        private final boolean containsErrors;

        public ProblemStats(int count2, boolean containsErrors) {
            this.count = count2;
            this.containsErrors = containsErrors;
        }

        public final int getCount() {
            return this.count;
        }

        public final boolean getContainsErrors() {
            return this.containsErrors;
        }

        public final int component1() {
            return this.count;
        }

        public final boolean component2() {
            return this.containsErrors;
        }

        @NotNull
        public final ProblemStats copy(int count2, boolean containsErrors) {
            return new ProblemStats(count2, containsErrors);
        }

        public static /* synthetic */ ProblemStats copy$default(ProblemStats problemStats, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = problemStats.count;
            }
            if ((n2 & 2) != 0) {
                bl = problemStats.containsErrors;
            }
            return problemStats.copy(n, bl);
        }

        @NotNull
        public String toString() {
            return "ProblemStats(count=" + this.count + ", containsErrors=" + this.containsErrors + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.count);
            int n = this.containsErrors ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProblemStats)) {
                return false;
            }
            ProblemStats problemStats = (ProblemStats)other;
            if (this.count != problemStats.count) {
                return false;
            }
            return this.containsErrors == problemStats.containsErrors;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u0011\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/structure/dialog/SidePanel$PlaceData;", "", "place", "Lcom/intellij/ui/navigation/Place;", "separator", "", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "countProvider", "Lkotlin/Function0;", "Lcom/android/tools/idea/structure/dialog/SidePanel$ProblemStats;", "(Lcom/intellij/ui/navigation/Place;Ljava/lang/String;Lcom/intellij/openapi/actionSystem/Presentation;Lkotlin/jvm/functions/Function0;)V", "getCountProvider", "()Lkotlin/jvm/functions/Function0;", "getPlace", "()Lcom/intellij/ui/navigation/Place;", "getPresentation", "()Lcom/intellij/openapi/actionSystem/Presentation;", "getSeparator", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.core"})
    public static final class PlaceData {
        @NotNull
        private final Place place;
        @Nullable
        private final String separator;
        @NotNull
        private final Presentation presentation;
        @Nullable
        private final Function0<ProblemStats> countProvider;

        public PlaceData(@NotNull Place place, @Nullable String separator, @NotNull Presentation presentation, @Nullable Function0<ProblemStats> countProvider) {
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            this.place = place;
            this.separator = separator;
            this.presentation = presentation;
            this.countProvider = countProvider;
        }

        @NotNull
        public final Place getPlace() {
            return this.place;
        }

        @Nullable
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final Presentation getPresentation() {
            return this.presentation;
        }

        @Nullable
        public final Function0<ProblemStats> getCountProvider() {
            return this.countProvider;
        }

        @NotNull
        public final Place component1() {
            return this.place;
        }

        @Nullable
        public final String component2() {
            return this.separator;
        }

        @NotNull
        public final Presentation component3() {
            return this.presentation;
        }

        @Nullable
        public final Function0<ProblemStats> component4() {
            return this.countProvider;
        }

        @NotNull
        public final PlaceData copy(@NotNull Place place, @Nullable String separator, @NotNull Presentation presentation, @Nullable Function0<ProblemStats> countProvider) {
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            return new PlaceData(place, separator, presentation, countProvider);
        }

        public static /* synthetic */ PlaceData copy$default(PlaceData placeData, Place place, String string, Presentation presentation, Function0 function0, int n, Object object) {
            if ((n & 1) != 0) {
                place = placeData.place;
            }
            if ((n & 2) != 0) {
                string = placeData.separator;
            }
            if ((n & 4) != 0) {
                presentation = placeData.presentation;
            }
            if ((n & 8) != 0) {
                function0 = placeData.countProvider;
            }
            return placeData.copy(place, string, presentation, function0);
        }

        @NotNull
        public String toString() {
            return "PlaceData(place=" + this.place + ", separator=" + this.separator + ", presentation=" + this.presentation + ", countProvider=" + this.countProvider + ")";
        }

        public int hashCode() {
            int result2 = this.place.hashCode();
            result2 = result2 * 31 + (this.separator == null ? 0 : this.separator.hashCode());
            result2 = result2 * 31 + this.presentation.hashCode();
            result2 = result2 * 31 + (this.countProvider == null ? 0 : this.countProvider.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlaceData)) {
                return false;
            }
            PlaceData placeData = (PlaceData)other;
            if (!Intrinsics.areEqual((Object)this.place, (Object)placeData.place)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.separator, (Object)placeData.separator)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.presentation, (Object)placeData.presentation)) {
                return false;
            }
            return Intrinsics.areEqual(this.countProvider, placeData.countProvider);
        }
    }
}

