/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator.dialogs;

import com.android.emulator.control.SnapshotDetails;
import com.android.emulator.snapshot.SnapshotOuterClass;
import com.android.tools.idea.streaming.emulator.dialogs.SnapshotInfoKt;
import com.intellij.util.text.StringKt;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB-\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010*\u001a\u00020\u00132\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0004H\u0016R\u0011\u0010\u0016\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001cR\u001a\u0010\u0014\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u001c\"\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0011\u0010!\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0018R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010#R\u0011\u0010(\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001a\u00a8\u0006/"}, d2={"Lcom/android/tools/idea/streaming/emulator/dialogs/SnapshotInfo;", "", "prototype", "displayName", "", "description", "(Lcom/android/tools/idea/streaming/emulator/dialogs/SnapshotInfo;Ljava/lang/String;Ljava/lang/String;)V", "snapshotFolder", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "snapshotsFolder", "snapshotDetails", "Lcom/android/emulator/control/SnapshotDetails;", "(Ljava/nio/file/Path;Lcom/android/emulator/control/SnapshotDetails;)V", "snapshot", "Lcom/android/emulator/snapshot/SnapshotOuterClass$Snapshot;", "sizeOnDisk", "", "isCompatible", "", "isLoadedLast", "(Ljava/nio/file/Path;Lcom/android/emulator/snapshot/SnapshotOuterClass$Snapshot;JZZ)V", "creationTime", "getCreationTime", "()J", "getDescription", "()Ljava/lang/String;", "getDisplayName", "()Z", "isCreated", "setLoadedLast", "(Z)V", "isQuickBoot", "screenshotFile", "getScreenshotFile", "()Ljava/nio/file/Path;", "getSizeOnDisk", "getSnapshot", "()Lcom/android/emulator/snapshot/SnapshotOuterClass$Snapshot;", "getSnapshotFolder", "snapshotId", "getSnapshotId", "equals", "other", "hashCode", "", "toString", "intellij.android.streaming"})
public final class SnapshotInfo {
    @NotNull
    private final Path snapshotFolder;
    @NotNull
    private final SnapshotOuterClass.Snapshot snapshot;
    private final long sizeOnDisk;
    private final boolean isCompatible;
    private boolean isLoadedLast;
    @NotNull
    private final String snapshotId;
    private final boolean isQuickBoot;

    public SnapshotInfo(@NotNull Path snapshotFolder, @NotNull SnapshotOuterClass.Snapshot snapshot, long sizeOnDisk, boolean isCompatible, boolean isLoadedLast) {
        Intrinsics.checkNotNullParameter((Object)snapshotFolder, (String)"snapshotFolder");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.snapshotFolder = snapshotFolder;
        this.snapshot = snapshot;
        this.sizeOnDisk = sizeOnDisk;
        this.isCompatible = isCompatible;
        this.isLoadedLast = isLoadedLast;
        this.snapshotId = ((Object)this.snapshotFolder.getFileName()).toString();
        this.isQuickBoot = Intrinsics.areEqual((Object)this.snapshotId, (Object)"default_boot");
    }

    @NotNull
    public final Path getSnapshotFolder() {
        return this.snapshotFolder;
    }

    @NotNull
    public final SnapshotOuterClass.Snapshot getSnapshot() {
        return this.snapshot;
    }

    public final long getSizeOnDisk() {
        return this.sizeOnDisk;
    }

    public final boolean isCompatible() {
        return this.isCompatible;
    }

    public final boolean isLoadedLast() {
        return this.isLoadedLast;
    }

    public final void setLoadedLast(boolean bl) {
        this.isLoadedLast = bl;
    }

    public SnapshotInfo(@NotNull SnapshotInfo prototype, @NotNull String displayName2, @NotNull String description2) {
        Intrinsics.checkNotNullParameter((Object)prototype, (String)"prototype");
        Intrinsics.checkNotNullParameter((Object)displayName2, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        this(prototype.snapshotFolder, SnapshotInfoKt.access$withLogicalNameAndDescription(prototype.snapshot, Intrinsics.areEqual((Object)displayName2, (Object)prototype.snapshotId) ? "" : displayName2, description2), prototype.sizeOnDisk, prototype.isCompatible, prototype.isLoadedLast);
    }

    public SnapshotInfo(@NotNull Path snapshotFolder) {
        Intrinsics.checkNotNullParameter((Object)snapshotFolder, (String)"snapshotFolder");
        SnapshotOuterClass.Snapshot snapshot = SnapshotOuterClass.Snapshot.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)snapshot, (String)"getDefaultInstance()");
        this(snapshotFolder, snapshot, 0L, true, false);
    }

    public SnapshotInfo(@NotNull Path snapshotsFolder, @NotNull SnapshotDetails snapshotDetails) {
        Intrinsics.checkNotNullParameter((Object)snapshotsFolder, (String)"snapshotsFolder");
        Intrinsics.checkNotNullParameter((Object)snapshotDetails, (String)"snapshotDetails");
        Path path2 = snapshotsFolder.resolve(snapshotDetails.getSnapshotId());
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"snapshotsFolder.resolve(\u2026apshotDetails.snapshotId)");
        SnapshotOuterClass.Snapshot snapshot = snapshotDetails.getDetails();
        Intrinsics.checkNotNullExpressionValue((Object)snapshot, (String)"snapshotDetails.details");
        this(path2, snapshot, snapshotDetails.getSize(), snapshotDetails.getStatus() != SnapshotDetails.LoadStatus.Incompatible, snapshotDetails.getStatus() == SnapshotDetails.LoadStatus.Loaded);
    }

    @NotNull
    public final String getSnapshotId() {
        return this.snapshotId;
    }

    public final boolean isQuickBoot() {
        return this.isQuickBoot;
    }

    @NotNull
    public final String getDisplayName() {
        String string;
        if (this.isQuickBoot) {
            string = "Quickboot (auto-saved)";
        } else {
            string = StringKt.nullize$default((String)this.snapshot.getLogicalName(), (boolean)false, (int)1, null);
            if (string == null) {
                string = this.snapshotId;
            }
        }
        return string;
    }

    @NotNull
    public final Path getScreenshotFile() {
        Path path2 = this.snapshotFolder.resolve("screenshot.png");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"snapshotFolder.resolve(\"screenshot.png\")");
        return path2;
    }

    public final long getCreationTime() {
        return TimeUnit.SECONDS.toMillis(this.snapshot.getCreationTime());
    }

    @NotNull
    public final String getDescription() {
        String string = this.snapshot.getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"snapshot.description");
        return string;
    }

    public final boolean isCreated() {
        return this.snapshot.getCreationTime() != 0L;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.android.tools.idea.streaming.emulator.dialogs.SnapshotInfo");
        SnapshotInfo cfr_ignored_0 = (SnapshotInfo)other;
        return Intrinsics.areEqual((Object)this.snapshotFolder, (Object)((SnapshotInfo)other).snapshotFolder);
    }

    public int hashCode() {
        return ((Object)this.snapshotFolder).hashCode();
    }

    @NotNull
    public String toString() {
        StringBuilder buf = new StringBuilder("Snapshot " + this.snapshotId);
        if (!Intrinsics.areEqual((Object)this.getDisplayName(), (Object)this.snapshotId)) {
            buf.append(" (" + this.getDisplayName() + ")");
        }
        if (!this.isCompatible) {
            buf.append(" incompatible");
        }
        if (!this.isCreated()) {
            buf.append(" not created yet");
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
        return string;
    }
}

