/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator.dialogs;

import com.android.tools.adtui.util.HumanReadableUtil;
import com.android.tools.idea.streaming.emulator.dialogs.ManageSnapshotsDialog;
import com.android.tools.idea.streaming.emulator.dialogs.SnapshotInfo;
import com.intellij.util.text.JBDateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import javax.swing.ListSelectionModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u001a\u0016\u0010\u000b\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0011H\u0002\"\u0010\u0010\u0000\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\u00a8\u0006\u0014"}, d2={"DIMENSION_SERVICE_KEY", "", "HEADER_GAP", "", "QUICK_BOOT_SNAPSHOT_MODEL_ROW", "TIMESTAMP_FORMAT", "Ljava/text/SimpleDateFormat;", "isSingleItemSelected", "", "Ljavax/swing/ListSelectionModel;", "(Ljavax/swing/ListSelectionModel;)Z", "composeSnapshotId", "existingSnapshots", "", "Lcom/android/tools/idea/streaming/emulator/dialogs/SnapshotInfo;", "formatPrettySnapshotDateTime", "time", "", "formatSnapshotSize", "size", "intellij.android.streaming"})
public final class ManageSnapshotsDialogKt {
    @NotNull
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss", Locale.US);
    private static final int HEADER_GAP = 17;
    private static final int QUICK_BOOT_SNAPSHOT_MODEL_ROW = 0;
    @NonNls
    @NotNull
    private static final String DIMENSION_SERVICE_KEY = "#" + Reflection.getOrCreateKotlinClass(ManageSnapshotsDialog.class).getQualifiedName();

    private static final String formatPrettySnapshotDateTime(long time2) {
        String string;
        if (time2 > 0L) {
            String string2 = JBDateFormat.getFormatter().formatPrettyDateTime(time2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFormatter().formatPrettyDateTime(time)");
            string = StringsKt.replace$default((String)string2, (String)",", (String)"", (boolean)false, (int)4, null);
        } else {
            string = "-";
        }
        return string;
    }

    private static final String formatSnapshotSize(long size) {
        return size > 0L ? HumanReadableUtil.getHumanizedSize((long)size) : "-";
    }

    private static final String composeSnapshotId(Collection<SnapshotInfo> existingSnapshots) {
        String timestamp = TIMESTAMP_FORMAT.format(new Date());
        int counter = 0;
        int n = existingSnapshots.size();
        if (counter <= n) {
            while (true) {
                Object v0;
                String snapshotName;
                block4: {
                    Object suffix = counter == 0 ? "" : "_" + counter;
                    snapshotName = "snap_" + timestamp + (String)suffix;
                    Iterable iterable = existingSnapshots;
                    for (Object t : iterable) {
                        SnapshotInfo it = (SnapshotInfo)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getSnapshotId(), (Object)snapshotName)) continue;
                        v0 = t;
                        break block4;
                    }
                    v0 = null;
                }
                if (v0 == null) {
                    return snapshotName;
                }
                if (counter == n) break;
                ++counter;
            }
        }
        throw new AssertionError((Object)"Unable to create an unique snapshot ID");
    }

    private static final boolean isSingleItemSelected(ListSelectionModel $this$isSingleItemSelected) {
        return $this$isSingleItemSelected.getMinSelectionIndex() >= 0 && $this$isSingleItemSelected.getMinSelectionIndex() == $this$isSingleItemSelected.getMaxSelectionIndex();
    }

    public static final /* synthetic */ String access$composeSnapshotId(Collection existingSnapshots) {
        return ManageSnapshotsDialogKt.composeSnapshotId(existingSnapshots);
    }

    public static final /* synthetic */ boolean access$isSingleItemSelected(ListSelectionModel $receiver) {
        return ManageSnapshotsDialogKt.isSingleItemSelected($receiver);
    }

    public static final /* synthetic */ String access$formatPrettySnapshotDateTime(long time2) {
        return ManageSnapshotsDialogKt.formatPrettySnapshotDateTime(time2);
    }

    public static final /* synthetic */ String access$formatSnapshotSize(long size) {
        return ManageSnapshotsDialogKt.formatSnapshotSize(size);
    }

    public static final /* synthetic */ String access$getDIMENSION_SERVICE_KEY$p() {
        return DIMENSION_SERVICE_KEY;
    }
}

