/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.tools.idea.streaming.StreamingUtilsKt;
import com.android.tools.idea.streaming.emulator.AnchoredImage;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B1\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tJ8\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/streaming/emulator/SkinLayout;", "", "width", "", "height", "(II)V", "displaySize", "Ljava/awt/Dimension;", "frameRectangle", "Ljava/awt/Rectangle;", "frameImages", "", "Lcom/android/tools/idea/streaming/emulator/AnchoredImage;", "maskImages", "(Ljava/awt/Dimension;Ljava/awt/Rectangle;Ljava/util/List;Ljava/util/List;)V", "getDisplaySize", "()Ljava/awt/Dimension;", "getFrameImages", "()Ljava/util/List;", "getFrameRectangle", "()Ljava/awt/Rectangle;", "getMaskImages", "drawFrameAndMask", "", "g", "Ljava/awt/Graphics2D;", "displayRectangle", "drawImage", "anchoredImage", "scaleX", "", "scaleY", "transform", "Ljava/awt/geom/AffineTransform;", "intellij.android.streaming"})
public final class SkinLayout {
    @NotNull
    private final Dimension displaySize;
    @NotNull
    private final Rectangle frameRectangle;
    @NotNull
    private final List<AnchoredImage> frameImages;
    @NotNull
    private final List<AnchoredImage> maskImages;

    public SkinLayout(@NotNull Dimension displaySize, @NotNull Rectangle frameRectangle, @NotNull List<AnchoredImage> frameImages, @NotNull List<AnchoredImage> maskImages) {
        Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
        Intrinsics.checkNotNullParameter((Object)frameRectangle, (String)"frameRectangle");
        Intrinsics.checkNotNullParameter(frameImages, (String)"frameImages");
        Intrinsics.checkNotNullParameter(maskImages, (String)"maskImages");
        this.displaySize = displaySize;
        this.frameRectangle = frameRectangle;
        this.frameImages = frameImages;
        this.maskImages = maskImages;
    }

    @NotNull
    public final Dimension getDisplaySize() {
        return this.displaySize;
    }

    @NotNull
    public final Rectangle getFrameRectangle() {
        return this.frameRectangle;
    }

    @NotNull
    public final List<AnchoredImage> getFrameImages() {
        return this.frameImages;
    }

    @NotNull
    public final List<AnchoredImage> getMaskImages() {
        return this.maskImages;
    }

    public SkinLayout(int width, int height) {
        this(new Dimension(width, height), new Rectangle(0, 0, width, height), CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }

    public final void drawFrameAndMask(@NotNull Graphics2D g, @NotNull Rectangle displayRectangle) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)displayRectangle, (String)"displayRectangle");
        if (!((Collection)this.frameImages).isEmpty() || !((Collection)this.maskImages).isEmpty()) {
            double scaleX = (double)displayRectangle.width / (double)this.displaySize.width;
            double scaleY = (double)displayRectangle.height / (double)this.displaySize.height;
            AffineTransform transform2 = new AffineTransform();
            for (AnchoredImage image : this.frameImages) {
                this.drawImage(g, image, displayRectangle, scaleX, scaleY, transform2);
            }
            for (AnchoredImage image : this.maskImages) {
                this.drawImage(g, image, displayRectangle, scaleX, scaleY, transform2);
            }
        }
    }

    private final void drawImage(Graphics2D g, AnchoredImage anchoredImage, Rectangle displayRectangle, double scaleX, double scaleY, AffineTransform transform2) {
        int x = displayRectangle.x + anchoredImage.getAnchorPoint().getX() * displayRectangle.width + StreamingUtilsKt.scaled(anchoredImage.getOffset().x, scaleX);
        int y = displayRectangle.y + anchoredImage.getAnchorPoint().getY() * displayRectangle.height + StreamingUtilsKt.scaled(anchoredImage.getOffset().y, scaleY);
        transform2.setToTranslation(x, y);
        transform2.scale(scaleX, scaleY);
        g.drawImage(anchoredImage.getImage(), transform2, null);
    }
}

