/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u000eJ\b\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u000eH\u0002J\b\u0010\u001a\u001a\u00020\u000eH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/streaming/emulator/NotificationHolderPanel;", "Lcom/intellij/ui/components/JBLayeredPane;", "contentPanel", "Ljava/awt/Component;", "(Ljava/awt/Component;)V", "animator", "Lcom/intellij/util/ui/Animator;", "notificationContent", "Lcom/intellij/ui/EditorNotificationPanel;", "notificationPopup", "Lcom/android/tools/idea/streaming/emulator/NotificationHolderPanel$NotificationPopup;", "notificationVisible", "", "doLayout", "", "getPreferredSize", "Ljava/awt/Dimension;", "hideNotification", "hideNotificationPopup", "paintChildren", "g", "Ljava/awt/Graphics;", "showNotification", "text", "", "startAnimation", "stopAnimation", "FadeOutAnimator", "NotificationPopup", "intellij.android.streaming"})
public final class NotificationHolderPanel
extends JBLayeredPane {
    @NotNull
    private final EditorNotificationPanel notificationContent;
    @NotNull
    private final NotificationPopup notificationPopup;
    @Nullable
    private Animator animator;
    private boolean notificationVisible;

    public NotificationHolderPanel(@NotNull Component contentPanel2) {
        Intrinsics.checkNotNullParameter((Object)contentPanel2, (String)"contentPanel");
        this.notificationContent = new EditorNotificationPanel(HintUtil.INFORMATION_COLOR_KEY);
        this.notificationPopup = new NotificationPopup(this.notificationContent);
        this.setBorder((Border)JBUI.Borders.empty());
        Integer n = JBLayeredPane.DEFAULT_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"DEFAULT_LAYER");
        this.setLayer(contentPanel2, ((Number)n).intValue());
        this.add(contentPanel2);
        Component component2 = (Component)((Object)this.notificationPopup);
        Integer n2 = JBLayeredPane.POPUP_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"POPUP_LAYER");
        this.setLayer(component2, ((Number)n2).intValue());
        this.notificationPopup.setOpaque(false);
    }

    public void doLayout() {
        Component[] componentArray = this.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"components");
        for (Component component2 : componentArray) {
            component2.setBounds(0, 0, this.getWidth(), component2 == this.notificationPopup ? this.notificationPopup.getPreferredSize().height : this.getHeight());
        }
    }

    @NotNull
    public Dimension getPreferredSize() {
        Component mainComponent;
        Object object;
        block2: {
            Component[] componentArray = this.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"components");
            for (Object object2 : (Object[])componentArray) {
                Component it = (Component)object2;
                boolean bl = false;
                if (!(it != this.notificationPopup)) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        Component component2 = mainComponent = (Component)object;
        Dimension dimension2 = component2 != null ? component2.getPreferredSize() : null;
        if (dimension2 == null) {
            Dimension dimension3 = super.getPreferredSize();
            dimension2 = dimension3;
            Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"super.getPreferredSize()");
        }
        return dimension2;
    }

    protected void paintChildren(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.notificationVisible) {
            BufferedImage bufferedImage = UIUtil.createImage((Component)((Component)((Object)this)), (int)this.getWidth(), (int)this.getHeight(), (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(this, width,\u2026feredImage.TYPE_INT_ARGB)");
            BufferedImage image = bufferedImage;
            Graphics2D graphics2D = image.createGraphics();
            Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"image.createGraphics()");
            Graphics2D g2d = graphics2D;
            super.paintChildren(g);
            g2d.dispose();
            UIUtil.drawImage((Graphics)g, (Image)image, (Rectangle)new Rectangle(this.getWidth(), this.getHeight()), (Rectangle)new Rectangle(image.getWidth(null), image.getHeight(null)), null);
        } else {
            super.paintChildren(g);
        }
    }

    public final void showNotification(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.notificationContent.setText(text2);
        if (!this.notificationVisible) {
            this.add((Component)((Object)this.notificationPopup));
            this.notificationVisible = true;
        }
        this.startAnimation();
        this.revalidate();
    }

    public final void hideNotification() {
        this.stopAnimation();
        this.hideNotificationPopup();
    }

    private final void hideNotificationPopup() {
        if (this.notificationVisible) {
            this.remove((Component)((Object)this.notificationPopup));
            this.notificationVisible = false;
            this.revalidate();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void startAnimation() {
        void $this$startAnimation_u24lambda_u2d1;
        FadeOutAnimator fadeOutAnimator;
        Animator animator = this.animator;
        if (animator != null) {
            Disposable p0 = (Disposable)animator;
            boolean bl = false;
            Disposer.dispose((Disposable)p0);
        }
        this.notificationPopup.setAlpha(1.0f);
        FadeOutAnimator fadeOutAnimator2 = fadeOutAnimator = new FadeOutAnimator();
        NotificationHolderPanel notificationHolderPanel = this;
        boolean bl = false;
        $this$startAnimation_u24lambda_u2d1.resume();
        notificationHolderPanel.animator = fadeOutAnimator;
    }

    private final void stopAnimation() {
        Animator animator = this.animator;
        if (animator != null) {
            Disposable p0 = (Disposable)animator;
            boolean bl = false;
            Disposer.dispose((Disposable)p0);
        }
        this.animator = null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/streaming/emulator/NotificationHolderPanel$NotificationPopup;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "notificationPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "(Lcom/intellij/ui/EditorNotificationPanel;)V", "alpha", "", "getAlpha", "()F", "setAlpha", "(F)V", "paint", "", "g", "Ljava/awt/Graphics;", "intellij.android.streaming"})
    private static final class NotificationPopup
    extends BorderLayoutPanel {
        private float alpha;

        public NotificationPopup(@NotNull EditorNotificationPanel notificationPanel) {
            Intrinsics.checkNotNullParameter((Object)notificationPanel, (String)"notificationPanel");
            this.alpha = 1.0f;
            this.setBorder(IdeBorderFactory.createBorder((Color)JBColor.border(), (int)8));
            this.addToCenter((Component)notificationPanel);
        }

        public final float getAlpha() {
            return this.alpha;
        }

        public final void setAlpha(float f) {
            this.alpha = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (this.alpha == 1.0f) {
                super.paint(g);
            } else {
                Graphics graphics = g.create();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D g2d = (Graphics2D)graphics;
                try {
                    g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                    super.paint((Graphics)g2d);
                }
                finally {
                    g2d.dispose();
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0014J \u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/streaming/emulator/NotificationHolderPanel$FadeOutAnimator;", "Lcom/intellij/util/ui/Animator;", "(Lcom/android/tools/idea/streaming/emulator/NotificationHolderPanel;)V", "dispose", "", "paintCycleEnd", "paintNow", "frame", "", "totalFrames", "cycle", "intellij.android.streaming"})
    private final class FadeOutAnimator
    extends Animator {
        public FadeOutAnimator() {
            super("FadeOutAnimator", 150, 5000, false);
        }

        public void paintNow(int frame, int totalFrames, int cycle) {
            float alpha = (float)Math.cos(1.5707963267948966 * (double)frame / (double)totalFrames);
            if ((double)Math.abs(alpha - NotificationHolderPanel.this.notificationPopup.getAlpha()) >= 0.005) {
                NotificationHolderPanel.this.notificationPopup.setAlpha(alpha);
                NotificationHolderPanel.this.notificationPopup.paintImmediately(0, 0, NotificationHolderPanel.this.notificationPopup.getWidth(), NotificationHolderPanel.this.notificationPopup.getHeight());
            }
        }

        protected void paintCycleEnd() {
            if (!GraphicsEnvironment.isHeadless()) {
                NotificationHolderPanel.this.hideNotificationPopup();
            }
            Disposer.dispose((Disposable)((Disposable)this));
        }

        public void dispose() {
            super.dispose();
            NotificationHolderPanel.this.animator = null;
        }
    }
}

