/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.tools.idea.streaming.emulator.KeyValueFiles;
import com.google.common.base.Splitter;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\r\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u0002\u001a.\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0011\u001a$\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\r\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"KEY_VALUE_SPLITTER", "Lcom/google/common/base/Splitter;", "kotlin.jvm.PlatformType", "logError", "", "message", "", "e", "Ljava/io/IOException;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "readKeyValueFile", "", "file", "Ljava/nio/file/Path;", "keysToExtract", "", "updateKeyValueFile", "updates", "intellij.android.streaming"})
@JvmName(name="KeyValueFiles")
public final class KeyValueFiles {
    private static final Splitter KEY_VALUE_SPLITTER = Splitter.on((char)'=').trimResults();

    @Nullable
    public static final Map<String, String> readKeyValueFile(@NotNull Path file2, @Nullable Set<String> keysToExtract) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Map result2 = new LinkedHashMap();
        try {
            for (String line2 : Files.readAllLines(file2)) {
                Object e;
                Object e2;
                List keyValue = KEY_VALUE_SPLITTER.splitToList((CharSequence)line2);
                if (keyValue.size() != 2 || keysToExtract != null && !keysToExtract.contains(keyValue.get(0))) continue;
                Map map2 = result2;
                Intrinsics.checkNotNullExpressionValue(keyValue.get(0), (String)"keyValue[0]");
                Intrinsics.checkNotNullExpressionValue(keyValue.get(1), (String)"keyValue[1]");
                map2.put(e2, e);
            }
            return result2;
        }
        catch (IOException e) {
            KeyValueFiles.logError("Error reading " + file2, e);
            return null;
        }
    }

    public static /* synthetic */ Map readKeyValueFile$default(Path path2, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = null;
        }
        return KeyValueFiles.readKeyValueFile(path2, set);
    }

    public static final void updateKeyValueFile(@NotNull Path file2, @NotNull Map<String, String> updates) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(updates, (String)"updates");
        Map map2 = KeyValueFiles.readKeyValueFile$default(file2, null, 2, null);
        if (map2 == null) {
            return;
        }
        Map originalContents = map2;
        TreeMap<String, String> sortedContents = new TreeMap<String, String>(originalContents);
        sortedContents.putAll(updates);
        Set set = sortedContents.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"sortedContents.entries");
        List lines2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)updateKeyValueFile.lines.1.INSTANCE), (Function1)updateKeyValueFile.lines.2.INSTANCE));
        Path tempFile = file2.resolveSibling(file2.getFileName() + ".temp");
        try {
            Object[] objectArray = new OpenOption[]{StandardOpenOption.CREATE};
            Files.write(tempFile, (Iterable<? extends CharSequence>)lines2, Charsets.UTF_8, (OpenOption[])objectArray);
            objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE};
            Files.move(tempFile, file2, (CopyOption[])objectArray);
        }
        catch (IOException e) {
            try {
                Files.deleteIfExists(tempFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            KeyValueFiles.logError("Error writing " + file2, e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void logError(String message2, IOException e) {
        Object object;
        Logger logger2;
        block3: {
            block2: {
                void it;
                logger2 = KeyValueFiles.logger();
                object = e.getMessage();
                if (object == null) break block2;
                String string = object;
                Logger logger3 = logger2;
                boolean bl = false;
                String string2 = message2 + " - " + (String)it;
                logger2 = logger3;
                object = string2;
                if (string2 != null) break block3;
            }
            object = message2;
        }
        logger2.error((String)object);
    }

    private static final Logger logger() {
        Logger logger2 = Logger.getInstance((String)"#com.android.tools.idea.streaming.emulator.KeyValueFileUtils");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(\"#com.androi\u2026lator.KeyValueFileUtils\")");
        return logger2;
    }
}

