/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.UiThread;
import com.android.emulator.ImageConverter;
import com.android.emulator.control.DisplayModeValue;
import com.android.emulator.control.FoldedDisplay;
import com.android.emulator.control.Image;
import com.android.emulator.control.ImageFormat;
import com.android.emulator.control.KeyboardEvent;
import com.android.emulator.control.MouseEvent;
import com.android.emulator.control.Notification;
import com.android.emulator.control.Rotation;
import com.android.emulator.control.RotationRadian;
import com.android.emulator.control.Touch;
import com.android.emulator.control.TouchEvent;
import com.android.ide.common.util.Cancelable;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.adtui.common.AdtUiCursorType;
import com.android.tools.adtui.common.AdtUiCursorsProvider;
import com.android.tools.analytics.HistogramUtil;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.streaming.AbstractDisplayView;
import com.android.tools.idea.streaming.EmulatorSettings;
import com.android.tools.idea.streaming.StreamingConstants;
import com.android.tools.idea.streaming.StreamingUtilsKt;
import com.android.tools.idea.streaming.emulator.DisplayConfigurationListener;
import com.android.tools.idea.streaming.emulator.EmptyStreamObserver;
import com.android.tools.idea.streaming.emulator.EmulatorConfiguration;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.streaming.emulator.EmulatorView;
import com.android.tools.idea.streaming.emulator.EmulatorViewKt;
import com.android.tools.idea.streaming.emulator.NotificationHolderPanel;
import com.android.tools.idea.streaming.emulator.SkinDefinition;
import com.android.tools.idea.streaming.emulator.SkinLayout;
import com.android.tools.idea.streaming.emulator.VirtualSceneCameraVelocityController;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.util.Alarm;
import com.intellij.util.SofterReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.HdrHistogram.Histogram;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0014\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0010\u008c\u0001\u008d\u0001\u008e\u0001\u008f\u0001\u0090\u0001\u0091\u0001\u0092\u0001\u0093\u0001B/\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020$J\b\u0010d\u001a\u00020\fH\u0014J\b\u0010e\u001a\u00020bH\u0002J\b\u0010f\u001a\u00020bH\u0002J\b\u0010g\u001a\u00020\nH\u0014J\u0010\u0010g\u001a\u00020\n2\u0006\u0010h\u001a\u00020\bH\u0002J\u0010\u0010i\u001a\u00020\u00152\u0006\u0010j\u001a\u00020kH\u0002J\u0018\u0010l\u001a\u00020b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010m\u001a\u00020nH\u0016J\u0015\u0010o\u001a\u00020b2\u0006\u0010p\u001a\u00020qH\u0000\u00a2\u0006\u0002\brJ\b\u0010s\u001a\u00020bH\u0016J\u0010\u0010t\u001a\u00020\b2\u0006\u0010u\u001a\u00020\bH\u0002J\b\u0010v\u001a\u00020bH\u0002J\b\u0010w\u001a\u00020bH\u0002J\u0010\u0010x\u001a\u00020b2\u0006\u0010y\u001a\u00020zH\u0014J\u000e\u0010{\u001a\u00020b2\u0006\u0010c\u001a\u00020$J\b\u0010|\u001a\u00020bH\u0002J\b\u0010}\u001a\u00020bH\u0002J\u0018\u0010}\u001a\u00020b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010h\u001a\u00020\bH\u0002J\u001b\u0010~\u001a\u00020b2\u0007\u0010\u007f\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u0080\u0001H\u0002J-\u0010\u0082\u0001\u001a\u00020b2\u0007\u0010\u0083\u0001\u001a\u00020\b2\u0007\u0010\u0084\u0001\u001a\u00020\b2\u0007\u0010\u0085\u0001\u001a\u00020\b2\u0007\u0010\u0086\u0001\u001a\u00020\bH\u0016J\u0014\u0010\u0087\u0001\u001a\u00020b2\t\b\u0002\u0010\u0088\u0001\u001a\u00020\u001fH\u0002J\t\u0010\u0089\u0001\u001a\u00020bH\u0002J\t\u0010\u008a\u0001\u001a\u00020bH\u0002J\u0011\u0010\u008b\u0001\u001a\u00020b2\u0006\u0010m\u001a\u00020nH\u0002R\u0014\u0010\u000e\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\n8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R$\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0010\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\u0004\u0018\u00010&8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R$\u0010)\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b8V@PX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010.\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0013R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R \u0010:\u001a\u0002092\u0006\u00108\u001a\u0002098G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0014\u0010=\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010+R\u0010\u0010?\u001a\u0004\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u0004\u0018\u00010BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010C\u001a\u00060DR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010E\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\bF\u0010\u001dR\u0010\u0010G\u001a\u0004\u0018\u00010HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010I\u001a\b\u0018\u00010JR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010L\u001a\u0004\u0018\u00010HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010M\u001a\b\u0018\u00010NR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010O\u001a\u00020P8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010RR\u0010\u0010S\u001a\u0004\u0018\u00010TX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010U\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\bV\u0010\u001dR\u001e\u0010W\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\bX\u0010\u001dR\u0010\u0010Y\u001a\u0004\u0018\u00010ZX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010[\u001a\n ]*\u0004\u0018\u00010\\0\\*\u00020^8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b_\u0010`\u00a8\u0006\u0094\u0001"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView;", "Lcom/android/tools/idea/streaming/AbstractDisplayView;", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionStateListener;", "Lcom/intellij/openapi/Disposable;", "disposableParent", "emulator", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "displayId", "", "displaySize", "Ljava/awt/Dimension;", "deviceFrameVisible", "", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/streaming/emulator/EmulatorController;ILjava/awt/Dimension;Z)V", "connected", "getConnected", "()Z", "currentDisplaySize", "getCurrentDisplaySize", "()Ljava/awt/Dimension;", "deviceDisplayRegion", "Ljava/awt/Rectangle;", "getDeviceDisplayRegion", "()Ljava/awt/Rectangle;", "deviceDisplaySize", "getDeviceDisplaySize$intellij_android_streaming", "value", "getDeviceFrameVisible", "setDeviceFrameVisible", "(Z)V", "deviceSerialNumber", "", "getDeviceSerialNumber", "()Ljava/lang/String;", "displayConfigurationListeners", "", "Lcom/android/tools/idea/streaming/emulator/DisplayConfigurationListener;", "displayMode", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;", "getDisplayMode$intellij_android_streaming", "()Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;", "displayOrientationQuadrants", "getDisplayOrientationQuadrants", "()I", "setDisplayOrientationQuadrants$intellij_android_streaming", "(I)V", "displaySizeWithFrame", "getDisplaySizeWithFrame", "displayTransform", "Ljava/awt/geom/AffineTransform;", "getEmulator", "()Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "emulatorConfig", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration;", "getEmulatorConfig", "()Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration;", "<set-?>", "", "frameTimestampMillis", "getFrameTimestampMillis", "()J", "initialOrientation", "getInitialOrientation", "lastScreenshot", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$Screenshot;", "lastTouchCoordinates", "Ljava/awt/Point;", "mouseListener", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$MyMouseListener;", "multiTouchMode", "setMultiTouchMode", "notificationFeed", "Lcom/android/ide/common/util/Cancelable;", "notificationReceiver", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$NotificationReceiver;", "receivedFrameCount", "screenshotFeed", "screenshotReceiver", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$ScreenshotReceiver;", "screenshotShape", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$DisplayShape;", "getScreenshotShape", "()Lcom/android/tools/idea/streaming/emulator/EmulatorView$DisplayShape;", "stats", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$Stats;", "virtualSceneCameraActive", "setVirtualSceneCameraActive", "virtualSceneCameraOperating", "setVirtualSceneCameraOperating", "virtualSceneCameraVelocityController", "Lcom/android/tools/idea/streaming/emulator/VirtualSceneCameraVelocityController;", "rootPane", "Ljavax/swing/JRootPane;", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/wm/IdeGlassPane;", "getRootPane", "(Lcom/intellij/openapi/wm/IdeGlassPane;)Ljavax/swing/JRootPane;", "addDisplayConfigurationListener", "", "listener", "canZoom", "cancelNotificationFeed", "cancelScreenshotFeed", "computeActualSize", "orientationQuadrants", "computeDisplayRectangle", "skin", "Lcom/android/tools/idea/streaming/emulator/SkinLayout;", "connectionStateChanged", "connectionState", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionState;", "displayModeChanged", "displayModeId", "Lcom/android/emulator/control/DisplayModeValue;", "displayModeChanged$intellij_android_streaming", "dispose", "getButtonBit", "button", "hideVirtualSceneCameraPrompt", "notifyEmulatorIsOutOfDate", "paintComponent", "g", "Ljava/awt/Graphics;", "removeDisplayConfigurationListener", "requestNotificationFeed", "requestScreenshotFeed", "rotateVirtualSceneCamera", "rotationX", "", "rotationY", "setBounds", "x", "y", "width", "height", "showVirtualSceneCameraPrompt", "prompt", "startOperatingVirtualSceneCamera", "stopOperatingVirtualSceneCamera", "updateConnectionState", "DisplayShape", "MyKeyListener", "MyMouseListener", "NotificationReceiver", "Screenshot", "ScreenshotReceiver", "SkinLayoutCache", "Stats", "intellij.android.streaming"})
public final class EmulatorView
extends AbstractDisplayView
implements EmulatorController.ConnectionStateListener,
Disposable {
    @NotNull
    private final EmulatorController emulator;
    @Nullable
    private final Dimension displaySize;
    @Nullable
    private Screenshot lastScreenshot;
    @NotNull
    private final AffineTransform displayTransform;
    private long frameTimestampMillis;
    private int receivedFrameCount;
    @Nullable
    private Cancelable screenshotFeed;
    @Nullable
    private volatile ScreenshotReceiver screenshotReceiver;
    @Nullable
    private Cancelable notificationFeed;
    @Nullable
    private volatile NotificationReceiver notificationReceiver;
    @NotNull
    private final List<DisplayConfigurationListener> displayConfigurationListeners;
    private boolean deviceFrameVisible;
    private boolean multiTouchMode;
    @NotNull
    private final MyMouseListener mouseListener;
    @Nullable
    private Point lastTouchCoordinates;
    private boolean virtualSceneCameraActive;
    private boolean virtualSceneCameraOperating;
    @Nullable
    private VirtualSceneCameraVelocityController virtualSceneCameraVelocityController;
    @Nullable
    private final Stats stats;

    public EmulatorView(@NotNull Disposable disposableParent, @NotNull EmulatorController emulator, final int displayId, @Nullable Dimension displaySize, boolean deviceFrameVisible) {
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        Intrinsics.checkNotNullParameter((Object)emulator, (String)"emulator");
        super(displayId);
        this.emulator = emulator;
        this.displaySize = displaySize;
        this.displayTransform = new AffineTransform();
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createLockFreeCopyOnWriteList()");
        this.displayConfigurationListeners = list2;
        this.deviceFrameVisible = deviceFrameVisible;
        this.mouseListener = new MyMouseListener();
        Object t = StudioFlags.EMBEDDED_EMULATOR_SCREENSHOT_STATISTICS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_SCREENSHOT_STATISTICS.get()");
        this.stats = (Boolean)t != false ? new Stats() : null;
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        this.emulator.addConnectionStateListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(@NotNull ComponentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.requestScreenshotFeed();
                if (displayId == 0) {
                    this.requestNotificationFeed();
                }
            }
        });
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.addKeyListener(new MyKeyListener());
        if (displayId == 0) {
            this.showLongRunningOperationIndicator("Connecting to the Emulator");
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(@NotNull FocusEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (virtualSceneCameraActive) {
                        EmulatorView.showVirtualSceneCameraPrompt$default(this, null, 1, null);
                    }
                }

                @Override
                public void focusLost(@NotNull FocusEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.hideVirtualSceneCameraPrompt();
                }
            });
        }
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"getApplication().messageBus.connect(this)");
        MessageBusConnection connection2 = messageBusConnection;
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection2.subscribe(topic, (Object)new LafManagerListener(){

            public final void lookAndFeelChanged(@NotNull LafManager lafManager) {
                Intrinsics.checkNotNullParameter((Object)lafManager, (String)"lafManager");
                if (this.getConnected()) {
                    EmulatorController.setUiTheme$default(this.getEmulator(), StreamingUtilsKt.getEmulatorUiTheme(lafManager), null, 2, null);
                }
            }
        });
        this.updateConnectionState(this.emulator.getConnectionState());
    }

    @NotNull
    public final EmulatorController getEmulator() {
        return this.emulator;
    }

    @Override
    public int getDisplayOrientationQuadrants() {
        return this.getScreenshotShape().getOrientation();
    }

    public void setDisplayOrientationQuadrants$intellij_android_streaming(int value2) {
        if (value2 != this.getScreenshotShape().getOrientation() && this.deviceFrameVisible) {
            this.requestScreenshotFeed(this.getCurrentDisplaySize(), value2);
        }
    }

    private final DisplayShape getScreenshotShape() {
        Object object = this.lastScreenshot;
        if (object == null || (object = ((Screenshot)object).getDisplayShape()) == null) {
            object = new DisplayShape(0, 0, this.getInitialOrientation(), null, null, 0, 56, null);
        }
        return object;
    }

    private final int getInitialOrientation() {
        return this.getDisplayId() == 0 ? this.getEmulatorConfig().getInitialOrientation().getNumber() : Rotation.SkinRotation.PORTRAIT.getNumber();
    }

    private final Dimension getCurrentDisplaySize() {
        Rectangle rectangle = this.getScreenshotShape().getActiveDisplayRegion();
        Dimension dimension2 = rectangle != null ? rectangle.getSize() : null;
        if (dimension2 == null) {
            dimension2 = this.getDeviceDisplaySize$intellij_android_streaming();
        }
        return dimension2;
    }

    private final Rectangle getDeviceDisplayRegion() {
        Rectangle rectangle = this.getScreenshotShape().getActiveDisplayRegion();
        if (rectangle == null) {
            rectangle = new Rectangle(this.getDeviceDisplaySize$intellij_android_streaming());
        }
        return rectangle;
    }

    @Nullable
    public final EmulatorConfiguration.DisplayMode getDisplayMode$intellij_android_streaming() {
        EmulatorConfiguration.DisplayMode displayMode = this.getScreenshotShape().getDisplayMode();
        if (displayMode == null) {
            displayMode = (EmulatorConfiguration.DisplayMode)CollectionsKt.firstOrNull(this.getEmulatorConfig().getDisplayModes());
        }
        return displayMode;
    }

    @Override
    @NotNull
    public Dimension getDeviceDisplaySize$intellij_android_streaming() {
        Dimension dimension2 = this.displaySize;
        if (dimension2 == null) {
            dimension2 = this.getEmulatorConfig().getDisplaySize();
        }
        return dimension2;
    }

    @Override
    @NotNull
    public String getDeviceSerialNumber() {
        return this.emulator.getEmulatorId().getSerialNumber();
    }

    @VisibleForTesting
    public final long getFrameTimestampMillis() {
        return this.frameTimestampMillis;
    }

    public final boolean getDeviceFrameVisible() {
        return this.deviceFrameVisible;
    }

    public final void setDeviceFrameVisible(boolean value2) {
        if (this.deviceFrameVisible != value2) {
            this.deviceFrameVisible = value2;
            this.requestScreenshotFeed();
        }
    }

    private final boolean getConnected() {
        return this.emulator.getConnectionState() == EmulatorController.ConnectionState.CONNECTED;
    }

    private final EmulatorConfiguration getEmulatorConfig() {
        return this.emulator.getEmulatorConfig();
    }

    @NotNull
    public final Dimension getDisplaySizeWithFrame() {
        return this.computeActualSize(this.getScreenshotShape().getOrientation());
    }

    private final void setMultiTouchMode(boolean value2) {
        if (value2 != this.multiTouchMode) {
            if (!value2) {
                this.mouseListener.terminateDragging();
            }
            this.multiTouchMode = value2;
            this.repaint();
        }
    }

    private final void setVirtualSceneCameraActive(boolean value2) {
        if (value2 != this.virtualSceneCameraActive) {
            this.virtualSceneCameraActive = value2;
            if (value2) {
                this.setMultiTouchMode(false);
                if (this.isFocusOwner()) {
                    EmulatorView.showVirtualSceneCameraPrompt$default(this, null, 1, null);
                }
            } else {
                this.setVirtualSceneCameraOperating(false);
                this.hideVirtualSceneCameraPrompt();
            }
        }
    }

    private final void setVirtualSceneCameraOperating(boolean value2) {
        if (value2 != this.virtualSceneCameraOperating) {
            this.virtualSceneCameraOperating = value2;
            if (value2) {
                this.startOperatingVirtualSceneCamera();
            } else {
                this.stopOperatingVirtualSceneCamera();
            }
        }
    }

    public void dispose() {
        block0: {
            this.cancelNotificationFeed();
            this.cancelScreenshotFeed();
            this.emulator.removeConnectionStateListener(this);
            Stats stats = this.stats;
            if (stats == null) break block0;
            Stats it = stats;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
    }

    public final void addDisplayConfigurationListener(@NotNull DisplayConfigurationListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.displayConfigurationListeners.add(listener2);
    }

    public final void removeDisplayConfigurationListener(@NotNull DisplayConfigurationListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.displayConfigurationListeners.remove(listener2);
    }

    @Override
    protected boolean canZoom() {
        return this.getConnected();
    }

    @Override
    @NotNull
    protected Dimension computeActualSize() {
        return this.computeActualSize(this.getScreenshotShape().getOrientation());
    }

    private final Dimension computeActualSize(int orientationQuadrants) {
        SkinDefinition skin = this.emulator.getSkinDefinition$intellij_android_streaming();
        return skin != null && this.deviceFrameVisible ? skin.getRotatedFrameSize(orientationQuadrants, this.getCurrentDisplaySize()) : StreamingUtilsKt.rotatedByQuadrants(this.getCurrentDisplaySize(), orientationQuadrants);
    }

    public void setBounds(int x, int y, int width, int height) {
        boolean resized = width != this.getWidth() || height != this.getHeight();
        super.setBounds(x, y, width, height);
        if (resized) {
            this.requestScreenshotFeed();
        }
    }

    @Override
    public void connectionStateChanged(@NotNull EmulatorController emulator, @NotNull EmulatorController.ConnectionState connectionState) {
        Intrinsics.checkNotNullParameter((Object)emulator, (String)"emulator");
        Intrinsics.checkNotNullParameter((Object)((Object)connectionState), (String)"connectionState");
        EventQueue.invokeLater(new Runnable(this, connectionState){
            final /* synthetic */ EmulatorView this$0;
            final /* synthetic */ EmulatorController.ConnectionState $connectionState;
            {
                this.this$0 = $receiver;
                this.$connectionState = $connectionState;
            }

            public final void run() {
                EmulatorView.access$updateConnectionState(this.this$0, this.$connectionState);
            }
        });
    }

    private final void updateConnectionState(EmulatorController.ConnectionState connectionState) {
        if (connectionState == EmulatorController.ConnectionState.CONNECTED) {
            this.hideDisconnectedStateMessage();
            if (this.isVisible()) {
                if (this.screenshotFeed == null) {
                    this.requestScreenshotFeed();
                }
                if (this.getDisplayId() == 0 && this.notificationFeed == null) {
                    this.requestNotificationFeed();
                }
            }
        } else if (connectionState == EmulatorController.ConnectionState.DISCONNECTED) {
            this.lastScreenshot = null;
            AbstractDisplayView.showDisconnectedStateMessage$default(this, "Disconnected from the Emulator", null, 2, null);
        }
        this.repaint();
    }

    private final void notifyEmulatorIsOutOfDate() {
        if (EmulatorViewKt.access$getEmulatorOutOfDateNotificationShown$p()) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)((Object)this)));
        if (project == null) {
            return;
        }
        Project project2 = project;
        String title = "Emulator is out of date";
        String string = XmlStringUtil.wrapInHtml((CharSequence)"Please update the Android Emulator");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrapInHtml(\"Please update the Android Emulator\")");
        String message2 = string;
        com.intellij.notification.Notification notification = StreamingConstants.getRUNNING_DEVICES_NOTIFICATION_GROUP().createNotification(title, message2, NotificationType.WARNING);
        notification.setCollapseDirection(Notification.CollapseActionsDirection.KEEP_LEFTMOST);
        notification.addAction((AnAction)new NotificationAction(){

            public void actionPerformed(@NotNull AnActionEvent event, @NotNull com.intellij.notification.Notification notification) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                notification.expire();
                AnAction action2 = ActionManager.getInstance().getAction("CheckForUpdate");
                action2.actionPerformed(event);
            }
        });
        notification.notify(project2);
        EmulatorViewKt.access$setEmulatorOutOfDateNotificationShown$p(true);
    }

    protected void paintComponent(@NotNull Graphics g) {
        block8: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paintComponent(g);
            Screenshot screenshot = this.lastScreenshot;
            if (screenshot == null) {
                return;
            }
            Screenshot screenshot2 = screenshot;
            SkinLayout skin = screenshot2.getSkinLayout();
            boolean bl2 = bl = this.getScreenshotShape().getWidth() != 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean bl3 = bl = this.getScreenshotShape().getHeight() != 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Rectangle displayRect = this.computeDisplayRectangle(skin);
            this.setDisplayRectangle(displayRect);
            Graphics2D cfr_ignored_0 = (Graphics2D)g;
            double physicalToVirtualScale = 1.0 / this.getScreenScale();
            ((Graphics2D)g).scale(physicalToVirtualScale, physicalToVirtualScale);
            if (displayRect.width == this.getScreenshotShape().getWidth() && displayRect.height == this.getScreenshotShape().getHeight()) {
                ((Graphics2D)g).drawImage(screenshot2.getImage(), null, displayRect.x, displayRect.y);
            } else {
                this.displayTransform.setToTranslation(displayRect.x, displayRect.y);
                this.displayTransform.scale((double)displayRect.width / (double)this.getScreenshotShape().getWidth(), (double)displayRect.height / (double)this.getScreenshotShape().getHeight());
                ((Graphics2D)g).drawImage(screenshot2.getImage(), this.displayTransform, null);
            }
            this.setFrameNumber(this.getScreenshotShape().getFrameNumber());
            this.notifyFrameListeners(displayRect, screenshot2.getImage());
            if (this.multiTouchMode) {
                this.drawMultiTouchFeedback((Graphics2D)g, displayRect, this.lastTouchCoordinates != null);
            }
            if (this.deviceFrameVisible) {
                skin.drawFrameAndMask((Graphics2D)g, displayRect);
            }
            if (screenshot2.getPainted()) break block8;
            screenshot2.setPainted(true);
            long paintTime = System.currentTimeMillis();
            Stats stats = this.stats;
            if (stats != null) {
                stats.recordLatencyEndToEnd(paintTime - screenshot2.getFrameOriginationTime());
            }
        }
    }

    private final Rectangle computeDisplayRectangle(SkinLayout skin) {
        Rectangle rectangle;
        Dimension maxSize = this.computeMaxImageSize();
        int maxWidth = maxSize.width;
        int maxHeight = maxSize.height;
        if (this.deviceFrameVisible) {
            Rectangle frameRectangle = skin.getFrameRectangle();
            double scale = this.roundScale(Math.min((double)maxWidth / (double)frameRectangle.width, (double)maxHeight / (double)frameRectangle.height));
            int fw = StreamingUtilsKt.scaled(frameRectangle.width, scale);
            int fh = StreamingUtilsKt.scaled(frameRectangle.height, scale);
            int w = StreamingUtilsKt.scaled(this.getScreenshotShape().getWidth(), scale);
            int h = StreamingUtilsKt.scaled(this.getScreenshotShape().getHeight(), scale);
            rectangle = new Rectangle((this.getPhysicalWidth() - fw) / 2 - StreamingUtilsKt.scaled(frameRectangle.x, scale), (this.getPhysicalHeight() - fh) / 2 - StreamingUtilsKt.scaled(frameRectangle.y, scale), w, h);
        } else {
            double scale = this.roundScale(Math.min((double)maxWidth / (double)this.getScreenshotShape().getWidth(), (double)maxHeight / (double)this.getScreenshotShape().getHeight()));
            int w = StreamingUtilsKt.scaled(this.getScreenshotShape().getWidth(), scale);
            int h = StreamingUtilsKt.scaled(this.getScreenshotShape().getHeight(), scale);
            rectangle = new Rectangle((this.getPhysicalWidth() - w) / 2, (this.getPhysicalHeight() - h) / 2, w, h);
        }
        return rectangle;
    }

    private final void requestScreenshotFeed() {
        if (this.getConnected()) {
            this.requestScreenshotFeed(this.getCurrentDisplaySize(), this.getDisplayOrientationQuadrants());
        }
    }

    private final void requestScreenshotFeed(Dimension displaySize, int orientationQuadrants) {
        if (this.getWidth() != 0 && this.getHeight() != 0 && this.getConnected()) {
            ScreenshotReceiver receiver2;
            Dimension maxSize = StreamingUtilsKt.rotatedByQuadrants(this.getPhysicalSize(), -orientationQuadrants);
            SkinDefinition skin = this.emulator.getSkinDefinition$intellij_android_streaming();
            if (skin != null && this.deviceFrameVisible) {
                SkinLayout layout = skin.getLayout();
                maxSize.width = StreamingUtilsKt.scaledDown(maxSize.width, layout.getDisplaySize().width, layout.getFrameRectangle().width);
                maxSize.height = StreamingUtilsKt.scaledDown(maxSize.height, layout.getDisplaySize().height, layout.getFrameRectangle().height);
            }
            maxSize.width = RangesKt.coerceAtMost((int)maxSize.width, (int)displaySize.width);
            maxSize.height = RangesKt.coerceAtMost((int)maxSize.height, (int)displaySize.height);
            Dimension maxImageSize = StreamingUtilsKt.rotatedByQuadrants(maxSize, orientationQuadrants);
            ScreenshotReceiver currentReceiver = this.screenshotReceiver;
            if (currentReceiver != null && Intrinsics.areEqual((Object)currentReceiver.getMaxImageSize(), (Object)maxImageSize) && currentReceiver.getOrientationQuadrants() == orientationQuadrants) {
                return;
            }
            this.cancelScreenshotFeed();
            ImageFormat imageFormat = ImageFormat.newBuilder().setDisplay(this.getDisplayId()).setFormat(ImageFormat.ImgFormat.RGB888).setWidth(maxImageSize.width).setHeight(maxImageSize.height).build();
            this.screenshotReceiver = receiver2 = new ScreenshotReceiver(maxImageSize, orientationQuadrants);
            Intrinsics.checkNotNullExpressionValue((Object)imageFormat, (String)"imageFormat");
            this.screenshotFeed = this.emulator.streamScreenshot(imageFormat, (StreamObserver<Image>)((StreamObserver)receiver2));
        }
    }

    private final void cancelScreenshotFeed() {
        ScreenshotReceiver screenshotReceiver = this.screenshotReceiver;
        if (screenshotReceiver != null) {
            ScreenshotReceiver it = screenshotReceiver;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.screenshotReceiver = null;
        Cancelable cancelable = this.screenshotFeed;
        if (cancelable != null) {
            cancelable.cancel();
        }
        this.screenshotFeed = null;
    }

    private final void requestNotificationFeed() {
        this.cancelNotificationFeed();
        if (this.getConnected()) {
            NotificationReceiver receiver2;
            this.notificationReceiver = receiver2 = new NotificationReceiver();
            this.notificationFeed = this.emulator.streamNotification((StreamObserver<Notification>)((StreamObserver)receiver2));
        }
    }

    private final void cancelNotificationFeed() {
        this.notificationReceiver = null;
        Cancelable cancelable = this.notificationFeed;
        if (cancelable != null) {
            cancelable.cancel();
        }
        this.notificationFeed = null;
    }

    private final void showVirtualSceneCameraPrompt(String prompt) {
        block1: {
            if (!EmulatorSettings.Companion.getInstance().getShowCameraControlPrompts()) break block1;
            NotificationHolderPanel notificationHolderPanel = this.findNotificationHolderPanel();
            if (notificationHolderPanel != null) {
                notificationHolderPanel.showNotification(prompt);
            }
        }
    }

    static /* synthetic */ void showVirtualSceneCameraPrompt$default(EmulatorView emulatorView, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "Hold Shift to control camera";
        }
        emulatorView.showVirtualSceneCameraPrompt(string);
    }

    private final void hideVirtualSceneCameraPrompt() {
        block0: {
            NotificationHolderPanel notificationHolderPanel = this.findNotificationHolderPanel();
            if (notificationHolderPanel == null) break block0;
            notificationHolderPanel.hideNotification();
        }
    }

    private final void startOperatingVirtualSceneCamera() {
        VirtualSceneCameraVelocityController velocityController;
        String keys = EmulatorSettings.Companion.getInstance().getCameraVelocityControls().getKeys();
        this.showVirtualSceneCameraPrompt("Move camera with " + keys + " keys, rotate with mouse or arrow keys");
        IdeGlassPane ideGlassPane = IdeGlassPaneUtil.find((Component)((Component)((Object)this)));
        Intrinsics.checkNotNullExpressionValue((Object)ideGlassPane, (String)"find(this)");
        IdeGlassPane glass = ideGlassPane;
        Cursor cursor = AdtUiCursorsProvider.Companion.getInstance().getCursor(AdtUiCursorType.MOVE);
        JRootPane rootPane = this.getRootPane(glass);
        double scale = Math.PI / (double)Math.min(rootPane.getWidth(), rootPane.getHeight());
        UIUtil.setCursor((Component)rootPane, (Cursor)cursor);
        glass.setCursor(cursor, (Object)this);
        Point referencePoint = MouseInfo.getPointerInfo().getLocation();
        MouseAdapter mouseListener2 = new MouseAdapter(this, referencePoint, scale, glass, cursor){
            final /* synthetic */ EmulatorView this$0;
            final /* synthetic */ Point $referencePoint;
            final /* synthetic */ double $scale;
            final /* synthetic */ IdeGlassPane $glass;
            final /* synthetic */ Cursor $cursor;
            {
                this.this$0 = $receiver;
                this.$referencePoint = $referencePoint;
                this.$scale = $scale;
                this.$glass = $glass;
                this.$cursor = $cursor;
            }

            public void mouseMoved(@NotNull java.awt.event.MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                EmulatorView.access$rotateVirtualSceneCamera(this.this$0, (double)(-(event.getYOnScreen() - this.$referencePoint.y)) * this.$scale, (double)(this.$referencePoint.x - event.getXOnScreen()) * this.$scale);
                this.$referencePoint.setLocation(event.getXOnScreen(), event.getYOnScreen());
                event.consume();
            }

            public void mouseDragged(@NotNull java.awt.event.MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.mouseMoved(e);
            }

            public void mouseEntered(@NotNull java.awt.event.MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$glass.setCursor(this.$cursor, (Object)this);
            }
        };
        this.virtualSceneCameraVelocityController = velocityController = new VirtualSceneCameraVelocityController(this.emulator, EmulatorSettings.Companion.getInstance().getCameraVelocityControls().getKeys());
        glass.addMousePreprocessor((MouseListener)mouseListener2, (Disposable)velocityController);
        glass.addMouseMotionPreprocessor((MouseMotionListener)mouseListener2, (Disposable)velocityController);
    }

    private final void stopOperatingVirtualSceneCamera() {
        VirtualSceneCameraVelocityController virtualSceneCameraVelocityController = this.virtualSceneCameraVelocityController;
        if (virtualSceneCameraVelocityController != null) {
            Disposable p0 = virtualSceneCameraVelocityController;
            boolean bl = false;
            Disposer.dispose((Disposable)p0);
        }
        this.virtualSceneCameraVelocityController = null;
        EmulatorView.showVirtualSceneCameraPrompt$default(this, null, 1, null);
        IdeGlassPane ideGlassPane = IdeGlassPaneUtil.find((Component)((Component)((Object)this)));
        Intrinsics.checkNotNullExpressionValue((Object)ideGlassPane, (String)"find(this)");
        IdeGlassPane glass = ideGlassPane;
        glass.setCursor(null, (Object)this);
        UIUtil.setCursor((Component)this.getRootPane(glass), null);
    }

    private final void rotateVirtualSceneCamera(double rotationX, double rotationY) {
        RotationRadian cameraRotation = RotationRadian.newBuilder().setX((float)rotationX).setY((float)rotationY).build();
        Intrinsics.checkNotNullExpressionValue((Object)cameraRotation, (String)"cameraRotation");
        EmulatorController.rotateVirtualSceneCamera$default(this.emulator, cameraRotation, null, 2, null);
    }

    private final int getButtonBit(int button) {
        int n;
        switch (button) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public final void displayModeChanged$intellij_android_streaming(@NotNull DisplayModeValue displayModeId) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)displayModeId, (String)"displayModeId");
            Iterable $this$firstOrNull$iv = this.getEmulatorConfig().getDisplayModes();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EmulatorConfiguration.DisplayMode it = (EmulatorConfiguration.DisplayMode)element$iv;
                boolean bl = false;
                if (!(it.getDisplayModeId() == displayModeId)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        EmulatorConfiguration.DisplayMode displayMode = v0;
        if (displayMode == null) {
            return;
        }
        EmulatorConfiguration.DisplayMode displayMode2 = displayMode;
        this.requestScreenshotFeed(displayMode2.getDisplaySize(), this.getDisplayOrientationQuadrants());
    }

    private final JRootPane getRootPane(IdeGlassPane $this$rootPane) {
        Intrinsics.checkNotNull((Object)$this$rootPane, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.IdeGlassPaneImpl");
        return ((IdeGlassPaneImpl)$this$rootPane).getRootPane();
    }

    public static final /* synthetic */ void access$updateConnectionState(EmulatorView $this, EmulatorController.ConnectionState connectionState) {
        $this.updateConnectionState(connectionState);
    }

    public static final /* synthetic */ void access$setVirtualSceneCameraActive(EmulatorView $this, boolean value2) {
        $this.setVirtualSceneCameraActive(value2);
    }

    public static final /* synthetic */ void access$requestScreenshotFeed(EmulatorView $this, Dimension displaySize, int orientationQuadrants) {
        $this.requestScreenshotFeed(displaySize, orientationQuadrants);
    }

    public static final /* synthetic */ Dimension access$getCurrentDisplaySize(EmulatorView $this) {
        return $this.getCurrentDisplaySize();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$NotificationReceiver;", "Lcom/android/tools/idea/streaming/emulator/EmptyStreamObserver;", "Lcom/android/emulator/control/Notification;", "(Lcom/android/tools/idea/streaming/emulator/EmulatorView;)V", "notifyDisplayConfigurationListeners", "", "onNext", "response", "intellij.android.streaming"})
    private final class NotificationReceiver
    extends EmptyStreamObserver<Notification> {
        @Override
        public void onNext(@NotNull Notification response2) {
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_NOTIFICATIONS.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_NOTIFICATIONS.get()");
            if (((Boolean)t).booleanValue()) {
                EmulatorViewKt.access$getLOG$p().info("Notification " + response2.getEvent());
            }
            if (!Intrinsics.areEqual((Object)EmulatorView.this.notificationReceiver, (Object)this)) {
                return;
            }
            EventQueue.invokeLater(new Runnable(response2, EmulatorView.this, this){
                final /* synthetic */ Notification $response;
                final /* synthetic */ EmulatorView this$0;
                final /* synthetic */ NotificationReceiver this$1;
                {
                    this.$response = $response;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public final void run() {
                    Notification.EventType eventType = this.$response.getEvent();
                    switch (eventType == null ? -1 : onNext.WhenMappings.$EnumSwitchMapping$0[eventType.ordinal()]) {
                        case 1: {
                            EmulatorView.access$setVirtualSceneCameraActive(this.this$0, true);
                            break;
                        }
                        case 2: {
                            EmulatorView.access$setVirtualSceneCameraActive(this.this$0, false);
                            break;
                        }
                        case 3: {
                            NotificationReceiver.access$notifyDisplayConfigurationListeners(this.this$1);
                        }
                    }
                }
            });
        }

        private final void notifyDisplayConfigurationListeners() {
            for (DisplayConfigurationListener listener2 : EmulatorView.this.displayConfigurationListeners) {
                listener2.displayConfigurationChanged();
            }
        }

        public static final /* synthetic */ void access$notifyDisplayConfigurationListeners(NotificationReceiver $this) {
            $this.notifyDisplayConfigurationListeners();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$MyKeyListener;", "Ljava/awt/event/KeyAdapter;", "(Lcom/android/tools/idea/streaming/emulator/EmulatorView;)V", "keyPressed", "", "event", "Ljava/awt/event/KeyEvent;", "keyReleased", "keyTyped", "intellij.android.streaming"})
    private final class MyKeyListener
    extends KeyAdapter {
        @Override
        public void keyTyped(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (EmulatorView.this.virtualSceneCameraOperating) {
                return;
            }
            char c = event.getKeyChar();
            if (c == '\uffff' || Character.isISOControl(c)) {
                return;
            }
            KeyboardEvent keyboardEvent = KeyboardEvent.newBuilder().setText(String.valueOf(c)).build();
            EmulatorController emulatorController = EmulatorView.this.getEmulator();
            Intrinsics.checkNotNullExpressionValue((Object)keyboardEvent, (String)"keyboardEvent");
            EmulatorController.sendKey$default(emulatorController, keyboardEvent, null, 2, null);
        }

        @Override
        public void keyPressed(@NotNull KeyEvent event) {
            String string;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getKeyCode() == 16 && event.getModifiersEx() == 64 && EmulatorView.this.virtualSceneCameraActive) {
                EmulatorView.this.setVirtualSceneCameraOperating(true);
                return;
            }
            if (EmulatorView.this.virtualSceneCameraOperating) {
                switch (event.getKeyCode()) {
                    case 37: 
                    case 226: {
                        EmulatorView.this.rotateVirtualSceneCamera(0.0, 0.08726646259971647);
                        break;
                    }
                    case 39: 
                    case 227: {
                        EmulatorView.this.rotateVirtualSceneCamera(0.0, -0.08726646259971647);
                        break;
                    }
                    case 38: 
                    case 224: {
                        EmulatorView.this.rotateVirtualSceneCamera(0.08726646259971647, 0.0);
                        break;
                    }
                    case 40: 
                    case 225: {
                        EmulatorView.this.rotateVirtualSceneCamera(-0.08726646259971647, 0.0);
                        break;
                    }
                    case 36: {
                        EmulatorView.this.rotateVirtualSceneCamera(0.08726646259971647, 0.08726646259971647);
                        break;
                    }
                    case 35: {
                        EmulatorView.this.rotateVirtualSceneCamera(-0.08726646259971647, 0.08726646259971647);
                        break;
                    }
                    case 33: {
                        EmulatorView.this.rotateVirtualSceneCamera(0.08726646259971647, -0.08726646259971647);
                        break;
                    }
                    case 34: {
                        EmulatorView.this.rotateVirtualSceneCamera(-0.08726646259971647, -0.08726646259971647);
                        break;
                    }
                    default: {
                        VirtualSceneCameraVelocityController virtualSceneCameraVelocityController = EmulatorView.this.virtualSceneCameraVelocityController;
                        if (virtualSceneCameraVelocityController == null) break;
                        virtualSceneCameraVelocityController.keyPressed(event.getKeyCode());
                        break;
                    }
                }
                return;
            }
            if (event.getKeyCode() == 17 && event.getModifiersEx() == 128) {
                EmulatorView.this.setMultiTouchMode(true);
                return;
            }
            if (event.getKeyCode() == 9 && event.getModifiersEx() == 64) {
                Object object = event.getSource();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Component");
                KeyEvent tabEvent = new KeyEvent((Component)object, event.getID(), event.getWhen(), 0, event.getKeyCode(), event.getKeyChar(), event.getKeyLocation());
                EmulatorView.this.traverseFocusLocally(tabEvent);
                return;
            }
            if (event.getModifiersEx() != 0) {
                return;
            }
            switch (event.getKeyCode()) {
                case 8: {
                    string = "Backspace";
                    break;
                }
                case 127: {
                    if (SystemInfo.isMac) {
                        string = "Backspace";
                        break;
                    }
                    string = "Delete";
                    break;
                }
                case 10: {
                    string = "Enter";
                    break;
                }
                case 27: {
                    string = "Escape";
                    break;
                }
                case 9: {
                    string = "Tab";
                    break;
                }
                case 37: 
                case 226: {
                    string = "ArrowLeft";
                    break;
                }
                case 39: 
                case 227: {
                    string = "ArrowRight";
                    break;
                }
                case 38: 
                case 224: {
                    string = "ArrowUp";
                    break;
                }
                case 40: 
                case 225: {
                    string = "ArrowDown";
                    break;
                }
                case 36: {
                    string = "Home";
                    break;
                }
                case 35: {
                    string = "End";
                    break;
                }
                case 33: {
                    string = "PageUp";
                    break;
                }
                case 34: {
                    string = "PageDown";
                    break;
                }
                default: {
                    return;
                }
            }
            String keyName = string;
            EmulatorController.sendKey$default(EmulatorView.this.getEmulator(), StreamingUtilsKt.createHardwareKeyEvent$default(keyName, null, 2, null), null, 2, null);
            event.consume();
        }

        @Override
        public void keyReleased(@NotNull KeyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getKeyCode() == 17) {
                EmulatorView.this.setMultiTouchMode(false);
            } else if (event.getKeyCode() == 16) {
                EmulatorView.this.setVirtualSceneCameraOperating(false);
            }
            VirtualSceneCameraVelocityController virtualSceneCameraVelocityController = EmulatorView.this.virtualSceneCameraVelocityController;
            if (virtualSceneCameraVelocityController != null) {
                virtualSceneCameraVelocityController.keyReleased(event.getKeyCode());
            }
            event.consume();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0017\u001a\u00020\fH\u0002J(\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u0010J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$MyMouseListener;", "Ljava/awt/event/MouseAdapter;", "(Lcom/android/tools/idea/streaming/emulator/EmulatorView;)V", "buttons", "", "createTouch", "Lcom/android/emulator/control/Touch$Builder;", "x", "y", "identifier", "pressure", "isInsideDisplay", "", "event", "Ljava/awt/event/MouseEvent;", "mouseDragged", "", "mouseEntered", "mouseExited", "mouseMoved", "mousePressed", "mouseReleased", "sendMouseEvent", "drag", "sendMouseOrTouchEvent", "displayX", "displayY", "deviceDisplayRegion", "Ljava/awt/Rectangle;", "terminateDragging", "updateMultiTouchMode", "intellij.android.streaming"})
    private final class MyMouseListener
    extends MouseAdapter {
        private int buttons;

        @Override
        public void mousePressed(@NotNull java.awt.event.MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            EmulatorView.this.requestFocusInWindow();
            this.buttons |= EmulatorView.this.getButtonBit(event.getButton());
            if (this.isInsideDisplay(event)) {
                EmulatorView.this.lastTouchCoordinates = new Point(event.getX(), event.getY());
                this.updateMultiTouchMode(event);
                MyMouseListener.sendMouseEvent$default(this, event.getX(), event.getY(), this.buttons, false, 8, null);
            }
        }

        @Override
        public void mouseReleased(@NotNull java.awt.event.MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.buttons &= ~EmulatorView.this.getButtonBit(event.getButton());
            if (event.getButton() == 1) {
                EmulatorView.this.lastTouchCoordinates = null;
                this.updateMultiTouchMode(event);
            }
            MyMouseListener.sendMouseEvent$default(this, event.getX(), event.getY(), this.buttons, false, 8, null);
        }

        @Override
        public void mouseEntered(@NotNull java.awt.event.MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.updateMultiTouchMode(event);
        }

        @Override
        public void mouseExited(@NotNull java.awt.event.MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (EmulatorView.this.lastTouchCoordinates != null) {
                MyMouseListener.sendMouseEvent$default(this, event.getX(), event.getY(), 0, false, 8, null);
            }
            EmulatorView.this.lastTouchCoordinates = null;
            EmulatorView.this.setMultiTouchMode(false);
        }

        @Override
        public void mouseDragged(@NotNull java.awt.event.MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.updateMultiTouchMode(event);
            if (!EmulatorView.this.virtualSceneCameraOperating && EmulatorView.this.lastTouchCoordinates != null) {
                this.sendMouseEvent(event.getX(), event.getY(), this.buttons, true);
            }
        }

        @Override
        public void mouseMoved(@NotNull java.awt.event.MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.updateMultiTouchMode(event);
            if (!EmulatorView.this.virtualSceneCameraOperating && !EmulatorView.this.multiTouchMode) {
                MyMouseListener.sendMouseEvent$default(this, event.getX(), event.getY(), 0, false, 8, null);
            }
        }

        private final void updateMultiTouchMode(java.awt.event.MouseEvent event) {
            boolean oldMultiTouchMode = EmulatorView.this.multiTouchMode;
            EmulatorView.this.setMultiTouchMode((event.getModifiersEx() & 0x80) != 0 && !EmulatorView.this.virtualSceneCameraOperating);
            if (EmulatorView.this.multiTouchMode && oldMultiTouchMode) {
                EmulatorView.this.repaint();
            }
        }

        public final void terminateDragging() {
            block0: {
                Point point = EmulatorView.this.lastTouchCoordinates;
                if (point == null) break block0;
                Point it = point;
                boolean bl = false;
                MyMouseListener.sendMouseEvent$default(this, it.x, it.y, 0, false, 8, null);
            }
        }

        private final void sendMouseEvent(int x, int y, int buttons, boolean drag) {
            Rectangle rectangle = EmulatorView.this.getDisplayRectangle();
            if (rectangle == null) {
                return;
            }
            Rectangle displayRectangle = rectangle;
            int normalizedX = 0;
            int normalizedY = 0;
            int imageWidth = 0;
            int imageHeight = 0;
            switch (EmulatorView.this.getDisplayOrientationQuadrants()) {
                case 0: {
                    normalizedX = StreamingUtilsKt.scaled(x, EmulatorView.this.getScreenScale()) - displayRectangle.x;
                    normalizedY = StreamingUtilsKt.scaled(y, EmulatorView.this.getScreenScale()) - displayRectangle.y;
                    imageWidth = displayRectangle.width;
                    imageHeight = displayRectangle.height;
                    break;
                }
                case 1: {
                    normalizedX = displayRectangle.y + displayRectangle.height - StreamingUtilsKt.scaled(y, EmulatorView.this.getScreenScale());
                    normalizedY = StreamingUtilsKt.scaled(x, EmulatorView.this.getScreenScale()) - displayRectangle.x;
                    imageWidth = displayRectangle.height;
                    imageHeight = displayRectangle.width;
                    break;
                }
                case 2: {
                    normalizedX = displayRectangle.x + displayRectangle.width - StreamingUtilsKt.scaled(x, EmulatorView.this.getScreenScale());
                    normalizedY = displayRectangle.y + displayRectangle.height - StreamingUtilsKt.scaled(y, EmulatorView.this.getScreenScale());
                    imageWidth = displayRectangle.width;
                    imageHeight = displayRectangle.height;
                    break;
                }
                case 3: {
                    normalizedX = StreamingUtilsKt.scaled(y, EmulatorView.this.getScreenScale()) - displayRectangle.y;
                    normalizedY = displayRectangle.x + displayRectangle.width - StreamingUtilsKt.scaled(x, EmulatorView.this.getScreenScale());
                    imageWidth = displayRectangle.height;
                    imageHeight = displayRectangle.width;
                    break;
                }
                default: {
                    EmulatorView emulatorView = EmulatorView.this;
                    if (_Assertions.ENABLED) {
                        boolean $i$a$-assert-EmulatorView$MyMouseListener$sendMouseEvent$22 = false;
                        String $i$a$-assert-EmulatorView$MyMouseListener$sendMouseEvent$22 = "Invalid display orientation: " + emulatorView.getDisplayOrientationQuadrants();
                        throw new AssertionError((Object)$i$a$-assert-EmulatorView$MyMouseListener$sendMouseEvent$22);
                    }
                    return;
                }
            }
            Rectangle deviceDisplayRegion = EmulatorView.this.getDeviceDisplayRegion();
            int displayX = StreamingUtilsKt.scaledUnbiased(normalizedX, imageWidth, deviceDisplayRegion.width);
            int displayY = StreamingUtilsKt.scaledUnbiased(normalizedY, imageHeight, deviceDisplayRegion.height);
            if (deviceDisplayRegion.contains(displayX, displayY)) {
                this.sendMouseOrTouchEvent(displayX, displayY, buttons, deviceDisplayRegion);
            } else if (drag) {
                EmulatorView.this.lastTouchCoordinates = null;
                int adjustedX = RangesKt.coerceIn((int)displayX, (int)deviceDisplayRegion.x, (int)(deviceDisplayRegion.width - 1));
                int adjustedY = RangesKt.coerceIn((int)displayY, (int)deviceDisplayRegion.y, (int)(deviceDisplayRegion.height - 1));
                this.sendMouseOrTouchEvent(adjustedX, adjustedY, 0, deviceDisplayRegion);
            }
        }

        static /* synthetic */ void sendMouseEvent$default(MyMouseListener myMouseListener, int n, int n2, int n3, boolean bl, int n4, Object object) {
            if ((n4 & 8) != 0) {
                bl = false;
            }
            myMouseListener.sendMouseEvent(n, n2, n3, bl);
        }

        private final void sendMouseOrTouchEvent(int displayX, int displayY, int buttons, Rectangle deviceDisplayRegion) {
            if (EmulatorView.this.multiTouchMode) {
                int pressure = buttons == 0 ? 0 : 1024;
                TouchEvent touchEvent = TouchEvent.newBuilder().setDisplay(EmulatorView.this.getDisplayId()).addTouches(this.createTouch(displayX, displayY, 0, pressure)).addTouches(this.createTouch(deviceDisplayRegion.width - 1 - displayX, deviceDisplayRegion.height - 1 - displayY, 1, pressure)).build();
                EmulatorController emulatorController = EmulatorView.this.getEmulator();
                Intrinsics.checkNotNullExpressionValue((Object)touchEvent, (String)"touchEvent");
                EmulatorController.sendTouch$default(emulatorController, touchEvent, null, 2, null);
            } else {
                MouseEvent mouseEvent = MouseEvent.newBuilder().setDisplay(EmulatorView.this.getDisplayId()).setX(displayX).setY(displayY).setButtons(buttons).build();
                EmulatorController emulatorController = EmulatorView.this.getEmulator();
                Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"mouseEvent");
                EmulatorController.sendMouse$default(emulatorController, mouseEvent, null, 2, null);
            }
        }

        private final Touch.Builder createTouch(int x, int y, int identifier, int pressure) {
            Touch.Builder builder2 = Touch.newBuilder().setX(x).setY(y).setIdentifier(identifier).setPressure(pressure).setExpiration(Touch.EventExpiration.NEVER_EXPIRE);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()\n        .se\u2026tExpiration(NEVER_EXPIRE)");
            return builder2;
        }

        private final boolean isInsideDisplay(java.awt.event.MouseEvent event) {
            Rectangle rectangle = EmulatorView.this.getDisplayRectangle();
            return rectangle != null ? rectangle.contains((double)event.getX() * EmulatorView.this.getScreenScale(), (double)event.getY() * EmulatorView.this.getScreenScale()) : false;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0015H\u0002J\b\u0010\"\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u0002H\u0016J\b\u0010%\u001a\u00020 H\u0003J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0015H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$ScreenshotReceiver;", "Lcom/android/tools/idea/streaming/emulator/EmptyStreamObserver;", "Lcom/android/emulator/control/Image;", "Lcom/intellij/openapi/Disposable;", "maxImageSize", "Ljava/awt/Dimension;", "orientationQuadrants", "", "(Lcom/android/tools/idea/streaming/emulator/EmulatorView;Ljava/awt/Dimension;I)V", "alarm", "Lcom/intellij/util/Alarm;", "expectedFrameNumber", "getMaxImageSize", "()Ljava/awt/Dimension;", "getOrientationQuadrants", "()I", "recycledImage", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/util/SofterReference;", "Ljava/awt/image/BufferedImage;", "screenshotForDisplay", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$Screenshot;", "screenshotForProcessing", "skinLayoutCache", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$SkinLayoutCache;", "checkAspectRatioConsistency", "", "imageFormat", "Lcom/android/emulator/control/ImageFormat;", "displayMode", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;", "computeSkinLayoutOnPooledThread", "", "screenshotWithoutSkin", "dispose", "onNext", "response", "updateDisplayImage", "updateDisplayImageOnUiThread", "screenshot", "intellij.android.streaming"})
    private final class ScreenshotReceiver
    extends EmptyStreamObserver<Image>
    implements Disposable {
        @NotNull
        private final Dimension maxImageSize;
        private final int orientationQuadrants;
        @NotNull
        private final AtomicReference<Screenshot> screenshotForProcessing;
        @NotNull
        private final AtomicReference<Screenshot> screenshotForDisplay;
        @NotNull
        private final SkinLayoutCache skinLayoutCache;
        @NotNull
        private final AtomicReference<SofterReference<BufferedImage>> recycledImage;
        @NotNull
        private final Alarm alarm;
        private int expectedFrameNumber;

        public ScreenshotReceiver(Dimension maxImageSize, int orientationQuadrants) {
            Intrinsics.checkNotNullParameter((Object)maxImageSize, (String)"maxImageSize");
            this.maxImageSize = maxImageSize;
            this.orientationQuadrants = orientationQuadrants;
            this.screenshotForProcessing = new AtomicReference();
            this.screenshotForDisplay = new AtomicReference();
            this.skinLayoutCache = new SkinLayoutCache(EmulatorView.this.getEmulator());
            this.recycledImage = new AtomicReference();
            this.alarm = new Alarm((Disposable)this);
            this.expectedFrameNumber = -1;
        }

        @NotNull
        public final Dimension getMaxImageSize() {
            return this.maxImageSize;
        }

        public final int getOrientationQuadrants() {
            return this.orientationQuadrants;
        }

        @Override
        public void onNext(@NotNull Image response2) {
            BufferedImage bufferedImage;
            int[] pixels;
            BufferedImage recycledImage;
            EmulatorConfiguration.DisplayMode displayMode;
            long frameOriginationTime;
            int imageRotation;
            ImageFormat imageFormat;
            long arrivalTime;
            block17: {
                Object object;
                String foldedState;
                long latency;
                block19: {
                    block18: {
                        Object v0;
                        block16: {
                            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                            arrivalTime = System.currentTimeMillis();
                            imageFormat = response2.getFormat();
                            imageRotation = imageFormat.getRotation().getRotation().getNumber();
                            frameOriginationTime = response2.getTimestampUs() / (long)1000;
                            Iterable $this$firstOrNull$iv = EmulatorView.this.getEmulatorConfig().getDisplayModes();
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                EmulatorConfiguration.DisplayMode it = (EmulatorConfiguration.DisplayMode)element$iv;
                                boolean bl = false;
                                if (!(it.getDisplayModeId() == imageFormat.getDisplayMode())) continue;
                                v0 = element$iv;
                                break block16;
                            }
                            v0 = null;
                        }
                        displayMode = v0;
                        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_SCREENSHOTS.get();
                        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_SCREENSHOTS.get()");
                        if (!((Boolean)t).booleanValue()) break block17;
                        latency = arrivalTime - frameOriginationTime;
                        foldedState = imageFormat.hasFoldedDisplay() ? " " + imageFormat.getFoldedDisplay() : "";
                        object = imageFormat.getDisplayMode();
                        if (object == null) break block18;
                        DisplayModeValue it = object;
                        boolean bl = false;
                        String string = " " + it;
                        object = string;
                        if (string != null) break block19;
                    }
                    object = "";
                }
                Object mode = object;
                EmulatorViewKt.access$getLOG$p().info("Screenshot " + response2.getSeq() + " " + imageFormat.getWidth() + "x" + imageFormat.getHeight() + (String)mode + foldedState + " " + imageRotation + " " + latency + " ms latency");
            }
            if (!Intrinsics.areEqual((Object)EmulatorView.this.screenshotReceiver, (Object)this)) {
                int latency = this.expectedFrameNumber;
                this.expectedFrameNumber = latency + 1;
                return;
            }
            if (imageFormat.getWidth() == 0 || imageFormat.getHeight() == 0) {
                int latency = this.expectedFrameNumber;
                this.expectedFrameNumber = latency + 1;
                return;
            }
            if (response2.getImage().size() != imageFormat.getWidth() * imageFormat.getHeight() * 3) {
                EmulatorViewKt.access$getLOG$p().error("Inconsistent ImageMessage: " + imageFormat.getWidth() + "x" + imageFormat.getWidth() + " image contains " + response2.getImage().size() + " bytes instead of " + imageFormat.getWidth() * imageFormat.getHeight() * 3);
                return;
            }
            if (imageRotation != this.orientationQuadrants) {
                EventQueue.invokeLater(new Runnable(EmulatorView.this, imageRotation){
                    final /* synthetic */ EmulatorView this$0;
                    final /* synthetic */ int $imageRotation;
                    {
                        this.this$0 = $receiver;
                        this.$imageRotation = $imageRotation;
                    }

                    public final void run() {
                        EmulatorView.access$requestScreenshotFeed(this.this$0, EmulatorView.access$getCurrentDisplaySize(this.this$0), this.$imageRotation);
                    }
                });
                int latency = this.expectedFrameNumber;
                this.expectedFrameNumber = latency + 1;
                return;
            }
            EmulatorConfiguration.DisplayMode displayMode2 = displayMode;
            if (imageFormat.getDisplayMode() != (displayMode2 != null ? displayMode2.getDisplayModeId() : null) && displayMode != null) {
                EventQueue.invokeLater(new Runnable(EmulatorView.this, displayMode, imageRotation){
                    final /* synthetic */ EmulatorView this$0;
                    final /* synthetic */ EmulatorConfiguration.DisplayMode $displayMode;
                    final /* synthetic */ int $imageRotation;
                    {
                        this.this$0 = $receiver;
                        this.$displayMode = $displayMode;
                        this.$imageRotation = $imageRotation;
                    }

                    public final void run() {
                        EmulatorView.access$requestScreenshotFeed(this.this$0, this.$displayMode.getDisplaySize(), this.$imageRotation);
                    }
                });
                int latency = this.expectedFrameNumber;
                this.expectedFrameNumber = latency + 1;
                return;
            }
            this.alarm.cancelAllRequests();
            SofterReference softerReference = this.recycledImage.getAndSet(null);
            BufferedImage bufferedImage2 = recycledImage = softerReference != null ? (BufferedImage)softerReference.get() : null;
            boolean bl = bufferedImage2 != null ? bufferedImage2.getWidth() == imageFormat.getWidth() : false;
            if (bl && recycledImage.getHeight() == imageFormat.getHeight()) {
                DataBuffer dataBuffer = recycledImage.getRaster().getDataBuffer();
                Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
                pixels = ((DataBufferInt)dataBuffer).getData();
                ImageConverter.unpackRgb888(response2.getImage(), pixels);
                bufferedImage = recycledImage;
            } else {
                pixels = new int[imageFormat.getWidth() * imageFormat.getHeight()];
                ImageConverter.unpackRgb888(response2.getImage(), pixels);
                DataBufferInt buffer = new DataBufferInt(pixels, pixels.length);
                SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(3, imageFormat.getWidth(), imageFormat.getHeight(), EmulatorViewKt.access$getSAMPLE_MODEL_BIT_MASKS$p());
                WritableRaster raster = Raster.createWritableRaster(sampleModel, buffer, EmulatorViewKt.access$getZERO_POINT$p());
                bufferedImage = new BufferedImage(EmulatorViewKt.access$getCOLOR_MODEL$p(), raster, false, null);
            }
            BufferedImage image = bufferedImage;
            int lostFrames = this.expectedFrameNumber > 0 ? response2.getSeq() - this.expectedFrameNumber : 0;
            Stats stats = EmulatorView.this.stats;
            if (stats != null) {
                stats.recordFrameArrival(arrivalTime - frameOriginationTime, lostFrames, imageFormat.getWidth() * imageFormat.getHeight());
            }
            this.expectedFrameNumber = response2.getSeq() + 1;
            if (displayMode != null) {
                Intrinsics.checkNotNullExpressionValue((Object)imageFormat, (String)"imageFormat");
                if (!this.checkAspectRatioConsistency(imageFormat, displayMode)) {
                    return;
                }
            }
            FoldedDisplay foldedDisplay = imageFormat.getFoldedDisplay();
            Rectangle activeDisplayRegion = foldedDisplay.getWidth() != 0 && foldedDisplay.getHeight() != 0 ? new Rectangle(foldedDisplay.getXOffset(), foldedDisplay.getYOffset(), foldedDisplay.getWidth(), foldedDisplay.getHeight()) : (displayMode != null ? new Rectangle(displayMode.getDisplaySize()) : null);
            DisplayShape displayShape = new DisplayShape(imageFormat.getWidth(), imageFormat.getHeight(), imageRotation, activeDisplayRegion, displayMode, response2.getSeq());
            Screenshot screenshot = new Screenshot(displayShape, image, frameOriginationTime);
            SkinLayout skinLayout = this.skinLayoutCache.getCached(displayShape);
            if (skinLayout == null) {
                this.computeSkinLayoutOnPooledThread(screenshot);
            } else {
                screenshot.setSkinLayout(skinLayout);
                this.updateDisplayImageOnUiThread(screenshot);
            }
        }

        private final boolean checkAspectRatioConsistency(ImageFormat imageFormat, EmulatorConfiguration.DisplayMode displayMode) {
            double imageAspectRatio = imageFormat.getRotation().getRotationValue() % 2 == 0 ? (double)imageFormat.getWidth() / (double)imageFormat.getHeight() : (double)imageFormat.getHeight() / (double)imageFormat.getWidth();
            double displayAspectRatio = (double)displayMode.getWidth() / (double)displayMode.getHeight();
            double tolerance = 1.0 / (double)imageFormat.getWidth() + 1.0 / (double)imageFormat.getHeight();
            if (Math.abs(imageAspectRatio / displayAspectRatio - 1.0) > tolerance) {
                String imageDimensions = imageFormat.getRotation().getRotationValue() % 2 == 0 ? imageFormat.getWidth() + "x" + imageFormat.getHeight() : imageFormat.getHeight() + "x" + imageFormat.getWidth();
                EmulatorViewKt.access$getLOG$p().error("Inconsistent ImageMessage: the " + imageDimensions + " display image has different aspect ratio than the " + displayMode.getWidth() + "x" + displayMode.getHeight() + " display");
                return false;
            }
            return true;
        }

        private final void computeSkinLayoutOnPooledThread(Screenshot screenshotWithoutSkin) {
            this.screenshotForProcessing.set(screenshotWithoutSkin);
            FutureUtils.executeOnPooledThread((Function0)((Function0)new Function0<Unit>(EmulatorView.this, this){
                final /* synthetic */ EmulatorView this$0;
                final /* synthetic */ ScreenshotReceiver this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                public final void invoke() {
                    if (Intrinsics.areEqual((Object)EmulatorView.access$getScreenshotReceiver$p(this.this$0), (Object)this.this$1)) {
                        Screenshot screenshot = ScreenshotReceiver.access$getScreenshotForProcessing$p(this.this$1).getAndSet(null);
                        if (screenshot == null) {
                            Stats stats = EmulatorView.access$getStats$p(this.this$0);
                            if (stats != null) {
                                stats.recordDroppedFrame();
                            }
                        } else {
                            screenshot.setSkinLayout(ScreenshotReceiver.access$getSkinLayoutCache$p(this.this$1).get(screenshot.getDisplayShape()));
                            ScreenshotReceiver.access$updateDisplayImageOnUiThread(this.this$1, screenshot);
                        }
                    }
                }
            }));
        }

        private final void updateDisplayImageOnUiThread(Screenshot screenshot) {
            this.screenshotForDisplay.set(screenshot);
            EventQueue.invokeLater(new Runnable(EmulatorView.this, this){
                final /* synthetic */ EmulatorView this$0;
                final /* synthetic */ ScreenshotReceiver this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public final void run() {
                    if (Intrinsics.areEqual((Object)EmulatorView.access$getScreenshotReceiver$p(this.this$0), (Object)this.this$1)) {
                        ScreenshotReceiver.access$updateDisplayImage(this.this$1);
                    }
                }
            });
        }

        @UiThread
        private final void updateDisplayImage() {
            Object object;
            EmulatorView.this.hideLongRunningOperationIndicatorInstantly();
            Screenshot screenshot = this.screenshotForDisplay.getAndSet(null);
            if (screenshot == null) {
                Stats stats = EmulatorView.this.stats;
                if (stats != null) {
                    stats.recordDroppedFrame();
                }
                return;
            }
            Object object2 = EmulatorView.this.lastScreenshot;
            if (object2 != null && (object2 = ((Screenshot)object2).getImage()) != null) {
                Object object3 = object2;
                EmulatorView emulatorView = EmulatorView.this;
                Object it = object3;
                boolean bl = false;
                if (((BufferedImage)it).getWidth() == screenshot.getDisplayShape().getWidth() && ((BufferedImage)it).getHeight() == screenshot.getDisplayShape().getHeight()) {
                    this.recycledImage.set((SofterReference<BufferedImage>)new SofterReference(it));
                    this.alarm.cancelAllRequests();
                    this.alarm.addRequest(new Runnable(this){
                        final /* synthetic */ ScreenshotReceiver this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public final void run() {
                            ScreenshotReceiver.access$getRecycledImage$p(this.this$0).set(null);
                        }
                    }, 2000, ModalityState.any());
                } else if (!StreamingUtilsKt.isSameAspectRatio(((BufferedImage)it).getWidth(), ((BufferedImage)it).getHeight(), screenshot.getDisplayShape().getWidth(), screenshot.getDisplayShape().getHeight(), 0.01)) {
                    emulatorView.zoom(ZoomType.FIT);
                }
            }
            EmulatorConfiguration.DisplayMode lastDisplayMode = (object = EmulatorView.this.lastScreenshot) != null && (object = ((Screenshot)object).getDisplayShape()) != null ? ((DisplayShape)object).getDisplayMode() : null;
            EmulatorView.this.lastScreenshot = screenshot;
            EmulatorView emulatorView = EmulatorView.this;
            int n = emulatorView.receivedFrameCount;
            emulatorView.receivedFrameCount = n + 1;
            EmulatorView.this.frameTimestampMillis = System.currentTimeMillis();
            EmulatorView.this.repaint();
            if (!Intrinsics.areEqual((Object)screenshot.getDisplayShape().getDisplayMode(), (Object)lastDisplayMode)) {
                EmulatorView.this.firePropertyChange("displayMode", lastDisplayMode, screenshot.getDisplayShape().getDisplayMode());
            }
        }

        public void dispose() {
        }

        public static final /* synthetic */ AtomicReference access$getScreenshotForProcessing$p(ScreenshotReceiver $this) {
            return $this.screenshotForProcessing;
        }

        public static final /* synthetic */ SkinLayoutCache access$getSkinLayoutCache$p(ScreenshotReceiver $this) {
            return $this.skinLayoutCache;
        }

        public static final /* synthetic */ void access$updateDisplayImageOnUiThread(ScreenshotReceiver $this, Screenshot screenshot) {
            $this.updateDisplayImageOnUiThread(screenshot);
        }

        public static final /* synthetic */ void access$updateDisplayImage(ScreenshotReceiver $this) {
            $this.updateDisplayImage();
        }

        public static final /* synthetic */ AtomicReference access$getRecycledImage$p(ScreenshotReceiver $this) {
            return $this.recycledImage;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$Screenshot;", "", "displayShape", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$DisplayShape;", "image", "Ljava/awt/image/BufferedImage;", "frameOriginationTime", "", "(Lcom/android/tools/idea/streaming/emulator/EmulatorView$DisplayShape;Ljava/awt/image/BufferedImage;J)V", "getDisplayShape", "()Lcom/android/tools/idea/streaming/emulator/EmulatorView$DisplayShape;", "getFrameOriginationTime", "()J", "getImage", "()Ljava/awt/image/BufferedImage;", "painted", "", "getPainted", "()Z", "setPainted", "(Z)V", "skinLayout", "Lcom/android/tools/idea/streaming/emulator/SkinLayout;", "getSkinLayout", "()Lcom/android/tools/idea/streaming/emulator/SkinLayout;", "setSkinLayout", "(Lcom/android/tools/idea/streaming/emulator/SkinLayout;)V", "intellij.android.streaming"})
    private static final class Screenshot {
        @NotNull
        private final DisplayShape displayShape;
        @NotNull
        private final BufferedImage image;
        private final long frameOriginationTime;
        public SkinLayout skinLayout;
        private boolean painted;

        public Screenshot(@NotNull DisplayShape displayShape, @NotNull BufferedImage image, long frameOriginationTime) {
            Intrinsics.checkNotNullParameter((Object)displayShape, (String)"displayShape");
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.displayShape = displayShape;
            this.image = image;
            this.frameOriginationTime = frameOriginationTime;
        }

        @NotNull
        public final DisplayShape getDisplayShape() {
            return this.displayShape;
        }

        @NotNull
        public final BufferedImage getImage() {
            return this.image;
        }

        public final long getFrameOriginationTime() {
            return this.frameOriginationTime;
        }

        @NotNull
        public final SkinLayout getSkinLayout() {
            SkinLayout skinLayout = this.skinLayout;
            if (skinLayout != null) {
                return skinLayout;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"skinLayout");
            return null;
        }

        public final void setSkinLayout(@NotNull SkinLayout skinLayout) {
            Intrinsics.checkNotNullParameter((Object)skinLayout, (String)"<set-?>");
            this.skinLayout = skinLayout;
        }

        public final boolean getPainted() {
            return this.painted;
        }

        public final void setPainted(boolean bl) {
            this.painted = bl;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0006R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$SkinLayoutCache;", "", "emulator", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "(Lcom/android/tools/idea/streaming/emulator/EmulatorController;)V", "displayShape", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$DisplayShape;", "getDisplayShape", "()Lcom/android/tools/idea/streaming/emulator/EmulatorView$DisplayShape;", "setDisplayShape", "(Lcom/android/tools/idea/streaming/emulator/EmulatorView$DisplayShape;)V", "getEmulator", "()Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "skinLayout", "Lcom/android/tools/idea/streaming/emulator/SkinLayout;", "getSkinLayout", "()Lcom/android/tools/idea/streaming/emulator/SkinLayout;", "setSkinLayout", "(Lcom/android/tools/idea/streaming/emulator/SkinLayout;)V", "get", "getCached", "intellij.android.streaming"})
    private static final class SkinLayoutCache {
        @NotNull
        private final EmulatorController emulator;
        @Nullable
        private DisplayShape displayShape;
        @Nullable
        private SkinLayout skinLayout;

        public SkinLayoutCache(@NotNull EmulatorController emulator) {
            Intrinsics.checkNotNullParameter((Object)emulator, (String)"emulator");
            this.emulator = emulator;
        }

        @NotNull
        public final EmulatorController getEmulator() {
            return this.emulator;
        }

        @Nullable
        public final DisplayShape getDisplayShape() {
            return this.displayShape;
        }

        public final void setDisplayShape(@Nullable DisplayShape displayShape) {
            this.displayShape = displayShape;
        }

        @Nullable
        public final SkinLayout getSkinLayout() {
            return this.skinLayout;
        }

        public final void setSkinLayout(@Nullable SkinLayout skinLayout) {
            this.skinLayout = skinLayout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final SkinLayout getCached(@NotNull DisplayShape displayShape) {
            Intrinsics.checkNotNullParameter((Object)displayShape, (String)"displayShape");
            SkinLayoutCache skinLayoutCache = this;
            synchronized (skinLayoutCache) {
                boolean bl = false;
                SkinLayout skinLayout = Intrinsics.areEqual((Object)displayShape, (Object)this.displayShape) ? this.skinLayout : null;
                return skinLayout;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Slow
        @NotNull
        public final SkinLayout get(@NotNull DisplayShape displayShape) {
            Intrinsics.checkNotNullParameter((Object)displayShape, (String)"displayShape");
            SkinLayoutCache skinLayoutCache = this;
            synchronized (skinLayoutCache) {
                boolean bl = false;
                Object layout = this.skinLayout;
                if (!Intrinsics.areEqual((Object)displayShape, (Object)this.displayShape) || layout == null) {
                    Object object = this.emulator.getSkinDefinition$intellij_android_streaming();
                    if (object == null || (object = ((SkinDefinition)object).createScaledLayout(displayShape.getWidth(), displayShape.getHeight(), displayShape.getOrientation())) == null) {
                        object = new SkinLayout(displayShape.getWidth(), displayShape.getHeight());
                    }
                    layout = object;
                    this.displayShape = displayShape;
                    this.skinLayout = layout;
                }
                SkinLayout skinLayout = layout;
                return skinLayout;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003JI\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$DisplayShape;", "", "width", "", "height", "orientation", "activeDisplayRegion", "Ljava/awt/Rectangle;", "displayMode", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;", "frameNumber", "(IIILjava/awt/Rectangle;Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;I)V", "getActiveDisplayRegion", "()Ljava/awt/Rectangle;", "getDisplayMode", "()Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;", "getFrameNumber", "()I", "getHeight", "getOrientation", "getWidth", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.streaming"})
    private static final class DisplayShape {
        private final int width;
        private final int height;
        private final int orientation;
        @Nullable
        private final Rectangle activeDisplayRegion;
        @Nullable
        private final EmulatorConfiguration.DisplayMode displayMode;
        private final int frameNumber;

        public DisplayShape(int width, int height, int orientation, @Nullable Rectangle activeDisplayRegion, @Nullable EmulatorConfiguration.DisplayMode displayMode, int frameNumber) {
            this.width = width;
            this.height = height;
            this.orientation = orientation;
            this.activeDisplayRegion = activeDisplayRegion;
            this.displayMode = displayMode;
            this.frameNumber = frameNumber;
        }

        public /* synthetic */ DisplayShape(int n, int n2, int n3, Rectangle rectangle, EmulatorConfiguration.DisplayMode displayMode, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 8) != 0) {
                rectangle = null;
            }
            if ((n5 & 0x10) != 0) {
                displayMode = null;
            }
            if ((n5 & 0x20) != 0) {
                n4 = 0;
            }
            this(n, n2, n3, rectangle, displayMode, n4);
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final int getOrientation() {
            return this.orientation;
        }

        @Nullable
        public final Rectangle getActiveDisplayRegion() {
            return this.activeDisplayRegion;
        }

        @Nullable
        public final EmulatorConfiguration.DisplayMode getDisplayMode() {
            return this.displayMode;
        }

        public final int getFrameNumber() {
            return this.frameNumber;
        }

        public final int component1() {
            return this.width;
        }

        public final int component2() {
            return this.height;
        }

        public final int component3() {
            return this.orientation;
        }

        @Nullable
        public final Rectangle component4() {
            return this.activeDisplayRegion;
        }

        @Nullable
        public final EmulatorConfiguration.DisplayMode component5() {
            return this.displayMode;
        }

        public final int component6() {
            return this.frameNumber;
        }

        @NotNull
        public final DisplayShape copy(int width, int height, int orientation, @Nullable Rectangle activeDisplayRegion, @Nullable EmulatorConfiguration.DisplayMode displayMode, int frameNumber) {
            return new DisplayShape(width, height, orientation, activeDisplayRegion, displayMode, frameNumber);
        }

        public static /* synthetic */ DisplayShape copy$default(DisplayShape displayShape, int n, int n2, int n3, Rectangle rectangle, EmulatorConfiguration.DisplayMode displayMode, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = displayShape.width;
            }
            if ((n5 & 2) != 0) {
                n2 = displayShape.height;
            }
            if ((n5 & 4) != 0) {
                n3 = displayShape.orientation;
            }
            if ((n5 & 8) != 0) {
                rectangle = displayShape.activeDisplayRegion;
            }
            if ((n5 & 0x10) != 0) {
                displayMode = displayShape.displayMode;
            }
            if ((n5 & 0x20) != 0) {
                n4 = displayShape.frameNumber;
            }
            return displayShape.copy(n, n2, n3, rectangle, displayMode, n4);
        }

        @NotNull
        public String toString() {
            return "DisplayShape(width=" + this.width + ", height=" + this.height + ", orientation=" + this.orientation + ", activeDisplayRegion=" + this.activeDisplayRegion + ", displayMode=" + this.displayMode + ", frameNumber=" + this.frameNumber + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.width);
            result2 = result2 * 31 + Integer.hashCode(this.height);
            result2 = result2 * 31 + Integer.hashCode(this.orientation);
            result2 = result2 * 31 + (this.activeDisplayRegion == null ? 0 : this.activeDisplayRegion.hashCode());
            result2 = result2 * 31 + (this.displayMode == null ? 0 : this.displayMode.hashCode());
            result2 = result2 * 31 + Integer.hashCode(this.frameNumber);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DisplayShape)) {
                return false;
            }
            DisplayShape displayShape = (DisplayShape)other;
            if (this.width != displayShape.width) {
                return false;
            }
            if (this.height != displayShape.height) {
                return false;
            }
            if (this.orientation != displayShape.orientation) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.activeDisplayRegion, (Object)displayShape.activeDisplayRegion)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.displayMode, (Object)displayShape.displayMode)) {
                return false;
            }
            return this.frameNumber == displayShape.frameNumber;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J\b\u0010\u000b\u001a\u00020\bH\u0002J\u0006\u0010\f\u001a\u00020\bJ\u001e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000fJ\b\u0010\u0015\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$Stats;", "Lcom/intellij/openapi/Disposable;", "()V", "alarm", "Lcom/intellij/util/Alarm;", "data", "Lcom/android/tools/idea/streaming/emulator/EmulatorView$Stats$Data;", "dispose", "", "getAndSetData", "newData", "logAndReset", "recordDroppedFrame", "recordFrameArrival", "latencyOfArrival", "", "numberOfLostFrames", "", "numberOfPixels", "recordLatencyEndToEnd", "latency", "scheduleNextLogging", "Data", "intellij.android.streaming"})
    private static final class Stats
    implements Disposable {
        @NotNull
        private Data data = new Data();
        @NotNull
        private final Alarm alarm = new Alarm((Disposable)this);

        public Stats() {
            this.scheduleNextLogging();
        }

        public final synchronized void recordFrameArrival(long latencyOfArrival, int numberOfLostFrames, int numberOfPixels) {
            Data data2 = this.data;
            data2.setFrameCount(data2.getFrameCount() + (1 + numberOfLostFrames));
            data2 = this.data;
            data2.setPixelCount(data2.getPixelCount() + (long)((1 + numberOfLostFrames) * numberOfPixels));
            this.data.getLatencyOfArrival().recordValue(latencyOfArrival);
            if (numberOfLostFrames != 0) {
                data2 = this.data;
                data2.setDroppedFrameCount(data2.getDroppedFrameCount() + numberOfLostFrames);
                data2 = this.data;
                data2.setDroppedFrameCountBeforeArrival(data2.getDroppedFrameCountBeforeArrival() + numberOfLostFrames);
            }
        }

        public final synchronized void recordDroppedFrame() {
            Data data2 = this.data;
            int n = data2.getDroppedFrameCount();
            data2.setDroppedFrameCount(n + 1);
        }

        public final synchronized void recordLatencyEndToEnd(long latency) {
            this.data.getLatencyEndToEnd().recordValue(latency);
        }

        public synchronized void dispose() {
            this.data.log();
        }

        private final synchronized Data getAndSetData(Data newData) {
            Data oldData = this.data;
            this.data = newData;
            return oldData;
        }

        private final void scheduleNextLogging() {
            this.alarm.addRequest(new Runnable(this){
                final /* synthetic */ Stats $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void run() {
                    Stats.access$logAndReset(this.$tmp0);
                }
            }, EmulatorViewKt.access$getSTATS_LOG_INTERVAL_MILLIS$p(), ModalityState.any());
        }

        private final void logAndReset() {
            this.getAndSetData(new Data()).log();
            this.scheduleNextLogging();
        }

        public static final /* synthetic */ void access$logAndReset(Stats $this) {
            $this.logAndReset();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001d\u001a\u00020\u001eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001a\u0010\u0019\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0006\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorView$Stats$Data;", "", "()V", "collectionStart", "", "getCollectionStart", "()J", "droppedFrameCount", "", "getDroppedFrameCount", "()I", "setDroppedFrameCount", "(I)V", "droppedFrameCountBeforeArrival", "getDroppedFrameCountBeforeArrival", "setDroppedFrameCountBeforeArrival", "frameCount", "getFrameCount", "setFrameCount", "latencyEndToEnd", "Lorg/HdrHistogram/Histogram;", "getLatencyEndToEnd", "()Lorg/HdrHistogram/Histogram;", "latencyOfArrival", "getLatencyOfArrival", "pixelCount", "getPixelCount", "setPixelCount", "(J)V", "log", "", "intellij.android.streaming"})
        private static final class Data {
            private int frameCount;
            private int droppedFrameCount;
            private int droppedFrameCountBeforeArrival;
            private long pixelCount;
            @NotNull
            private final Histogram latencyEndToEnd = new Histogram(1);
            @NotNull
            private final Histogram latencyOfArrival = new Histogram(1);
            private final long collectionStart = System.currentTimeMillis();

            public final int getFrameCount() {
                return this.frameCount;
            }

            public final void setFrameCount(int n) {
                this.frameCount = n;
            }

            public final int getDroppedFrameCount() {
                return this.droppedFrameCount;
            }

            public final void setDroppedFrameCount(int n) {
                this.droppedFrameCount = n;
            }

            public final int getDroppedFrameCountBeforeArrival() {
                return this.droppedFrameCountBeforeArrival;
            }

            public final void setDroppedFrameCountBeforeArrival(int n) {
                this.droppedFrameCountBeforeArrival = n;
            }

            public final long getPixelCount() {
                return this.pixelCount;
            }

            public final void setPixelCount(long l) {
                this.pixelCount = l;
            }

            @NotNull
            public final Histogram getLatencyEndToEnd() {
                return this.latencyEndToEnd;
            }

            @NotNull
            public final Histogram getLatencyOfArrival() {
                return this.latencyOfArrival;
            }

            public final long getCollectionStart() {
                return this.collectionStart;
            }

            public final void log() {
                if (this.frameCount != 0) {
                    String string = "%.2g";
                    Object[] objectArray = new Object[]{(double)this.frameCount * 1000.0 / (double)(System.currentTimeMillis() - this.collectionStart)};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                    String frameRate = string2;
                    int frameSize = MathKt.roundToInt((double)((double)this.pixelCount / (double)this.frameCount));
                    String neverArrived = this.droppedFrameCountBeforeArrival != 0 ? " (" + this.droppedFrameCountBeforeArrival + " never arrived)" : "";
                    String dropped = this.droppedFrameCount != 0 ? " dropped frames: " + this.droppedFrameCount + neverArrived : "";
                    EmulatorViewKt.access$getLOG$p().info("Frames: " + this.frameCount + " " + dropped + " average frame rate: " + frameRate + " average frame size: " + frameSize + " pixels\nlatency: " + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)HistogramUtil.toProto(this.latencyEndToEnd))) + "\nlatency of arrival: " + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)HistogramUtil.toProto(this.latencyOfArrival))));
                }
            }
        }
    }
}

