/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.annotations.concurrency.AnyThread;
import com.android.emulator.control.DisplayConfiguration;
import com.android.emulator.control.DisplayConfigurations;
import com.android.emulator.control.ExtendedControlsStatus;
import com.android.tools.adtui.ZoomableKt;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.util.ActionToolbarUtil;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.protobuf.MessageOrBuilder;
import com.android.tools.idea.protobuf.TextFormat;
import com.android.tools.idea.streaming.AbstractDisplayPanel;
import com.android.tools.idea.streaming.DeviceFileDropHandlerKt;
import com.android.tools.idea.streaming.DeviceId;
import com.android.tools.idea.streaming.EmulatorSettings;
import com.android.tools.idea.streaming.RunningDevicePanel;
import com.android.tools.idea.streaming.StreamingConstants;
import com.android.tools.idea.streaming.StreamingUtilsKt;
import com.android.tools.idea.streaming.emulator.DisplayConfigurationListener;
import com.android.tools.idea.streaming.emulator.EmptyStreamObserver;
import com.android.tools.idea.streaming.emulator.EmulatorClipboardSynchronizer;
import com.android.tools.idea.streaming.emulator.EmulatorConstants;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.streaming.emulator.EmulatorDisplayPanel;
import com.android.tools.idea.streaming.emulator.EmulatorId;
import com.android.tools.idea.streaming.emulator.EmulatorPanelState;
import com.android.tools.idea.streaming.emulator.EmulatorSplitPanel;
import com.android.tools.idea.streaming.emulator.EmulatorToolWindowPanelKt;
import com.android.tools.idea.streaming.emulator.EmulatorView;
import com.android.tools.idea.streaming.emulator.LayoutNode;
import com.android.tools.idea.streaming.emulator.LeafNode;
import com.android.tools.idea.streaming.emulator.MultiDisplayLayoutOptimizerKt;
import com.android.tools.idea.streaming.emulator.SplitNode;
import com.android.tools.idea.streaming.emulator.actions.EmulatorManageSnapshotsActionKt;
import com.android.tools.idea.streaming.emulator.actions.EmulatorShowExtendedControlsActionKt;
import com.android.tools.idea.ui.screenrecording.ScreenRecorderAction;
import com.android.utils.HashCodes;
import com.google.wireless.android.sdk.stats.DeviceMirroringSession;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002:\u0005STUVWB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010B\u001a\u00020C2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010D\u001a\u00020EH\u0016J\u001a\u0010F\u001a\u00020C2\u0006\u0010G\u001a\u00020\r2\b\u0010H\u001a\u0004\u0018\u00010IH\u0016J\u0018\u0010J\u001a\u00020,2\u0006\u0010K\u001a\u0002092\u0006\u0010L\u001a\u00020\rH\u0002J\b\u0010M\u001a\u00020&H\u0016J\u0012\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010P\u001a\u000209H\u0016J\u0010\u0010Q\u001a\u00020C2\u0006\u0010R\u001a\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000fR\u001e\u0010%\u001a\u0004\u0018\u00010&8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00108\u001a\u0002098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u000e\u0010<\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010>\u001a\u00020\r2\u0006\u0010=\u001a\u00020\r@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u000f\"\u0004\b@\u0010A\u00a8\u0006X"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel;", "Lcom/android/tools/idea/streaming/RunningDevicePanel;", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionStateListener;", "project", "Lcom/intellij/openapi/project/Project;", "emulator", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/streaming/emulator/EmulatorController;)V", "centerPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "clipboardSynchronizer", "Lcom/android/tools/idea/streaming/emulator/EmulatorClipboardSynchronizer;", "connected", "", "getConnected", "()Z", "contentDisposable", "Lcom/intellij/openapi/Disposable;", "displayConfigurator", "Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$DisplayConfigurator;", "displayPanels", "Lit/unimi/dsi/fastutil/ints/Int2ObjectRBTreeMap;", "Lcom/android/tools/idea/streaming/emulator/EmulatorDisplayPanel;", "getEmulator", "()Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "emulatorId", "Lcom/android/tools/idea/streaming/emulator/EmulatorId;", "getEmulatorId", "()Lcom/android/tools/idea/streaming/emulator/EmulatorId;", "focusOwnerListener", "Ljava/beans/PropertyChangeListener;", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "isClosable", "lastUiState", "Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$EmulatorUiState;", "getLastUiState", "()Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$EmulatorUiState;", "setLastUiState", "(Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$EmulatorUiState;)V", "mainToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "multiDisplayStateStorage", "Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$MultiDisplayStateStorage;", "multiDisplayStateUpdater", "Ljava/lang/Runnable;", "northEastToolbar", "preferredFocusableComponent", "Ljavax/swing/JComponent;", "getPreferredFocusableComponent", "()Ljavax/swing/JComponent;", "primaryEmulatorView", "Lcom/android/tools/idea/streaming/emulator/EmulatorView;", "title", "", "getTitle", "()Ljava/lang/String;", "toolbarPanel", "value", "zoomToolbarVisible", "getZoomToolbarVisible", "setZoomToolbarVisible", "(Z)V", "connectionStateChanged", "", "connectionState", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionState;", "createContent", "deviceFrameVisible", "savedUiState", "Lcom/android/tools/idea/streaming/RunningDevicePanel$UiState;", "createToolbar", "toolbarId", "horizontal", "destroyContent", "getData", "", "dataId", "setDeviceFrameVisible", "visible", "DisplayConfigurator", "DisplayDescriptor", "EmulatorUiState", "MultiDisplayState", "MultiDisplayStateStorage", "intellij.android.streaming"})
public final class EmulatorToolWindowPanel
extends RunningDevicePanel
implements EmulatorController.ConnectionStateListener {
    @NotNull
    private final Project project;
    @NotNull
    private final EmulatorController emulator;
    @NotNull
    private final BorderLayoutPanel toolbarPanel;
    @NotNull
    private final ActionToolbar mainToolbar;
    @NotNull
    private final ActionToolbar northEastToolbar;
    @NotNull
    private final BorderLayoutPanel centerPanel;
    @NotNull
    private final Int2ObjectRBTreeMap<EmulatorDisplayPanel> displayPanels;
    @NotNull
    private final DisplayConfigurator displayConfigurator;
    @Nullable
    private EmulatorClipboardSynchronizer clipboardSynchronizer;
    @Nullable
    private Disposable contentDisposable;
    @Nullable
    private EmulatorView primaryEmulatorView;
    @NotNull
    private final MultiDisplayStateStorage multiDisplayStateStorage;
    @NotNull
    private final Runnable multiDisplayStateUpdater;
    @NotNull
    private final PropertyChangeListener focusOwnerListener;
    private final boolean isClosable;
    private boolean zoomToolbarVisible;
    @Nullable
    private EmulatorUiState lastUiState;

    public EmulatorToolWindowPanel(@NotNull Project project, @NotNull EmulatorController emulator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)emulator, (String)"emulator");
        super(DeviceId.Companion.ofEmulator(emulator.getEmulatorId()));
        this.project = project;
        this.emulator = emulator;
        this.toolbarPanel = new BorderLayoutPanel();
        this.centerPanel = new BorderLayoutPanel();
        this.displayPanels = new Int2ObjectRBTreeMap();
        this.displayConfigurator = new DisplayConfigurator();
        this.multiDisplayStateStorage = MultiDisplayStateStorage.Companion.getInstance(this.project);
        this.multiDisplayStateUpdater = new Runnable(this){
            final /* synthetic */ EmulatorToolWindowPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public final void run() {
                EmulatorToolWindowPanel.access$getMultiDisplayStateStorage$p(this.this$0).setMultiDisplayState(EmulatorToolWindowPanel.access$getEmulatorId(this.this$0).getAvdFolder(), EmulatorToolWindowPanel.access$getDisplayConfigurator$p(this.this$0).getMultiDisplayState());
            }
        };
        this.focusOwnerListener = new PropertyChangeListener(this){
            final /* synthetic */ EmulatorToolWindowPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public final void propertyChange(PropertyChangeEvent event) {
                block2: {
                    boolean lost;
                    block3: {
                        Object newFocus = event.getNewValue();
                        boolean gained = newFocus instanceof EmulatorView && Intrinsics.areEqual((Object)((EmulatorView)newFocus).getEmulator(), (Object)this.this$0.getEmulator());
                        Object oldFocus = event.getOldValue();
                        boolean bl = lost = oldFocus instanceof EmulatorView && Intrinsics.areEqual((Object)((EmulatorView)oldFocus).getEmulator(), (Object)this.this$0.getEmulator());
                        if (gained == lost) break block2;
                        if (!gained) break block3;
                        if (!EmulatorToolWindowPanel.access$getConnected(this.this$0) || !EmulatorSettings.Companion.getInstance().getSynchronizeClipboard()) break block2;
                        EmulatorClipboardSynchronizer emulatorClipboardSynchronizer = EmulatorToolWindowPanel.access$getClipboardSynchronizer$p(this.this$0);
                        if (emulatorClipboardSynchronizer != null) {
                            emulatorClipboardSynchronizer.setDeviceClipboardAndKeepHostClipboardInSync();
                        }
                        break block2;
                    }
                    if (!lost) break block2;
                    EmulatorClipboardSynchronizer emulatorClipboardSynchronizer = EmulatorToolWindowPanel.access$getClipboardSynchronizer$p(this.this$0);
                    if (emulatorClipboardSynchronizer != null) {
                        emulatorClipboardSynchronizer.stopKeepingHostClipboardInSync();
                    }
                }
            }
        };
        this.isClosable = true;
        this.setBackground((Color)StudioColorsKt.getPrimaryPanelBackground());
        this.mainToolbar = this.createToolbar("EmulatorToolbar", true);
        this.northEastToolbar = this.createToolbar("EmulatorToolbarSecondary", true);
        this.northEastToolbar.getComponent().setBorder(new EmptyBorder((Insets)JBUI.emptyInsets()));
        this.addToCenter((Component)this.centerPanel);
        this.mainToolbar.setOrientation(0);
        this.northEastToolbar.setOrientation(0);
        this.toolbarPanel.add((Component)this.mainToolbar.getComponent(), (Object)"Center");
        this.toolbarPanel.add((Component)this.northEastToolbar.getComponent(), (Object)"East");
        this.centerPanel.setBorder(IdeBorderFactory.createBorder((Color)JBColor.border(), (int)2));
        this.addToTop((Component)this.toolbarPanel);
    }

    @NotNull
    public final EmulatorController getEmulator() {
        return this.emulator;
    }

    private final EmulatorId getEmulatorId() {
        return this.emulator.getEmulatorId();
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.getEmulatorId().getAvdName();
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return EmulatorToolWindowPanelKt.access$getICON$p();
    }

    @Override
    public boolean isClosable() {
        return this.isClosable;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusableComponent() {
        EmulatorView emulatorView = this.primaryEmulatorView;
        return emulatorView != null ? (JComponent)((Object)emulatorView) : (JComponent)((Object)this);
    }

    @Override
    public boolean getZoomToolbarVisible() {
        return this.zoomToolbarVisible;
    }

    @Override
    public void setZoomToolbarVisible(boolean value2) {
        this.zoomToolbarVisible = value2;
        for (EmulatorDisplayPanel panel2 : (ObjectCollection)this.displayPanels.values()) {
            panel2.setZoomToolbarVisible(value2);
        }
    }

    private final boolean getConnected() {
        return this.emulator.getConnectionState() == EmulatorController.ConnectionState.CONNECTED;
    }

    @TestOnly
    @Nullable
    public final EmulatorUiState getLastUiState() {
        return this.lastUiState;
    }

    public final void setLastUiState(@Nullable EmulatorUiState emulatorUiState) {
        this.lastUiState = emulatorUiState;
    }

    @Override
    public void setDeviceFrameVisible(boolean visible) {
        EmulatorView emulatorView = this.primaryEmulatorView;
        if (emulatorView != null) {
            emulatorView.setDeviceFrameVisible(visible);
        }
    }

    @Override
    public void connectionStateChanged(@NotNull EmulatorController emulator, @NotNull EmulatorController.ConnectionState connectionState) {
        Intrinsics.checkNotNullParameter((Object)emulator, (String)"emulator");
        Intrinsics.checkNotNullParameter((Object)((Object)connectionState), (String)"connectionState");
        if (connectionState == EmulatorController.ConnectionState.CONNECTED) {
            this.displayConfigurator.refreshDisplayConfiguration();
            EventQueue.invokeLater(new Runnable(this){
                final /* synthetic */ EmulatorToolWindowPanel this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void run() {
                    block1: {
                        if (!this.this$0.isFocusOwner() || !EmulatorSettings.Companion.getInstance().getSynchronizeClipboard()) break block1;
                        EmulatorClipboardSynchronizer emulatorClipboardSynchronizer = EmulatorToolWindowPanel.access$getClipboardSynchronizer$p(this.this$0);
                        if (emulatorClipboardSynchronizer != null) {
                            emulatorClipboardSynchronizer.setDeviceClipboardAndKeepHostClipboardInSync();
                        }
                    }
                }
            });
        }
    }

    @Override
    public void createContent(boolean deviceFrameVisible, @Nullable RunningDevicePanel.UiState savedUiState) {
        EmulatorUiState emulatorUiState;
        EmulatorView emulatorView;
        Disposable disposable2;
        this.mirroringStarted();
        this.lastUiState = null;
        Disposable disposable3 = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"newDisposable()");
        this.contentDisposable = disposable2 = disposable3;
        this.clipboardSynchronizer = new EmulatorClipboardSynchronizer(this.emulator, disposable2);
        EmulatorDisplayPanel primaryDisplayPanel = new EmulatorDisplayPanel(disposable2, this.emulator, 0, null, this.getZoomToolbarVisible(), deviceFrameVisible);
        ((Map)this.displayPanels).put(primaryDisplayPanel.getDisplayId(), primaryDisplayPanel);
        this.primaryEmulatorView = emulatorView = (EmulatorView)primaryDisplayPanel.getDisplayView();
        this.mainToolbar.setTargetComponent((JComponent)((Object)emulatorView));
        this.northEastToolbar.setTargetComponent((JComponent)((Object)emulatorView));
        emulatorView.addPropertyChangeListener("displayMode", new PropertyChangeListener(this){
            final /* synthetic */ EmulatorToolWindowPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public final void propertyChange(PropertyChangeEvent it) {
                EmulatorToolWindowPanel.access$getMainToolbar$p(this.this$0).updateActionsImmediately();
                EmulatorToolWindowPanel.access$getNorthEastToolbar$p(this.this$0).updateActionsImmediately();
            }
        });
        DeviceFileDropHandlerKt.installFileDropHandler((JComponent)((Object)this), this.getId().getSerialNumber(), emulatorView, this.project);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.focusOwnerListener);
        emulatorView.addDisplayConfigurationListener(this.displayConfigurator);
        this.emulator.addConnectionStateListener(this);
        MultiDisplayState multiDisplayState = this.multiDisplayStateStorage.getMultiDisplayState(this.getEmulatorId().getAvdFolder());
        if (multiDisplayState == null) {
            this.centerPanel.addToCenter((Component)((Object)primaryDisplayPanel));
        } else {
            try {
                this.displayConfigurator.buildLayout(multiDisplayState);
            }
            catch (RuntimeException e) {
                EmulatorToolWindowPanelKt.access$getLOG().error("Corrupted multi-display state", (Throwable)e);
                this.centerPanel.addToCenter((Component)((Object)primaryDisplayPanel));
            }
        }
        if ((emulatorUiState = (EmulatorUiState)savedUiState) == null) {
            emulatorUiState = new EmulatorUiState();
        }
        EmulatorUiState uiState = emulatorUiState;
        Int2ObjectRBTreeMap<AbstractDisplayPanel.ZoomScrollState> zoomScrollState = uiState.getZoomScrollState();
        for (EmulatorDisplayPanel panel2 : (ObjectCollection)this.displayPanels.values()) {
            AbstractDisplayPanel.ZoomScrollState it;
            if ((AbstractDisplayPanel.ZoomScrollState)zoomScrollState.get(panel2.getDisplayId()) == null) continue;
            boolean bl = false;
            panel2.setZoomScrollState$intellij_android_streaming(it);
        }
        this.multiDisplayStateStorage.addUpdater(this.multiDisplayStateUpdater);
        if (this.getConnected()) {
            this.displayConfigurator.refreshDisplayConfiguration();
            if (uiState.getManageSnapshotsDialogShown()) {
                EmulatorManageSnapshotsActionKt.showManageSnapshotsDialog(emulatorView, this.project);
            }
            if (uiState.getExtendedControlsShown()) {
                EmulatorShowExtendedControlsActionKt.showExtendedControls$default(this.emulator, this.project, null, 4, null);
            }
        }
    }

    @Override
    @NotNull
    public EmulatorUiState destroyContent() {
        DialogWrapper dialogWrapper2;
        EmulatorView it;
        this.mirroringEnded(DeviceMirroringSession.DeviceKind.VIRTUAL);
        this.multiDisplayStateUpdater.run();
        this.multiDisplayStateStorage.removeUpdater(this.multiDisplayStateUpdater);
        EmulatorUiState uiState = new EmulatorUiState();
        for (EmulatorDisplayPanel panel2 : (ObjectCollection)this.displayPanels.values()) {
            ((Map)uiState.getZoomScrollState()).put(panel2.getDisplayId(), panel2.getZoomScrollState$intellij_android_streaming());
        }
        EmulatorView emulatorView = this.primaryEmulatorView;
        if (emulatorView != null) {
            it = emulatorView;
            boolean bl = false;
            dialogWrapper2 = EmulatorManageSnapshotsActionKt.findManageSnapshotDialog(it);
        } else {
            dialogWrapper2 = null;
        }
        DialogWrapper manageSnapshotsDialog = dialogWrapper2;
        uiState.setManageSnapshotsDialogShown(manageSnapshotsDialog != null);
        DialogWrapper dialogWrapper3 = manageSnapshotsDialog;
        if (dialogWrapper3 != null) {
            dialogWrapper3.close(1);
        }
        if (this.getConnected()) {
            this.emulator.closeExtendedControls((StreamObserver<ExtendedControlsStatus>)new EmptyStreamObserver<ExtendedControlsStatus>(uiState){
                final /* synthetic */ EmulatorUiState $uiState;
                {
                    this.$uiState = $uiState;
                }

                public void onNext(@NotNull ExtendedControlsStatus response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    EventQueue.invokeLater(new Runnable(this.$uiState, response2){
                        final /* synthetic */ EmulatorUiState $uiState;
                        final /* synthetic */ ExtendedControlsStatus $response;
                        {
                            this.$uiState = $uiState;
                            this.$response = $response;
                        }

                        public final void run() {
                            this.$uiState.setExtendedControlsShown(this.$response.getVisibilityChanged());
                        }
                    });
                }
            });
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this.focusOwnerListener);
        this.emulator.removeConnectionStateListener(this);
        Disposable disposable2 = this.contentDisposable;
        if (disposable2 != null) {
            it = disposable2;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.contentDisposable = null;
        this.centerPanel.removeAll();
        this.displayPanels.clear();
        this.primaryEmulatorView = null;
        this.mainToolbar.setTargetComponent((JComponent)((Object)this));
        this.northEastToolbar.setTargetComponent((JComponent)((Object)this));
        this.clipboardSynchronizer = null;
        this.lastUiState = uiState;
        return uiState;
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        String string = dataId;
        if (Intrinsics.areEqual((Object)string, (Object)EmulatorConstants.EMULATOR_CONTROLLER_KEY.getName())) {
            object = this.emulator;
        } else if (Intrinsics.areEqual((Object)string, (Object)EmulatorConstants.EMULATOR_VIEW_KEY.getName()) ? true : Intrinsics.areEqual((Object)string, (Object)ZoomableKt.ZOOMABLE_KEY.getName())) {
            object = this.primaryEmulatorView;
        } else if (Intrinsics.areEqual((Object)string, (Object)StreamingConstants.NUMBER_OF_DISPLAYS.getName())) {
            object = this.displayPanels.size();
        } else if (Intrinsics.areEqual((Object)string, (Object)ScreenRecorderAction.Companion.getSCREEN_RECORDER_PARAMETERS_KEY().getName())) {
            EmulatorView emulatorView = this.primaryEmulatorView;
            if (emulatorView != null) {
                EmulatorView it = emulatorView;
                boolean bl = false;
                object = this.emulator.getConnectionState() == EmulatorController.ConnectionState.CONNECTED ? new ScreenRecorderAction.Parameters(this.getId().getSerialNumber(), this.emulator.getEmulatorConfig().getApi(), this.getEmulatorId().getAvdId(), it) : null;
            } else {
                object = null;
            }
        } else {
            object = super.getData(dataId);
        }
        return object;
    }

    private final ActionToolbar createToolbar(String toolbarId, boolean horizontal) {
        AnAction anAction = CustomActionsSchema.getInstance().getCorrectedAction(toolbarId);
        Intrinsics.checkNotNull((Object)anAction);
        List actions2 = CollectionsKt.listOf((Object)anAction);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar(toolbarId, (ActionGroup)new DefaultActionGroup(actions2), horizontal);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"getInstance().createActi\u2026oup(actions), horizontal)");
        ActionToolbar toolbar2 = actionToolbar;
        toolbar2.setLayoutPolicy(2);
        ActionToolbarUtil.makeToolbarNavigable((ActionToolbar)toolbar2);
        toolbar2.setTargetComponent((JComponent)((Object)this));
        return toolbar2;
    }

    public static final /* synthetic */ EmulatorClipboardSynchronizer access$getClipboardSynchronizer$p(EmulatorToolWindowPanel $this) {
        return $this.clipboardSynchronizer;
    }

    public static final /* synthetic */ Disposable access$getContentDisposable$p(EmulatorToolWindowPanel $this) {
        return $this.contentDisposable;
    }

    public static final /* synthetic */ MultiDisplayStateStorage access$getMultiDisplayStateStorage$p(EmulatorToolWindowPanel $this) {
        return $this.multiDisplayStateStorage;
    }

    public static final /* synthetic */ EmulatorId access$getEmulatorId(EmulatorToolWindowPanel $this) {
        return $this.getEmulatorId();
    }

    public static final /* synthetic */ DisplayConfigurator access$getDisplayConfigurator$p(EmulatorToolWindowPanel $this) {
        return $this.displayConfigurator;
    }

    public static final /* synthetic */ boolean access$getConnected(EmulatorToolWindowPanel $this) {
        return $this.getConnected();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u000e\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0017J\u0016\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0004H\u0002J$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0004H\u0002J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010J\b\u0010\u001b\u001a\u00020\u000eH\u0007J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$DisplayConfigurator;", "Lcom/android/tools/idea/streaming/emulator/DisplayConfigurationListener;", "(Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel;)V", "displayDescriptors", "", "Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$DisplayDescriptor;", "getDisplayDescriptors", "()Ljava/util/List;", "setDisplayDescriptors", "(Ljava/util/List;)V", "buildLayout", "Ljavax/swing/JPanel;", "state", "Lcom/android/tools/idea/streaming/emulator/EmulatorPanelState;", "", "multiDisplayState", "Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$MultiDisplayState;", "layoutNode", "Lcom/android/tools/idea/streaming/emulator/LayoutNode;", "displayConfigurationChanged", "displayConfigurationReceived", "displayConfigs", "Lcom/android/emulator/control/DisplayConfiguration;", "emulatorView", "Lcom/android/tools/idea/streaming/emulator/EmulatorView;", "displays", "getMultiDisplayState", "refreshDisplayConfiguration", "setRootPanel", "rootPanel", "intellij.android.streaming"})
    private final class DisplayConfigurator
    implements DisplayConfigurationListener {
        @NotNull
        private List<DisplayDescriptor> displayDescriptors = CollectionsKt.emptyList();

        @NotNull
        public final List<DisplayDescriptor> getDisplayDescriptors() {
            return this.displayDescriptors;
        }

        public final void setDisplayDescriptors(@NotNull List<DisplayDescriptor> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
            this.displayDescriptors = list2;
        }

        @Override
        @AnyThread
        public void displayConfigurationChanged() {
            this.refreshDisplayConfiguration();
        }

        @AnyThread
        public final void refreshDisplayConfiguration() {
            EmulatorToolWindowPanel.this.getEmulator().getDisplayConfigurations((StreamObserver<DisplayConfigurations>)new EmptyStreamObserver<DisplayConfigurations>(this){
                final /* synthetic */ DisplayConfigurator this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onNext(@NotNull DisplayConfigurations response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    EmulatorToolWindowPanelKt.access$getLOG().debug("Display configurations: " + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)response2)));
                    EventQueue.invokeLater(new Runnable(this.this$0, response2){
                        final /* synthetic */ DisplayConfigurator this$0;
                        final /* synthetic */ DisplayConfigurations $response;
                        {
                            this.this$0 = $receiver;
                            this.$response = $response;
                        }

                        public final void run() {
                            List list2 = this.$response.getDisplaysList();
                            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"response.displaysList");
                            DisplayConfigurator.access$displayConfigurationReceived(this.this$0, list2);
                        }
                    });
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void displayConfigurationReceived(List<DisplayConfiguration> displayConfigs) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            EmulatorView emulatorView = EmulatorToolWindowPanel.this.primaryEmulatorView;
            if (emulatorView == null) {
                return;
            }
            EmulatorView primaryDisplayView = emulatorView;
            List<DisplayDescriptor> newDisplays = this.getDisplayDescriptors(primaryDisplayView, displayConfigs);
            if (newDisplays.size() == 1 && this.displayDescriptors.size() <= 1 || Intrinsics.areEqual(newDisplays, this.displayDescriptors)) {
                return;
            }
            EmulatorToolWindowPanel.this.displayPanels.int2ObjectEntrySet().removeIf(new Predicate(newDisplays){
                final /* synthetic */ List<DisplayDescriptor> $newDisplays;
                {
                    this.$newDisplays = $newDisplays;
                }

                public final boolean test(Int2ObjectMap.Entry<EmulatorDisplayPanel> entry) {
                    boolean bl;
                    boolean bl2;
                    EmulatorDisplayPanel displayPanel;
                    block5: {
                        Intrinsics.checkNotNullExpressionValue(entry, (String)"(displayId, displayPanel)");
                        Integer displayId = (Integer)((Map.Entry)entry).getKey();
                        displayPanel = (EmulatorDisplayPanel)((Object)((Map.Entry)entry).getValue());
                        Iterable $this$any$iv = this.$newDisplays;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                DisplayDescriptor it = (DisplayDescriptor)element$iv;
                                boolean bl3 = false;
                                Integer n = displayId;
                                if (!(n != null && it.getDisplayId() == n.intValue())) continue;
                                bl2 = true;
                                break block5;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) {
                        Disposer.dispose((Disposable)displayPanel);
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }
            });
            Iterable iterable = newDisplays;
            Dimension dimension2 = StreamingUtilsKt.getSizeWithoutInsets((Container)EmulatorToolWindowPanel.this.centerPanel);
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DisplayDescriptor displayDescriptor = (DisplayDescriptor)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getSize());
            }
            LayoutNode layoutRoot = MultiDisplayLayoutOptimizerKt.computeBestLayout(dimension2, (List)destination$iv$iv);
            JPanel rootPanel2 = this.buildLayout(layoutRoot, newDisplays);
            this.displayDescriptors = newDisplays;
            this.setRootPanel(rootPanel2);
            EmulatorToolWindowPanel.this.mainToolbar.updateActionsImmediately();
            EmulatorToolWindowPanel.this.northEastToolbar.updateActionsImmediately();
        }

        public final void buildLayout(@NotNull MultiDisplayState multiDisplayState) {
            Intrinsics.checkNotNullParameter((Object)multiDisplayState, (String)"multiDisplayState");
            List<DisplayDescriptor> newDisplays = multiDisplayState.getDisplayDescriptors();
            JPanel rootPanel2 = this.buildLayout(multiDisplayState.getEmulatorPanelState(), newDisplays);
            this.displayDescriptors = newDisplays;
            this.setRootPanel(rootPanel2);
        }

        private final JPanel buildLayout(LayoutNode layoutNode, List<DisplayDescriptor> displayDescriptors) {
            JPanel jPanel;
            LayoutNode layoutNode2 = layoutNode;
            if (layoutNode2 instanceof LeafNode) {
                DisplayDescriptor display2 = displayDescriptors.get(((LeafNode)layoutNode).getRectangleIndex());
                int displayId = display2.getDisplayId();
                Object object = EmulatorToolWindowPanel.this.displayPanels.computeIfAbsent(displayId, new IntFunction(EmulatorToolWindowPanel.this, display2){
                    final /* synthetic */ EmulatorToolWindowPanel this$0;
                    final /* synthetic */ DisplayDescriptor $display;
                    {
                        this.this$0 = $receiver;
                        this.$display = $display;
                    }

                    public final EmulatorDisplayPanel apply(int it) {
                        boolean bl;
                        boolean bl2 = bl = it != 0;
                        if (_Assertions.ENABLED && !bl) {
                            String string = "Assertion failed";
                            throw new AssertionError((Object)string);
                        }
                        Disposable disposable2 = EmulatorToolWindowPanel.access$getContentDisposable$p(this.this$0);
                        Intrinsics.checkNotNull((Object)disposable2);
                        return new EmulatorDisplayPanel(disposable2, this.this$0.getEmulator(), it, this.$display.getSize(), this.this$0.getZoomToolbarVisible(), false, 32, null);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"class EmulatorToolWindow\u2026java)\n      }\n    }\n  }\n}");
                jPanel = (JPanel)object;
            } else if (layoutNode2 instanceof SplitNode) {
                EmulatorSplitPanel emulatorSplitPanel;
                EmulatorSplitPanel $this$buildLayout_u24lambda_u2d1 = emulatorSplitPanel = new EmulatorSplitPanel((SplitNode)layoutNode);
                boolean bl = false;
                $this$buildLayout_u24lambda_u2d1.setFirstComponent(this.buildLayout(((SplitNode)layoutNode).getFirstChild(), displayDescriptors));
                $this$buildLayout_u24lambda_u2d1.setSecondComponent(this.buildLayout(((SplitNode)layoutNode).getSecondChild(), displayDescriptors));
                jPanel = emulatorSplitPanel;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return jPanel;
        }

        private final JPanel buildLayout(EmulatorPanelState state2, List<DisplayDescriptor> displayDescriptors) {
            JPanel jPanel;
            EmulatorPanelState.SplitPanelState splitPanelState = state2.getSplitPanel();
            if (splitPanelState != null) {
                EmulatorSplitPanel emulatorSplitPanel;
                EmulatorSplitPanel $this$buildLayout_u24lambda_u2d2 = emulatorSplitPanel = new EmulatorSplitPanel(splitPanelState.getSplitType(), splitPanelState.getProportion());
                boolean bl = false;
                $this$buildLayout_u24lambda_u2d2.setFirstComponent(this.buildLayout(splitPanelState.getFirstComponent(), displayDescriptors));
                $this$buildLayout_u24lambda_u2d2.setSecondComponent(this.buildLayout(splitPanelState.getSecondComponent(), displayDescriptors));
                jPanel = emulatorSplitPanel;
            } else {
                Object v2;
                int displayId;
                block5: {
                    Integer n = state2.getDisplayId();
                    if (n == null) {
                        throw new IllegalArgumentException();
                    }
                    displayId = n;
                    Iterable iterable = displayDescriptors;
                    for (Object t : iterable) {
                        DisplayDescriptor it = (DisplayDescriptor)t;
                        boolean bl = false;
                        if (!(it.getDisplayId() == displayId)) continue;
                        v2 = t;
                        break block5;
                    }
                    v2 = null;
                }
                DisplayDescriptor displayDescriptor = v2;
                if (displayDescriptor == null) {
                    throw new IllegalArgumentException();
                }
                DisplayDescriptor display2 = displayDescriptor;
                Object object = EmulatorToolWindowPanel.this.displayPanels.computeIfAbsent(displayId, new IntFunction(EmulatorToolWindowPanel.this, display2){
                    final /* synthetic */ EmulatorToolWindowPanel this$0;
                    final /* synthetic */ DisplayDescriptor $display;
                    {
                        this.this$0 = $receiver;
                        this.$display = $display;
                    }

                    public final EmulatorDisplayPanel apply(int it) {
                        boolean bl;
                        boolean bl2 = bl = it != 0;
                        if (_Assertions.ENABLED && !bl) {
                            String string = "Assertion failed";
                            throw new AssertionError((Object)string);
                        }
                        Disposable disposable2 = EmulatorToolWindowPanel.access$getContentDisposable$p(this.this$0);
                        Intrinsics.checkNotNull((Object)disposable2);
                        return new EmulatorDisplayPanel(disposable2, this.this$0.getEmulator(), it, this.$display.getSize(), this.this$0.getZoomToolbarVisible(), false, 32, null);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"class EmulatorToolWindow\u2026java)\n      }\n    }\n  }\n}");
                jPanel = (JPanel)object;
            }
            return jPanel;
        }

        private final void setRootPanel(JPanel rootPanel2) {
            EmulatorToolWindowPanel.this.mainToolbar.updateActionsImmediately();
            EmulatorToolWindowPanel.this.northEastToolbar.updateActionsImmediately();
            EmulatorToolWindowPanel.this.centerPanel.removeAll();
            EmulatorToolWindowPanel.this.centerPanel.addToCenter((Component)rootPanel2);
            EmulatorToolWindowPanel.this.centerPanel.validate();
        }

        /*
         * WARNING - void declaration
         */
        private final List<DisplayDescriptor> getDisplayDescriptors(EmulatorView emulatorView, List<DisplayConfiguration> displays) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = displays;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DisplayConfiguration displayConfiguration = (DisplayConfiguration)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getDisplay() == 0 ? new DisplayDescriptor(0, emulatorView.getDisplaySizeWithFrame()) : new DisplayDescriptor((DisplayConfiguration)it));
            }
            return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        }

        @Nullable
        public final MultiDisplayState getMultiDisplayState() {
            Component panel2;
            if (EmulatorToolWindowPanel.this.centerPanel.getComponentCount() > 0 && (panel2 = EmulatorToolWindowPanel.this.centerPanel.getComponent(0)) instanceof EmulatorSplitPanel) {
                return new MultiDisplayState(CollectionsKt.toMutableList((Collection)this.displayDescriptors), ((EmulatorSplitPanel)panel2).getState());
            }
            return null;
        }

        public static final /* synthetic */ void access$displayConfigurationReceived(DisplayConfigurator $this, List displayConfigs) {
            $this.displayConfigurationReceived(displayConfigs);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0007\b\u0016\u00a2\u0006\u0002\u0010\nB\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0019\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$DisplayDescriptor;", "", "displayConfig", "Lcom/android/emulator/control/DisplayConfiguration;", "(Lcom/android/emulator/control/DisplayConfiguration;)V", "displayId", "", "size", "Ljava/awt/Dimension;", "(ILjava/awt/Dimension;)V", "()V", "width", "height", "(III)V", "getDisplayId", "()I", "setDisplayId", "(I)V", "getHeight", "setHeight", "getSize", "()Ljava/awt/Dimension;", "getWidth", "setWidth", "compareTo", "other", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "", "intellij.android.streaming"})
    public static final class DisplayDescriptor
    implements Comparable<DisplayDescriptor> {
        private int displayId;
        private int width;
        private int height;

        public DisplayDescriptor(int displayId, int width, int height) {
            this.displayId = displayId;
            this.width = width;
            this.height = height;
        }

        public final int getDisplayId() {
            return this.displayId;
        }

        public final void setDisplayId(int n) {
            this.displayId = n;
        }

        public final int getWidth() {
            return this.width;
        }

        public final void setWidth(int n) {
            this.width = n;
        }

        public final int getHeight() {
            return this.height;
        }

        public final void setHeight(int n) {
            this.height = n;
        }

        public DisplayDescriptor(@NotNull DisplayConfiguration displayConfig) {
            Intrinsics.checkNotNullParameter((Object)displayConfig, (String)"displayConfig");
            this(displayConfig.getDisplay(), displayConfig.getWidth(), displayConfig.getHeight());
        }

        public DisplayDescriptor(int displayId, @NotNull Dimension size) {
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            this(displayId, size.width, size.height);
        }

        public DisplayDescriptor() {
            this(0, 0, 0);
        }

        @NotNull
        public final Dimension getSize() {
            return new Dimension(this.width, this.height);
        }

        @Override
        public int compareTo(@NotNull DisplayDescriptor other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.displayId - other.displayId;
        }

        public final int component1() {
            return this.displayId;
        }

        public final int component2() {
            return this.width;
        }

        public final int component3() {
            return this.height;
        }

        @NotNull
        public final DisplayDescriptor copy(int displayId, int width, int height) {
            return new DisplayDescriptor(displayId, width, height);
        }

        public static /* synthetic */ DisplayDescriptor copy$default(DisplayDescriptor displayDescriptor, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = displayDescriptor.displayId;
            }
            if ((n4 & 2) != 0) {
                n2 = displayDescriptor.width;
            }
            if ((n4 & 4) != 0) {
                n3 = displayDescriptor.height;
            }
            return displayDescriptor.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "DisplayDescriptor(displayId=" + this.displayId + ", width=" + this.width + ", height=" + this.height + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.displayId);
            result2 = result2 * 31 + Integer.hashCode(this.width);
            result2 = result2 * 31 + Integer.hashCode(this.height);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DisplayDescriptor)) {
                return false;
            }
            DisplayDescriptor displayDescriptor = (DisplayDescriptor)other;
            if (this.displayId != displayDescriptor.displayId) {
                return false;
            }
            if (this.width != displayDescriptor.width) {
                return false;
            }
            return this.height == displayDescriptor.height;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$EmulatorUiState;", "Lcom/android/tools/idea/streaming/RunningDevicePanel$UiState;", "()V", "extendedControlsShown", "", "getExtendedControlsShown", "()Z", "setExtendedControlsShown", "(Z)V", "manageSnapshotsDialogShown", "getManageSnapshotsDialogShown", "setManageSnapshotsDialogShown", "multiDisplayState", "Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$MultiDisplayState;", "getMultiDisplayState", "()Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$MultiDisplayState;", "setMultiDisplayState", "(Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$MultiDisplayState;)V", "zoomScrollState", "Lit/unimi/dsi/fastutil/ints/Int2ObjectRBTreeMap;", "Lcom/android/tools/idea/streaming/AbstractDisplayPanel$ZoomScrollState;", "getZoomScrollState", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectRBTreeMap;", "intellij.android.streaming"})
    public static final class EmulatorUiState
    implements RunningDevicePanel.UiState {
        private boolean manageSnapshotsDialogShown;
        private boolean extendedControlsShown;
        @Nullable
        private MultiDisplayState multiDisplayState;
        @NotNull
        private final Int2ObjectRBTreeMap<AbstractDisplayPanel.ZoomScrollState> zoomScrollState = new Int2ObjectRBTreeMap();

        public final boolean getManageSnapshotsDialogShown() {
            return this.manageSnapshotsDialogShown;
        }

        public final void setManageSnapshotsDialogShown(boolean bl) {
            this.manageSnapshotsDialogShown = bl;
        }

        public final boolean getExtendedControlsShown() {
            return this.extendedControlsShown;
        }

        public final void setExtendedControlsShown(boolean bl) {
            this.extendedControlsShown = bl;
        }

        @Nullable
        public final MultiDisplayState getMultiDisplayState() {
            return this.multiDisplayState;
        }

        public final void setMultiDisplayState(@Nullable MultiDisplayState multiDisplayState) {
            this.multiDisplayState = multiDisplayState;
        }

        @NotNull
        public final Int2ObjectRBTreeMap<AbstractDisplayPanel.ZoomScrollState> getZoomScrollState() {
            return this.zoomScrollState;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$MultiDisplayState;", "", "displayDescriptors", "", "Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$DisplayDescriptor;", "emulatorPanelState", "Lcom/android/tools/idea/streaming/emulator/EmulatorPanelState;", "(Ljava/util/List;Lcom/android/tools/idea/streaming/emulator/EmulatorPanelState;)V", "()V", "getDisplayDescriptors", "()Ljava/util/List;", "setDisplayDescriptors", "(Ljava/util/List;)V", "getEmulatorPanelState", "()Lcom/android/tools/idea/streaming/emulator/EmulatorPanelState;", "setEmulatorPanelState", "(Lcom/android/tools/idea/streaming/emulator/EmulatorPanelState;)V", "equals", "", "other", "hashCode", "", "intellij.android.streaming"})
    public static final class MultiDisplayState {
        public List<DisplayDescriptor> displayDescriptors;
        public EmulatorPanelState emulatorPanelState;

        public MultiDisplayState() {
        }

        public MultiDisplayState(@NotNull List<DisplayDescriptor> displayDescriptors, @NotNull EmulatorPanelState emulatorPanelState) {
            Intrinsics.checkNotNullParameter(displayDescriptors, (String)"displayDescriptors");
            Intrinsics.checkNotNullParameter((Object)emulatorPanelState, (String)"emulatorPanelState");
            this();
            this.setDisplayDescriptors(displayDescriptors);
            this.setEmulatorPanelState(emulatorPanelState);
        }

        @NotNull
        public final List<DisplayDescriptor> getDisplayDescriptors() {
            List<DisplayDescriptor> list2 = this.displayDescriptors;
            if (list2 != null) {
                return list2;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"displayDescriptors");
            return null;
        }

        public final void setDisplayDescriptors(@NotNull List<DisplayDescriptor> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
            this.displayDescriptors = list2;
        }

        @NotNull
        public final EmulatorPanelState getEmulatorPanelState() {
            EmulatorPanelState emulatorPanelState = this.emulatorPanelState;
            if (emulatorPanelState != null) {
                return emulatorPanelState;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"emulatorPanelState");
            return null;
        }

        public final void setEmulatorPanelState(@NotNull EmulatorPanelState emulatorPanelState) {
            Intrinsics.checkNotNullParameter((Object)emulatorPanelState, (String)"<set-?>");
            this.emulatorPanelState = emulatorPanelState;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.android.tools.idea.streaming.emulator.EmulatorToolWindowPanel.MultiDisplayState");
            MultiDisplayState cfr_ignored_0 = (MultiDisplayState)other;
            return Intrinsics.areEqual(this.getDisplayDescriptors(), ((MultiDisplayState)other).getDisplayDescriptors()) && Intrinsics.areEqual((Object)this.getEmulatorPanelState(), (Object)((MultiDisplayState)other).getEmulatorPanelState());
        }

        public int hashCode() {
            return HashCodes.mix((int)((Object)this.getDisplayDescriptors()).hashCode(), (int)this.getEmulatorPanelState().hashCode());
        }
    }

    @State(name="EmulatorDisplays", storages={@Storage(value="emulatorDisplays.xml")})
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0000H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0000H\u0016J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006R(\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$MultiDisplayStateStorage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "()V", "displayStateByAvdFolder", "", "", "Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$MultiDisplayState;", "getDisplayStateByAvdFolder", "()Ljava/util/Map;", "setDisplayStateByAvdFolder", "(Ljava/util/Map;)V", "updaters", "", "Ljava/lang/Runnable;", "addUpdater", "", "updater", "getMultiDisplayState", "avdFolder", "Ljava/nio/file/Path;", "getState", "loadState", "state", "removeUpdater", "setMultiDisplayState", "Companion", "intellij.android.streaming"})
    public static final class MultiDisplayStateStorage
    implements PersistentStateComponent<MultiDisplayStateStorage> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private Map<String, MultiDisplayState> displayStateByAvdFolder = new LinkedHashMap();
        @NotNull
        private final List<Runnable> updaters = new ArrayList();

        @Property(surroundWithTag=true)
        @NotNull
        public final Map<String, MultiDisplayState> getDisplayStateByAvdFolder() {
            return this.displayStateByAvdFolder;
        }

        public final void setDisplayStateByAvdFolder(@NotNull Map<String, MultiDisplayState> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            this.displayStateByAvdFolder = map2;
        }

        @NotNull
        public MultiDisplayStateStorage getState() {
            for (Runnable updater : this.updaters) {
                updater.run();
            }
            return this;
        }

        public void loadState(@NotNull MultiDisplayStateStorage state2) {
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            XmlSerializerUtil.copyBean((Object)state2, (Object)this);
        }

        public final void addUpdater(@NotNull Runnable updater) {
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            this.updaters.add(updater);
        }

        public final void removeUpdater(@NotNull Runnable updater) {
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            this.updaters.remove(updater);
        }

        @Nullable
        public final MultiDisplayState getMultiDisplayState(@NotNull Path avdFolder) {
            Intrinsics.checkNotNullParameter((Object)avdFolder, (String)"avdFolder");
            return this.displayStateByAvdFolder.get(((Object)avdFolder).toString());
        }

        public final void setMultiDisplayState(@NotNull Path avdFolder, @Nullable MultiDisplayState state2) {
            Intrinsics.checkNotNullParameter((Object)avdFolder, (String)"avdFolder");
            if (state2 == null) {
                this.displayStateByAvdFolder.remove(((Object)avdFolder).toString());
            } else {
                this.displayStateByAvdFolder.put(((Object)avdFolder).toString(), state2);
            }
        }

        @JvmStatic
        @NotNull
        public static final MultiDisplayStateStorage getInstance(@NotNull Project project) {
            return Companion.getInstance(project);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$MultiDisplayStateStorage$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$MultiDisplayStateStorage;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.streaming"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final MultiDisplayStateStorage getInstance(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Object object = project.getService(MultiDisplayStateStorage.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(Multi\u2026StateStorage::class.java)");
                return (MultiDisplayStateStorage)object;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

