/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.Slow;
import com.android.emulator.control.AudioPacket;
import com.android.emulator.control.ClipData;
import com.android.emulator.control.DisplayConfigurations;
import com.android.emulator.control.DisplayMode;
import com.android.emulator.control.DisplayModeValue;
import com.android.emulator.control.EmulatorControllerGrpc;
import com.android.emulator.control.EmulatorStatus;
import com.android.emulator.control.ExtendedControlsStatus;
import com.android.emulator.control.Image;
import com.android.emulator.control.ImageFormat;
import com.android.emulator.control.KeyboardEvent;
import com.android.emulator.control.MouseEvent;
import com.android.emulator.control.Notification;
import com.android.emulator.control.PaneEntry;
import com.android.emulator.control.PhysicalModelValue;
import com.android.emulator.control.RotationRadian;
import com.android.emulator.control.SnapshotFilter;
import com.android.emulator.control.SnapshotList;
import com.android.emulator.control.SnapshotPackage;
import com.android.emulator.control.SnapshotServiceGrpc;
import com.android.emulator.control.ThemingStyle;
import com.android.emulator.control.TouchEvent;
import com.android.emulator.control.UiControllerGrpc;
import com.android.emulator.control.Velocity;
import com.android.emulator.control.VmRunState;
import com.android.ide.common.util.Cancelable;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.io.grpc.CallCredentials;
import com.android.tools.idea.io.grpc.Channel;
import com.android.tools.idea.io.grpc.ClientCall;
import com.android.tools.idea.io.grpc.CompressorRegistry;
import com.android.tools.idea.io.grpc.ConnectivityState;
import com.android.tools.idea.io.grpc.DecompressorRegistry;
import com.android.tools.idea.io.grpc.ManagedChannel;
import com.android.tools.idea.io.grpc.MethodDescriptor;
import com.android.tools.idea.io.grpc.Status;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.io.grpc.stub.AbstractStub;
import com.android.tools.idea.io.grpc.stub.ClientCallStreamObserver;
import com.android.tools.idea.io.grpc.stub.ClientCalls;
import com.android.tools.idea.io.grpc.stub.ClientResponseObserver;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.protobuf.Empty;
import com.android.tools.idea.protobuf.MessageOrBuilder;
import com.android.tools.idea.protobuf.TextFormat;
import com.android.tools.idea.streaming.emulator.EmptyStreamObserver;
import com.android.tools.idea.streaming.emulator.EmulatorConfiguration;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.streaming.emulator.EmulatorControllerKt;
import com.android.tools.idea.streaming.emulator.EmulatorId;
import com.android.tools.idea.streaming.emulator.ImageResponseMarshaller;
import com.android.tools.idea.streaming.emulator.RuntimeConfigurationOverrider;
import com.android.tools.idea.streaming.emulator.SkinDefinition;
import com.android.tools.idea.streaming.emulator.SkinDefinitionCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00d9\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\b*\u0001\u0018\u0018\u00002\u00020\u0001:\u000e\u00a6\u0001\u00a7\u0001\u00a8\u0001\u00a9\u0001\u00aa\u0001\u00ab\u0001\u00ac\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u0016H\u0007J\u0016\u0010T\u001a\u00020R2\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020V07J\b\u0010W\u001a\u00020RH\u0007J\u0012\u0010X\u001a\u00020R2\b\b\u0002\u0010Y\u001a\u00020ZH\u0007J\u001e\u0010[\u001a\u00020R2\u0006\u0010\\\u001a\u00020]2\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020^07J\b\u0010_\u001a\u00020RH\u0016J\u001e\u0010`\u001a\u00020R2\u0006\u0010a\u001a\u0002062\f\u0010U\u001a\b\u0012\u0004\u0012\u00020807H\u0002J\u0013\u0010b\u001a\u0002002\b\u0010c\u001a\u0004\u0018\u00010dH\u0096\u0002J\u0014\u0010e\u001a\u00020R2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020f07J\u001c\u0010g\u001a\u00020R2\u0006\u0010h\u001a\u00020i2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020j07J\u001c\u0010k\u001a\u00020R2\u0006\u0010l\u001a\u00020H2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020I07J\u0014\u0010m\u001a\u00020R2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020n07J\b\u0010o\u001a\u00020ZH\u0016J \u0010p\u001a\b\u0012\u0004\u0012\u00020q072\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020q\u0012\u0004\u0012\u0002080rJ\u001e\u0010s\u001a\u00020R2\u0006\u0010t\u001a\u00020u2\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020v07J\u001e\u0010w\u001a\u00020R2\u0006\u0010\\\u001a\u00020]2\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020^07J \u0010x\u001a\b\u0012\u0004\u0012\u00020^072\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020^\u0012\u0004\u0012\u00020^0rJ\u0010\u0010y\u001a\u00020R2\u0006\u0010S\u001a\u00020\u0016H\u0007J\u001e\u0010z\u001a\u00020R2\u0006\u0010{\u001a\u00020|2\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020807J\u001e\u0010}\u001a\u00020R2\u0006\u0010\\\u001a\u00020]2\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020^07J\b\u0010~\u001a\u00020RH\u0002J\u001e\u0010\u007f\u001a\u00020R2\u0006\u0010a\u001a\u0002062\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020807J!\u0010\u0080\u0001\u001a\u00020R2\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020807J\t\u0010\u0083\u0001\u001a\u00020RH\u0002J\t\u0010\u0084\u0001\u001a\u00020RH\u0002J!\u0010\u0085\u0001\u001a\u00020R2\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020807J!\u0010\u0088\u0001\u001a\u00020R2\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020807J \u0010\u008b\u0001\u001a\u00020R2\u0007\u0010\u008c\u0001\u001a\u00020f2\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020f07J!\u0010\u008d\u0001\u001a\u00020R2\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020807J \u0010\u0090\u0001\u001a\u00020R2\u0007\u0010\u0091\u0001\u001a\u00020j2\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020807J!\u0010\u0092\u0001\u001a\u00020R2\b\u0010\u0093\u0001\u001a\u00030\u0094\u00012\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020807J!\u0010\u0095\u0001\u001a\u00020R2\b\u0010\u0096\u0001\u001a\u00030\u0097\u00012\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020807J!\u0010\u0098\u0001\u001a\u00020R2\b\u0010\u0099\u0001\u001a\u00030\u009a\u00012\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020807J!\u0010\u009b\u0001\u001a\u00020R2\b\u0010\u009c\u0001\u001a\u00030\u009d\u00012\u000e\b\u0002\u0010U\u001a\b\u0012\u0004\u0012\u00020V07J\u0007\u0010\u009e\u0001\u001a\u00020RJ\u0017\u0010\u009f\u0001\u001a\u00030\u00a0\u00012\r\u0010U\u001a\t\u0012\u0005\u0012\u00030\u008a\u000107J\u0017\u0010\u00a1\u0001\u001a\u00030\u00a0\u00012\r\u0010U\u001a\t\u0012\u0005\u0012\u00030\u00a2\u000107J\u001e\u0010\u00a3\u0001\u001a\u00030\u00a0\u00012\u0006\u0010l\u001a\u00020H2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020I07J\n\u0010\u00a4\u0001\u001a\u00030\u00a5\u0001H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u000b0\u000b0\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R%\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u001a8F@\u00c2\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R%\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"8F@\u00c2\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0010\u0010(\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001c\u0010+\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010,0,0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b/\u00101R\u000e\u00102\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u00103\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u000208070504X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00109\u001a\u0004\u0018\u00010:X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R%\u0010@\u001a\u00020?2\u0006\u0010!\u001a\u00020?8F@\u00c2\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u0010\u0010E\u001a\u0004\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0002\n\u0000RN\u0010F\u001aB\u0012\f\u0012\n \u0013*\u0004\u0018\u00010H0H\u0012\f\u0012\n \u0013*\u0004\u0018\u00010I0I \u0013* \u0012\f\u0012\n \u0013*\u0004\u0018\u00010H0H\u0012\f\u0012\n \u0013*\u0004\u0018\u00010I0I\u0018\u00010G0GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010K\u001a\u00020J2\u0006\u0010!\u001a\u00020J8F@\u00c2\u0002X\u0086\u000e\u00a2\u0006\f\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\u0010\u0010P\u001a\u0004\u0018\u00010JX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00ad\u0001"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "Lcom/intellij/openapi/Disposable;", "emulatorId", "Lcom/android/tools/idea/streaming/emulator/EmulatorId;", "parentDisposable", "(Lcom/android/tools/idea/streaming/emulator/EmulatorId;Lcom/intellij/openapi/Disposable;)V", "alarm", "Lcom/intellij/util/Alarm;", "channel", "Lcom/android/tools/idea/io/grpc/ManagedChannel;", "value", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionState;", "connectionState", "getConnectionState", "()Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionState;", "setConnectionState", "(Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionState;)V", "connectionStateInternal", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "connectionStateListeners", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionStateListener;", "connectivityStateWatcher", "com/android/tools/idea/streaming/emulator/EmulatorController$connectivityStateWatcher$1", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$connectivityStateWatcher$1;", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration;", "emulatorConfig", "getEmulatorConfig", "()Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration;", "setEmulatorConfig", "(Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration;)V", "emulatorConfigInternal", "stub", "Lcom/android/emulator/control/EmulatorControllerGrpc$EmulatorControllerStub;", "emulatorControllerStub", "getEmulatorControllerStub", "()Lcom/android/emulator/control/EmulatorControllerGrpc$EmulatorControllerStub;", "setEmulatorControllerStub", "(Lcom/android/emulator/control/EmulatorControllerGrpc$EmulatorControllerStub;)V", "emulatorControllerStubInternal", "getEmulatorId", "()Lcom/android/tools/idea/streaming/emulator/EmulatorId;", "emulatorState", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$EmulatorState;", "imageResponseMarshaller", "Lcom/android/tools/idea/streaming/emulator/ImageResponseMarshaller;", "isShuttingDown", "", "()Z", "keyboardEventInFlight", "keyboardEventQueue", "Lkotlin/collections/ArrayDeque;", "Lkotlin/Pair;", "Lcom/android/emulator/control/KeyboardEvent;", "Lcom/android/tools/idea/io/grpc/stub/StreamObserver;", "Lcom/android/tools/idea/protobuf/Empty;", "skinDefinition", "Lcom/android/tools/idea/streaming/emulator/SkinDefinition;", "getSkinDefinition$intellij_android_streaming", "()Lcom/android/tools/idea/streaming/emulator/SkinDefinition;", "setSkinDefinition$intellij_android_streaming", "(Lcom/android/tools/idea/streaming/emulator/SkinDefinition;)V", "Lcom/android/emulator/control/SnapshotServiceGrpc$SnapshotServiceStub;", "snapshotServiceStub", "getSnapshotServiceStub", "()Lcom/android/emulator/control/SnapshotServiceGrpc$SnapshotServiceStub;", "setSnapshotServiceStub", "(Lcom/android/emulator/control/SnapshotServiceGrpc$SnapshotServiceStub;)V", "snapshotServiceStubInternal", "streamScreenshotMethod", "Lcom/android/tools/idea/io/grpc/MethodDescriptor;", "Lcom/android/emulator/control/ImageFormat;", "Lcom/android/emulator/control/Image;", "Lcom/android/emulator/control/UiControllerGrpc$UiControllerStub;", "uiControllerStub", "getUiControllerStub", "()Lcom/android/emulator/control/UiControllerGrpc$UiControllerStub;", "setUiControllerStub", "(Lcom/android/emulator/control/UiControllerGrpc$UiControllerStub;)V", "uiControllerStubInternal", "addConnectionStateListener", "", "listener", "closeExtendedControls", "streamObserver", "Lcom/android/emulator/control/ExtendedControlsStatus;", "connect", "connectGrpc", "maxInboundMessageSize", "", "deleteSnapshot", "snapshotId", "", "Lcom/android/emulator/control/SnapshotPackage;", "dispose", "doSendKeyboardEvent", "keyboardEvent", "equals", "other", "", "getDisplayConfigurations", "Lcom/android/emulator/control/DisplayConfigurations;", "getPhysicalModel", "physicalType", "Lcom/android/emulator/control/PhysicalModelValue$PhysicalType;", "Lcom/android/emulator/control/PhysicalModelValue;", "getScreenshot", "imageFormat", "getStatus", "Lcom/android/emulator/control/EmulatorStatus;", "hashCode", "injectAudio", "Lcom/android/emulator/control/AudioPacket;", "Lcom/android/tools/idea/io/grpc/stub/ClientResponseObserver;", "listSnapshots", "snapshotFilter", "Lcom/android/emulator/control/SnapshotFilter;", "Lcom/android/emulator/control/SnapshotList;", "loadSnapshot", "pushSnapshot", "removeConnectionStateListener", "rotateVirtualSceneCamera", "cameraRotation", "Lcom/android/emulator/control/RotationRadian;", "saveSnapshot", "sendKeepAlive", "sendKey", "sendMouse", "mouseEvent", "Lcom/android/emulator/control/MouseEvent;", "sendQueuedKeyboardEventIfAny", "sendShutdown", "sendTouch", "touchEvent", "Lcom/android/emulator/control/TouchEvent;", "setClipboard", "clipData", "Lcom/android/emulator/control/ClipData;", "setDisplayConfigurations", "displayConfigurations", "setDisplayMode", "displayModeValue", "Lcom/android/emulator/control/DisplayModeValue;", "setPhysicalModel", "modelValue", "setUiTheme", "style", "Lcom/android/emulator/control/ThemingStyle$Style;", "setVirtualSceneCameraVelocity", "cameraVelocity", "Lcom/android/emulator/control/Velocity;", "setVmState", "vmState", "Lcom/android/emulator/control/VmRunState;", "showExtendedControls", "pane", "Lcom/android/emulator/control/PaneEntry;", "shutdown", "streamClipboard", "Lcom/android/ide/common/util/Cancelable;", "streamNotification", "Lcom/android/emulator/control/Notification;", "streamScreenshot", "throwNotYetConnected", "", "CancelableClientCall", "ConnectionState", "ConnectionStateListener", "DelegatingClientResponseObserver", "DelegatingStreamObserver", "EmulatorState", "TokenCallCredentials", "intellij.android.streaming"})
public final class EmulatorController
implements Disposable {
    @NotNull
    private final EmulatorId emulatorId;
    @NotNull
    private final ImageResponseMarshaller imageResponseMarshaller;
    private final MethodDescriptor<ImageFormat, Image> streamScreenshotMethod;
    @Nullable
    private ManagedChannel channel;
    @Nullable
    private volatile EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStubInternal;
    @Nullable
    private volatile SnapshotServiceGrpc.SnapshotServiceStub snapshotServiceStubInternal;
    @Nullable
    private volatile UiControllerGrpc.UiControllerStub uiControllerStubInternal;
    @Nullable
    private volatile EmulatorConfiguration emulatorConfigInternal;
    @Nullable
    private volatile SkinDefinition skinDefinition;
    @NotNull
    private final Alarm alarm;
    @NotNull
    private AtomicReference<ConnectionState> connectionStateInternal;
    @NotNull
    private final AtomicReference<EmulatorState> emulatorState;
    @NotNull
    private final ConcurrentList<ConnectionStateListener> connectionStateListeners;
    @NotNull
    private final connectivityStateWatcher.1 connectivityStateWatcher;
    @NotNull
    private final ArrayDeque<Pair<KeyboardEvent, StreamObserver<Empty>>> keyboardEventQueue;
    private boolean keyboardEventInFlight;

    public EmulatorController(@NotNull EmulatorId emulatorId, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)emulatorId, (String)"emulatorId");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.emulatorId = emulatorId;
        this.imageResponseMarshaller = new ImageResponseMarshaller();
        this.streamScreenshotMethod = EmulatorControllerGrpc.getStreamScreenshotMethod().toBuilder(EmulatorControllerGrpc.getStreamScreenshotMethod().getRequestMarshaller(), (MethodDescriptor.Marshaller)this.imageResponseMarshaller).build();
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.connectionStateInternal = new AtomicReference<ConnectionState>(ConnectionState.NOT_INITIALIZED);
        this.emulatorState = new AtomicReference<EmulatorState>(EmulatorState.RUNNING);
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList()");
        this.connectionStateListeners = concurrentList;
        this.connectivityStateWatcher = new Runnable(this){
            final /* synthetic */ EmulatorController this$0;
            {
                this.this$0 = $receiver;
            }

            public void run() {
                ConnectivityState state2;
                if (this.this$0.getConnectionState() == ConnectionState.DISCONNECTED) {
                    return;
                }
                ManagedChannel managedChannel = EmulatorController.access$getChannel$p(this.this$0);
                if (managedChannel == null) {
                    return;
                }
                ManagedChannel ch = managedChannel;
                ConnectivityState connectivityState = state2 = ch.getState(false);
                switch (connectivityState == null ? -1 : connectivityStateWatcher.WhenMappings.$EnumSwitchMapping$0[connectivityState.ordinal()]) {
                    case 1: {
                        EmulatorController.access$setConnectionState(this.this$0, ConnectionState.CONNECTING);
                        break;
                    }
                    case 2: {
                        EmulatorController.access$setConnectionState(this.this$0, ConnectionState.DISCONNECTED);
                    }
                }
                ch.notifyWhenStateChanged(state2, (Runnable)this);
            }
        };
        this.keyboardEventQueue = new ArrayDeque();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @NotNull
    public final EmulatorId getEmulatorId() {
        return this.emulatorId;
    }

    @Nullable
    public final SkinDefinition getSkinDefinition$intellij_android_streaming() {
        return this.skinDefinition;
    }

    public final void setSkinDefinition$intellij_android_streaming(@Nullable SkinDefinition skinDefinition) {
        this.skinDefinition = skinDefinition;
    }

    @NotNull
    public final EmulatorConfiguration getEmulatorConfig() {
        EmulatorConfiguration emulatorConfiguration = this.emulatorConfigInternal;
        if (emulatorConfiguration == null) {
            this.throwNotYetConnected();
            throw new KotlinNothingValueException();
        }
        return emulatorConfiguration;
    }

    private final void setEmulatorConfig(EmulatorConfiguration value2) {
        boolean $i$f$setEmulatorConfig = false;
        this.emulatorConfigInternal = value2;
    }

    @NotNull
    public final ConnectionState getConnectionState() {
        ConnectionState connectionState = this.connectionStateInternal.get();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)connectionState), (String)"connectionStateInternal.get()");
        return connectionState;
    }

    private final void setConnectionState(ConnectionState value2) {
        ConnectionState oldValue = this.connectionStateInternal.getAndSet(value2);
        if (oldValue != value2) {
            if (value2 == ConnectionState.DISCONNECTED) {
                if (oldValue == ConnectionState.CONNECTED) {
                    EmulatorControllerKt.access$getLOG$p().info("Disconnected from " + this.getEmulatorConfig().getAvdName() + " (" + this.emulatorId.getSerialPort() + ")");
                } else {
                    EmulatorControllerKt.access$getLOG$p().warn("Unable to connect " + this.getEmulatorConfig().getAvdName() + " (" + this.emulatorId.getSerialPort() + ")");
                }
            }
            for (ConnectionStateListener listener2 : this.connectionStateListeners) {
                listener2.connectionStateChanged(this, value2);
            }
        }
    }

    public final boolean isShuttingDown() {
        return this.emulatorState.get() != EmulatorState.RUNNING;
    }

    @NotNull
    public final EmulatorControllerGrpc.EmulatorControllerStub getEmulatorControllerStub() {
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.emulatorControllerStubInternal;
        if (emulatorControllerStub == null) {
            this.throwNotYetConnected();
            throw new KotlinNothingValueException();
        }
        return emulatorControllerStub;
    }

    private final void setEmulatorControllerStub(EmulatorControllerGrpc.EmulatorControllerStub stub) {
        boolean $i$f$setEmulatorControllerStub = false;
        this.emulatorControllerStubInternal = stub;
    }

    @NotNull
    public final SnapshotServiceGrpc.SnapshotServiceStub getSnapshotServiceStub() {
        SnapshotServiceGrpc.SnapshotServiceStub snapshotServiceStub = this.snapshotServiceStubInternal;
        if (snapshotServiceStub == null) {
            this.throwNotYetConnected();
            throw new KotlinNothingValueException();
        }
        return snapshotServiceStub;
    }

    private final void setSnapshotServiceStub(SnapshotServiceGrpc.SnapshotServiceStub stub) {
        boolean $i$f$setSnapshotServiceStub = false;
        this.snapshotServiceStubInternal = stub;
    }

    @NotNull
    public final UiControllerGrpc.UiControllerStub getUiControllerStub() {
        UiControllerGrpc.UiControllerStub uiControllerStub = this.uiControllerStubInternal;
        if (uiControllerStub == null) {
            this.throwNotYetConnected();
            throw new KotlinNothingValueException();
        }
        return uiControllerStub;
    }

    private final void setUiControllerStub(UiControllerGrpc.UiControllerStub stub) {
        boolean $i$f$setUiControllerStub = false;
        this.uiControllerStubInternal = stub;
    }

    @AnyThread
    public final void addConnectionStateListener(@NotNull ConnectionStateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.connectionStateListeners.add((Object)listener2);
    }

    @AnyThread
    public final void removeConnectionStateListener(@NotNull ConnectionStateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.connectionStateListeners.remove((Object)listener2);
    }

    @Slow
    public final void connect() {
        Comparable comparable;
        int maxInboundMessageSize = 0;
        EmulatorConfiguration config2 = EmulatorConfiguration.Companion.readAvdDefinition(this.emulatorId.getAvdId(), this.emulatorId.getAvdFolder());
        if (config2 == null) {
            this.setConnectionState(ConnectionState.DISCONNECTED);
            return;
        }
        EmulatorController this_$iv = this;
        boolean $i$f$setEmulatorConfig = false;
        this_$iv.emulatorConfigInternal = config2;
        this.skinDefinition = SkinDefinitionCache.Companion.getInstance().getSkinDefinition(config2.getSkinFolder());
        Iterator iterator2 = ((Iterable)config2.getDisplayModes()).iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            EmulatorConfiguration.DisplayMode it = (EmulatorConfiguration.DisplayMode)iterator2.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it.getDisplaySize().width * it.getDisplaySize().height);
            while (iterator2.hasNext()) {
                EmulatorConfiguration.DisplayMode it2 = (EmulatorConfiguration.DisplayMode)iterator2.next();
                $i$a$-maxOfOrNull-EmulatorController$connect$maxPixels$1 = false;
                Comparable comparable3 = Integer.valueOf(it2.getDisplaySize().width * it2.getDisplaySize().height);
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        int maxPixels = n != null ? n : config2.getDisplayWidth() * config2.getDisplayHeight();
        maxInboundMessageSize = maxPixels * 3 + 100;
        this.connectGrpc(maxInboundMessageSize);
        this.sendKeepAlive();
    }

    @Slow
    public final void connectGrpc(int maxInboundMessageSize) {
        ManagedChannel channel;
        this.setConnectionState(ConnectionState.CONNECTING);
        this.channel = channel = RuntimeConfigurationOverrider.getRuntimeConfiguration().newGrpcChannelBuilder("localhost", this.emulatorId.getGrpcPort()).usePlaintext().maxInboundMessageSize(maxInboundMessageSize).compressorRegistry(CompressorRegistry.newEmptyInstance()).decompressorRegistry(DecompressorRegistry.emptyInstance()).build();
        String token = this.emulatorId.getGrpcToken();
        if (token == null) {
            EmulatorController emulatorController = this;
            EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = EmulatorControllerGrpc.newStub((Channel)((Channel)channel));
            Intrinsics.checkNotNullExpressionValue((Object)emulatorControllerStub, (String)"newStub(channel)");
            EmulatorControllerGrpc.EmulatorControllerStub stub$iv = emulatorControllerStub;
            boolean $i$f$setEmulatorControllerStub = false;
            this_$iv.emulatorControllerStubInternal = stub$iv;
            EmulatorController this_$iv = this;
            SnapshotServiceGrpc.SnapshotServiceStub snapshotServiceStub = SnapshotServiceGrpc.newStub((Channel)((Channel)channel));
            Intrinsics.checkNotNullExpressionValue((Object)snapshotServiceStub, (String)"newStub(channel)");
            stub$iv = snapshotServiceStub;
            boolean $i$f$setSnapshotServiceStub = false;
            this_$iv.snapshotServiceStubInternal = stub$iv;
            this_$iv = this;
            UiControllerGrpc.UiControllerStub uiControllerStub = UiControllerGrpc.newStub((Channel)((Channel)channel));
            Intrinsics.checkNotNullExpressionValue((Object)uiControllerStub, (String)"newStub(channel)");
            stub$iv = uiControllerStub;
            boolean $i$f$setUiControllerStub = false;
            this_$iv.uiControllerStubInternal = stub$iv;
        } else {
            TokenCallCredentials credentials = new TokenCallCredentials(token);
            EmulatorController stub$iv = this;
            AbstractStub abstractStub = EmulatorControllerGrpc.newStub((Channel)((Channel)channel)).withCallCredentials((CallCredentials)credentials);
            Intrinsics.checkNotNullExpressionValue((Object)abstractStub, (String)"newStub(channel).withCallCredentials(credentials)");
            EmulatorControllerGrpc.EmulatorControllerStub stub$iv2 = (EmulatorControllerGrpc.EmulatorControllerStub)abstractStub;
            boolean $i$f$setEmulatorControllerStub = false;
            this_$iv.emulatorControllerStubInternal = stub$iv2;
            EmulatorController this_$iv = this;
            AbstractStub abstractStub2 = SnapshotServiceGrpc.newStub((Channel)((Channel)channel)).withCallCredentials((CallCredentials)credentials);
            Intrinsics.checkNotNullExpressionValue((Object)abstractStub2, (String)"newStub(channel).withCallCredentials(credentials)");
            stub$iv2 = (SnapshotServiceGrpc.SnapshotServiceStub)abstractStub2;
            boolean $i$f$setSnapshotServiceStub = false;
            this_$iv.snapshotServiceStubInternal = stub$iv2;
            this_$iv = this;
            AbstractStub abstractStub3 = UiControllerGrpc.newStub((Channel)((Channel)channel)).withCallCredentials((CallCredentials)credentials);
            Intrinsics.checkNotNullExpressionValue((Object)abstractStub3, (String)"newStub(channel).withCallCredentials(credentials)");
            stub$iv2 = (UiControllerGrpc.UiControllerStub)abstractStub3;
            boolean $i$f$setUiControllerStub = false;
            this_$iv.uiControllerStubInternal = stub$iv2;
        }
        channel.notifyWhenStateChanged(channel.getState(false), (Runnable)this.connectivityStateWatcher);
    }

    public static /* synthetic */ void connectGrpc$default(EmulatorController emulatorController, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0x400000;
        }
        emulatorController.connectGrpc(n);
    }

    public final void shutdown() {
        if (this.emulatorState.compareAndSet(EmulatorState.RUNNING, EmulatorState.SHUTDOWN_REQUESTED) && this.getConnectionState() == ConnectionState.CONNECTED) {
            this.sendShutdown();
        }
    }

    private final void sendShutdown() {
        if (this.emulatorState.compareAndSet(EmulatorState.SHUTDOWN_REQUESTED, EmulatorState.SHUTDOWN_SENT)) {
            this.alarm.cancelAllRequests();
            VmRunState vmRunState = VmRunState.newBuilder().setState(VmRunState.RunState.SHUTDOWN).build();
            Intrinsics.checkNotNullExpressionValue((Object)vmRunState, (String)"vmRunState");
            EmulatorController.setVmState$default(this, vmRunState, null, 2, null);
        }
    }

    @NotNull
    public final StreamObserver<AudioPacket> injectAudio(@NotNull ClientResponseObserver<AudioPacket, Empty> streamObserver) {
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("injectAudio()");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getInjectAudioMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getInjectAudioMethod()");
        StreamObserver streamObserver2 = emulatorControllerStub.injectAudio((StreamObserver)new DelegatingClientResponseObserver<AudioPacket, Empty>(streamObserver, methodDescriptor));
        Intrinsics.checkNotNullExpressionValue((Object)streamObserver2, (String)"emulatorControllerStub.i\u2026.getInjectAudioMethod()))");
        return streamObserver2;
    }

    public final void setClipboard(@NotNull ClipData clipData, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)clipData, (String)"clipData");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            String clipDataForLogging = TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)clipData.toBuilder().setText("<clipboard contents>").build()));
            EmulatorControllerKt.access$getLOG$p().info("setClipboard(" + clipDataForLogging + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getSetClipboardMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSetClipboardMethod()");
        emulatorControllerStub.setClipboard(clipData, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void setClipboard$default(EmulatorController emulatorController, ClipData clipData, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.getEmptyObserver();
        }
        emulatorController.setClipboard(clipData, streamObserver);
    }

    @NotNull
    public final Cancelable streamClipboard(@NotNull StreamObserver<ClipData> streamObserver) {
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("streamClipboard()");
        }
        MethodDescriptor method2 = EmulatorControllerGrpc.getStreamClipboardMethod();
        ClientCall call = this.getEmulatorControllerStub().getChannel().newCall(method2, this.getEmulatorControllerStub().getCallOptions());
        Empty empty = EmulatorControllerKt.access$getEMPTY_PROTO$p();
        Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
        ClientCalls.asyncServerStreamingCall((ClientCall)call, (Object)empty, (StreamObserver)new DelegatingStreamObserver(streamObserver, method2));
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"call");
        return new CancelableClientCall(call);
    }

    public final void setDisplayMode(@NotNull DisplayModeValue displayModeValue, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)displayModeValue, (String)"displayModeValue");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        DisplayMode displayMode = DisplayMode.newBuilder().setValue(displayModeValue).build();
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("setDisplayMode(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)displayMode)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getSetDisplayModeMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSetDisplayModeMethod()");
        emulatorControllerStub.setDisplayMode(displayMode, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void setDisplayMode$default(EmulatorController emulatorController, DisplayModeValue displayModeValue, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.getEmptyObserver();
        }
        emulatorController.setDisplayMode(displayModeValue, streamObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendKey(@NotNull KeyboardEvent keyboardEvent, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)keyboardEvent, (String)"keyboardEvent");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("sendKey(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)keyboardEvent)) + ")");
        }
        ArrayDeque<Pair<KeyboardEvent, StreamObserver<Empty>>> arrayDeque = this.keyboardEventQueue;
        synchronized (arrayDeque) {
            boolean bl = false;
            if (this.keyboardEventInFlight) {
                this.keyboardEventQueue.add((Object)new Pair((Object)keyboardEvent, streamObserver));
                return;
            }
            this.keyboardEventInFlight = true;
            Unit unit = Unit.INSTANCE;
        }
        this.doSendKeyboardEvent(keyboardEvent, streamObserver);
    }

    public static /* synthetic */ void sendKey$default(EmulatorController emulatorController, KeyboardEvent keyboardEvent, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.getEmptyObserver();
        }
        emulatorController.sendKey(keyboardEvent, streamObserver);
    }

    private final void doSendKeyboardEvent(KeyboardEvent keyboardEvent, StreamObserver<Empty> streamObserver) {
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getSendKeyMethod();
        DelegatingStreamObserver<KeyboardEvent, Empty> observer2 = new DelegatingStreamObserver<KeyboardEvent, Empty>(this, streamObserver, (MethodDescriptor<KeyboardEvent, Empty>)methodDescriptor){
            final /* synthetic */ EmulatorController this$0;
            {
                this.this$0 = $receiver;
                Intrinsics.checkNotNullExpressionValue($super_call_param$1, (String)"getSendKeyMethod()");
                super($streamObserver, $super_call_param$1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompleted() {
                try {
                    super.onCompleted();
                }
                finally {
                    EmulatorController.access$sendQueuedKeyboardEventIfAny(this.this$0);
                }
            }
        };
        this.getEmulatorControllerStub().sendKey(keyboardEvent, (StreamObserver)observer2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendQueuedKeyboardEventIfAny() {
        Pair item2 = null;
        ArrayDeque<Pair<KeyboardEvent, StreamObserver<Empty>>> arrayDeque = this.keyboardEventQueue;
        synchronized (arrayDeque) {
            boolean bl = false;
            this.keyboardEventInFlight = false;
            Pair pair = (Pair)this.keyboardEventQueue.removeFirstOrNull();
            if (pair == null) {
                return;
            }
            item2 = pair;
            this.keyboardEventInFlight = true;
            Unit unit = Unit.INSTANCE;
        }
        this.doSendKeyboardEvent((KeyboardEvent)item2.getFirst(), (StreamObserver<Empty>)((StreamObserver)item2.getSecond()));
    }

    public final void sendMouse(@NotNull MouseEvent mouseEvent, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_HIGH_VOLUME_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_\u2026H_VOLUME_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("sendMouse(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)mouseEvent)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getSendMouseMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSendMouseMethod()");
        emulatorControllerStub.sendMouse(mouseEvent, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void sendMouse$default(EmulatorController emulatorController, MouseEvent mouseEvent, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.getEmptyObserver();
        }
        emulatorController.sendMouse(mouseEvent, streamObserver);
    }

    public final void sendTouch(@NotNull TouchEvent touchEvent, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)touchEvent, (String)"touchEvent");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_HIGH_VOLUME_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_\u2026H_VOLUME_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("sendTouch(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)touchEvent)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getSendTouchMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSendTouchMethod()");
        emulatorControllerStub.sendTouch(touchEvent, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void sendTouch$default(EmulatorController emulatorController, TouchEvent touchEvent, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.getEmptyObserver();
        }
        emulatorController.sendTouch(touchEvent, streamObserver);
    }

    @NotNull
    public final Cancelable streamNotification(@NotNull StreamObserver<Notification> streamObserver) {
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("streamNotification()");
        }
        MethodDescriptor method2 = EmulatorControllerGrpc.getStreamNotificationMethod();
        ClientCall call = this.getEmulatorControllerStub().getChannel().newCall(method2, this.getEmulatorControllerStub().getCallOptions());
        Empty empty = EmulatorControllerKt.access$getEMPTY_PROTO$p();
        Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
        ClientCalls.asyncServerStreamingCall((ClientCall)call, (Object)empty, (StreamObserver)new DelegatingStreamObserver(streamObserver, method2));
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"call");
        return new CancelableClientCall(call);
    }

    public final void getPhysicalModel(@NotNull PhysicalModelValue.PhysicalType physicalType, @NotNull StreamObserver<PhysicalModelValue> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)physicalType, (String)"physicalType");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        PhysicalModelValue modelValue = PhysicalModelValue.newBuilder().setTarget(physicalType).build();
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("getPhysicalModel(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)modelValue)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getGetPhysicalModelMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getGetPhysicalModelMethod()");
        emulatorControllerStub.getPhysicalModel(modelValue, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public final void setPhysicalModel(@NotNull PhysicalModelValue modelValue, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)modelValue, (String)"modelValue");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("setPhysicalModel(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)modelValue)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getSetPhysicalModelMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSetPhysicalModelMethod()");
        emulatorControllerStub.setPhysicalModel(modelValue, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void setPhysicalModel$default(EmulatorController emulatorController, PhysicalModelValue physicalModelValue, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.getEmptyObserver();
        }
        emulatorController.setPhysicalModel(physicalModelValue, streamObserver);
    }

    public final void getScreenshot(@NotNull ImageFormat imageFormat, @NotNull StreamObserver<Image> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)imageFormat, (String)"imageFormat");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("getScreenshot(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)imageFormat)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getGetScreenshotMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getGetScreenshotMethod()");
        emulatorControllerStub.getScreenshot(imageFormat, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    @NotNull
    public final Cancelable streamScreenshot(@NotNull ImageFormat imageFormat, @NotNull StreamObserver<Image> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)imageFormat, (String)"imageFormat");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("streamScreenshot(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)imageFormat)) + ")");
        }
        ClientCall call = this.getEmulatorControllerStub().getChannel().newCall(this.streamScreenshotMethod, this.getEmulatorControllerStub().getCallOptions());
        MethodDescriptor<ImageFormat, Image> methodDescriptor = this.streamScreenshotMethod;
        Intrinsics.checkNotNullExpressionValue(methodDescriptor, (String)"streamScreenshotMethod");
        ClientCalls.asyncServerStreamingCall((ClientCall)call, (Object)imageFormat, (StreamObserver)new DelegatingStreamObserver<ImageFormat, Image>(streamObserver, methodDescriptor));
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"call");
        return new CancelableClientCall(call);
    }

    public final void getStatus(@NotNull StreamObserver<EmulatorStatus> streamObserver) {
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("getStatus()");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        Empty empty = EmulatorControllerKt.access$getEMPTY_PROTO$p();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getGetStatusMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getGetStatusMethod()");
        emulatorControllerStub.getStatus(empty, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public final void setVmState(@NotNull VmRunState vmState, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)vmState, (String)"vmState");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("setVmState(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)vmState)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getSetVmStateMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSetVmStateMethod()");
        emulatorControllerStub.setVmState(vmState, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void setVmState$default(EmulatorController emulatorController, VmRunState vmRunState, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.getEmptyObserver();
        }
        emulatorController.setVmState(vmRunState, streamObserver);
    }

    public final void getDisplayConfigurations(@NotNull StreamObserver<DisplayConfigurations> streamObserver) {
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("getDisplayConfigurations()");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        Empty empty = EmulatorControllerKt.access$getEMPTY_PROTO$p();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getGetDisplayConfigurationsMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getGetDisplayConfigurationsMethod()");
        emulatorControllerStub.getDisplayConfigurations(empty, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public final void setDisplayConfigurations(@NotNull DisplayConfigurations displayConfigurations, @NotNull StreamObserver<DisplayConfigurations> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)displayConfigurations, (String)"displayConfigurations");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("setDisplayConfigurations(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)displayConfigurations)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getSetDisplayConfigurationsMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSetDisplayConfigurationsMethod()");
        emulatorControllerStub.setDisplayConfigurations(displayConfigurations, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void setDisplayConfigurations$default(EmulatorController emulatorController, DisplayConfigurations displayConfigurations, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.getEmptyObserver();
        }
        emulatorController.setDisplayConfigurations(displayConfigurations, streamObserver);
    }

    public final void rotateVirtualSceneCamera(@NotNull RotationRadian cameraRotation, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)cameraRotation, (String)"cameraRotation");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("rotateVirtualSceneCamera(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)cameraRotation)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getRotateVirtualSceneCameraMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getRotateVirtualSceneCameraMethod()");
        emulatorControllerStub.rotateVirtualSceneCamera(cameraRotation, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void rotateVirtualSceneCamera$default(EmulatorController emulatorController, RotationRadian rotationRadian, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.getEmptyObserver();
        }
        emulatorController.rotateVirtualSceneCamera(rotationRadian, streamObserver);
    }

    public final void setVirtualSceneCameraVelocity(@NotNull Velocity cameraVelocity, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)cameraVelocity, (String)"cameraVelocity");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("setVirtualSceneCameraVelocity(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)cameraVelocity)) + ")");
        }
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = this.getEmulatorControllerStub();
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getSetVirtualSceneCameraVelocityMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSetVirtualSceneCameraVelocityMethod()");
        emulatorControllerStub.setVirtualSceneCameraVelocity(cameraVelocity, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void setVirtualSceneCameraVelocity$default(EmulatorController emulatorController, Velocity velocity, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.getEmptyObserver();
        }
        emulatorController.setVirtualSceneCameraVelocity(velocity, streamObserver);
    }

    public final void listSnapshots(@NotNull SnapshotFilter snapshotFilter, @NotNull StreamObserver<SnapshotList> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)snapshotFilter, (String)"snapshotFilter");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("listSnapshots()");
        }
        SnapshotServiceGrpc.SnapshotServiceStub snapshotServiceStub = this.getSnapshotServiceStub();
        MethodDescriptor methodDescriptor = SnapshotServiceGrpc.getListSnapshotsMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getListSnapshotsMethod()");
        snapshotServiceStub.listSnapshots(snapshotFilter, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void listSnapshots$default(EmulatorController emulatorController, SnapshotFilter snapshotFilter, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.getEmptyObserver();
        }
        emulatorController.listSnapshots(snapshotFilter, streamObserver);
    }

    public final void loadSnapshot(@NotNull String snapshotId, @NotNull StreamObserver<SnapshotPackage> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)snapshotId, (String)"snapshotId");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        SnapshotPackage snapshot = SnapshotPackage.newBuilder().setSnapshotId(snapshotId).build();
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("loadSnapshot(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)snapshot)) + ")");
        }
        SnapshotServiceGrpc.SnapshotServiceStub snapshotServiceStub = this.getSnapshotServiceStub();
        MethodDescriptor methodDescriptor = SnapshotServiceGrpc.getLoadSnapshotMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getLoadSnapshotMethod()");
        snapshotServiceStub.loadSnapshot(snapshot, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void loadSnapshot$default(EmulatorController emulatorController, String string, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.getEmptyObserver();
        }
        emulatorController.loadSnapshot(string, streamObserver);
    }

    @NotNull
    public final StreamObserver<SnapshotPackage> pushSnapshot(@NotNull ClientResponseObserver<SnapshotPackage, SnapshotPackage> streamObserver) {
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("pushSnapshot()");
        }
        SnapshotServiceGrpc.SnapshotServiceStub snapshotServiceStub = this.getSnapshotServiceStub();
        MethodDescriptor methodDescriptor = SnapshotServiceGrpc.getPushSnapshotMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getPushSnapshotMethod()");
        StreamObserver streamObserver2 = snapshotServiceStub.pushSnapshot((StreamObserver)new DelegatingClientResponseObserver<SnapshotPackage, SnapshotPackage>(streamObserver, methodDescriptor));
        Intrinsics.checkNotNullExpressionValue((Object)streamObserver2, (String)"snapshotServiceStub.push\u2026getPushSnapshotMethod()))");
        return streamObserver2;
    }

    public final void saveSnapshot(@NotNull String snapshotId, @NotNull StreamObserver<SnapshotPackage> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)snapshotId, (String)"snapshotId");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        SnapshotPackage snapshot = SnapshotPackage.newBuilder().setSnapshotId(snapshotId).build();
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("saveSnapshot(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)snapshot)) + ")");
        }
        SnapshotServiceGrpc.SnapshotServiceStub snapshotServiceStub = this.getSnapshotServiceStub();
        MethodDescriptor methodDescriptor = SnapshotServiceGrpc.getSaveSnapshotMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSaveSnapshotMethod()");
        snapshotServiceStub.saveSnapshot(snapshot, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void saveSnapshot$default(EmulatorController emulatorController, String string, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.getEmptyObserver();
        }
        emulatorController.saveSnapshot(string, streamObserver);
    }

    public final void deleteSnapshot(@NotNull String snapshotId, @NotNull StreamObserver<SnapshotPackage> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)snapshotId, (String)"snapshotId");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        SnapshotPackage snapshot = SnapshotPackage.newBuilder().setSnapshotId(snapshotId).build();
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("deleteSnapshot(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)snapshot)) + ")");
        }
        SnapshotServiceGrpc.SnapshotServiceStub snapshotServiceStub = this.getSnapshotServiceStub();
        MethodDescriptor methodDescriptor = SnapshotServiceGrpc.getSaveSnapshotMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSaveSnapshotMethod()");
        snapshotServiceStub.deleteSnapshot(snapshot, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void deleteSnapshot$default(EmulatorController emulatorController, String string, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.getEmptyObserver();
        }
        emulatorController.deleteSnapshot(string, streamObserver);
    }

    public final void showExtendedControls(@NotNull PaneEntry pane, @NotNull StreamObserver<ExtendedControlsStatus> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)pane, (String)"pane");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("showExtendedControls(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)pane)) + ")");
        }
        UiControllerGrpc.UiControllerStub uiControllerStub = this.getUiControllerStub();
        MethodDescriptor methodDescriptor = UiControllerGrpc.getShowExtendedControlsMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getShowExtendedControlsMethod()");
        uiControllerStub.showExtendedControls(pane, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void showExtendedControls$default(EmulatorController emulatorController, PaneEntry paneEntry, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.getEmptyObserver();
        }
        emulatorController.showExtendedControls(paneEntry, streamObserver);
    }

    public final void closeExtendedControls(@NotNull StreamObserver<ExtendedControlsStatus> streamObserver) {
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("closeExtendedControls()");
        }
        UiControllerGrpc.UiControllerStub uiControllerStub = this.getUiControllerStub();
        Empty empty = EmulatorControllerKt.access$getEMPTY_PROTO$p();
        MethodDescriptor methodDescriptor = UiControllerGrpc.getCloseExtendedControlsMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getCloseExtendedControlsMethod()");
        uiControllerStub.closeExtendedControls(empty, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void closeExtendedControls$default(EmulatorController emulatorController, StreamObserver streamObserver, int n, Object object) {
        if ((n & 1) != 0) {
            streamObserver = EmulatorControllerKt.getEmptyObserver();
        }
        emulatorController.closeExtendedControls(streamObserver);
    }

    public final void setUiTheme(@NotNull ThemingStyle.Style style, @NotNull StreamObserver<Empty> streamObserver) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(streamObserver, (String)"streamObserver");
        ThemingStyle themingStyle = ThemingStyle.newBuilder().setStyle(style).build();
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("setUiTheme(" + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)themingStyle)) + ")");
        }
        UiControllerGrpc.UiControllerStub uiControllerStub = this.getUiControllerStub();
        MethodDescriptor methodDescriptor = UiControllerGrpc.getSetUiThemeMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getSetUiThemeMethod()");
        uiControllerStub.setUiTheme(themingStyle, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    public static /* synthetic */ void setUiTheme$default(EmulatorController emulatorController, ThemingStyle.Style style, StreamObserver streamObserver, int n, Object object) {
        if ((n & 2) != 0) {
            streamObserver = EmulatorControllerKt.getEmptyObserver();
        }
        emulatorController.setUiTheme(style, streamObserver);
    }

    private final void sendKeepAlive() {
        EmptyStreamObserver<VmRunState> responseObserver2 = new EmptyStreamObserver<VmRunState>(this){
            final /* synthetic */ EmulatorController this$0;
            {
                this.this$0 = $receiver;
            }

            public void onNext(@NotNull VmRunState response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                EmulatorController.access$setConnectionState(this.this$0, ConnectionState.CONNECTED);
                if (EmulatorController.access$getEmulatorState$p(this.this$0).get() == EmulatorState.SHUTDOWN_REQUESTED) {
                    EmulatorController.access$sendShutdown(this.this$0);
                } else {
                    EmulatorController emulatorController = this.this$0;
                    EmulatorController.access$getAlarm$p(this.this$0).addRequest(new Runnable(emulatorController){
                        final /* synthetic */ EmulatorController $tmp0;
                        {
                            this.$tmp0 = $tmp0;
                        }

                        public final void run() {
                            EmulatorController.access$sendKeepAlive(this.$tmp0);
                        }
                    }, EmulatorControllerKt.access$getKEEP_ALIVE_INTERVAL_MILLIS$p());
                }
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                if (t instanceof StatusRuntimeException && ((StatusRuntimeException)t).getStatus().getCode() == Status.Code.UNAVAILABLE || this.this$0.getConnectionState() != ConnectionState.CONNECTED) {
                    EmulatorController.access$setConnectionState(this.this$0, ConnectionState.DISCONNECTED);
                }
            }
        };
        Object t = StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()");
        if (((Boolean)t).booleanValue()) {
            EmulatorControllerKt.access$getLOG$p().info("getVmState()");
        }
        long timeout = this.getConnectionState() == ConnectionState.CONNECTED ? 3L : 15L;
        EmulatorControllerGrpc.EmulatorControllerStub emulatorControllerStub = (EmulatorControllerGrpc.EmulatorControllerStub)this.getEmulatorControllerStub().withDeadlineAfter(timeout, TimeUnit.SECONDS);
        Empty empty = EmulatorControllerKt.access$getEMPTY_PROTO$p();
        StreamObserver streamObserver = responseObserver2;
        MethodDescriptor methodDescriptor = EmulatorControllerGrpc.getGetVmStateMethod();
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"getGetVmStateMethod()");
        emulatorControllerStub.getVmState(empty, (StreamObserver)new DelegatingStreamObserver(streamObserver, methodDescriptor));
    }

    private final Void throwNotYetConnected() {
        throw new IllegalStateException("Not yet connected to the Emulator");
    }

    public void dispose() {
        block0: {
            ManagedChannel managedChannel = this.channel;
            if (managedChannel == null) break block0;
            managedChannel.shutdown();
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.android.tools.idea.streaming.emulator.EmulatorController");
        EmulatorController cfr_ignored_0 = (EmulatorController)other;
        return Intrinsics.areEqual((Object)this.emulatorId, (Object)((EmulatorController)other).emulatorId);
    }

    public int hashCode() {
        return this.emulatorId.hashCode();
    }

    public static final /* synthetic */ void access$sendQueuedKeyboardEventIfAny(EmulatorController $this) {
        $this.sendQueuedKeyboardEventIfAny();
    }

    public static final /* synthetic */ AtomicReference access$getEmulatorState$p(EmulatorController $this) {
        return $this.emulatorState;
    }

    public static final /* synthetic */ void access$sendShutdown(EmulatorController $this) {
        $this.sendShutdown();
    }

    public static final /* synthetic */ Alarm access$getAlarm$p(EmulatorController $this) {
        return $this.alarm;
    }

    public static final /* synthetic */ void access$sendKeepAlive(EmulatorController $this) {
        $this.sendKeepAlive();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionState;", "", "(Ljava/lang/String;I)V", "NOT_INITIALIZED", "CONNECTING", "CONNECTED", "DISCONNECTED", "intellij.android.streaming"})
    public static final class ConnectionState
    extends Enum<ConnectionState> {
        public static final /* enum */ ConnectionState NOT_INITIALIZED = new ConnectionState();
        public static final /* enum */ ConnectionState CONNECTING = new ConnectionState();
        public static final /* enum */ ConnectionState CONNECTED = new ConnectionState();
        public static final /* enum */ ConnectionState DISCONNECTED = new ConnectionState();
        private static final /* synthetic */ ConnectionState[] $VALUES;

        public static ConnectionState[] values() {
            return (ConnectionState[])$VALUES.clone();
        }

        public static ConnectionState valueOf(String value2) {
            return Enum.valueOf(ConnectionState.class, value2);
        }

        static {
            $VALUES = connectionStateArray = new ConnectionState[]{ConnectionState.NOT_INITIALIZED, ConnectionState.CONNECTING, ConnectionState.CONNECTED, ConnectionState.DISCONNECTED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController$EmulatorState;", "", "(Ljava/lang/String;I)V", "RUNNING", "SHUTDOWN_REQUESTED", "SHUTDOWN_SENT", "intellij.android.streaming"})
    public static final class EmulatorState
    extends Enum<EmulatorState> {
        public static final /* enum */ EmulatorState RUNNING = new EmulatorState();
        public static final /* enum */ EmulatorState SHUTDOWN_REQUESTED = new EmulatorState();
        public static final /* enum */ EmulatorState SHUTDOWN_SENT = new EmulatorState();
        private static final /* synthetic */ EmulatorState[] $VALUES;

        public static EmulatorState[] values() {
            return (EmulatorState[])$VALUES.clone();
        }

        public static EmulatorState valueOf(String value2) {
            return Enum.valueOf(EmulatorState.class, value2);
        }

        static {
            $VALUES = emulatorStateArray = new EmulatorState[]{EmulatorState.RUNNING, EmulatorState.SHUTDOWN_REQUESTED, EmulatorState.SHUTDOWN_SENT};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController$CancelableClientCall;", "Lcom/android/ide/common/util/Cancelable;", "call", "Lcom/android/tools/idea/io/grpc/ClientCall;", "(Lcom/android/tools/idea/streaming/emulator/EmulatorController;Lcom/android/tools/idea/io/grpc/ClientCall;)V", "cancel", "", "intellij.android.streaming"})
    public final class CancelableClientCall
    implements Cancelable {
        @NotNull
        private final ClientCall<?, ?> call;

        public CancelableClientCall(ClientCall<?, ?> call) {
            Intrinsics.checkNotNullParameter(call, (String)"call");
            this.call = call;
        }

        public void cancel() {
            this.call.cancel("Canceled by consumer", null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0096\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u0003B/\u0012\u0010\u0010\u0004\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0001\u0018\u00010\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0000\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0015\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013R\u001e\u0010\u0004\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0001\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\u0005\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0000\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController$DelegatingStreamObserver;", "RequestT", "ResponseT", "Lcom/android/tools/idea/io/grpc/stub/StreamObserver;", "delegate", "method", "Lcom/android/tools/idea/io/grpc/MethodDescriptor;", "(Lcom/android/tools/idea/streaming/emulator/EmulatorController;Lcom/android/tools/idea/io/grpc/stub/StreamObserver;Lcom/android/tools/idea/io/grpc/MethodDescriptor;)V", "getDelegate", "()Lcom/android/tools/idea/io/grpc/stub/StreamObserver;", "getMethod", "()Lcom/android/tools/idea/io/grpc/MethodDescriptor;", "onCompleted", "", "onError", "t", "", "onNext", "response", "(Ljava/lang/Object;)V", "intellij.android.streaming"})
    public class DelegatingStreamObserver<RequestT, ResponseT>
    implements StreamObserver<ResponseT> {
        @Nullable
        private final StreamObserver<? super ResponseT> delegate;
        @NotNull
        private final MethodDescriptor<? super RequestT, ? super ResponseT> method;

        public DelegatingStreamObserver(@NotNull StreamObserver<? super ResponseT> delegate2, MethodDescriptor<? super RequestT, ? super ResponseT> method2) {
            Intrinsics.checkNotNullParameter(method2, (String)"method");
            this.delegate = delegate2;
            this.method = method2;
        }

        @Nullable
        public StreamObserver<? super ResponseT> getDelegate() {
            return this.delegate;
        }

        @NotNull
        public final MethodDescriptor<? super RequestT, ? super ResponseT> getMethod() {
            return this.method;
        }

        public void onNext(ResponseT response2) {
            block0: {
                StreamObserver<ResponseT> streamObserver = this.getDelegate();
                if (streamObserver == null) break block0;
                streamObserver.onNext(response2);
            }
        }

        public void onError(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            if (!(t instanceof StatusRuntimeException) || ((StatusRuntimeException)t).getStatus().getCode() != Status.Code.CANCELLED) {
                ManagedChannel managedChannel = EmulatorController.this.channel;
                boolean bl = managedChannel != null ? !managedChannel.isShutdown() : false;
                if (bl) {
                    EmulatorControllerKt.access$getLOG$p().warn(this.method.getFullMethodName() + " call failed - " + t.getMessage());
                }
            }
            StreamObserver<ResponseT> streamObserver = this.getDelegate();
            if (streamObserver != null) {
                streamObserver.onError(t);
            }
            if (t instanceof StatusRuntimeException && ((StatusRuntimeException)t).getStatus().getCode() == Status.Code.UNAVAILABLE) {
                EmulatorController.this.setConnectionState(ConnectionState.DISCONNECTED);
            }
        }

        public void onCompleted() {
            block0: {
                StreamObserver<ResponseT> streamObserver = this.getDelegate();
                if (streamObserver == null) break block0;
                streamObserver.onCompleted();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0012\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003R\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0005B3\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0000\u0012\u00028\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000fH\u0016R\"\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController$DelegatingClientResponseObserver;", "RequestT", "ResponseT", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$DelegatingStreamObserver;", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "Lcom/android/tools/idea/io/grpc/stub/ClientResponseObserver;", "delegate", "method", "Lcom/android/tools/idea/io/grpc/MethodDescriptor;", "(Lcom/android/tools/idea/streaming/emulator/EmulatorController;Lcom/android/tools/idea/io/grpc/stub/ClientResponseObserver;Lcom/android/tools/idea/io/grpc/MethodDescriptor;)V", "getDelegate", "()Lcom/android/tools/idea/io/grpc/stub/ClientResponseObserver;", "beforeStart", "", "requestStream", "Lcom/android/tools/idea/io/grpc/stub/ClientCallStreamObserver;", "intellij.android.streaming"})
    public final class DelegatingClientResponseObserver<RequestT, ResponseT>
    extends DelegatingStreamObserver<RequestT, ResponseT>
    implements ClientResponseObserver<RequestT, ResponseT> {
        @Nullable
        private final ClientResponseObserver<RequestT, ResponseT> delegate;

        public DelegatingClientResponseObserver(@NotNull ClientResponseObserver<RequestT, ResponseT> delegate2, MethodDescriptor<? super RequestT, ? super ResponseT> method2) {
            Intrinsics.checkNotNullParameter(method2, (String)"method");
            super((StreamObserver)delegate2, method2);
            this.delegate = delegate2;
        }

        @Nullable
        public ClientResponseObserver<RequestT, ResponseT> getDelegate() {
            return this.delegate;
        }

        public void beforeStart(@Nullable ClientCallStreamObserver<RequestT> requestStream) {
            block0: {
                ClientResponseObserver<RequestT, ResponseT> clientResponseObserver = this.getDelegate();
                if (clientResponseObserver == null) break block0;
                clientResponseObserver.beforeStart(requestStream);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H'\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionStateListener;", "", "connectionStateChanged", "", "emulator", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "connectionState", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionState;", "intellij.android.streaming"})
    public static interface ConnectionStateListener {
        @AnyThread
        public void connectionStateChanged(@NotNull EmulatorController var1, @NotNull ConnectionState var2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorController$TokenCallCredentials;", "Lcom/android/tools/idea/io/grpc/CallCredentials;", "token", "", "(Ljava/lang/String;)V", "applyRequestMetadata", "", "requestInfo", "Lcom/android/tools/idea/io/grpc/CallCredentials$RequestInfo;", "executor", "Ljava/util/concurrent/Executor;", "applier", "Lcom/android/tools/idea/io/grpc/CallCredentials$MetadataApplier;", "thisUsesUnstableApi", "intellij.android.streaming"})
    private static final class TokenCallCredentials
    extends CallCredentials {
        @NotNull
        private final String token;

        public TokenCallCredentials(@NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            this.token = token;
        }

        public void applyRequestMetadata(@NotNull CallCredentials.RequestInfo requestInfo, @NotNull Executor executor2, @NotNull CallCredentials.MetadataApplier applier) {
            Intrinsics.checkNotNullParameter((Object)requestInfo, (String)"requestInfo");
            Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)applier, (String)"applier");
            executor2.execute(new Runnable(this, applier){
                final /* synthetic */ TokenCallCredentials this$0;
                final /* synthetic */ CallCredentials.MetadataApplier $applier;
                {
                    this.this$0 = $receiver;
                    this.$applier = $applier;
                }

                public final void run() {
                    try {
                        com.android.tools.idea.io.grpc.Metadata headers = new com.android.tools.idea.io.grpc.Metadata();
                        headers.put(EmulatorControllerKt.access$getAUTHORIZATION_METADATA_KEY$p(), (Object)("Bearer " + TokenCallCredentials.access$getToken$p(this.this$0)));
                        this.$applier.apply(headers);
                    }
                    catch (Throwable e) {
                        TokenCallCredentials $this$thisLogger$iv = this.this$0;
                        boolean $i$f$thisLogger = false;
                        Logger logger2 = Logger.getInstance(TokenCallCredentials.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
                        logger2.error(e);
                        this.$applier.fail(Status.UNAUTHENTICATED.withCause(e));
                    }
                }
            });
        }

        public void thisUsesUnstableApi() {
        }

        public static final /* synthetic */ String access$getToken$p(TokenCallCredentials $this) {
            return $this.token;
        }
    }
}

