/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.emulator.control.DisplayModeValue;
import com.android.emulator.control.Rotation;
import com.android.tools.idea.streaming.emulator.KeyValueFiles;
import com.google.common.base.Splitter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Dimension;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u001a\u0018\u0000 -2\u00020\u0001:\u0002-.Bw\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0006\u0010\u0016\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0017R\u0011\u0010\u0016\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u0011\u0010\u001f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0019R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0019R\u0011\u0010\u0010\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010(R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010(R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010(R\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010(R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001b\u00a8\u0006/"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration;", "", "avdName", "", "avdFolder", "Ljava/nio/file/Path;", "displaySize", "Ljava/awt/Dimension;", "density", "", "skinFolder", "isFoldable", "", "isRollable", "isWearOs", "hasOrientationSensors", "hasAudioOutput", "initialOrientation", "Lcom/android/emulator/control/Rotation$SkinRotation;", "displayModes", "", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;", "api", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/awt/Dimension;ILjava/nio/file/Path;ZZZZZLcom/android/emulator/control/Rotation$SkinRotation;Ljava/util/List;I)V", "getApi", "()I", "getAvdFolder", "()Ljava/nio/file/Path;", "getAvdName", "()Ljava/lang/String;", "getDensity", "displayHeight", "getDisplayHeight", "getDisplayModes", "()Ljava/util/List;", "getDisplaySize", "()Ljava/awt/Dimension;", "displayWidth", "getDisplayWidth", "getHasAudioOutput", "()Z", "getHasOrientationSensors", "getInitialOrientation", "()Lcom/android/emulator/control/Rotation$SkinRotation;", "getSkinFolder", "Companion", "DisplayMode", "intellij.android.streaming"})
public final class EmulatorConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String avdName;
    @NotNull
    private final Path avdFolder;
    @NotNull
    private final Dimension displaySize;
    private final int density;
    @Nullable
    private final Path skinFolder;
    private final boolean isFoldable;
    private final boolean isRollable;
    private final boolean isWearOs;
    private final boolean hasOrientationSensors;
    private final boolean hasAudioOutput;
    @NotNull
    private final Rotation.SkinRotation initialOrientation;
    @NotNull
    private final List<DisplayMode> displayModes;
    private final int api;

    private EmulatorConfiguration(String avdName, Path avdFolder, Dimension displaySize, int density, Path skinFolder, boolean isFoldable, boolean isRollable, boolean isWearOs, boolean hasOrientationSensors, boolean hasAudioOutput, Rotation.SkinRotation initialOrientation, List<DisplayMode> displayModes, int api) {
        this.avdName = avdName;
        this.avdFolder = avdFolder;
        this.displaySize = displaySize;
        this.density = density;
        this.skinFolder = skinFolder;
        this.isFoldable = isFoldable;
        this.isRollable = isRollable;
        this.isWearOs = isWearOs;
        this.hasOrientationSensors = hasOrientationSensors;
        this.hasAudioOutput = hasAudioOutput;
        this.initialOrientation = initialOrientation;
        this.displayModes = displayModes;
        this.api = api;
    }

    @NotNull
    public final String getAvdName() {
        return this.avdName;
    }

    @NotNull
    public final Path getAvdFolder() {
        return this.avdFolder;
    }

    @NotNull
    public final Dimension getDisplaySize() {
        return this.displaySize;
    }

    public final int getDensity() {
        return this.density;
    }

    @Nullable
    public final Path getSkinFolder() {
        return this.skinFolder;
    }

    public final boolean isFoldable() {
        return this.isFoldable;
    }

    public final boolean isRollable() {
        return this.isRollable;
    }

    public final boolean isWearOs() {
        return this.isWearOs;
    }

    public final boolean getHasOrientationSensors() {
        return this.hasOrientationSensors;
    }

    public final boolean getHasAudioOutput() {
        return this.hasAudioOutput;
    }

    @NotNull
    public final Rotation.SkinRotation getInitialOrientation() {
        return this.initialOrientation;
    }

    @NotNull
    public final List<DisplayMode> getDisplayModes() {
        return this.displayModes;
    }

    public final int getApi() {
        return this.api;
    }

    public final int getDisplayWidth() {
        return this.displaySize.width;
    }

    public final int getDisplayHeight() {
        return this.displaySize.height;
    }

    public /* synthetic */ EmulatorConfiguration(String avdName, Path avdFolder, Dimension displaySize, int density, Path skinFolder, boolean isFoldable, boolean isRollable, boolean isWearOs, boolean hasOrientationSensors, boolean hasAudioOutput, Rotation.SkinRotation initialOrientation, List displayModes, int api, DefaultConstructorMarker $constructor_marker) {
        this(avdName, avdFolder, displaySize, density, skinFolder, isFoldable, isRollable, isWearOs, hasOrientationSensors, hasAudioOutput, initialOrientation, displayModes, api);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0004\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$Companion;", "", "()V", "getSkinPath", "Ljava/nio/file/Path;", "configIni", "", "", "androidSdkRoot", "parseDisplayMode", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;", "mode", "parseDisplayModes", "", "modes", "readAvdDefinition", "Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration;", "avdId", "avdFolder", "intellij.android.streaming"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final EmulatorConfiguration readAvdDefinition(@NotNull String avdId, @NotNull Path avdFolder) {
            List list2;
            String string;
            Intrinsics.checkNotNullParameter((Object)avdId, (String)"avdId");
            Intrinsics.checkNotNullParameter((Object)avdFolder, (String)"avdFolder");
            Path hardwareIniFile = avdFolder.resolve("hardware-qemu.ini");
            Object[] objectArray = new String[]{"android.sdk.root", "hw.audioOutput", "hw.lcd.height", "hw.lcd.width", "hw.lcd.density", "hw.sensor.hinge.count", "hw.sensor.roll.count"};
            Set keysToExtract1 = SetsKt.setOf((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)hardwareIniFile, (String)"hardwareIniFile");
            Map<String, String> map2 = KeyValueFiles.readKeyValueFile(hardwareIniFile, keysToExtract1);
            if (map2 == null) {
                return null;
            }
            Map<String, String> hardwareIni = map2;
            String string2 = hardwareIni.get("android.sdk.root");
            if (string2 == null) {
                string2 = string = System.getenv("ANDROID_HOME");
            }
            if (string2 == null) {
                string = "";
            }
            String sdkPath = string;
            Path androidSdkRoot = avdFolder.resolve(sdkPath);
            int displayWidth = StringUtil.parseInt((String)hardwareIni.get("hw.lcd.width"), (int)0);
            int displayHeight = StringUtil.parseInt((String)hardwareIni.get("hw.lcd.height"), (int)0);
            if (displayWidth <= 0 || displayHeight <= 0) {
                return null;
            }
            int density = StringUtil.parseInt((String)hardwareIni.get("hw.lcd.density"), (int)0);
            String string3 = hardwareIni.get("hw.audioOutput");
            boolean hasAudioOutput = string3 != null ? Boolean.parseBoolean(string3) : true;
            boolean isFoldable = StringUtil.parseInt((String)hardwareIni.get("hw.sensor.hinge.count"), (int)0) > 0;
            boolean isRollable = StringUtil.parseInt((String)hardwareIni.get("hw.sensor.roll.count"), (int)0) > 0;
            Path configIniFile = avdFolder.resolve("config.ini");
            Object[] objectArray2 = new String[]{"avd.ini.displayname", "hw.resizable.configs", "hw.sensors.orientation", "hw.initialOrientation", "image.sysdir.1", "showDeviceFrame", "skin.path", "tag.id"};
            Set keysToExtract2 = SetsKt.setOf((Object[])objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)configIniFile, (String)"configIniFile");
            Map<String, String> map3 = KeyValueFiles.readKeyValueFile(configIniFile, keysToExtract2);
            if (map3 == null) {
                return null;
            }
            Map<String, String> configIni = map3;
            String string4 = configIni.get("avd.ini.displayname");
            if (string4 == null) {
                string4 = StringsKt.replace$default((String)avdId, (char)'_', (char)' ', (boolean)false, (int)4, null);
            }
            String avdName = string4;
            Rotation.SkinRotation initialOrientation = StringsKt.equals((String)"landscape", (String)configIni.get("hw.initialOrientation"), (boolean)true) ? Rotation.SkinRotation.LANDSCAPE : Rotation.SkinRotation.PORTRAIT;
            Intrinsics.checkNotNullExpressionValue((Object)androidSdkRoot, (String)"androidSdkRoot");
            Path skinPath = this.getSkinPath(configIni, androidSdkRoot);
            String string5 = configIni.get("tag.id");
            boolean isWearOs = string5 != null ? StringsKt.equals((String)string5, (String)"android-wear", (boolean)true) : false;
            String string6 = configIni.get("hw.sensors.orientation");
            boolean hasOrientationSensors = string6 != null ? StringsKt.equals((String)string6, (String)"yes", (boolean)true) : true;
            try {
                Object object;
                block15: {
                    block14: {
                        object = configIni.get("hw.resizable.configs");
                        if (object == null) break block14;
                        String p0 = object;
                        boolean bl = false;
                        List list3 = this.parseDisplayModes(p0);
                        object = list3;
                        if (list3 != null) break block15;
                    }
                    object = CollectionsKt.emptyList();
                }
                list2 = object;
            }
            catch (Exception e) {
                Companion $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
                logger2.warn("Unrecognized value of the hw.resizable.configs property, \"" + configIni.get("hw.resizable.configs") + "\", in " + configIniFile);
                list2 = CollectionsKt.emptyList();
            }
            List displayModes = list2;
            int api = 0;
            String systemImage = configIni.get("image.sysdir.1");
            if (systemImage != null) {
                Path sourcePropertiesFile = androidSdkRoot.resolve(systemImage).resolve("source.properties");
                Intrinsics.checkNotNullExpressionValue((Object)sourcePropertiesFile, (String)"sourcePropertiesFile");
                Map<String, String> map4 = KeyValueFiles.readKeyValueFile(sourcePropertiesFile, SetsKt.setOf((Object)"AndroidVersion.ApiLevel"));
                if (map4 == null) {
                    return null;
                }
                Map<String, String> sourceProperties = map4;
                api = StringUtil.parseInt((String)sourceProperties.get("AndroidVersion.ApiLevel"), (int)0);
            } else {
                api = 0;
            }
            return new EmulatorConfiguration(avdName, avdFolder, new Dimension(displayWidth, displayHeight), density, skinPath, isFoldable, isRollable, isWearOs, hasOrientationSensors, hasAudioOutput, initialOrientation, displayModes, api, null);
        }

        private final Path getSkinPath(Map<String, String> configIni, Path androidSdkRoot) {
            if (StringsKt.equals((String)"no", (String)configIni.get("showDeviceFrame"), (boolean)true)) {
                return null;
            }
            String skinPath = configIni.get("skin.path");
            return skinPath == null || Intrinsics.areEqual((Object)skinPath, (Object)"_no_skin") ? null : androidSdkRoot.resolve(skinPath);
        }

        /*
         * WARNING - void declaration
         */
        private final List<DisplayMode> parseDisplayModes(String modes) {
            void $this$mapTo$iv$iv;
            List list2 = Splitter.on((char)',').trimResults().splitToList((CharSequence)modes);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"on(',').trimResults().splitToList(modes)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(this.parseDisplayMode((String)p0));
            }
            return (List)destination$iv$iv;
        }

        private final DisplayMode parseDisplayMode(String mode) {
            List segments = Splitter.on((char)'-').splitToList((CharSequence)mode);
            DisplayModeValue[] displayModeValueArray = DisplayModeValue.values();
            Object e = segments.get(1);
            Intrinsics.checkNotNullExpressionValue(e, (String)"segments[1]");
            DisplayModeValue displayModeId = displayModeValueArray[Integer.parseInt((String)e)];
            Object e2 = segments.get(2);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"segments[2]");
            int width = Integer.parseInt((String)e2);
            Object e3 = segments.get(3);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"segments[3]");
            int height = Integer.parseInt((String)e3);
            if (width <= 0 || height <= 0) {
                throw new IllegalArgumentException();
            }
            return new DisplayMode(displayModeId, width, height);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\tH\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorConfiguration$DisplayMode;", "", "displayModeId", "Lcom/android/emulator/control/DisplayModeValue;", "width", "", "height", "(Lcom/android/emulator/control/DisplayModeValue;II)V", "displaySize", "Ljava/awt/Dimension;", "(Lcom/android/emulator/control/DisplayModeValue;Ljava/awt/Dimension;)V", "getDisplayModeId", "()Lcom/android/emulator/control/DisplayModeValue;", "getDisplaySize", "()Ljava/awt/Dimension;", "getHeight", "()I", "getWidth", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.streaming"})
    public static final class DisplayMode {
        @NotNull
        private final DisplayModeValue displayModeId;
        @NotNull
        private final Dimension displaySize;

        public DisplayMode(@NotNull DisplayModeValue displayModeId, @NotNull Dimension displaySize) {
            Intrinsics.checkNotNullParameter((Object)displayModeId, (String)"displayModeId");
            Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
            this.displayModeId = displayModeId;
            this.displaySize = displaySize;
        }

        @NotNull
        public final DisplayModeValue getDisplayModeId() {
            return this.displayModeId;
        }

        @NotNull
        public final Dimension getDisplaySize() {
            return this.displaySize;
        }

        public DisplayMode(@NotNull DisplayModeValue displayModeId, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)displayModeId, (String)"displayModeId");
            this(displayModeId, new Dimension(width, height));
        }

        public final int getWidth() {
            return this.displaySize.width;
        }

        public final int getHeight() {
            return this.displaySize.height;
        }

        @NotNull
        public final DisplayModeValue component1() {
            return this.displayModeId;
        }

        @NotNull
        public final Dimension component2() {
            return this.displaySize;
        }

        @NotNull
        public final DisplayMode copy(@NotNull DisplayModeValue displayModeId, @NotNull Dimension displaySize) {
            Intrinsics.checkNotNullParameter((Object)displayModeId, (String)"displayModeId");
            Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
            return new DisplayMode(displayModeId, displaySize);
        }

        public static /* synthetic */ DisplayMode copy$default(DisplayMode displayMode, DisplayModeValue displayModeValue, Dimension dimension2, int n, Object object) {
            if ((n & 1) != 0) {
                displayModeValue = displayMode.displayModeId;
            }
            if ((n & 2) != 0) {
                dimension2 = displayMode.displaySize;
            }
            return displayMode.copy(displayModeValue, dimension2);
        }

        @NotNull
        public String toString() {
            return "DisplayMode(displayModeId=" + this.displayModeId + ", displaySize=" + this.displaySize + ")";
        }

        public int hashCode() {
            int result2 = this.displayModeId.hashCode();
            result2 = result2 * 31 + this.displaySize.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DisplayMode)) {
                return false;
            }
            DisplayMode displayMode = (DisplayMode)other;
            if (this.displayModeId != displayMode.displayModeId) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.displaySize, (Object)displayMode.displaySize);
        }
    }
}

