/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device.screenshot;

import com.android.annotations.concurrency.Slow;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.adtui.device.DeviceArtDescriptor;
import com.android.tools.adtui.device.DeviceArtPainter;
import com.android.tools.idea.streaming.device.screenshot.DeviceFramingOption;
import com.android.tools.idea.streaming.emulator.SkinDefinition;
import com.android.tools.idea.streaming.emulator.SkinDefinitionCache;
import com.android.tools.idea.streaming.emulator.SkinLayout;
import com.android.tools.idea.ui.screenshot.FramingOption;
import com.android.tools.idea.ui.screenshot.ScreenshotImage;
import com.android.tools.idea.ui.screenshot.ScreenshotPostprocessor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0017J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/streaming/device/screenshot/DeviceScreenshotPostprocessor;", "Lcom/android/tools/idea/ui/screenshot/ScreenshotPostprocessor;", "()V", "addDeviceArtBasedFrame", "Ljava/awt/image/BufferedImage;", "screenshotImage", "Lcom/android/tools/idea/ui/screenshot/ScreenshotImage;", "frameDescriptor", "Lcom/android/tools/adtui/device/DeviceArtDescriptor;", "addFrame", "framingOption", "Lcom/android/tools/idea/ui/screenshot/FramingOption;", "backgroundColor", "Ljava/awt/Color;", "addSkinBasedFrame", "skinFolder", "Ljava/nio/file/Path;", "intellij.android.streaming"})
public final class DeviceScreenshotPostprocessor
implements ScreenshotPostprocessor {
    @Override
    @Slow
    @NotNull
    public BufferedImage addFrame(@NotNull ScreenshotImage screenshotImage, @Nullable FramingOption framingOption, @Nullable Color backgroundColor) {
        Intrinsics.checkNotNullParameter((Object)screenshotImage, (String)"screenshotImage");
        if (framingOption == null) {
            BufferedImage bufferedImage;
            if (screenshotImage.isRoundDisplay()) {
                BufferedImage bufferedImage2 = ImageUtils.circularClip((BufferedImage)screenshotImage.getImage(), (Color)backgroundColor);
                bufferedImage = bufferedImage2;
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"circularClip(screenshotI\u2026e.image, backgroundColor)");
            } else {
                bufferedImage = screenshotImage.getImage();
            }
            return bufferedImage;
        }
        DeviceFramingOption cfr_ignored_0 = (DeviceFramingOption)framingOption;
        Path skinFolder = ((DeviceFramingOption)framingOption).getSkinFolder();
        return skinFolder != null ? this.addSkinBasedFrame(screenshotImage, skinFolder) : (((DeviceFramingOption)framingOption).getDeviceArtDescriptor() != null ? this.addDeviceArtBasedFrame(screenshotImage, ((DeviceFramingOption)framingOption).getDeviceArtDescriptor()) : screenshotImage.getImage());
    }

    private final BufferedImage addSkinBasedFrame(ScreenshotImage screenshotImage, Path skinFolder) {
        BufferedImage image = screenshotImage.getImage();
        SkinDefinition skinDefinition = SkinDefinitionCache.Companion.getInstance().getSkinDefinition(skinFolder);
        if (skinDefinition == null) {
            return image;
        }
        SkinDefinition skinDefinition2 = skinDefinition;
        int w = image.getWidth();
        int h = image.getHeight();
        SkinLayout skin = skinDefinition2.createScaledLayout(w, h, screenshotImage.getScreenshotRotationQuadrants());
        Rectangle frameRectangle = skin.getFrameRectangle();
        BufferedImage result2 = new BufferedImage(frameRectangle.width, frameRectangle.height, 2);
        Graphics2D graphics = result2.createGraphics();
        Rectangle displayRectangle = new Rectangle(-frameRectangle.x, -frameRectangle.y, w, h);
        graphics.drawImage(image, null, displayRectangle.x, displayRectangle.y);
        Intrinsics.checkNotNullExpressionValue((Object)graphics, (String)"graphics");
        skin.drawFrameAndMask(graphics, displayRectangle);
        graphics.dispose();
        return result2;
    }

    private final BufferedImage addDeviceArtBasedFrame(ScreenshotImage screenshotImage, DeviceArtDescriptor frameDescriptor) {
        BufferedImage bufferedImage = DeviceArtPainter.createFrame((BufferedImage)screenshotImage.getImage(), (DeviceArtDescriptor)frameDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createFrame(screenshotIm\u2026e.image, frameDescriptor)");
        BufferedImage framedImage = bufferedImage;
        BufferedImage bufferedImage2 = ImageUtils.cropBlank((BufferedImage)framedImage, null);
        if (bufferedImage2 == null) {
            throw new IllegalArgumentException("The screenshot is completely transparent");
        }
        return bufferedImage2;
    }
}

