/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device.screenshot;

import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.resources.ScreenRound;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.adtui.device.DeviceArtDescriptor;
import com.android.tools.idea.sdk.IdeDeviceManagers;
import com.android.tools.idea.streaming.device.DeviceConfiguration;
import com.android.tools.idea.streaming.device.DeviceView;
import com.android.tools.idea.streaming.device.screenshot.DeviceFramingOption;
import com.android.tools.idea.streaming.device.screenshot.DeviceScreenshotPostprocessor;
import com.android.tools.idea.ui.screenshot.FramingOption;
import com.android.tools.idea.ui.screenshot.ScreenshotAction;
import com.android.tools.idea.ui.screenshot.ScreenshotImage;
import com.android.tools.idea.ui.screenshot.ScreenshotPostprocessor;
import com.android.tools.idea.ui.screenshot.ScreenshotViewer;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001<B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0010H\u0016J$\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020$2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020 0.H\u0002J\u001e\u0010/\u001a\u00020\n2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010*2\u0006\u0010,\u001a\u00020$H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u0002010*2\u0006\u0010,\u001a\u00020$H\u0016J*\u00103\u001a\u000204*\b\u0012\u0004\u0012\u00020+052\u0006\u00106\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u00107\u001a\u000208H\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020 H\u0002J\f\u00109\u001a\u00020\u0010*\u00020:H\u0002J\f\u0010;\u001a\u00020\u0010*\u00020 H\u0002J\f\u0010(\u001a\u00020\u0010*\u00020 H\u0002J\f\u0010\u0011\u001a\u00020\u0010*\u00020 H\u0002R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u001e*\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006="}, d2={"Lcom/android/tools/idea/streaming/device/screenshot/DeviceScreenshotOptions;", "Lcom/android/tools/idea/ui/screenshot/ScreenshotAction$ScreenshotOptions;", "serialNumber", "", "deviceConfiguration", "Lcom/android/tools/idea/streaming/device/DeviceConfiguration;", "deviceView", "Lcom/android/tools/idea/streaming/device/DeviceView;", "(Ljava/lang/String;Lcom/android/tools/idea/streaming/device/DeviceConfiguration;Lcom/android/tools/idea/streaming/device/DeviceView;)V", "apiLevel", "", "getApiLevel", "()I", "defaultFrameIndex", "deviceModel", "isAutomotive", "", "isWatch", "screenshotPostprocessor", "Lcom/android/tools/idea/ui/screenshot/ScreenshotPostprocessor;", "getScreenshotPostprocessor", "()Lcom/android/tools/idea/ui/screenshot/ScreenshotPostprocessor;", "screenshotViewerOptions", "Ljava/util/EnumSet;", "Lcom/android/tools/idea/ui/screenshot/ScreenshotViewer$Option;", "getScreenshotViewerOptions", "()Ljava/util/EnumSet;", "getSerialNumber", "()Ljava/lang/String;", "skinHome", "Ljava/nio/file/Path;", "skinFolder", "Lcom/android/sdklib/devices/Device;", "getSkinFolder", "(Lcom/android/sdklib/devices/Device;)Ljava/nio/file/Path;", "createScreenshotImage", "Lcom/android/tools/idea/ui/screenshot/ScreenshotImage;", "image", "Ljava/awt/image/BufferedImage;", "displayInfo", "isTv", "findMatchingSkins", "", "Lcom/android/tools/idea/streaming/device/screenshot/DeviceScreenshotOptions$MatchingSkin;", "screenshotImage", "devices", "", "getDefaultFramingOption", "framingOptions", "Lcom/android/tools/idea/ui/screenshot/FramingOption;", "getFramingOptions", "addMatch", "", "", "displayName", "matchDistance", "", "isRound", "Lcom/android/sdklib/devices/Screen;", "isTablet", "MatchingSkin", "intellij.android.streaming"})
public final class DeviceScreenshotOptions
implements ScreenshotAction.ScreenshotOptions {
    @NotNull
    private final String serialNumber;
    @NotNull
    private final DeviceView deviceView;
    private final int apiLevel;
    @NotNull
    private final EnumSet<ScreenshotViewer.Option> screenshotViewerOptions;
    @NotNull
    private final ScreenshotPostprocessor screenshotPostprocessor;
    @Nullable
    private final String deviceModel;
    private final boolean isWatch;
    private final boolean isAutomotive;
    @Nullable
    private final Path skinHome;
    private int defaultFrameIndex;

    public DeviceScreenshotOptions(@NotNull String serialNumber, @NotNull DeviceConfiguration deviceConfiguration, @NotNull DeviceView deviceView) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Intrinsics.checkNotNullParameter((Object)deviceConfiguration, (String)"deviceConfiguration");
        Intrinsics.checkNotNullParameter((Object)deviceView, (String)"deviceView");
        this.serialNumber = serialNumber;
        this.deviceView = deviceView;
        this.apiLevel = deviceConfiguration.getApiLevel();
        EnumSet<ScreenshotViewer.Option> enumSet = EnumSet.noneOf(ScreenshotViewer.Option.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(ScreenshotViewer.Option::class.java)");
        this.screenshotViewerOptions = enumSet;
        this.screenshotPostprocessor = new DeviceScreenshotPostprocessor();
        this.deviceModel = deviceConfiguration.getDeviceModel();
        this.isWatch = deviceConfiguration.isWatch();
        this.isAutomotive = deviceConfiguration.isAutomotive();
        File file2 = DeviceArtDescriptor.getBundledDescriptorsFolder();
        this.skinHome = file2 != null ? file2.toPath() : null;
    }

    @Override
    @NotNull
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public int getApiLevel() {
        return this.apiLevel;
    }

    @NotNull
    public EnumSet<ScreenshotViewer.Option> getScreenshotViewerOptions() {
        return this.screenshotViewerOptions;
    }

    @Override
    @NotNull
    public ScreenshotPostprocessor getScreenshotPostprocessor() {
        return this.screenshotPostprocessor;
    }

    @Override
    @NotNull
    public ScreenshotImage createScreenshotImage(@NotNull BufferedImage image, @NotNull String displayInfo, boolean isTv) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)displayInfo, (String)"displayInfo");
        BufferedImage bufferedImage = ImageUtils.rotateByQuadrants((BufferedImage)image, (int)this.deviceView.getDisplayOrientationCorrectionQuadrants$intellij_android_streaming());
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"rotateByQuadrants(image,\u2026ationCorrectionQuadrants)");
        BufferedImage rotatedImage = bufferedImage;
        return new ScreenshotImage(rotatedImage, this.deviceView.getDisplayOrientationQuadrants(), displayInfo, isTv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FramingOption> getFramingOptions(@NotNull ScreenshotImage screenshotImage) {
        List framingOptions;
        block16: {
            double $i$f$indexOfFirst2;
            Path skinFolder;
            Device device2;
            Device device3;
            Object it;
            Intrinsics.checkNotNullParameter((Object)screenshotImage, (String)"screenshotImage");
            framingOptions = new ArrayList();
            AndroidSdkHandler androidSdkHandler = AndroidSdkHandler.getInstance((AndroidLocationsProvider)((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE), null);
            Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"getInstance(AndroidLocationsSingleton, null)");
            DeviceManager deviceManager = IdeDeviceManagers.getDeviceManager((AndroidSdkHandler)androidSdkHandler);
            Collection devices2 = deviceManager.getDevices(EnumSet.of((Enum)DeviceManager.DeviceFilter.USER, (Enum)DeviceManager.DeviceFilter.DEFAULT, (Enum)DeviceManager.DeviceFilter.VENDOR));
            String string = this.deviceModel;
            if (string != null) {
                Object v2;
                block13: {
                    String it2 = string;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)devices2, (String)"devices");
                    Iterable iterable = devices2;
                    for (Object t : iterable) {
                        it = (Device)t;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)this.deviceModel)) continue;
                        v2 = t;
                        break block13;
                    }
                    v2 = null;
                }
                device3 = v2;
            } else {
                device3 = device2 = null;
            }
            if (device2 != null && (skinFolder = this.getSkinFolder(device2)) != null) {
                String string2 = device2.getDisplayName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"device.displayName");
                return CollectionsKt.listOf((Object)new DeviceFramingOption(string2, skinFolder));
            }
            if (device2 == null) {
                Intrinsics.checkNotNullExpressionValue((Object)devices2, (String)"devices");
                List<MatchingSkin> matchingSkins = this.findMatchingSkins(screenshotImage, devices2);
                if (!((Collection)matchingSkins).isEmpty()) {
                    int n;
                    int n2;
                    block14: {
                        void $this$indexOfFirst$iv;
                        MatchingSkin bestMatch = matchingSkins.get(0);
                        for (MatchingSkin skin : matchingSkins) {
                            framingOptions.add(new DeviceFramingOption(skin.getDisplayName(), skin.getSkinFolder()));
                        }
                        List $this$sortBy$iv = framingOptions;
                        boolean $i$f$sortBy = false;
                        if ($this$sortBy$iv.size() > 1) {
                            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                                public final int compare(T a, T b) {
                                    DeviceFramingOption it = (DeviceFramingOption)a;
                                    boolean bl = false;
                                    Comparable comparable = (Comparable)((Object)it.getDisplayName());
                                    it = (DeviceFramingOption)b;
                                    Comparable comparable2 = comparable;
                                    bl = false;
                                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getDisplayName())));
                                }
                            });
                        }
                        $this$sortBy$iv = framingOptions;
                        DeviceScreenshotOptions deviceScreenshotOptions = this;
                        boolean $i$f$indexOfFirst2 = false;
                        int index$iv = 0;
                        for (Object item$iv : $this$indexOfFirst$iv) {
                            it = (DeviceFramingOption)item$iv;
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)((DeviceFramingOption)it).getSkinFolder(), (Object)bestMatch.getSkinFolder())) {
                                n2 = index$iv;
                                break block14;
                            }
                            ++index$iv;
                        }
                        n2 = -1;
                    }
                    deviceScreenshotOptions.defaultFrameIndex = n = n2;
                }
            }
            if (this.isWatch || screenshotImage.isTv()) break block16;
            Dimension displaySize = screenshotImage.getDisplaySize();
            double displayDensity = screenshotImage.getDisplayDensity();
            if (displaySize != null && !Double.isInfinite($i$f$indexOfFirst2 = displayDensity) && !Double.isNaN($i$f$indexOfFirst2)) {
                Object v7;
                block15: {
                    double diagonalSize = Math.hypot(displaySize.width, displaySize.height) / displayDensity;
                    String deviceArtId = diagonalSize < 7.0 ? "phone" : "tablet";
                    List list2 = DeviceArtDescriptor.getDescriptors(null);
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDescriptors(null)");
                    Iterable bl = list2;
                    for (Object t : bl) {
                        DeviceArtDescriptor it3 = (DeviceArtDescriptor)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it3.getId(), (Object)deviceArtId)) continue;
                        v7 = t;
                        break block15;
                    }
                    v7 = null;
                }
                DeviceArtDescriptor deviceArtDescriptor = v7;
                if (deviceArtDescriptor != null) {
                    DeviceArtDescriptor it4 = deviceArtDescriptor;
                    boolean bl = false;
                    framingOptions.add(new DeviceFramingOption(it4));
                }
            }
        }
        return framingOptions;
    }

    @Override
    public int getDefaultFramingOption(@NotNull List<? extends FramingOption> framingOptions, @NotNull ScreenshotImage screenshotImage) {
        Intrinsics.checkNotNullParameter(framingOptions, (String)"framingOptions");
        Intrinsics.checkNotNullParameter((Object)screenshotImage, (String)"screenshotImage");
        return this.defaultFrameIndex;
    }

    private final List<MatchingSkin> findMatchingSkins(ScreenshotImage screenshotImage, Collection<Device> devices2) {
        Dimension dimension2 = screenshotImage.getDisplaySize();
        if (dimension2 == null) {
            return CollectionsKt.emptyList();
        }
        Dimension displaySize = dimension2;
        double w = displaySize.width;
        double h = displaySize.height;
        double diagonalSize = Math.hypot(w, h);
        boolean isTv = screenshotImage.isTv();
        boolean isTablet = !this.isAutomotive && !isTv && !this.isWatch && diagonalSize >= 7.0;
        double aspectRatio = h / w;
        List matches = new ArrayList();
        for (Device device2 : devices2) {
            Path skinFolder;
            if (this.isAutomotive(device2) != this.isAutomotive || this.isTv(device2) != isTv || this.isWatch(device2) != this.isWatch || this.isTablet(device2) != isTablet) continue;
            Screen screen = device2.getDefaultHardware().getScreen();
            Intrinsics.checkNotNullExpressionValue((Object)screen, (String)"screen");
            if (this.isRound(screen) != screenshotImage.isRoundDisplay() || this.getSkinFolder(device2) == null) continue;
            int width = screen.getXDimension();
            int height = screen.getYDimension();
            double deviceDiagonal = Math.hypot(width, height);
            double deviceAspectRatio = (double)height / (double)width;
            double sizeDifference = Math.abs(MathKt.log2((double)(deviceDiagonal / diagonalSize)));
            double aspectRatioDifference = Math.abs(MathKt.log2((double)(deviceAspectRatio / aspectRatio)));
            double distance = Math.hypot(sizeDifference, aspectRatioDifference);
            String string = device2.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.displayName");
            this.addMatch(matches, string, skinFolder, distance);
        }
        return matches;
    }

    private final void addMatch(List<MatchingSkin> $this$addMatch, String displayName2, Path skinFolder, double matchDistance) {
        int i;
        if (!((Collection)$this$addMatch).isEmpty()) {
            if (matchDistance > $this$addMatch.get(0).getMatchDistance() * 2.0) {
                return;
            }
            int n = $this$addMatch.size() + -1;
            if (0 <= n) {
                int i2;
                while (!($this$addMatch.get(i2 = n--).getMatchDistance() <= matchDistance * 2.0)) {
                    $this$addMatch.remove(i2);
                    if (0 <= n) continue;
                }
            }
        }
        for (i = 0; i < $this$addMatch.size() && !(matchDistance < $this$addMatch.get(i).getMatchDistance()); ++i) {
        }
        $this$addMatch.add(i, new MatchingSkin(displayName2, skinFolder, matchDistance));
    }

    private final Path getSkinFolder(Device $this$skinFolder) {
        File file2 = $this$skinFolder.getDefaultHardware().getSkinFile();
        Path path2 = file2 != null ? file2.toPath() : null;
        if (path2 == null) {
            return null;
        }
        Path skinFolder = path2;
        if (Intrinsics.areEqual((Object)((Object)skinFolder).toString(), (Object)"_no_skin")) {
            return null;
        }
        if (!skinFolder.isAbsolute()) {
            Path path3 = this.skinHome;
            Path path4 = path3 != null ? path3.resolve(skinFolder) : null;
            if (path4 == null) {
                return null;
            }
            skinFolder = path4;
        }
        if (!Files.exists(skinFolder.resolve("layout"), new LinkOption[0])) {
            return null;
        }
        return skinFolder;
    }

    private final boolean isAutomotive(Device $this$isAutomotive) {
        String string = $this$isAutomotive.getTagId();
        return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"automotive", (boolean)false, (int)2, null) : false;
    }

    private final boolean isTv(Device $this$isTv) {
        String string = $this$isTv.getTagId();
        return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"android-tv", (boolean)false, (int)2, null) : false;
    }

    private final boolean isWatch(Device $this$isWatch) {
        String string = $this$isWatch.getTagId();
        return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"wear", (boolean)false, (int)2, null) : false;
    }

    private final boolean isTablet(Device $this$isTablet) {
        if (this.isAutomotive($this$isTablet) || this.isTv($this$isTablet) || !this.isWatch($this$isTablet)) {
            return false;
        }
        Screen screen = $this$isTablet.getDefaultHardware().getScreen();
        return Math.hypot((double)screen.getXDimension() / screen.getXdpi(), (double)screen.getYDimension() / screen.getYdpi()) >= 7.0;
    }

    private final boolean isRound(Screen $this$isRound) {
        return $this$isRound.getScreenRound() == ScreenRound.ROUND;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/streaming/device/screenshot/DeviceScreenshotOptions$MatchingSkin;", "", "displayName", "", "skinFolder", "Ljava/nio/file/Path;", "matchDistance", "", "(Ljava/lang/String;Ljava/nio/file/Path;D)V", "getDisplayName", "()Ljava/lang/String;", "getMatchDistance", "()D", "getSkinFolder", "()Ljava/nio/file/Path;", "intellij.android.streaming"})
    private static final class MatchingSkin {
        @NotNull
        private final String displayName;
        @NotNull
        private final Path skinFolder;
        private final double matchDistance;

        public MatchingSkin(@NotNull String displayName2, @NotNull Path skinFolder, double matchDistance) {
            Intrinsics.checkNotNullParameter((Object)displayName2, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)skinFolder, (String)"skinFolder");
            this.displayName = displayName2;
            this.skinFolder = skinFolder;
            this.matchDistance = matchDistance;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final Path getSkinFolder() {
            return this.skinFolder;
        }

        public final double getMatchDistance() {
            return this.matchDistance;
        }
    }
}

