/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.streaming.StreamingUtilsKt;
import com.android.tools.idea.streaming.device.SuspendingSocketChannel;
import com.android.tools.idea.streaming.device.VideoDecoder;
import com.android.tools.idea.streaming.device.VideoDecoderException;
import com.android.tools.idea.streaming.device.VideoDecoderKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParserContext;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.ffmpeg.global.swscale;
import org.bytedeco.ffmpeg.swscale.SwsContext;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0004 !\"#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bJ\u0016\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0019H\u0007J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0002J\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R:\u0010\t\u001a.\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\u000e\u00a2\u0006\u0002\b\r0\n\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/streaming/device/VideoDecoder;", "", "videoChannel", "Lcom/android/tools/idea/streaming/device/SuspendingSocketChannel;", "maxOutputSize", "Ljava/awt/Dimension;", "(Lcom/android/tools/idea/streaming/device/SuspendingSocketChannel;Ljava/awt/Dimension;)V", "displayFrame", "Lcom/android/tools/idea/streaming/device/VideoDecoder$VideoFrame;", "frameListeners", "", "Lcom/android/tools/idea/streaming/device/VideoDecoder$FrameListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "imageLock", "getMaxOutputSize", "()Ljava/awt/Dimension;", "setMaxOutputSize", "(Ljava/awt/Dimension;)V", "addFrameListener", "", "listener", "consumeDisplayFrame", "consumer", "Ljava/util/function/Consumer;", "onEndOfVideoStream", "onNewFrameAvailable", "removeFrameListener", "start", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "DecodingContext", "FrameListener", "PacketHeader", "VideoFrame", "intellij.android.streaming"})
public final class VideoDecoder {
    @NotNull
    private final SuspendingSocketChannel videoChannel;
    @NotNull
    private volatile Dimension maxOutputSize;
    @NotNull
    private final Object imageLock;
    @Nullable
    private VideoFrame displayFrame;
    @NotNull
    private final List<FrameListener> frameListeners;

    public VideoDecoder(@NotNull SuspendingSocketChannel videoChannel, @NotNull Dimension maxOutputSize) {
        Intrinsics.checkNotNullParameter((Object)videoChannel, (String)"videoChannel");
        Intrinsics.checkNotNullParameter((Object)maxOutputSize, (String)"maxOutputSize");
        this.videoChannel = videoChannel;
        this.maxOutputSize = maxOutputSize;
        this.imageLock = new Object();
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createLockFreeCopyOnWriteList<FrameListener>()");
        this.frameListeners = list2;
    }

    @NotNull
    public final Dimension getMaxOutputSize() {
        return this.maxOutputSize;
    }

    public final void setMaxOutputSize(@NotNull Dimension dimension2) {
        Intrinsics.checkNotNullParameter((Object)dimension2, (String)"<set-?>");
        this.maxOutputSize = dimension2;
    }

    public final void addFrameListener(@NotNull FrameListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.frameListeners.add(listener2);
    }

    public final void removeFrameListener(@NotNull FrameListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.frameListeners.remove(listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public final void consumeDisplayFrame(@NotNull Consumer<VideoFrame> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Object object = this.imageLock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            VideoFrame videoFrame = this.displayFrame;
            if (videoFrame != null) {
                VideoFrame it = videoFrame;
                boolean bl2 = false;
                consumer.accept(it);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    public final void start(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        VideoDecoderKt.setFirstPacketArrival(0L);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ VideoDecoder this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        header = ByteBuffer.allocate(20);
                        v0 = VideoDecoder.access$getVideoChannel$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)header, (String)"header");
                        this.L$0 = header;
                        this.label = 1;
                        v1 = SuspendingSocketChannel.readFully$default(v0, header, 0L, null, (Continuation)this, 6, null);
                        if (v1 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        header = (ByteBuffer)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl18:
                        // 2 sources

                        var4_4 = header.array();
                        Intrinsics.checkNotNullExpressionValue((Object)var4_4, (String)"header.array()");
                        var5_5 = Charsets.UTF_8;
                        codecName = StringsKt.trim((CharSequence)new String(var4_4, var5_5)).toString();
                        decodingContext = this.this$0.new DecodingContext(codecName);
                        try {
                        }
                        catch (ClosedChannelException var5_6) {
                            decodingContext.close();
                            VideoDecoder.access$onEndOfVideoStream(this.this$0);
                            return Unit.INSTANCE;
                        }
                        catch (EOFException var5_7) {
                            decodingContext.close();
                            VideoDecoder.access$onEndOfVideoStream(this.this$0);
                            return Unit.INSTANCE;
                            catch (Throwable var5_8) {
                                decodingContext.close();
                                VideoDecoder.access$onEndOfVideoStream(this.this$0);
                                throw var5_8;
                            }
                        }
lbl39:
                        // 2 sources

                        while (true) {
                            this.L$0 = decodingContext;
                            this.label = 2;
                            v2 = decodingContext.readAndProcessPacket((Continuation<? super Unit>)((Continuation)this));
                            if (v2 != var6_2) continue;
                            return var6_2;
                        }
                    }
                    case 2: {
                        decodingContext = (DecodingContext)this.L$0;
                        {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            ** continue;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void onNewFrameAvailable() {
        for (FrameListener listener2 : this.frameListeners) {
            listener2.onNewFrameAvailable();
        }
    }

    private final void onEndOfVideoStream() {
        for (FrameListener listener2 : this.frameListeners) {
            listener2.onEndOfVideoStream();
        }
    }

    public static final /* synthetic */ SuspendingSocketChannel access$getVideoChannel$p(VideoDecoder $this) {
        return $this.videoChannel;
    }

    public static final /* synthetic */ void access$onEndOfVideoStream(VideoDecoder $this) {
        $this.onEndOfVideoStream();
    }

    public static final /* synthetic */ Object access$getImageLock$p(VideoDecoder $this) {
        return $this.imageLock;
    }

    public static final /* synthetic */ void access$onNewFrameAvailable(VideoDecoder $this) {
        $this.onNewFrameAvailable();
    }

    public static final /* synthetic */ VideoFrame access$getDisplayFrame$p(VideoDecoder $this) {
        return $this.displayFrame;
    }

    public static final /* synthetic */ void access$setDisplayFrame$p(VideoDecoder $this, VideoFrame videoFrame) {
        $this.displayFrame = videoFrame;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/device/VideoDecoder$FrameListener;", "", "onEndOfVideoStream", "", "onNewFrameAvailable", "intellij.android.streaming"})
    public static interface FrameListener {
        public void onNewFrameAvailable();

        public void onEndOfVideoStream();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/streaming/device/VideoDecoder$VideoFrame;", "", "image", "Ljava/awt/image/BufferedImage;", "displaySize", "Ljava/awt/Dimension;", "orientation", "", "orientationCorrection", "frameNumber", "originationTime", "", "(Ljava/awt/image/BufferedImage;Ljava/awt/Dimension;IIIJ)V", "getDisplaySize", "()Ljava/awt/Dimension;", "getFrameNumber", "()I", "getImage", "()Ljava/awt/image/BufferedImage;", "getOrientation", "getOrientationCorrection", "getOriginationTime", "()J", "intellij.android.streaming"})
    public static final class VideoFrame {
        @NotNull
        private final BufferedImage image;
        @NotNull
        private final Dimension displaySize;
        private final int orientation;
        private final int orientationCorrection;
        private final int frameNumber;
        private final long originationTime;

        public VideoFrame(@NotNull BufferedImage image, @NotNull Dimension displaySize, int orientation, int orientationCorrection, int frameNumber, long originationTime) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
            this.image = image;
            this.displaySize = displaySize;
            this.orientation = orientation;
            this.orientationCorrection = orientationCorrection;
            this.frameNumber = frameNumber;
            this.originationTime = originationTime;
        }

        @NotNull
        public final BufferedImage getImage() {
            return this.image;
        }

        @NotNull
        public final Dimension getDisplaySize() {
            return this.displaySize;
        }

        public final int getOrientation() {
            return this.orientation;
        }

        public final int getOrientationCorrection() {
            return this.orientationCorrection;
        }

        public final int getFrameNumber() {
            return this.frameNumber;
        }

        public final long getOriginationTime() {
            return this.originationTime;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010$\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0002J\u0011\u0010%\u001a\u00020\u001cH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/streaming/device/VideoDecoder$DecodingContext;", "Ljava/lang/AutoCloseable;", "codecName", "", "(Lcom/android/tools/idea/streaming/device/VideoDecoder;Ljava/lang/String;)V", "codec", "Lorg/bytedeco/ffmpeg/avcodec/AVCodec;", "codecContext", "Lorg/bytedeco/ffmpeg/avcodec/AVCodecContext;", "decodingFrame", "Lorg/bytedeco/ffmpeg/avutil/AVFrame;", "hasPendingPacket", "", "headerBuffer", "Ljava/nio/ByteBuffer;", "packet", "Lorg/bytedeco/ffmpeg/avcodec/AVPacket;", "parserContext", "Lorg/bytedeco/ffmpeg/avcodec/AVCodecParserContext;", "pendingPacket", "renderingFrame", "renderingSize", "Ljava/awt/Dimension;", "getRenderingSize", "()Ljava/awt/Dimension;", "swsContext", "Lorg/bytedeco/ffmpeg/swscale/SwsContext;", "close", "", "createRenderingFrame", "size", "getSwsContext", "processDataPacket", "header", "Lcom/android/tools/idea/streaming/device/VideoDecoder$PacketHeader;", "processFrame", "processPacket", "readAndProcessPacket", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.android.streaming"})
    private final class DecodingContext
    implements AutoCloseable {
        @NotNull
        private final AVCodec codec;
        @NotNull
        private final AVCodecContext codecContext;
        @NotNull
        private final AVFrame decodingFrame;
        @Nullable
        private AVFrame renderingFrame;
        @Nullable
        private SwsContext swsContext;
        @NotNull
        private final AVCodecParserContext parserContext;
        @NotNull
        private final ByteBuffer headerBuffer;
        @NotNull
        private final AVPacket packet;
        @NotNull
        private final AVPacket pendingPacket;
        private boolean hasPendingPacket;

        /*
         * WARNING - void declaration
         */
        public DecodingContext(String codecName) {
            void $this$_init__u24lambda_u2d1;
            AVCodecParserContext aVCodecParserContext;
            Object object;
            Intrinsics.checkNotNullParameter((Object)codecName, (String)"codecName");
            this.headerBuffer = PacketHeader.Companion.createBuffer();
            AVPacket aVPacket = avcodec.av_packet_alloc();
            Intrinsics.checkNotNullExpressionValue((Object)aVPacket, (String)"av_packet_alloc()");
            this.packet = aVPacket;
            AVPacket aVPacket2 = avcodec.av_packet_alloc();
            Intrinsics.checkNotNullExpressionValue((Object)aVPacket2, (String)"av_packet_alloc()");
            this.pendingPacket = aVPacket2;
            DecodingContext $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(DecodingContext.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
            Logger $this$debug$iv = logger2;
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                object = $this$debug$iv;
                boolean bl = false;
                object.debug("Receiving " + codecName + " video stream", (Throwable)e$iv);
            }
            String ffmpegCodecName = Intrinsics.areEqual((Object)codecName, (Object)"avc") ? "h264" : codecName;
            AVCodec aVCodec = avcodec.avcodec_find_decoder_by_name((String)ffmpegCodecName);
            if (aVCodec == null) {
                throw new VideoDecoderException(ffmpegCodecName + " decoder not found");
            }
            this.codec = aVCodec;
            AVCodecContext aVCodecContext = avcodec.avcodec_alloc_context3((AVCodec)this.codec);
            if (aVCodecContext == null) {
                throw new VideoDecoderException("Could not allocate decoder context");
            }
            this.codecContext = aVCodecContext;
            AVCodecParserContext aVCodecParserContext2 = avcodec.av_parser_init((int)this.codec.id());
            if (aVCodecParserContext2 == null) {
                throw new VideoDecoderException("Could not initialize parser");
            }
            AVCodecParserContext bl = aVCodecParserContext = aVCodecParserContext2;
            object = this;
            boolean bl2 = false;
            $this$_init__u24lambda_u2d1.flags($this$_init__u24lambda_u2d1.flags() | 1);
            object.parserContext = aVCodecParserContext;
            if (avcodec.avcodec_open2((AVCodecContext)this.codecContext, (AVCodec)this.codec, (AVDictionary)null) < 0) {
                avcodec.avcodec_free_context((AVCodecContext)this.codecContext);
                throw new VideoDecoderException("Could not open codec " + this.codec.name());
            }
            AVFrame aVFrame = avutil.av_frame_alloc();
            Intrinsics.checkNotNullExpressionValue((Object)aVFrame, (String)"av_frame_alloc()");
            this.decodingFrame = aVFrame;
        }

        private final Dimension getRenderingSize() {
            Dimension videoSize = new Dimension(this.decodingFrame.width(), this.decodingFrame.height());
            Dimension maximumSize = VideoDecoder.this.getMaxOutputSize();
            if (maximumSize.width == 0 || maximumSize.height == 0) {
                return videoSize;
            }
            return StreamingUtilsKt.coerceAtMost(videoSize, maximumSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Nullable
        public final Object readAndProcessPacket(@NotNull Continuation<? super Unit> var1_1) {
            if (!(var1_1 instanceof readAndProcessPacket.1)) ** GOTO lbl-1000
            var9_2 = var1_1;
            if ((var9_2.label & -2147483648) != 0) {
                var9_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    Object L$1;
                    long J$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ DecodingContext this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.readAndProcessPacket((Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = SuspendingSocketChannel.readFully$default(VideoDecoder.access$getVideoChannel$p(VideoDecoder.this), this.headerBuffer, 0L, null, (Continuation)$continuation, 6, null);
                    if (v0 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    this = (DecodingContext)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    if (VideoDecoderKt.getFirstPacketArrival() == 0L) {
                        VideoDecoderKt.setFirstPacketArrival(System.currentTimeMillis());
                    }
                    this.headerBuffer.rewind();
                    header = PacketHeader.Companion.deserialize(this.headerBuffer);
                    this.headerBuffer.clear();
                    presentationTimestampUs = header.getPresentationTimestampUs();
                    packetSize = header.getPacketSize();
                    if (presentationTimestampUs < 0L || packetSize <= 0) {
                        throw new VideoDecoderException("Invalid packet header: " + this.headerBuffer);
                    }
                    if (avcodec.av_new_packet((AVPacket)this.packet, (int)packetSize) != 0) {
                        throw new VideoDecoderException("Could not allocate packet");
                    }
                    v1 = VideoDecoder.access$getVideoChannel$p(VideoDecoder.this);
                    v2 = this.packet.data();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"packet.data()");
                    $continuation.L$0 = this;
                    $continuation.L$1 = header;
                    $continuation.J$0 = presentationTimestampUs;
                    $continuation.label = 2;
                    v3 = SuspendingSocketChannel.readFully$default(v1, VideoDecoderKt.access$asByteBufferOfSize((Pointer)v2, packetSize), 0L, null, (Continuation)$continuation, 6, null);
                    ** if (v3 != var10_4) goto lbl47
lbl46:
                    // 1 sources

                    return var10_4;
lbl47:
                    // 1 sources

                    ** GOTO lbl56
                }
                case 2: {
                    presentationTimestampUs = $continuation.J$0;
                    header = (PacketHeader)$continuation.L$1;
                    this = (DecodingContext)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl56:
                        // 2 sources

                        this.packet.pts(presentationTimestampUs == 0L ? avutil.AV_NOPTS_VALUE : var3_6);
                        this.processPacket(this.packet, header);
                    }
                    catch (VideoDecoderException e) {
                        $i$f$thisLogger = false;
                        v4 = Logger.getInstance(DecodingContext.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"Logger.getInstance(T::class.java)");
                        v4.error((Throwable)e);
                        ** GOTO lbl73
                    }
                    avcodec.av_packet_unref((AVPacket)this.packet);
                    ** GOTO lbl73
                }
                {
                    finally {
                        avcodec.av_packet_unref((AVPacket)this.packet);
                    }
                }
lbl73:
                // 2 sources

                return Unit.INSTANCE;
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @Override
        public void close() {
            AVFrame it;
            avcodec.avcodec_close((AVCodecContext)this.codecContext);
            avcodec.avcodec_free_context((AVCodecContext)this.codecContext);
            avutil.av_frame_free((AVFrame)this.decodingFrame);
            AVFrame aVFrame = this.renderingFrame;
            if (aVFrame != null) {
                it = aVFrame;
                boolean bl = false;
                avutil.av_frame_free((AVFrame)it);
            }
            SwsContext swsContext = this.swsContext;
            if (swsContext != null) {
                it = swsContext;
                boolean bl = false;
                swscale.sws_freeContext((SwsContext)it);
            }
            avcodec.av_packet_free((AVPacket)this.packet);
            avcodec.av_packet_free((AVPacket)this.pendingPacket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void processPacket(AVPacket packet, PacketHeader header) {
            boolean isConfig = packet.pts() == avutil.AV_NOPTS_VALUE;
            AVPacket packetToProcess = packet;
            if (this.hasPendingPacket || isConfig) {
                int offset = 0;
                if (this.hasPendingPacket) {
                    offset = this.pendingPacket.size();
                    if (avcodec.av_grow_packet((AVPacket)this.pendingPacket, (int)packet.size()) != 0) {
                        throw new VideoDecoderException("Could not grow packet");
                    }
                } else {
                    offset = 0;
                    if (avcodec.av_new_packet((AVPacket)this.pendingPacket, (int)packet.size()) != 0) {
                        throw new VideoDecoderException("Could not create packet");
                    }
                    this.hasPendingPacket = true;
                }
                Pointer.memcpy((Pointer)((Pointer)this.pendingPacket.data().position((long)offset)), (Pointer)((Pointer)packet.data()), (long)packet.size());
                if (!isConfig) {
                    this.pendingPacket.pts(packet.pts());
                    this.pendingPacket.dts(packet.dts());
                    this.pendingPacket.flags(packet.flags());
                    packetToProcess = this.pendingPacket;
                }
            }
            if (!isConfig) {
                try {
                    this.processDataPacket(packetToProcess, header);
                }
                finally {
                    if (this.hasPendingPacket) {
                        this.hasPendingPacket = false;
                        if (!Intrinsics.areEqual((Object)this.pendingPacket, (Object)packet)) {
                            avcodec.av_packet_unref((AVPacket)this.pendingPacket);
                        }
                    }
                }
            }
        }

        private final void processDataPacket(AVPacket packet, PacketHeader header) {
            boolean bl;
            BytePointer outData = new BytePointer();
            int[] nArray = new int[]{0};
            IntPointer outLen = new IntPointer(nArray);
            int r = avcodec.av_parser_parse2((AVCodecParserContext)this.parserContext, (AVCodecContext)this.codecContext, (BytePointer)outData, (IntPointer)outLen, (BytePointer)packet.data(), (int)packet.size(), (long)avutil.AV_NOPTS_VALUE, (long)avutil.AV_NOPTS_VALUE, (long)-1L);
            boolean bl2 = bl = r == packet.size();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean bl3 = bl = outLen.get() == packet.size();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (this.parserContext.key_frame() == 1) {
                packet.flags(packet.flags() | 1);
            }
            this.processFrame(packet, header);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private final void processFrame(AVPacket packet, PacketHeader header) {
            ret = avcodec.avcodec_send_packet((AVCodecContext)this.codecContext, (AVPacket)packet);
            if (ret < 0) {
                throw new VideoDecoderException("Video packet was rejected by the decoder: " + ret);
            }
            if (avcodec.avcodec_receive_frame((AVCodecContext)this.codecContext, (AVFrame)this.decodingFrame) != 0) {
                throw new VideoDecoderException("Could not receive video frame");
            }
            size = this.getRenderingSize();
            renderingFrame = this.renderingFrame;
            if (renderingFrame == null || renderingFrame.width() != size.width || renderingFrame.height() != size.height) {
                v0 = renderingFrame;
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-VideoDecoder$DecodingContext$processFrame$1 = false;
                    avutil.av_frame_free((AVFrame)it);
                }
                it = var6_11 = this.createRenderingFrame(size);
                $i$a$-also-VideoDecoder$DecodingContext$processFrame$2 = false;
                this.renderingFrame = it;
                renderingFrame = var6_11;
                if (avutil.av_frame_get_buffer((AVFrame)renderingFrame, (int)4) < 0) {
                    throw new RuntimeException("av_frame_get_buffer failed");
                }
            }
            if (avutil.av_frame_make_writable((AVFrame)renderingFrame) < 0) {
                throw new RuntimeException("av_frame_make_writable failed");
            }
            swscale.sws_scale((SwsContext)this.getSwsContext(renderingFrame), (PointerPointer)this.decodingFrame.data(), (IntPointer)this.decodingFrame.linesize(), (int)0, (int)this.decodingFrame.height(), (PointerPointer)renderingFrame.data(), (IntPointer)renderingFrame.linesize());
            numBytes = avutil.av_image_get_buffer_size((int)renderingFrame.format(), (int)renderingFrame.width(), (int)renderingFrame.height(), (int)1);
            v1 = renderingFrame.data().get();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"renderingFrame.data().get()");
            framePixels = VideoDecoderKt.access$asByteBufferOfSize(v1, numBytes).asIntBuffer();
            imageSize = new Dimension(renderingFrame.width(), renderingFrame.height());
            var9_10 = VideoDecoder.access$getImageLock$p(VideoDecoder.this);
            var10_14 = VideoDecoder.this;
            var11_15 = var9_10;
            synchronized (var11_15) {
                $i$a$-synchronized-VideoDecoder$DecodingContext$processFrame$3 = false;
                v2 = VideoDecoder.access$getDisplayFrame$p(var10_14);
                v3 = image = v2 != null ? v2.getImage() : null;
                v4 = v3 != null ? v3.getWidth() == imageSize.width : false;
                if (!v4 || image.getHeight() != imageSize.height) ** GOTO lbl-1000
                v5 = VideoDecoder.access$getDisplayFrame$p(var10_14);
                v6 = v5 != null ? v5.getOrientationCorrection() == 0 : false;
                if (v6 && header.getDisplayOrientationCorrection() == 0) {
                    v7 = image.getRaster().getDataBuffer();
                    Intrinsics.checkNotNull((Object)v7, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
                    imagePixels = ((DataBufferInt)v7).getData();
                    framePixels.get(imagePixels);
                } else lbl-1000:
                // 2 sources

                {
                    imagePixels = new int[imageSize.width * imageSize.height];
                    framePixels.get(imagePixels);
                    buffer = new DataBufferInt(imagePixels, imagePixels.length);
                    sampleModel = new SinglePixelPackedSampleModel(3, imageSize.width, imageSize.height, VideoDecoderKt.access$getSAMPLE_MODEL_BIT_MASKS$p());
                    raster = Raster.createWritableRaster(sampleModel, buffer, VideoDecoderKt.access$getZERO_POINT$p());
                    image = ImageUtils.rotateByQuadrants((BufferedImage)new BufferedImage(VideoDecoderKt.access$getCOLOR_MODEL$p(), raster, false, null), (int)header.getDisplayOrientationCorrection());
                }
                VideoDecoder.access$setDisplayFrame$p(var10_14, new VideoFrame(image, header.getDisplaySize(), header.getDisplayOrientation(), header.getDisplayOrientationCorrection(), (int)header.getFrameNumber(), header.getOriginationTimestampUs() / (long)1000));
                var12_17 = Unit.INSTANCE;
            }
            VideoDecoder.access$onNewFrameAvailable(VideoDecoder.this);
        }

        private final SwsContext getSwsContext(AVFrame renderingFrame) {
            SwsContext context2;
            SwsContext swsContext = swscale.sws_getCachedContext((SwsContext)this.swsContext, (int)this.decodingFrame.width(), (int)this.decodingFrame.height(), (int)this.decodingFrame.format(), (int)renderingFrame.width(), (int)renderingFrame.height(), (int)renderingFrame.format(), (int)2, null, null, (DoublePointer)null);
            if (swsContext == null) {
                throw new VideoDecoderException("Could not allocate SwsContext");
            }
            this.swsContext = context2 = swsContext;
            return context2;
        }

        private final AVFrame createRenderingFrame(Dimension size) {
            AVFrame aVFrame;
            AVFrame $this$createRenderingFrame_u24lambda_u2d7 = aVFrame = avutil.av_frame_alloc();
            boolean bl = false;
            $this$createRenderingFrame_u24lambda_u2d7.width(size.width);
            $this$createRenderingFrame_u24lambda_u2d7.height(size.height);
            $this$createRenderingFrame_u24lambda_u2d7.format(28);
            AVFrame aVFrame2 = aVFrame;
            Intrinsics.checkNotNullExpressionValue((Object)aVFrame2, (String)"av_frame_alloc().apply {\u2026(AV_PIX_FMT_BGRA)\n      }");
            return aVFrame2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000f\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B?\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/streaming/device/VideoDecoder$PacketHeader;", "", "displaySize", "Ljava/awt/Dimension;", "displayOrientation", "", "displayOrientationCorrection", "packetSize", "frameNumber", "", "originationTimestampUs", "presentationTimestampUs", "(Ljava/awt/Dimension;IIIJJJ)V", "getDisplayOrientation", "()I", "getDisplayOrientationCorrection", "getDisplaySize", "()Ljava/awt/Dimension;", "getFrameNumber", "()J", "getOriginationTimestampUs", "getPacketSize", "getPresentationTimestampUs", "Companion", "intellij.android.streaming"})
    private static final class PacketHeader {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Dimension displaySize;
        private final int displayOrientation;
        private final int displayOrientationCorrection;
        private final int packetSize;
        private final long frameNumber;
        private final long originationTimestampUs;
        private final long presentationTimestampUs;
        private static final int WIRE_SIZE = 40;

        private PacketHeader(Dimension displaySize, int displayOrientation, int displayOrientationCorrection, int packetSize, long frameNumber, long originationTimestampUs, long presentationTimestampUs) {
            this.displaySize = displaySize;
            this.displayOrientation = displayOrientation;
            this.displayOrientationCorrection = displayOrientationCorrection;
            this.packetSize = packetSize;
            this.frameNumber = frameNumber;
            this.originationTimestampUs = originationTimestampUs;
            this.presentationTimestampUs = presentationTimestampUs;
        }

        @NotNull
        public final Dimension getDisplaySize() {
            return this.displaySize;
        }

        public final int getDisplayOrientation() {
            return this.displayOrientation;
        }

        public final int getDisplayOrientationCorrection() {
            return this.displayOrientationCorrection;
        }

        public final int getPacketSize() {
            return this.packetSize;
        }

        public final long getFrameNumber() {
            return this.frameNumber;
        }

        public final long getOriginationTimestampUs() {
            return this.originationTimestampUs;
        }

        public final long getPresentationTimestampUs() {
            return this.presentationTimestampUs;
        }

        public /* synthetic */ PacketHeader(Dimension displaySize, int displayOrientation, int displayOrientationCorrection, int packetSize, long frameNumber, long originationTimestampUs, long presentationTimestampUs, DefaultConstructorMarker $constructor_marker) {
            this(displaySize, displayOrientation, displayOrientationCorrection, packetSize, frameNumber, originationTimestampUs, presentationTimestampUs);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/streaming/device/VideoDecoder$PacketHeader$Companion;", "", "()V", "WIRE_SIZE", "", "createBuffer", "Ljava/nio/ByteBuffer;", "deserialize", "Lcom/android/tools/idea/streaming/device/VideoDecoder$PacketHeader;", "buffer", "intellij.android.streaming"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final PacketHeader deserialize(@NotNull ByteBuffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                int width = buffer.getInt();
                int height = buffer.getInt();
                short displayOrientation = buffer.getShort();
                short displayOrientationCorrection = buffer.getShort();
                int packetSize = buffer.getInt();
                long frameNumber = buffer.getLong();
                long originationTimestampUs = buffer.getLong();
                long presentationTimestampUs = buffer.getLong();
                return new PacketHeader(new Dimension(width, height), displayOrientation, displayOrientationCorrection, packetSize, frameNumber, originationTimestampUs, presentationTimestampUs, null);
            }

            @NotNull
            public final ByteBuffer createBuffer() {
                ByteBuffer byteBuffer = ByteBuffer.allocate(40).order(ByteOrder.LITTLE_ENDIAN);
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(WIRE_SIZE).order(LITTLE_ENDIAN)");
                return byteBuffer;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

